C****** STDDEV   MEAN AND STANDARD DEVIATTION            MTADV EXT    REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL STDDEV (A,IA,AMEAN,ASDEV,N)
C
C        where,
C
C        A        Real input vector
C
C        IA       Integer input scaler stride for A.
C
C        AMEAN    Real output scaler mean of A.
C
C        ASDEV    Real output scaler standard deviation of A.
C
C        N        Integer input scaler number of elements in A.
C
C  DESCRIPTION
C
C        This routine finds the mean and the standard deviation of the input
C        vector A.   The mean and standard deviation are defined as:
C
C             AMEAN  = SUM(A(I))/N    for i=1,N
C
C             ASDEV  = SQRT { SUM( (A(i) - AMEAN)**2 )/N }    for i=1,N
C
C        The ASDEV definition is inconvenient for computation.  Instead, use is
C        made of a procedure discussed in the reference in which the standard
C        deviation is calculated from moments about the origin.
C
C        This routine immediately exits if N is less than or equal to zero.
C
C  REFERENCE
C
C        W. H. Beyer, 1966, CRC Handbook of Tables for Probability and
C        Statistics (Chemical Rubber Co., Cleveland, Ohio) page 3.
C
C  EXAMPLE
C
C        CALL STDDEV (A, 1, AMEAN, ASDEV, 5)
C
C        Input Operands:
C
C              A = (1.000)
C                  (2.000)
C                  (3.000)
C                  (4.000)
C                  (5.000)
C
C
C        Output Operands:
C
C              AMEAN = 3.00000000E+00
C
C              ASDEV = 1.41421354E+00
C
C  SUBPROGRAMS
C
C        INTRINSICS:   SQRT, FLOAT
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
      SUBROUTINE STDDEV (A, IA, AMEAN, ASDEV, N)
C
      REAL    A(*), AMEAN, ASDEV, XNRCIP, SUM, SSQ, AJA, AVAR
      INTEGER IA, N, JA, J
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0) GO TO 800
C
      XNRCIP = 1.0 / FLOAT( N )
C
      SUM = 0.0
      SSQ = 0.0
      JA  = 1
      DO 110 J = 1, N
         AJA = A(JA)
         SUM = SUM + AJA
         SSQ = SSQ + AJA * AJA
         JA  = JA + IA
  110 CONTINUE
C
      AMEAN = SUM * XNRCIP
      AVAR  = SSQ * XNRCIP - AMEAN * AMEAN
      ASDEV = SQRT( AVAR )
C
  800 CONTINUE
      RETURN
      END
