C*****  SVDIV   Scalar Vector Divide              MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SVDIV (A,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input scalar.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine divides a scalar A by the elements of a
C       vector B and stores the results in vector C.
C
C            C(i) = A/B(i)    for i = 1,N
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL SVDIV (A,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 3.000
C
C       B = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C
C       Output Operands:
C
C       C = 3.000
C           1.500
C           1.000
C           0.750
C           0.600
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE SVDIV(A,B,IA,C,IC,N)
C
      INTEGER IA,IC,N,JJ,KK,M
      REAL A,B(1),C(1)
      IF (N.LE.0) GO TO 12
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A / B(JJ)
        JJ = JJ+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
