C*****  TRANS   Transfer Function                 MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL TRANS (A,B,C,N)
C
C       where,
C
C       A       Real input vector, auto-spectrum.
C
C       B       Complex input vector cross-spectrum.
C
C       C       Complex output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine performs a complex transfer function calculation by
C       dividing the cross-spectrum B by the auto-spectrum A and stores
C       the results in C.
C
C            real(C(i)) = real(B(i)) / A(i)
C            imag(C(i)) = imag(B(i)) / A(i)    for i=1,N
C
C
C  REFERENCE
C
C       G. W. Jenkins and D. G. Watts.  1969.  Spectral
C       analysis and its applications.  San Francisco: Holden-
C       Day.
C
C
C  EXAMPLE
C
C       CALL TRANS (A,B,C,5)
C
C       Input Operands:
C
C       A = 6.000
C          27.000
C          64.000
C         117.000
C         186.000
C
C       B = (  6.00,0.0)
C           ( 27.00,0.0)
C           ( 64.00,0.0)
C           (117.00,0.0)
C           (186.00,0.0)
C
C       Output Operands:
C
C       C = (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C           (1.0,0.0)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE TRANS(A,B,C,N)
C
      INTEGER N,IA,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 800
      IA = 1
      DO 300 M = 1, N
        C(IA) =  B(IA) / A(M)
        C(IA+1) =  B(IA+1) / A(M)
        IA = IA + 2
300   CONTINUE
800   RETURN
      END
