C*****  TREC   Time Varying Recursive Filter         MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL TREC (S,U,INCU,X,INCX,Y,INCY,N)
C
C       where,
C
C       S       Real input scalar, offset for Y(1) computation.
C
C       U       Real input vector.
C
C       INCU    Integer input stride for vector U.
C
C       X       Real input vector.
C
C       INCX    Integer input stride for vector X.
C
C       Y       Real output vector.
C
C       INCY    Integer input stride for vector Y.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine implements the first order time varying recursive
C       equation, using an initial value of S, target vectors U and X,
C       and output vector Y.
C
C       Y(1) = S + U(1)*X(1)
C       Y(i) = U(i)*Y(i-1) + U(1)*X(i)  for i = 2,n
C
C  EXAMPLE
C
C       CALL TREC (S,U,1,X,1,Y,1,8)
C
C       Input Operands:
C
C       S = 1.0    U = 1.0    X = 3.0
C                      2.0        2.0
C                      3.0        1.0
C                      3.0        1.0
C                      2.0        2.0
C                      1.0        3.0
C                      1.0        3.0
C                      2.0        2.0
C
C       Output Operands:
C
C       Y =  4.0
C           10.0
C           31.0
C           94.0
C          190.0
C          193.0
C          196.0
C          394.0
C
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original (from ESSL manual).
C
C-----------------------------------------------------------------------
C
      SUBROUTINE TREC(S,U,INCU,X,INCX,Y,INCY,N)
C
      INTEGER INCU,INCX,INCY,N,II,JJ,KK,I
      REAL S,U(1),X(1),Y(1)
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0) GO TO 12
C
      Y(1) = S + U(1)*X(1)
      II = 1 + INCU
      JJ = 1 + INCX
      KK = 1 + INCY
      DO 10 I = 2,N
        Y(KK) = U(II)*Y(KK-INCY) + U(1)*X(JJ)
        II = II + INCU
        JJ = JJ + INCX
        KK = KK + INCY
10    CONTINUE
12    RETURN
      END
