C*****  UPRFT2  Unpack RFFT2D Results             MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL UPRFT2 (A,C,NRC,NCC)
C
C       where,
C
C       A       Real input matrix, result of RFFT2D.
C
C       C       Complex output matrix, unpacked result.
C
C       NRC     Integer input number of real rows.
C
C       NCC     Integer input number of real columns.
C
C
C  DESCRIPTION
C
C       This routine unpacks the output matrix from the RFFT2D
C       routine into a full complex array.  The result is
C       the same, except for a scaling factor, as one would
C       get from storing the original real array in complex
C       form and using CFFT2D to compute the transform.
C
C       The arguments NRC and NCC are the same values used in
C       the call to RFFT2D.  Both NRC and NCC must be integer
C       powers of two.
C
C       In place operation is permitted.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL UPRFT2 (A,C,4,4)
C
C       Input Operands:
C
C       A =    1.0     5.0     9.0    13.0
C              2.0     6.0    10.0    14.0
C              3.0     7.0    11.0    15.0
C              4.0     8.0    12.0    16.0
C
C       Output Operands:
C
C       C =  (1.0,  0.0)  (9.0,   13.0)  (5.0,    0.0)  (9.0,  -13.0)
C            (3.0,  4.0)  (7.0,    8.0)  (11.0,  12.0)  (15.0,  16.0)
C            (2.0,  0.0)  (10.0,  14.0)  (6.0,    0.0)  (10.0, -14.0)
C            (3.0, -4.0)  (15.0, -16.0)  (11.0, -12.0)  (7.0,   -8.0)
C
C
C  HISTORY
C         1) Jul 86     D. Benua       Original.
C
      SUBROUTINE UPRFT2(A,C,NRC,NCC)
C
      REAL A(1),C(1),TEMP
      INTEGER NRC,NCC,I,J,NRC2,IROW,ICOL,JROW,JCOL
C
C  COPY INPUT ARRAY TO OUTPUT ARRAY, BY COLUMNS
C  START WITH LAST COLUMN FOR IN PLACE OPERATION
C
      NRC2 = 2*NRC
      DO 10 I=NCC,1,-1
          CALL VMOV(A((I-1)*NRC+1),1,C((I-1)*NRC2+1),1,NRC)
10    CONTINUE
C
C  COPY ROW 2 TO ROW NRC+1
C
      CALL VMOV(C(2),NRC2,C(NRC+1),NRC2,NCC)
      CALL VCLR(C(2),NRC2,NCC)
C
C  RESHUFFLE ROW 1 INTO COMPLEX FORMAT
C
      TEMP = C(NRC2+1)
      C(2) = 0.0
      J = 2*NRC2 + 1
      DO 20 I=(NRC2+1),(NRC2*((NCC/2)-1)+1),NRC2
         C(I) = C(J)
         J = J + NRC2
         C(I+1) = C(J)
         J = J + NRC2
20    CONTINUE
      C(NRC*NCC+1) = TEMP
      C(NRC*NCC+2) = 0.0
C
C  FILL REMAINDER OF ROW 1 WITH COMPLEX CONJUGATES
C
      DO 30 I=(NRC2+1),(NRC2*((NCC/2)-1)+1),NRC2
         J = J - NRC2
         C(J) = C(I)
         C(J+1) = -C(I+1)
30    CONTINUE
C
C  FOLLOW THE SAME UNPACKING PROCEDURE FOR ROW NRC+1
C  RESHUFFLE ROW NRC+1 INTO COMPLEX FORMAT
C
      TEMP = C(NRC2+1+NRC)
      C(2+NRC) = 0.0
      J = 2*NRC2 + 1 + NRC
      DO 40 I=(NRC2+1+NRC),(NRC2*((NCC/2)-1)+1+NRC),NRC2
         C(I) = C(J)
         J = J + NRC2
         C(I+1) = C(J)
         J = J + NRC2
40    CONTINUE
      C(NRC*NCC+1+NRC) = TEMP
      C(NRC*NCC+2+NRC) = 0.0
C
C  FILL REMAINDER OF ROW NRC+1 WITH COMPLEX CONJUGATES
C
      DO 50 I=(NRC2+1+NRC),(NRC2*((NCC/2)-1)+1+NRC),NRC2
         J = J - NRC2
         C(J) = C(I)
         C(J+1) = -C(I+1)
50    CONTINUE
C
C  FILL REMAINING ROWS WITH REFLECTED COMPLEX CONJUGATES
C  OF ROWS ALREADY FILLED.
C
       JROW = NRC - 1
       DO 100 IROW = (NRC+3),(NRC2-1),2
          C(IROW) = C(JROW)
          C(IROW+1) = -C(JROW+1)
          JCOL = JROW+((NCC-1)*NRC2)
          DO 80 ICOL = IROW+NRC2,(IROW+((NCC-1)*NRC2)),NRC2
             C(ICOL) = C(JCOL)
             C(ICOL+1) = -C(JCOL+1)
             JCOL = JCOL - NRC2
80        CONTINUE
       JROW = JROW - 2
100    CONTINUE
C
900   RETURN
      END
