C*****  VAAM    Vector Add, Add and Multiply       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VAAM (A,IA,B,IB,C,IC,D,ID,E,IE,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector.
C
C       IC      Integer input stride for vector C.
C
C       D       Real input vector.
C
C       ID      Integer input stride for vector D.
C
C       E       Real output vector.
C
C       IE      Integer input stride for vector E.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine adds the elements of a pair of vectors, A and B,
C       adds the elements of a second pair of vectors, C and D; and
C       multiplies the sums, storing the results in vector E.
C
C            E(i) = (A(i) + B(i)) * (C(i) + D(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VAAM (A,1,B,1,C,1,D,1,E,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 0.10
C           2.00           0.20
C           3.00           0.30
C           4.00           0.40
C           5.00           0.50
C
C       C = 2.00       D = 1.00
C           1.00           3.00
C           2.00           2.00
C           2.00           2.50
C           3.00           2.00
C
C       Output Operands:
C
C       E = 3.30
C           8.80
C          13.20
C          19.80
C          27.50
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VAAM(A,IA,B,IB,C,IC,D,ID,E,M,N)
C
      INTEGER IA,IB,IC,ID,M,N,II,JJ,KK,LL,IE,MM
      REAL A(1),B(1),C(1),D(1),E(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      LL = 1
      IE = 1
      DO 10 MM=1,N
        E(IE) = (A(II) + B(JJ)) * (C(KK) + D(LL))
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
        LL = LL+ID
        IE = IE+M
10    CONTINUE
12    RETURN
      END
