C*****  VADD    Vector Add                        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VADD (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine adds the elements of two vectors, A and B,
C       and stores the results in C.
C
C            C(i) = A(i) + B(i)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VADD (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 10.0       B = 1.00
C           20.0           2.00
C           30.0           3.00
C           40.0           4.00
C           50.0           5.00
C
C       Output Operands:
C
C       C = 11.0
C           22.0
C           33.0
C           44.0
C           55.0
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VADD(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II) + B(JJ)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
