C*****  VCMPRS    Vector Compress               MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VCMPRS (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine compresses vector A based on the logical
C       value of elements of vector B.  The elements of A
C       corresponding to non-zero values of B are stored
C       sequentially in vector C.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VCMPRS (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.0
C           2.0
C           3.0
C           4.0
C           5.0
C
C       B = 0.0
C           4.0
C           0.0
C           2.0
C           1.0
C
C       Output Operands:
C
C       C = 2.0
C           4.0
C           5.0
C
C  HISTORY
C         1) Jul 86     D. Benua        Original.
C
      SUBROUTINE VCMPRS(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        IF (B(JJ) .EQ. 0.0) GOTO 8
           C(KK) = A(II)
           KK = KK+IC
8       II = II+IA
        JJ = JJ+IB
10    CONTINUE
12    RETURN
      END
