C*****  VDBCON  Vector Conversion to dB           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VDBCON (A,IA,B,C,IC,N,IFLG)
C
C  where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar, zero dB reference.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   =0 for power definition.
C                   =1 for voltage definition.
C
C
C  DESCRIPTION
C
C       This routine computes the decibel equivalents of the
C       elements of a vector A, relative to a zero-decibel reference
C       scalar B, and stores the results in vector C.  Either power
C       or voltage dB definition can be selected.
C
C            If IFLG = 0:
C
C            C(i) = 10.0 * LOG10(A(i)/B)    for i=1,N
C
C            If IFLG = 1:
C
C            C(i) = 20.0 * LOG10(A(i)/B)    for i=1,N
C
C
C  REFERENCE
C
C       G. W. Jenkins and D. G. Watts.  1969.  Spectral
C       analysis and its applications.  San Francisco: Holden-
C       Day.
C
C
C  EXAMPLE
C
C       CALL VDBCON (A,1,B,C,1,5,0)
C
C       Input Operands:
C
C       A =     1.0
C              10.0
C             100.0
C            1000.0
C           10000.0
C
C       B = 10.0000
C
C       Output Operands:
C
C       C = -10.000
C             0.000
C            10.000
C            20.000
C            30.000
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
      SUBROUTINE VDBCON(A,IA,B,C,IC,N,IFLG)
C
      INTEGER IA,IC,N,IFLG,II,KK,M
      REAL A(1),B,C(1),X
      IF (N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        X = 10.0 * ALOG10(A(II) / B)
        IF (IFLG.EQ.1) X = X + X
        C(KK) = X
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
