C*****  VDIV    Vector Divide                     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VDIV (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine divides the elements of a vector A by
C       the corresponding elements of a vector B and stores
C       the results in vector C.
C
C            C(i) = A(i) / B(i)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VDIV (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.0     B = 0.50
C           2.0         0.40
C           3.0         0.30
C           4.0         0.20
C           5.0         0.10
C
C       Output Operands:
C
C       C = 2.0
C           5.0
C          10.0
C          20.0
C          50.0
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VDIV(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II) / B(JJ)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
