C*****  VFLOT2  Integer*2 to Floating Pt. Conversion MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VFLOT2 (A,IA,C,IC,N)
C
C       where,
C
C       A       Integer input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine converts the elements of a vector A from
C       integer*2 to floating point numbers, and stores the results
C       in vector C.
C
C            C(i) = FLOAT(A(i))    for i=1,N
C
C       This routine is identical to VFLOAT, except that the input
C       vector A is of type integer*2 instead of integer*4.
C
C       Note: this routine is available only on the IBM 3090.
C
C  EXAMPLE
C
C       CALL VFLOT2 (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1
C           2
C           3
C           4
C           5
C
C       Output Operands:
C
C       C = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE VFLOT2(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      INTEGER*2 A(1)
      REAL C(1)
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II)
        II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
