C*****  VGATHR  Vector Gather                     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VGATHR (A,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector, values.
C
C       B       Integer input vector, indices.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine forms a vector C by using the elements of
C       one vector B as the subscripts by which to select the
C       elements of another vector A.  This routine is similar
C       to VINDEX, except the indices are integers and are not
C       truncated or adjusted.
C
C            C(i) = A(B(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VGATHR (A,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 3
C           3.00           5
C           5.00           1
C           7.00           4
C           9.00           2
C
C       Output Operands:
C
C       C = 5.00
C           9.00
C           1.00
C           7.00
C           3.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VGATHR(A,B,IB,C,IC,N)
      INTEGER B(1),IB,IC,N,M,JJ,KK
      REAL A(1),C(1)
      IF (N .LE. 0) GO TO 800
      JJ = 1
      KK = 1
      DO 110 M = 1, N
         C(KK) = A(B(JJ))
         JJ = JJ + IB
         KK = KK + IC
110   CONTINUE
800   RETURN
      END
