C*****  VLINT  Vector Linear Interpolate           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLINT (A,NA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       NA      Integer input element count for vector A.
C
C       B       Real input vector, points at which to
C               sample vector A.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for vectors B and C.
C
C
C  DESCRIPTION
C
C       This routine interpolates values of vector A according
C       to the indicies stored in vector B.  The interpolated
C       values are stored in vector C.  NA must be greater than
C       or equal to 2.  Values stored in vector B must be
C       such that  0 <= INT(B(i)) <= NA-2 for all i=1,N.
C       Indicies of A are assumed to begin with zero.
C
C           IT = INT(B(i))
C           F = B(i) - AINT(B(i))
C           C(i) = A(IT+1) + F*( A(IT+2) - A(IT+1) )   for i=1,N
C
C
C  REFERENCE
C
C       P. Lancaster and K. Salkauskas.  1986.  Curve and sur-
C       face fitting: an introduction.  New York: Academic
C       Press.
C
C
C  EXAMPLE
C
C       CALL VLINT (A,10,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 5.00
C          13.00
C          18.00
C          26.00
C          32.00
C          40.00
C          35.00
C          29.00
C          22.00
C          15.00
C
C       B = 2.000
C           2.500
C           2.666
C           5.500
C           8.250
C
C       Output Operands:
C
C       C = 18.00
C           22.00
C           23.32
C           37.50
C           20.25
C
C  HISTORY
C         1) Jul 86     D. Benua          Original.
C
      SUBROUTINE VLINT(A,NA,B,IB,C,IC,N)
C
      INTEGER NA,IB,IC,N,JJ,KK,M,IT
      REAL A(1),B(1),C(1),F
      IF (N.LE.0 .OR. NA .LT. 2) GO TO 12
      JJ = 1
      KK = 1
      DO 10 M=1,N
        IT = INT(B(JJ))
        F = B(JJ) - AINT(B(JJ))
        IF(IT .LT. 0 .OR. IT .GT. NA-2) GOTO 6
           C(KK) = A(IT+1) + F*( A(IT+2) - A(IT+1) )
           GOTO 8
6       C(KK) = 0.0
8       JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
