C*****  VLOGGM  Vector Log Gamma            MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLOGGM(A,IA,C,IC,N)
C
C       where,
C
C       A     Real input vector of length N.
C
C       IA    Integer input stride for vector A.
C
C       C     Real output vector of length N.
C
C       IC    Integer input stride for vector C.
C
C       N     Integer input element count for vectors A and C.
C
C
C  DESCRIPTION
C
C       This function returns the value C(i) = ln(gamma(A(i))).
C       The values of all A(i) must be greater than 0.  The
C       calculation is based on Stirling's formula and uses
C       the reflection formula for values less than 1.
C
C  REFERENCES
C
C       Milton Abromowitz and Irene A. Stegun. 1964. Handbook of
C       Mathematical Functions. Applied Mathematics Series, Vol 55.
C       Washington: National Bureau of Standards.
C
C
C  EXAMPLE
C
C       CALL VLOGGM(A,1,C,1,10)
C
C       Input Operands:
C
C       A = 0.2500000
C           0.3333333
C           0.6666667
C           0.7500000
C           1.0000000
C           1.5000000
C           2.0000000
C           3.0000000
C           6.0000000
C           9.0000000
C
C       Output Operands:
C
C       C = 1.288022E+00
C           9.854205E-01
C           3.031503E-01
C           2.032809E-01
C          -3.413536E-11
C          -1.207822E-01
C          -7.818723E-11
C           6.931472E-01
C           4.787492E+00
C           1.060460E+01
C
C  HISTORY
C         1) Jan 88     C. Ward           Original.
C
      SUBROUTINE VLOGGM(A,IA,C,IC,N)
C
      REAL A(1),C(1)
      DOUBLE PRECISION COF(6),STP,HALF,ONE,FPF,X,TMP,SER
C
      DATA COF,STP/.7618009173D+2,-.8650532033D+2,.2401409822D+2,
     & -.1231739516D+1,.120858003D-2,-.536382D-5,.250662827465D+1/
      DATA HALF,ONE,FPF/.5D+0,.1D+1,.55D+1/
C
      IF (N.LE.0) GOTO 999
C
      II = 1
      KK = 1
C
      DO 12 I=1,N
C
         IF (A(II).LT.1.0) THEN
            X = 1.0-A(II)
         ELSE
            X = A(II)-ONE
         ENDIF
         TMP = X+FPF
         TMP = (X+HALF)*DLOG(TMP)-TMP
         SER = ONE
         DO 11 J=1,6
            X=X+ONE
            SER = SER+COF(J)/X
 11      CONTINUE
         C(KK) = TMP+DLOG(STP*SER)
         IF (A(II).LT.1.0) THEN
            C(KK)=1.144729886+LOG(1.0-A(II))-C(KK)
     *            -LOG(SIN(3.1415927*(1.0-A(II))))
         ENDIF
         II=II+IA
         KK=KK+IC
 12   CONTINUE
C
 999  CONTINUE
      RETURN
      END
