C*****  VMSB    Vector Multiply and Subtract      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VMSB (A,IA,B,IB,C,IC,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector.
C
C       IC      Integer input stride for vector C.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of two vectors,
C       A and B, and then subtracts the elements of a third
C       vector C from the products.  The results are stored
C       in vector D.
C
C            D(i) = (A(i) * B(i)) - C(i)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VMSB (A,1,B,1,C,1,D,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 0.10        C = 2.0
C           2.00           0.20            3.0
C           3.00           0.30            4.0
C           4.00           0.40            5.0
C           5.00           0.50            6.0
C
C       Output Operands:
C
C       D = -1.90
C           -2.60
C           -3.10
C           -3.40
C           -3.50
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VMSB(A,IA,B,IB,C,IC,D,ID,N)
C
      INTEGER IA,IB,IC,ID,N,II,JJ,KK,LL,M
      REAL A(1),B(1),C(1),D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      LL = 1
      DO 10 M=1,N
        D(LL) = A(II) * B(JJ) - C(KK)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
