C*****  VRANDN  Vector Normal Random Number Generator  MATH ADVANTAGE REL 3.0
C
C  **   COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VRANDN(IS,AMEAN,SDEV,C,IC,N)
C
C       where,
C
C       IS      Integer seed value.
C
C       AMEAN   Real mean value for the normal distribution.
C
C       SDEV    Real standard deviation for the normal distribution.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for vector C.
C
C
C  DESCRIPTION
C
C       This routine fills vector C with a sequence of normally
C       distributed random numbers.  Every element of vector C
C       is filled with a different random number.  The random numbers are
C       normally distributed with a mean of AMEAN and a standard deviation
C       of SDEV.
C
C       Different values of IS will result in different
C       pseudo-random sequences of values being stored in vector C.
C
C  REFERENCE
C
C       US Department of Commerce, National Bureau of Stan-
C       dards, 1977.  Data encryption standard.  Federal Infor-
C       mation Processing Standards Publication no. 46,
C
C
C  EXAMPLE
C
C       CALL VRANDN(IS,100.0,10.0,C,1,5)
C
C       Input operands:
C
C       IS = 1
C
C       Output operands:
C
C       C =  84.78708649
C            91.61515045
C           114.18099213
C           112.55098724
C           111.63014221
C
C
C  HISTORY
C
C       1) August 1986  L. A. Westerman
C       2) February 1987  L.J. Shanbeck
C               Removed check for IC <= 0
C
 
        SUBROUTINE VRANDN(IS,AMEAN,SDEV,C,IC,N)
 
        INTEGER IS
        REAL AMEAN, SDEV, C(1), QTC027
        INTEGER IC, N
 
        INTEGER J, K
 
        IF ( N .LE. 0 ) GO TO 99
        K = 1
        DO 10 J = 1, N
            C(K) = QTC027(IS,AMEAN,SDEV)
            K = K + IC
10      CONTINUE
 
99      CONTINUE
 
        RETURN
        END
