C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VSOCF8                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VSOCF8  (A,IA,B,C,D,E,F,N)                                      *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (*) -                                  *
C      IA      INTEGER  ??IOU*      -                                  *
C      B       REAL     ??IOU*      -                                  *
C      C       REAL     ??IOU*      -                                  *
C      D       REAL     ??IOU*      -                                  *
C      E       REAL     ??IOU*      -                                  *
C      F       INTEGER  ??IOU*  (*) -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/05/28  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/05/06  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      LOGICAL*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****  VSOCF8  Vector Scale, Offset, Clip, Fix, & Pack to 8 bits
C                                                        MTHADV EXT. REL 1.0
C
C  CALL FORMAT
C
C       CALL VSOCF8 (A,IA,B,C,D,E,F,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar for scaling.
C
C       C       Real input scalar for offset.
C
C       D       Real input scalar, lower threshold.
C
C       E       Real input scalar, upper threshold.
C
C       F       Integer output vector.
C
C       N       Integer input element count for vector A.
C
C
C  DESCRIPTION
C
C       This routine multiplies the values of a vector A by
C       a scalar B and adds a scalar C, clipping the results
C       to within a range specified by scalars D and E.
C       The results are changed from type real to type integer
C       data and the least significant 8 bits are packed into
C       the output vector, F.  The last word of F is padded
C       with zeros if needed.  Note: the number of output words
C       in F = (N+nb-1)/nb where nb is the number of bytes per
C       word.
C
C            temp = IFIX(D),         if (A(i)*B+C) < D,
C                 = IFIX(A(i)*B+C),  if D <= (A(i)*B+C) <= E,
C                 = IFIX(E),         if (A(i)*B+C) > E  for i=1,N
C
C            F{i} = AND(temp,X'FF')
C
C            where F{i} is the i-th byte in the vector F and X'FF' is
C            the hexadecimal representation of 255.
C
C            Note: this routine is only available on the CRAY 2.
C
C  EXAMPLE
C
C       CALL VSOCF8 (A,1,B,C,D,E,F,11)
C
C       Input Operands:
C
C       A =  527.49
C           1074.73
C             20.68
C            776.30
C           1407.35
C            874.72
C           1534.82
C            291.07
C           1474.92
C            -86.72
C            470.96
C
C       B =    0.25
C
C       C = -100.00
C
C       D =    0.00
C
C       E =  255.00
C
C       Output Operands on a 32-bit word machine:
C
C       F = X'1FA8005E'
C           X'FB76FF00'
C           X'FF001100'
C
C       Output Operands on a 64-bit word machine:
C
C       F = X'1FA8005EFB76FF00'
C           X'FF00110000000000'
C
C  HISTORY
C         1) Sep 87     R. Coleman      Original.
C
C  LANGUAGE
C       FORTRAN 77 WITH EXTENSION FOR LOGICAL*1
C
C-----------------------------------------------------------------------
C
C  IMPLEMENTATION NOTES:
C       THE IMPLEMENTATION OF THIS ROUTINE IS MACHINE DEPENDENT.  THIS
C       IMPLEMENTATION MAKES USE OF THE LOGICAL*1 DATA TYPE WHICH IS A
C       FORTRAN EXTENSION ON BOTH THE VAX AND IBM.  THE NUMBERING OF
C       BYTES WITHIN A 32-BIT WORD ON A VAX IS BACKWARDS (4,3,2,1) IN
C       COMPARISON WITH THE IBM.  THE LOGICAL PARAMETER "VAX" CONTROLS
C       THE NUMBERING OF BYTES.  VAX = .TRUE. FOR VAX FORTRAN AND
C       VAX = .FALSE. FOR IBM FORTRAN.
C
C       THE ALTERNATE CODE IN COMMENTS IS THE CODE USED IN THE CRAY
C       FORTRAN VERSION (MODIFIED FOR 32-BIT WORDS).  THE ORDER IN
C       WHICH VECTOR ELEMENTS ARE PROCESSED ALSO COMES FROM THE CRAY
C       VERSION SINCE IT ENABLES THE CODE TO VECTORIZE.
C
C-----------------------------------------------------------------------
C
C - modified 12/14/98 - joe m. wade
C
C   code was added to handle byte swapping on a Linux system. I'm not
C   sure changes are correct for all instances, but they correspond to 
C   the xsd_server4 code with which I'm communicating...
C
C-----------------------------------------------------------------------

#include <localsys.h>

      SUBROUTINE VSOCF8 (A, IA, B, C, D, E, F, N)
C
      LOGICAL VAX,INTEL
#ifdef LINUXSYSTEM
      PARAMETER (INTEL = .TRUE.)
#else
      PARAMETER (INTEL = .FALSE.)
#endif
#ifdef VAX
      PARAMETER (VAX = .TRUE.)
#else
      PARAMETER (VAX = .FALSE.)
#endif
C
      INTEGER   IA, F(*), N, K, L
      REAL      A(*), B, C, D, E
      LOGICAL*1 LK(4), LL(4)
      INTEGER   I, II, IA4, J, JA, JA0, J2, KBYTE, LBYTE
      REAL      R, S, T
C
C     DATA MASK / X'FF' /
C
      EQUIVALENCE (K, LK), (L, LL)
C
C-----------------------------------------------------------------------
C
      IF ( N .LE. 0 ) GO TO 800
      IF (VAX .or. INTEL) THEN
         KBYTE = 1
      ELSE
         KBYTE = 4
      ENDIF
C
      J2 = (N + 3) / 4
      DO 110 J = 1, J2
         F(J) = 0
  110 CONTINUE
C
C     ISHFT = 32
C
      IA4   = 4 * IA
      JA0   = 1
      II    = N + 4
      DO 220 I = 1, 4
C
C        ISHFT = ISHFT - 8
C
         JA    = JA0
         II    = II - 1
         J2    = II / 4
         IF (J2 .LE. 0) GO TO 800
C
	 if (INTEL) then
	    LBYTE = I
         else IF (VAX) THEN
            LBYTE = 5 - I
         ELSE
            LBYTE = I
         ENDIF
C
         DO 210 J = 1, J2
            R    = A(JA) * B + C
C
C           S    = CVMGP( R, D, R-D )
C           T    = CVMGP( S, E, E-S )
C
            IF (R .GE. D) THEN
               S = R
            ELSE
               S = D
            ENDIF
C
            IF (E .GE. S) THEN
               T = S
            ELSE
               T = E
            ENDIF
C
c           K    = IDINT( T )    - j.m.wade - T is a real, not a double
            K    = IFIX( T )
C
C           L    = AND( K, MASK )
C           M    = SHIFTL( L, ISHFT)
C           F(J) = OR( F(J), M)
C
            L         = F(J)
            LL(LBYTE) = LK(KBYTE)
            F(J)      = L
C
            JA   = JA + IA4
  210    CONTINUE
         JA0 = JA0 + IA
  220 CONTINUE
C
  800 CONTINUE
      RETURN
      END
