C*****  VTMERG   Tapered Merge of Two Vectors     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VTMERG (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine forms the tapered merge between
C       vectors A and B according to the following
C       formula and stores the result in vector C.
C
C          C(i) = A(i) + ((i-1)*(B(i) - A(i)) / (N-1)
C                 for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VTMERG (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.00     B = 1.40
C           2.00         1.30
C           3.00         1.20
C           4.00         1.10
C           5.00         1.00
C
C       Output Operands:
C
C       C = 1.00
C           1.83
C           2.10
C           1.83
C           1.00
C
C  HISTORY
C         1) Jul 86      D. Benua      Original.
C         2) Aug 87      L. Shanbeck   Test for N=1
C
      SUBROUTINE VTMERG(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1),NM1
      IF (N.LE.0) GO TO 12
      IF (N.GT.1) GO TO 5
      C(1) = A(1)
      GO TO 12
5     NM1 = FLOAT(N-1)
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II) + ((M-1) * (B(JJ) - A(II))) / NM1
        II = II + IA
        JJ = JJ + IB
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
