      SUBROUTINE DMLINE (CTITLE, IPRT,   ITAPIN,   NFOLD,
     &             NREC,   ICC,    IOLEN,  IBYTES, NTRCS,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             RECLEN, NSAMPS, dt, si, nsmpv, siv, tape,
     &             nrecv, intrp, luvel, restart)
C***********************************************************************00000840
C                                                                       00000850
C     PROGRAM NAME: DMLINE (READ LINE HEADER FOR DM3D)                  00000860
C                                                                       00000870
C     LANGUAGE: FORTRAN                                                 00000880
C                                                                       00000890
C     AUTHOR: G.MURPHY                                                  00000900
C                                                                       00000910
C     DATE WRITTEN: 07/01/88                                            00000920
C                                                                       00000930
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000950
C                                                                       00000970
C     ABSTRACT: READS AND CHECKS LINE HEADER.                           00000980
C               STARTS ACCOUNTING.                                      00000990
C               OPENS TAPES.                                            00001000
C               PRINTS BANNER PAGE.                                     00001010
C                                                                       00001020
C                                                                       00001030
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00001040
C                                                                       00001050
C***********************************************************************00001060

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      INTEGER       MHEAD  (SZLNHD)
      CHARACTER*(*) CTITLE
      logical       tape, intrp, restart
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)

C *** PRINT THE BANNER PAGE & OPEN THE LOGICAL INPUT/OUTPUT DEVICES     00001160

      ICC = 0                                                           00001180
c     CALL GAMOCO (CTITLE, 1, IPRT)                                     00001190

C *** READ THE INPUT DATA SET LINE HEADER                               00001220

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      IF (IBYTES .EQ. 0) THEN
         WRITE (IPRT, 100)
  100    FORMAT(/, 1X, '** M0100 ** ERROR DETECTED BY PROGRAM DM3D'  ,
     &             2X, 'END-OF-FILE ENCOUNTERED WHILE ATTEMPTING '   ,
     &                 'TO READ THE INPUT DATA ',                   /,
     &            45X, 'SET LINE HEADER. VERIFY THE DATA SET NAMES ' ,
     &                 'AND IN THE CASE OF'     ,                   /,
     &            45X, 'MULTI-VOLUME DATA SETS, VERIFY THE ORDER '   ,
     &                 'THEY WERE CATALOGED.',                      /)
         ICC = 100
      END IF
c     CALL HLH (JHEAD, IBYTES, 'DM3D', 4, IPRT)

C *** GET INFO FROM LINE HEADERS                                        00001380


      call saver (JHEAD, 'NumTrc', NTRCi  , LINHED)
      call saver (JHEAD, 'NumRec', NRECi  , LINHED)
      call saver (JHEAD, 'NumSmp', NSAMPS , LINHED)
      call saver (JHEAD, 'Format', IFMT   , LINHED)
      NTRCS = NTRCi

      IOLEN = SZSMPD * NSAMPS + SZTRHD


      call saver (JHEAD, 'CDPFld', NFOLDi , LINHED)
      call saver (JHEAD, 'UnitFl',IHEAD71 , LINHED)
      call saver (JHEAD, 'StWdFl',I2STAT  , LINHED)
      call saver (JHEAD, 'MnLnIn', MINLIi , LINHED)
      call saver (JHEAD, 'MxLnIn', MAXLIi , LINHED)
      call saver (JHEAD, 'MnDpIn', MINDIi , LINHED)
      call saver (JHEAD, 'MxDpIn', MAXDIi , LINHED)
      call saver (JHEAD, 'ILClIn', IDXi   , LINHED)
      call saver (JHEAD, 'CLClIn', IDYi   , LINHED)
      call saver (JHEAD, 'DptInt', IHEAD76, LINHED)
      call saver (JHEAD, 'SmpInt', IS     , LINHED)
      call saver (JHEAD, 'UnitSc', unitsc , LINHED)

      if (unitsc .eq. 0.0) then
          write(IPRT,*)'********************************************'
          write(IPRT,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPRT,*)'         will set to .001 (millisec default)'
          write(IPRT,*)'********************************************'
          unitsc = .001
          call savew(JHEAD, 'UnitSc', unitsc, LINHED)
      endif

      DXi = IDXi
      DYi = IDYi
      SI = IS
      dt = float (IS) * unitsc

      if (MINLI .eq. 0) MINLI = MINLIi
      if (MINDI .eq. 0) MINDI = MINDIi

      write(IPRT,*)NFOLD,MINLI,MAXLI,MINDI,MAXDI,DX,DY,IS

      RECLEN = IS * NSAMPS

C *** ROUTINE LINE HEADER ERROR CHECKS (FORMAT, NO. OF SAMPLES)         00001550

      WRITE (IPRT, 110) MINLIi,MAXLIi,MINDIi,MAXDIi,DYi,DXi,NFOLDi
  110 FORMAT (//, 30X, '3-D INPUT LINE HEADER VALUES:',
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  CROSS-LINE CELL INCREMENT . . .',F15.5  ,
     &        //, 23X, '  IN-LINE CELL INCREMENT. . . . .',F15.5  ,
     &        //, 23X, '  INPUT CELL FOLD.......... . . .',I9  ,//)

C *** ROUTINE LINE HEADER ERROR CHECKS (FORMAT, NO. OF SAMPLES)

      IF (IFMT .NE. 1 .AND. IFMT .NE. 3) THEN
         WRITE (IPRT, 120)
  120    FORMAT(/, 1X, '** M0120 ** ERROR DETECTED BY PROGRAM DM3D'  ,
     &             2X, 'THE FORMAT CODE IN THE INPUT DATA SET LINE ' ,
     &                 'HEADER IS NOT SPECIFIED'                   ,/,
     &            45X, 'AS FORMAT 1 OR FORMAT 3.'                  ,/)
         ICC = 100
      END IF

      IF (IOLEN .GT. 32256) THEN
         WRITE (IPRT, 130)
  130    FORMAT(/, 1X, '** M0130 ** ERROR DETECTED BY PROGRAM DM3D'  ,
     &             2X, 'THE NUMBER OF SAMPLES IN THE INPUT DATA SET ',
     &                 'LINE HEADER EXCEEDS THE '                  ,/,
     &            45X, 'PROGRAM LIMIT. PROGRAM DM3D CAN PROCESS '    ,
     &                 '16000 FORMAT 1 SAMPLES '                   ,/,
     &            45X, 'OR 8000 FORMAT 3 SAMPLES.'                 ,/)
         ICC = 100
      END IF

      if (.not.tape) return
c----
c  open optional velocity tape data set
c----
      CALL RTAPE (luvel , MHEAD, MBYTES)
      call saver (MHEAD, 'NumTrc', ntrcv  , LINHED)
      call saver (MHEAD, 'NumRec', nrecv  , LINHED)
      call saver (MHEAD, 'NumSmp', nsmpv  , LINHED)
      call saver (MHEAD, 'SmpInt', nsiv   , LINHED)

      write(iprt,*)'Velocity tape # recs  = ',nrecv
      write(iprt,*)'Velocity tape # samps = ',nsmpv
      if (ntrcv .ne. 1) then
         write(iprt,*)'Fatal Error in dm3d:'
         write(iprt,*)'Velocity tape does not contain 1-trc records'
         write(iprt,*)'Check velocity tape building steps'
         stop
      endif

      siv = nsiv
      r = siv / si
      intrp = .false.
      if (r .gt. 1.0) then
         write(iprt,*)'Input velocity data set has sample interval= ',
     1                 siv
         write(iprt,*)'Input data set has sample interval= ',
     1                 si
         write(iprt,*)'The ratio= ',r
         write(iprt,*)'The velocity traces will be interpolated in time'
         intrp = .true.
      endif

      RETURN
      END
