      SUBROUTINE DMTAPE (IPRT,   ITAPIN, luout , IBYTES, luvel, nu,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, nsmpv,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, siv,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, tape,
     &             nrecv, intrp, restart, divexp, amn, amx,
     &             nang, inca, luang, spread, ngrp, mode, iem,
     &             ttap, reverse, iord, lunrm, tap1, dt, saf, halt)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      parameter     (npol = 6)

      external      fpoly
      integer       intbin
      DIMENSION     TC (*), VC (*)
      DIMENSION     RHEAD  (SZLNHD)
      DIMENSION     TRACE  (SZLNHD)
      INTEGER       VHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       luout (*)
      integer       lunrm, obytes
      integer       irrec, nrrec, abytes
      real          vel1(SZLNHD), timvec(SZLNHD),  spread (*)
      real          tvel(SZLNHD), vcoefs(npol), errparms(5)
      real          vrms(SZLNHD), vsrms(SZLNHD)
      real          vism(SZLNHD),vit(SZLNHD), V(SZLNHD)
      real          tima(SZLNHD), work(SZLNHD), sig(SZLNHD)
      real          vel_array(SZLNHD), t_array(SZLNHD)

      REAL          SUM, STK, TAB, angio, angio1, angles
      pointer       (wkstk,   STK(1))
      pointer       (wksum,   SUM(1))
      pointer       (wktab,   TAB(1))
      pointer       (wkangio,  ANGIO(1))
      pointer       (wkangio1, ANGIO1(1))
      pointer       (wkangles, ANGLES(1))


      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character     tap1 * (*), ttap * (*)
      character     name * 7
      logical       verbos, norm, shot, tape, intrp, restart, reverse
      logical       fit, halt, detm, first

      real          amn (63,70), amx (63,70)
      real          angmn (SZLNHD), angmx (SZLNHD)

      real          tabl1 (SZLNHD), tabl2 (SZLNHD), zz (4*SZLNHD)
      integer       iz (SZLNHD)
      real          zza (4*SZLNHD)
      integer       iza (SZLNHD)

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)

      DATA first   / .false. /
      DATA name    / 'angst3d' /

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLD /-999999999 /
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/

      if (saf .eq. 0.) then
         fit = .false.
      else
         fit = .true.
      endif

      pi    = 3.14159265
      deg   = 180. /  pi

      call vclr (errparms, 1, 5)
      ierr = 0

      call minmgv (spread, 1, xmin, loc, ngrp)
      write(LER,*)' '
      write(LER,*)'Minimum offset= ',xmin,' at group ',loc
      if (abs (xmin) .lt. 1.e-10) then
         spread (loc) = .0005
      endif
      write(LER,*)' '

      dxg = TRCSPC

      icinit = 1
      icflag = 1

      nsmpa = nsamps / inca
      dta = inca * dt
      sia = inca * si

      do  i = 1, nsamps
          timvec (i) = float (i-1) * dt
          t_array (i) = i * dt
      enddo
      do  i = 1, nsmpa
          tima (i) = float (i-1) * dta
      enddo
      vtmax  = timvec (nsamps)
      vtmaxa = tima (nsamps)

      do  k = 1, nang
          angmn (k) = amn (k,1)
          angmx (k) = amx (k,1)
      enddo
      write(LERR,*)'angmn'
      write(LERR,*)(angmn(ii),ii=1,nang)
      write(LERR,*)'angmx'
      write(LERR,*)(angmx(ii),ii=1,nang)

      do  i = 1, nsmpv
          tvel   (i) = float (i-1) * siv / 1000.
      enddo

C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      IREC = 0


c---
c  there are 3 output files that are basically read/write:
c  (1) output data itself - consists of binned angle stacks with
c      each bin containing "nang" traces (stacked traces for that
c      pair of min/max angles.

c  (2) angle data set - consists of angles computed by the ray tracer
c      and sampled every inca samples (will be cubic spline interpolated
c      when read in).

c  (3) normalization data set - consists of sample-by-sample normalization
c      for each of the output angle traces (will be the same size as the
c      main output data set).

c      in addition there is the RMS velocity data set (which may be sampled
c      coarsely).
c---

C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)
      
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'angst3d starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'Min offset used  =   ',DSTMIN
      write(LER,*)'Max offset used  =   ',DSTMAX
      write(LER,*)'*********************************'
      write(LER,*)' '

      if (nu .eq. 1) then
         NRECo  = NX * NY
         NTRCo  = nang
         NTRKS  = NX * NY * nang
         nangi  = nang
      else
         NRECo  = NX
         NTRCo  = NY
         NTRKS  = NX * NY
         nangi  = 1
      endif
      NTRKSi = (ndi + 1) * (nli + 1) * nang

      write(LER,*)'nang,nangi= ',nang,nangi
      write(LER,*)'NTRKS = ',NTRKS
      write(LER,*)'NTRKSi= ',NTRKSi

      NBYTR  = NSAMPS * SZSMPD
      NBYTA  = nsmpa  * SZSMPD
      NTRKA  = NX * NY * ngrp
      obytes = NBYTR + SZTRHD
      abytes = NBYTA + SZTRHD

      NXNY  = NX * NY

      write(LERR,*)'nx,ny,nxny= ',nx,ny,nxny,dt,nang,dxg,nu

      if (nrecv .ne. nxny) then
         write(LERR,*)'FATAL ERROR in angst3d:'
         write(LERR,*)'number of records in velocity tape data set'
         write(LERR,*) nrecv
         write(LERR,*)'is not equal to number of output cells'
         write(LERR,*) nxny
         write(LERR,*)'Check velocity tape building steps'
         stop
      endif
      if (intrp) then
         do  i = 1, nsmpv
             tabl1 (i) = float (i) * siv
         enddo
         do  i = 1, nsamps
             tabl2 (i) = float (i) * si
         enddo
      endif

c---
c  tab   - I/O vector for the D/A normalization file
c  angio - I/O vector for the ray traced angle file
c---
      itema = nsmpa
      itemt = nsamps
      items = nsamps * nang
      itemd = nsamps * ngrp
      itemp = nsamps * npol


      call galloc (wktab,    SZSMPD * itemt , ierr1, iabort1)
      call galloc (wkstk,    SZSMPD * items , ierr2, iabort2)
      call galloc (wksum,    SZSMPD * items , ierr3, iabort3)
      call galloc (wkangles, SZSMPD * itemd , ierr4, iabort4)
      call galloc (wkangio,  SZSMPD * itema , ierr5, iabort5)
      call galloc (wkangio1, SZSMPD * itema , ierr6, iabort6)

      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     1    ierr4 .ne. 0 .or. ierr5 .ne. 0 .or. ierr6 .ne. 0) then
         write(LER ,*)'Unable to allocate arrays - too big'
         write(LER ,*)'3 arrays each sized ',SZSMPD*items,' bytes'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif
      write(LER ,*)'samps ',nsamps,nsmpa

      call vclr ( TAB, 1, nsamps)
      call vclr ( angio,  1, nsmpa)
      call vclr ( angio1, 1, nsmpa)


      write(LER ,*)' '
      write(LER ,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LER ,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt
      write(LER ,*)'NX,NY,nxy,items= ',NX,NY,NDI,NLI,items
      write(LER ,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LER ,*)'ntrcs,angmax,scale= ',ntrcs,angmax
      write(LER ,*)'TRCSPC= ',TRCSPC,' SI= ',si,' norm? ',norm
      write(LER ,*)' '

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NTRCo  , LINHED)
      call savew (JHEAD, 'NumRec', NRECo  , LINHED)
      call savew (JHEAD, 'NumSmp', NSAMPS , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'CDPFld', nang   , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then
         call savhlh (JHEAD, IBYTES, lbyout)
      endif

      if (.not. restart) then

         do  iu = 1, nu
             call rwd (luout (iu) )
             CALL WRTAPE (luout (iu) , JHEAD, lbyout)
         enddo
         call rwd (lunrm)
         call savew (JHEAD, 'NumTrc', nang   , LINHED)
         call savew (JHEAD, 'NumRec', NXNY   , LINHED)
         CALL WRTAPE (lunrm, JHEAD, lbyout)
         call rwd (luang)
         call savew (JHEAD, 'NumTrc', ngrp   , LINHED)
         call savew (JHEAD, 'NumRec', NXNY   , LINHED)
         call savew (JHEAD, 'NumSmp', nsmpa  , LINHED)
         CALL WRTAPE (luang, JHEAD, lbyout)

         call savew (JHEAD, 'NumTrc', NTRCo  , LINHED)
         call savew (JHEAD, 'NumRec', NRECo  , LINHED)
         call savew (JHEAD, 'NumSmp', nsamps , LINHED)

      else

         do  iu = 1, nu
             call rwd (luout (iu) )
             CALL  RTAPE (luout (iu) , JHEAD, LBYTES)
         enddo
         if (lbytes .eq. 0) then
            write(LERR,*)'Fatal error in angst3d:'
            write(LERR,*)'Restart failed because output file does'
            write(LERR,*)'not have a line header. You must re-run'
            write(LERR,*)'from scratch.'
            stop 666
         endif
         call sislgbuf (luang, 'off')
         call sislgbuf (lunrm, 'off')
         call rwd (luang)
         CALL RTAPE (luang, JHEAD, KBYTES)
         call rwd (lunrm)
         CALL RTAPE (lunrm, JHEAD, KBYTES)

      endif


c-----
c     fill up output data set and the rewind and read over LH
c     do same for the angles data (it may be sampled more coarsely)
c-----
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)

      if (.not. restart) then
         call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , TRACEHEADER)
         call savew2(JHEAD,ifmt_VPick1,l_VPick1, ln_VPick1,
     1               0     , TRACEHEADER)
         do  iu = 1, nu
             write(LER,*)'Building output data file ',iu,
     1                   ' with ',NTRKS,' traces'
             do  i = 1, NTRKS
                 call wrtape (luout(iu) , jhead, obytes)
             enddo
         enddo

         write(LER,*)'Building angles data file',
     1                   ' with ',NTRKA,' traces'
         call vmov (angio, 1, jhead(ITHWP1), 1, nsmpa)
         do  i = 1, NTRKA
             call wrtape (luang, jhead, abytes)
         enddo
         call sislgbuf (luang, 'off')

      endif

      do  iu = 1, nu
c         call rwd (luout(iu) )
          call sislgbuf (luout(iu) , 'off')
c         call rtape (luout(iu) , jhead, IBYTES)
      enddo
      call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            0 , TRACEHEADER)

c-----
c *** fill up file for normalization
c-----
      if (.not.restart) then

         write(LER,*)'Building normalization data file',
     1                   ' with ',NTRKSi,' traces'
         call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)
         do  i = 1, NTRKSi
             call wrtape (lunrm, jhead, obytes)
         enddo
         call sislgbuf (lunrm, 'off')

      endif


      write(LER,*)'Built I/O files: you have enough disk space'

c-----
C *** zero out output and normalization panels
c-----
      call vclr (stk, 1, nang * nsamps)
      call vclr (sum, 1, nang * nsamps)

c-----
c     For the spread geometry (trace distances) and for all bins:
c     read the velocities; pre-compute all the ray traced angles (which
c     we'll need when turning the trace to be stacked on and off), and
c     store the angle info on disk in decimated form
c-----
      IF (restart) go to 1400

      write(LER ,*)' '
      write(LER ,*)'Computing angles:'
      write(LER ,*)'mindi,maxdi,minli,maxli= ',mindi,maxdi,minli,maxli

      DO  J = mindi, maxdi
          DO  I = minli, maxli

c-----
c  get velocity if it is a velocity tape data set. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
              if (verbos) then
                 write(LER ,*)'Angles for LI,DI= ',I,J
              endif

              ipntr = (J - mindi) + (I - minli) * ndi + 1
              call sisseek (luvel, ipntr)
              call rtape (luvel, vhead, nvbytes)
              if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in angst3d:'
                 write(LERR,*)'Premature end of velocity data at LI/DI= 
     1',I,J
                 write(LERR,*)'Check velocity tape building steps.'
                 stop
              endif
              call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
              if (intrp) then
                 call fcuint (tabl1, vel1, nsmpv, tabl2, vel_array,
     1                        nsamps, iz, zz, icinit)
                 icinit = 0
              else
                 call vmov (vel1, 1, vel_array, 1, nsamps)
              endif
              call minv (vel_array, 1, vmin, loc, nsamps)
              if (vmin .le. 0.) then
                 write(LERR,*)'FATAL ERROR in angst3d:'
                 write(LERR,*)'detected velocity < 0. Something bad'
                 write(LERR,*)'either in input velocity traces, or'
                 write(LERR,*)'in the interpolation.'
                 stop
              endif

c----
c   for each bin we now have the RMS velocity
c   now we compute the smoothed RMS, the smoothed interval, and
c   the unsmoothed interval
c   NOTE: we now assume the RMS velocity field has already been properly
c         smoothed
c----
              if (fit) then
                 call sloper (t_array, vel_array, nsamps, saf)
              endif
              call fitvel (t_array, vel_array, nsamps, nsamps, dt,
     1                     vcoefs, sig, ch, vrms, vsrms, vism, vit,
     2                     iord, fit, jerr)

c----
c   now do the ray tracing and compute angles for the offsets
c   NOTE: dt & spread should both be divided by 2, i.e. the ray
c   tracer uses the half-sample interval and the half-offset.
c   However, since the calculations essentially involve ratios
c   of these quantities we ca get by with the 2-way S.I. & the
c   fill offset
c----
              if (iem .eq. 0) then

                 call crvray (ngrp, angles, timvec, spread, vrms,
     1                        vcoefs, dt, nsamps, mode, vtmax, ierr,
     2                        errparms, vsrms, vism, vit, deg)
              else
                 call creray (ngrp, angles, timvec, spread, vrms,
     1                        vcoefs, dt, nsamps, mode, vtmax, ierr,
     2                        errparms, vsrms, vism, vit, deg)
              endif

c----
c   ray tracing done for this bin (I,J). Now decimate the angle records
c   in time and write to the output R/W file
c----
              do  k = 1, ngrp

                  istrc  = (k-1) * nsamps + 1
                  call vmov (angles(istrc), 1, work, 1, nsamps)
                  ii = 0
                  do  l = 1, nsamps, inca
                      ii = ii + 1
                      angio (ii) = work (l)
                  enddo

                  kpntr  = (I - minli) * ndi * ngrp +
     1                     (J - mindi) * ngrp + k

                  call vmov (angio, 1, jhead(ITHWP1), 1, nsmpa)
                  call sisseek (luang, kpntr)
                  call wrtape  (luang, jhead, abytes)
              enddo

          ENDDO
      ENDDO

      call gfree  (wkangles)
1400  CONTINUE

      call galloc (wkangles, SZSMPD * itemt , ierr4, iabort2)

      write(LER,*)'Completed ray tracing for all bins'

      if (halt) then
         write(LER,*)'angst3d stopped after angle file built and after'
         write(LER,*)'normalization file ready for use. You can now'
         write(LER,*)'restart program using -R on cmd line'
         return
      endif

      write(LER,*)'Now reading & angle stacking traces'
c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = IOLEN
      IWRN = 0
      call vclr (trace, 1, nt)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDIST  , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD  = IRREC
         NRREC = NRREC + 1
         write(LER,*)'Angle Stack on Record ',NRREC
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

      IDIST = IABS (IDIST)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, ISLI)
      IRDIMN = MIN (IRDIMN, ISDI)
      ICLIMN = MIN (ICLIMN, ISLI)
      ICDIMN = MIN (ICDIMN, ISDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, ISLI)
      IRDIMX = MAX (IRDIMX, ISDI)
      ICLIMX = MAX (ICLIMX, ISLI)
      ICDIMX = MAX (ICDIMX, ISDI)
      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)


C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )

      if (off .gt. DSTMAX) go to 1500
      if (off .lt. DSTMIN) go to 1500

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

c----
c   if the current midpoint location of this trace is out of bounds
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c-----
c  find the pointer into the spread array for the current offset
c-----
          joff = intbin (ngrp, dxg, spread, off)

c-----
c  get velocity if it is a velocity tape data set. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
              ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
              call sisseek (luvel, ipntr)
              call rtape (luvel, vhead, nvbytes)
              if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in angst3d:'
                 write(LERR,*)'Premature end of velocity data at LI/DI=
     1',ICLI,ICDI
                 write(LERR,*)'Check velocity tape building steps.'
                 stop
              endif
              call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
              if (intrp) then
                 call fcuint (tabl1, vel1, nsmpv, tabl2, V, nsamps,
     1                        iz, zz, icinit)
                 icinit = 0
              else
                 call vmov (vel1, 1, V, 1, nsamps)
              endif
              call minv (V, 1, vmin, loc, nsamps)
              if (vmin .le. 0.) then
                 write(LERR,*)'FATAL ERROR in angst3d:'
                 write(LERR,*)'detected velocity < 0. Something bad'
                 write(LERR,*)'either in input velocity traces, or'
                 write(LERR,*)'in the interpolation.'
                 stop
              endif

c-----
c  (1) extract the current stacked data traces from this cell
c  (2) extract the current normalization traces from this cell
c-----
      call vclr (tab, 1, nsamps)

             ipntri = (ICLI - minli) * ndi * nangi + 
     1                (ICDI - mindi) * nangi + 1
             ic = 0
             do  iu = 1, nu
                call sisseek (luout(iu) , ipntri)
                do  k = 1, nangi
                    ic = ic + 1
                    istrc = (ic-1) * nsamps+1
                    call rtape (luout(iu) , jhead, nbytes)
                    call vmov (jhead(ITHWP1), 1, stk(istrc), 1, nsamps)
                enddo
             enddo

             ipntr  = (ICLI - minli) * ndi * nang  + 
     1                (ICDI - mindi) * nang
             do  k = 1, nang
                 ipntr = ipntr + 1
                 istrc = (k-1) * nsamps+1
c                read (lunrm, rec = ipntr) tab
                 call sisseek (lunrm, ipntr)
                 call rtape   (lunrm, jhead, nbytes)
                 call vmov (jhead(ITHWP1), 1, sum(istrc), 1, nsamps)
             enddo
c-----
c  extract the angle matrix from this cell & expand it
c-----
             jpntr = (ICLI - minli) * ndi * ngrp + 
     1               (ICDI - mindi) * ngrp + joff

             call sisseek (luang, jpntr)
             call rtape  (luang, jhead, nbytes)
             call vmov   (jhead(ITHWP1), 1, angio, 1, nsmpa)

             if (joff .gt. 1) then

                jpntr1 = jpntr - 1
                call sisseek (luang, jpntr1)
                call rtape  (luang, jhead, nbytes)
                call vmov   (jhead(ITHWP1), 1, angio1, 1, nsmpa)
                call xtrp   (angio1, work, angio, off, nsmpa,
     1                       spread(joff-1), spread(joff)    )
             endif
             call fcuint (tima, angio, nsmpa, timvec, angles,
     1                    nsamps, iza, zza, icflag)
             icflag = 0

c-----
c  take current input trace and stack the samples into the current
c  bin stack according to which samples lie within the angle range
c  based on the ray traced angles for the current cell (joff'th offset)
c-----
c     call maxmgv(sum,1,smax,loc,nang*nsamps)

             call stack (nang, ngrp, nsamps, stk, sum, dt, off,
     1                   trace, angles, angmn, angmx, V, joff,
     2                   norm, reverse)

777   format(10f7.0)
    

c     call maxmgv(sum,1,xmax,loc,nang*nsamps)
c     write(LER ,*)'S,D,R,bins: ',ISLI,ISDI,ICLI,ICDI,IRLI,IRDI,
c    1 joff,smax,xmax

c-----
c  put new summed angle stack & normalization back into current cell
c-----
             ipntri = (ICLI - minli) * ndi * nangi + 
     1                (ICDI - mindi) * nangi + 1
             ic = 0
             do  iu = 1, nu
                call sisseek (luout(iu) , ipntri)
                do  k = 1, nangi
                    ic = ic + 1
                    istrc = (ic-1) * nsamps + 1
                    call vmov (stk(istrc), 1, jhead(ITHWP1), 1, nsamps)
                    call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          0      , TRACEHEADER)
                    call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                          ICDPX   , TRACEHEADER)
                    call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                          ICDPY   , TRACEHEADER)
                    call wrtape (luout(iu) , jhead, obytes)
                enddo
             enddo

             ipntr  = (ICLI - minli) * ndi * nang  + 
     1                (ICDI - mindi) * nang

             do  k = 1, nang
                 ipntr = ipntr + 1
                 istrc = (k-1) * nsamps+1
                 call vmov (sum(istrc), 1, jhead(ITHWP1), 1, nsamps)
                 call sisseek (lunrm, ipntr)
                 call wrtape  (lunrm, jhead, obytes)
             enddo

      ENDIF

      go to 1500
 5000 CONTINUE

      write(LER,*)' '
      write(LER,*)'Completed angle stacking...'

      call rwd (lunrm)
      CALL RTAPE (lunrm, JHEAD, KBYTES)

      write(LER,*)'... now doing normalization step'
      write(LER,*)'min/max li/di= ',minli,maxli,mindi,maxdi
      write(LER,*)' '

      DO  J = mindi, maxdi
          DO  I = minli, maxli
 
              ipntri = (I - minli) * ndi * nangi + 
     1                 (J - mindi) * nangi + 1
              ipntr  = (I - minli) * ndi * nang  + 
     1                 (J - mindi) * nang

                  ic = 0
                  do  k = 1, nang

                      ic = ic + 1
                      ipntr = ipntr + 1
                      call sisseek (lunrm, ipntr)
                      call rtape   (lunrm, jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, tab, 1, nsamps)
                      if (nu .gt. 1) then
                         call sisseek (luout(ic) , ipntri)
                      elseif (nu .eq. 1 .AND. ic .eq. 0) then
                         call sisseek (luout(1) , ipntri)
                      endif
                      call rtape (luout(ic) , jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, trace, 1, nsamps)

                      im = 0
                      detm = .false.
                      do  ii = 1, nsamps
                          xlive = tab (ii)
                          if (xlive .eq. 0.) then
                          if (.not.detm) im = im + 1
                              xlive = 1.
                          else
                              detm = .true.
                              imt  = im * si
                          endif
                          trace (ii) = trace (ii) / (xlive ** divexp)
                          live = nint (xlive)
                          maxfld = max (maxfld, live)
                      enddo

                      call center_xy ( I, J, IX1, IY1, dx, dy, name,
     1                                 XX, XY, YX, YY, XYT, YXT,
     2                                 XXT, YYT, LER, LERR, IXC, IYC,
     3                                 first)
                      call savew2(jhead,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                            IXC , TRACEHEADER)
                      call savew2(jhead,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                            IYC , TRACEHEADER)

                      if (im .eq. nsamps)
     1                call savew2(jhead,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                            30000 , TRACEHEADER)
                      call savew2(jhead,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                            imt , TRACEHEADER)
                      call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            I      , TRACEHEADER)
                      call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            J      , TRACEHEADER)
                      call savew2(jhead,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            I   , TRACEHEADER)
                      call savew2(jhead,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            J   , TRACEHEADER)

                      if (nu .gt. 1) then
                         call sisseek (luout(ic) , ipntri)
                      elseif (nu .eq. 1 .AND. ic .eq. 0) then
                         call sisseek (luout(1) , ipntri)
                      endif
                      call vmov (trace, 1, jhead(ITHWP1), 1, nsamps)
                      call wrtape (luout(ic) , jhead, obytes)
                  enddo
          ENDDO
      ENDDO

      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,MAXFLD
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM STACK REDUNDANCY. . . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'angst3d processed ',NRREC,' records'
      ICC = 0

      RETURN
      END
