C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(  ntap, otap, ptap, x1, y1, x2, y2,
     :     x3, y3, x4, y4, dx, dy, CdpInt, incrLI, incrDI, minLI, maxLI,
     :     minDI, maxDI, NumVertices, Vertex_XY, LI_DI,
     :     DI_ordered, WalkOffMax, Average, verbos )

c     ntap  - C*255  input file name
c     otap  - C*255  output file name
c     ptap1 - C*255  xsd pickfile name [optional]
c     x1 thru x4  - I*4 X co-ordinates of corners
c     y1 thru y4 - I*4  co-ordinates of corners
c     dx - R*4 spacing in X direction
c     dy - R*4 spacing in Y direction
c     cdpint - R*4 cdp spacing on output traverse line in same units as
c                  (x,y) pairs
c     incrLI - I*4 input LinInd increment
c     incrDI - I*4 input DphInd increment
c     minLI - I*4 minimum LinInd on input
c     maxLI - I*4 maximum LinInd on input
c     minDI - I*4 minimum DphInd on input
c     maxDI - I*4 maximum DphInd on input
c     NumVertices -I*4 number of vertices in traverse on command line
c     Vertex_XY[] - R*4 array of vertice co-ordinates in X,Y system of
c                         input stacked data
c     LI_DI[] - I*4 array of vertice co-ordinates in li,di coordinate space

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine


      integer x1, y1, x2, y2, x3, y3, x4, y4
      integer incrLI, incrDI, WalkOffMax
      integer minLI, maxLI, minDI, maxDI, NumVertices
      integer LI_DI(2,SZLNHD)

      real dx, dy, cdpint, Vertex_XY(2,SZLNHD)

      character  ntap*(*), otap*(*), ptap*(*)

      logical DI_ordered, Average, verbos

c declare local variables

      integer argis, LI, DI, done

      real X, Y

c initialize variables

      NumVertices = 1
      done = 0

c parse command line

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-P',ptap, ' ', ' ')

      Average = (argis('-avg') .gt. 0)

      call argr4( '-cdpint', cdpint, 12.5, 12.5)

      DI_ordered = (argis('-DI') .gt. 0)
      call argi4( '-dii', incrDI, 1, 1 )
      call argi4( '-lii', incrLI, 1, 1 )
      call argr4( '-dx', dx, 1., 1. )
      call argr4( '-dy', dy, 1., 1. )

      call argi4( '-maxdi', maxDI, 9999999, 9999999 )
      call argi4( '-mindi', minDI, 9999999, 9999999 )
      call argi4( '-maxli', maxLI, 9999999, 9999999 )
      call argi4( '-minli', minLI, 9999999, 9999999 )

      call argi4( '-nout', WalkOffMax, 60, 60 )

      call argi4( '-x1', x1, 0, 0 )
      call argi4( '-x2', x2, 0, 0 )
      call argi4( '-x3', x3, 0, 0 )
      call argi4( '-x4', x4, 0, 0 )

      call argi4( '-y1', y1, 0, 0 )
      call argi4( '-y2', y2, 0, 0 )
      call argi4( '-y3', y3, 0, 0 )
      call argi4( '-y4', y4, 0, 0 )

      verbos = (argis('-V') .gt. 0)

      if ( ptap .eq. ' ' ) then
         
         do while ( done .eq. 0 )

            call argr4 ( '-x', X, 9999999., 9999999. )
            call argr4 ( '-y', Y, 9999999., 9999999. )
            call argi4 ( '-li',LI , 9999999, 9999999 )
            call argi4 ( '-di', DI, 9999999, 9999999 )

            if ( ( abs( X - 9999999. ) .gt. 1.e-32 .and. 
     :           abs( Y - 9999999.) .gt. 1.e-32 ) .or.
     :           ( LI .ne. 9999999 .and. DI .ne. 9999999 ) )then
               Vertex_XY(1,NumVertices) = X
               Vertex_XY(2,NumVertices) = Y
               LI_DI(1,NumVertices) = LI
               LI_DI(2,NumVertices) = DI
               NumVertices = NumVertices + 1
            else
               done = 1
            endif

         enddo

         NumVertices = NumVertices - 1

      endif

c Policemen

      if ( ptap .eq. ' ' .and. NumVertices .eq. 1 ) then
         write(LERR,*)' '
         write(LERR,*)' No traverse control entered.  Must supply '
         write(LERR,*)' turning points for line to be extracted '
         write(LERR,*)' from the input volume in the form of either '
         write(LERR,*)' an XSD pickfile or as (x,y) control points'
         write(LERR,*)' on the command line'
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LERR,*)' AT3D: No traverse control entered.  Must supply'
         write(LERR,*)'       turning points for line to be extracted '
         write(LERR,*)'       from the input volume in the form of  '
         write(LERR,*)'       either an XSD pickfile or as (x,y) '
         write(LERR,*)'       control points on the command line'
         write(LERR,*)' FATAL '
         goto 999
      endif

      if( dx .le. 0.0 .or. dy .le. 0.0 ) then
         write(LERR,*)' '
         write(LERR,*)' both -dx and -dy entries must be '
         write(LERR,*)' greater than zero.  You have input'
         write(LERR,*)' -dx = ',dx,' -dy = ',dy
         write(LERR,*)' please correct this problem and resubmit'
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' '
         write(LER,*)' AT3D: both -dx and -dy entries must be '
         write(LER,*)'       greater than zero.  You have input'
         write(LER,*)'       -dx = ',dx,' -dy = ',dy
         write(LER,*)'       correct this problem and resubmit'
         write(LER,*)' FATAL'
         write(LER,*)' '
         goto 999
      endif

      return

 999  continue
      
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' at3d: Abnormal Termination'
      stop

      end
