C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, ptap, x1, y1, x2, y2, x3, y3, x4, 
     :     y4, dx, dy, CdpInt, incrLI, incrDI, minLI, maxLI, minDI, 
     :     maxDI, NumVertices, Vertex_XY, LI_DI,
     :     Vertex_XY_Transformed, nsamp, ntrc, nrec, iform, nsi, 
     :     Num_CDPS, XSD_Record, XSD_Trace, XSD_Sample, 
     :     DI_ordered, WalkOffMax, Average, verbos ) 

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer x1, y1, x2, y2, x3, y3, x4, y4, NumVertices
      integer incrLI, incrDI, minLI, maxLI, minDI, maxDI
      integer nsamp, ntrc, nrec, iform, nsi, Num_CDPS
      integer LI_DI(2,NumVertices), WalkOffMax
      integer lenth

      real dx, dy, CdpInt
      real Vertex_XY(2,NumVertices)
      real Vertex_XY_Transformed(2,NumVertices)
      real XSD_Record(NumVertices), XSD_Trace(NumVertices)
      real XSD_Sample(NumVertices)

      character  ntap*(*), otap*(*), ptap*(*)

      logical    DI_ordered, Average, verbos

c declare local variables

      integer length

c begin output

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
	write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
	write(LERR,*) ' input data set name   =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
	write(LERR,*) ' output data set name  =  ', otap(1:length)
      else
	write(LERR,*) ' output data set name  =  stdout'
      endif
      if ( ptap .ne. ' ' ) then
         length = lenth(ptap)
	 if (length .gt. 0) then
          write(LERR,*) ' input xsd pickfile name = ', ptap(1:length)
	 endif
      endif
      write(LERR,*) ' start record          =  1'
      write(LERR,*) ' end record            =  ', Num_CDPS
      write(LERR,*) ' start trace           =  1'
      write(LERR,*) ' end trace             =  1'
      write(LERR,*) ' processing sample start =  1'
      write(LERR,*) ' processing sample end   = ', nsamp
      write(LERR,*)' '
      if ( DI_ordered ) then
         write(LERR,*)' '
         write(LERR,*)' DphInd indexing increases across record boundari
     :es '
         write(LERR,*)' '
      endif
      if ( Average ) then
         write(LERR,*)' '
         write(LERR,*)' Nearest neighbor trace averaging requested'
         write(LERR,*)' '
      endif
      write(LERR,*) ' number of trace seeks from outside volume allowed 
     : =  ',WalkOffMax
      write(LERR,*)' '
      write(LERR,*)' Grid Corner Parameters '
      write(LERR,*)' '
      write(LERR,*)' (x1,y1) = (',x1,', ',y1,')'
      write(LERR,*)' (x2,y2) = (',x2,', ',y2,')'
      write(LERR,*)' (x3,y3) = (',x3,', ',y3,')'
      write(LERR,*)' (x4,y4) = (',x4,', ',y4,')'
      write(LERR,*)' '
      write(LERR,*)' Grid Cell Dimensions '
      write(LERR,*)' '
      write(LERR,*)' dx = ', dx
      write(LERR,*)' dy = ', dy
      write(LERR,*)' '
      write(LERR,*)' Dataset (LI,DI) Dimensions '
      write(LERR,*)' '
      write(LERR,*)' minimum LI = ', minLI
      write(LERR,*)' maximum LI = ', maxLI
      write(LERR,*)' minimum DI = ', minDI
      write(LERR,*)' maximum DI = ', maxDI
      write(LERR,*)' '
      write(LERR,*)' LI increment = ', incrLI
      write(LERR,*)' DI increment = ', incrDI
      write(LERR,*)' '
      write(LERR,*)' Arbitrary Traverse Parameters '

      if ( ptap .ne. ' ' ) then
         if (verbos) then
            write(lerr,*) ' '
            write(lerr,*) ' XSD picks (record, trace, sample) '
            write(lerr,*) ' --------------------------------- '
            write(lerr,*) ' '
            do i = 1, NumVertices
               write(lerr,*) XSD_Record(i), XSD_Trace(i), XSD_Sample(i)
            enddo
         endif
         write(LERR,*)' '
         write(LERR,*)' Traverse Turning Vertices '
         write(LERR,*)' '
         do i = 1, NumVertices
            write(LERR,*)' (x', i, ',y', i, ') = (',
     :           Vertex_XY_Transformed(1,i), ',', 
     :           Vertex_XY_Transformed(2,i), ')'
         enddo
      else
         write(LERR,*)' '
         write(LERR,*)' Traverse Turning Vertices '
         write(LERR,*)' '
         do i = 1, NumVertices
            write(LERR,*)' (x', i, ',y', i, ') = (',
     :           Vertex_XY(1,i), ',', Vertex_XY(2,i), ')'
         enddo
         write(LERR,*)' '
         do i = 1, NumVertices
            write(LERR,*)' (LI', i, ',DI', i, ') = (',
     :           LI_DI(1,i), ',', LI_DI(2,i), ')'
         enddo
      endif

      if ( verbos )  then
         write(LERR,*)' '
         write(LERR,*) ' verbose printout requested'
      endif
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





