C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  azfilt: read input data and kill traces based
c                             on whether or not they fall into a
c                             given range of azimuths
C
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     itr (SZLNHD)
      integer     argis
#include <f77/pid.h>
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ierr, iabort
      integer 	  lenth, length
      real        az, as, ae

      integer     azbin
      pointer     (wkazbin, azbin(1))
      
      CHARACTER   NAME * 6, ntap * 256, otap * 256

      logical     verbos, kill, pass
 
      DATA NAME     /'AZFILT'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./
      data iabort/1/

      rad2deg = 180. / 3.14159265
      deg2rad = 3.14159265 / 180.

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,as,ae,na,kill,pass,verbos)

     
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c----
c  read line header of input save certain parameters
c----
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LOT,*)'azfilt: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call hlhprt (itr, lbytes, name, 9, LERR)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

c define number output bytes
 
      obytes = SZTRHD + nsamp * SZSMPD
 
c inject command line into historical lineheader
 
      call savhlh ( itr, lbytes, lbyout )
 
c write output lineheader
 
      call wrtape ( luout, itr, lbyout )

      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
	write(LERR,*)'Input data set name      = ',ntap(1:length)
      else
	write(LERR,*)'Input data set name      = stdin'
      endif
      length = lenth(otap)
      if (length .gt. 0) then
	write(LERR,*)'Output data set name     = ',otap(1:length)
      else
	write(LERR,*)'Output data set name     = stdout'
      endif
      write(LERR,*)'Number traces/record     = ',ntrc
      write(LERR,*)'Number records           = ',nrec
      write(LERR,*)'Mark zero traces as dead = ',kill
      if (pass) then
      write(LERR,*)'Pass traces between ',as,' and ',ae
      else
      write(LERR,*)'Reject traces between ',as,' and ',ae
      endif

      nbin = 360. / na
      call galloc (wkazbin, nbin * SZSMPD, ierr, iabort)
      if (ierr .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)nbin * SZSMPD,' bytes'
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*)nbin * SZSMPD,' bytes'
      else 
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)nbin * SZSMPD,' bytes'
      endif

      call vclr (azbin, 1, nbin)

      ipas = 0
      irej = 0
      itrc = 0
      irec = 1

      DO  while (1.eq.1)

          nbytes = 0
          call rtape (luin, itr, nbytes)
          if(nbytes .eq. 0) then
             write(LERR,*)'End of file on input:'
             write(LERR,*)'  rec= ',irec,'  trace= ',irec
             go to 999
          endif

          itrc = itrc + 1
          if (itrc .gt. ntrc) then
              itrc = 1
              irec = irec + 1
              if (verbos) then
              write(LERR,*)'Reading record ',irec
              write(LER ,*)'Reading record ',irec
              endif
          endif

          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                istatic  , TRACEHEADER)

          IF ( istatic .ne. 30000) THEN

C *** GET SHOT COORDINATE                                               00004930
 
             call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                   ISX     , TRACEHEADER)
             call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                   ISY     , TRACEHEADER)
             SX = ISX
             SY = ISY
 
C *** GET RECEIVER COORDINATE                                           00004980
 
             call saver2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                   IRX     , TRACEHEADER)
             call saver2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                   IRY     , TRACEHEADER)
             RX = IRX
             RY = IRY
 
c---
c  compute azimuth: zero degrees points along positive X
c  avoid pathological situations where src & srcvr are coincident
c---
             deltay = SY - RY
             deltax = SX - RX

             if ( deltax .ne. 0. .AND. deltay .ne.0. ) then

                az = rad2deg * atan2 ( deltay, deltax )
                if (az .lt. 0.0) az = abs (az + 360.)

c---
c  figure out which bin current azimuth belongs and add "1" to that bin
c---
                ibin = nint ( az / float (na) )
                if ( ibin .eq.    0) ibin = 1
                if ( ibin .gt. nbin) ibin = nbin
                azbin (ibin) = azbin (ibin) + 1

c---
c  pass data between start/end azimuths
c---
                if ( pass ) then

                   if ( az .ge. as .AND. az .le. ae) then

                      ipas = ipas + 1

                   else

                      do  i = 1, nsamp
                          itr (ITHWP1 + i) = 0
                      enddo
                      if ( kill ) call savew2(itr,ifmt_StaCor,l_StaCor,
     1                            ln_StaCor, 30000 , TRACEHEADER)
                      irej = irej + 1

                   endif

c---
c  reject data between start/end azimuths
c---
                else

                   if ( az .ge. as .AND. az .le. ae) then

                      do  i = 1, nsamp
                          itr (ITHWP1 + i) = 0
                      enddo
                      if ( kill ) call savew2(itr,ifmt_StaCor,l_StaCor,
     1                            ln_StaCor, 30000 , TRACEHEADER)
                      irej = irej + 1
                   else

                      ipas = ipas + 1

                   endif

                endif

c---
c  for src & rcvr coincident just kill it
c---
             else

                   irej = irej + 1
                   do  i = 1, nsamp
                       itr (ITHWP1 + i) = 0
                   enddo
                   if ( kill ) call savew2(itr,ifmt_StaCor,l_StaCor,
     1                         ln_StaCor, 30000 , TRACEHEADER)
                   write(LERR,*)'Found trace with zero delta X/Y'

             endif


          ENDIF

          call wrtape (luout, itr, nbytes)


      ENDDO

999   continue

      write(LERR,*)'azfilt completed processing ',irec,' records'
      write(LER ,*)'azfilt completed processing ',irec,' records'
      write(LERR,*)'Rejected ',irej,' traces and passed ',ipas,' traces'
      write(LER ,*)'Rejected ',irej,' traces and passed ',ipas,' traces'
      write(LERR,*)' '
      write(LERR,*)'Azimuth histogram distribution'
      write(LERR,*)'Angle (start/end)  Occurrences'
      ias = 0
      do  i = 1, nbin
          iae = i * na
          write(LERR,*)ias,'    ',iae,'    ',azbin(i)
          ias = iae
      enddo

      call lbclos (luin)
      call lbclos (luout)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for tim2hed3d: read flat'
        write(LER,*)'file of 3D workstation time picks keyed to XYs'
        write(LER,*)'and stuff them into input traces'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] (def = stdin) : input seismic data'
        write(LER,*)'-P[vtap] (def = none)  : workstation pick file'
        write(LER,*)' '
        write(LER,*)
     :' -as[as]      (def = none)  : start azimuth (deg) to reject/pass'
        write(LER,*)
     :' -ae[ae]      (def = none)  : end azimuth (deg) to reject/pass'
        write(LER,*)
     :' -bs[nb]      (def = 15)    : size (deg) azimuth bin'
        write(LER,*)'-P         : pass traces within as -> ae, else'
        write(LER,*)'             reject traces within as -> ae'
        write(LER,*)'-D         : mark zeroed traces as dead'
        write(LER,*)'-V         : verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   azfilt -N[] -O[] -as[] -ae[] -bs[] [ -P -D -V ]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,as,ae,na,kill,pass,verbos)

#include <f77/iounit.h>

      character  ntap*(*), otap*(*)
      integer    argis, na
      logical    verbos, kill, pass

         call argstr ('-N',ntap,' ',' ')
         call argstr ('-O',otap,' ',' ')

         call argr4 ('-as', as, 0. , 0. )
         call argr4 ('-ae', ae, 0. , 0. )
         call argi4 ('-bs', na, 15 , 15 )

         if (as .eq. 0. .AND. ae .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR in azfilt:'
            write(LERR,*)'Must supply different -as[] -ae[]'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR in azfilt:'
            write(LER ,*)'Must supply different -as[] -ae[]'
            call ccexit (666)
         endif
 
         kill      = ( argis( '-D' ) .gt. 0 )
         pass      = ( argis( '-P' ) .gt. 0 )
         verbos    = ( argis( '-V' ) .gt. 0 )

      return
      end
