      SUBROUTINE DMTAPE (IPRT, ITAPIN, luout, IBYTES, ANGMIN,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, spread,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, dxg,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, shot, restart, dt,
     &             iwin, amp)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      INTEGER       intbin
      DIMENSION     TC (*), VC (*)
      REAL          spread (SZLNHD)
      REAL          wrk1 (SZLNHD), wrk2 (SZLNHD)
      DIMENSION     RHEAD  (SZLNHD)
      DIMENSION     TRACE  (SZLNHD)
      DIMENSION     V      (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       obytes
      integer       ordfft, irrec, nrrec
      REAL          SUM, TAB
      pointer       (wksum,   SUM(1))
      pointer       (wktab,   TAB(1))

      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical       verbos, shot, restart, angflt, reverse

      real          MAXANG, MINANG
      integer       ISLIMN,ISDIMN,IRLIMN,IRDIMN,ICLIMN,ICDIMN,ISLIMX
      integer       ISDIMX,IRLIMX,IRDIMX,ICLIMX,ICDIMX,MINDST,MAXDST
      integer       MAXFLD

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
c     EQUIVALENCE  (TRACE, RHEAD(65))

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLD /-999999999 /
      DATA MAXANG /-999999999./
      DATA MINANG / 999999999./
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/
      DATA reverse / .false. /
      DATA angflt  / .false. /

      pi = 3.14159265
      deg = 180. / pi
      nu = ordfft( nsamps )
      nt = 2 ** nu

      amp  = .01 * amp * 2047
      iwin = float (iwin) / si

      if (iwin .le. 0 .or. iwin .gt. nsamps) then
            iwin = nsamps / 2
      endif
      iwin = iwin + ( mod (iwin,2) - 1 )

c     write(LER,*)'iwin,amp= ',iwin,amp


      icinit = 1

C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      IREC = 0

C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)
      

c----
c  the output data set will be NX x NY cells, each cell will have
c  NFOLD traces. The data will be organized into NXNY records each
c  with NFOLD traces
c----
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      if (MINLI .eq. 0) then
          MINLI  = 1
      endif
      if (MINDI .eq. 0) then
          MINDI  = 1
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      NRECo  = NDI * NLI
      NTRKS  = NDI * NLI * NFOLD
      ngrp   = NFOLD
      obytes = nsamps * SZSMPD + SZTRHD

      NXNY  = NX * NY
      NXY   = sqrt ( float(NX*NX) + float(NY*NY) )

      if (angmin .eq. angmax) then
          angflt = .false.
      else
          angflt = .true.
      endif
      write(LERR,*)'angmin/max= ',angmin,angmax,angflt

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'CDP Bin Stack starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'*********************************'
      write(LER,*)' '

      write(LERR,*)'nx,ny,nxny= ',nx,ny,nxny,si,dt

      items = nsamps
      call galloc (wktab,   SZSMPD * nsamps, ierr3, iabort3)
      call galloc (wksum,   SZSMPD * nsamps, ierr1, iabort1)

      if (ierr1 .ne. 0 .or. ierr3 .ne. 0) then
         write(LER ,*)'Unable to allocate DMO arrays - too big'
         write(LER ,*)'2 arrays each sized ',SZSMPD*items,' Mb'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

      call vclr ( TAB, 1, nsamps)


      write(LERR,*)' '
      write(LERR,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LERR,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt
      write(LERR,*)'NX,NY,items= ',NX,NY,NDI,NLI,items
      write(LERR,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LERR,*)'ntrcs,angmax,scale= ',ntrcs,angmax,nfold
      write(LERR,*)'TRCSPC= ',TRCSPC,' SI= ',si,' shot? ',shot
      write(LERR,*)'spread (#chans = ',ngrp,'):'
      write(LERR,*)(spread(i),i=1,ngrp)
      write(LERR,*)' '

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NFOLD  , LINHED)
      call savew (JHEAD, 'NumRec', NRECo  , LINHED)
      call savew (JHEAD, 'NumSmp', NSAMPS , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'CDPFld', NFOLD  , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then
         CALL WRTAPE (luout , JHEAD, IBYTES)
      endif

c-----
C *** fill up output data set and the rewind and read over LH
c-----
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)

      if (.not. restart) then
         do  i = 1, NTRKS
             call wrtape (luout , jhead, obytes)
         enddo
      endif
      call rwd (luout )
      call sislgbuf (luout , 'off')
      call rtape (luout , jhead, IBYTES)


c-----
C for flat file velocity function input
c-----
      call vel (TC, VC, nsamps, si, npairs, V)
      call maxmgv (V, 1, vmax, loc, nsamps)
      call minmgv (V, 1, vmin, loc, nsamps)
      write(LERR,*)'vmin/max= ',vmin,vmax

c-----
C *** zero out sum trace
c-----
      call vclr (sum, 1, nsamps)

c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = IOLEN
      IWRN = 0
      call vclr (trace, 1, nt)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDISTs , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD = IRREC
         NRREC = NRREC + 1
         write(LER,*)'CDP gather on Record ',IRREC
         write(LER,*)' '
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

      IDIST = IABS (IDISTs)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, IRLI)
      IRDIMN = MIN (IRDIMN, IRDI)
      ICLIMN = MIN (ICLIMN, ICLI)
      ICDIMN = MIN (ICDIMN, ICDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, IRLI)
      IRDIMX = MAX (IRDIMX, IRDI)
      ICLIMX = MAX (ICLIMX, ICLI)
      ICDIMX = MAX (ICDIMX, ICDI)
      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)

      H = 0.5 * IDIST

C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )

      if (off .gt. DSTMAX) go to 1500
      if (off .lt. DSTMIN) go to 1500

      IWRN = 0

      if (angflt) then
         phi = deg * atan2 ( DYT, DXT)
         if (phi .gt. angmin .AND. phi .lt. angmax) IWRN = 1
         maxang = amax1 (maxang, phi)
         minang = amin1 (minang, phi)
      endif

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

C *** COMPUTE THE TRACE SPACING

      B = SQRT (DDX*DDX + DDY*DDY)

c----
c   if the current midpoint location of this trace is out of bounds
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----
      IWRN = 0

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c-----
c  find the pointer into the spread array for the current offset
c-----
          joff = intbin (ngrp, dxg, spread, off)

c-----
c  extract the cumulative trace from the current bin and offset (within
c  current bin)
c  do forward NMO on it to reduce effects of residual NMO on the
c  fidelity of the offset bin stacking
c  add to it the current trace, reverse NMO, and write it back to disk
c-----
          reverse = .false.
          call nmo (trace, V, wrk1, off, nsamps, dt, wrk2, reverse)

          ipntr = (ICLI - minli) * ndi * nfold + 
     1            (ICDI - mindi) * nfold + joff

          call sisseek (luout , ipntr)
          call rtape (luout , jhead, nbytes)
          call vmov (jhead(ITHWP1), 1, sum, 1, nsamps)
          call vadd (wrk2, 1, sum, 1, trace, 1, nsamps)
          call vmov (trace, 1, jhead(ITHWP1), 1, nsamps)
          call sisseek (luout , ipntr)

               idis = nint (spread (joff) )
               call savew2(JHEAD,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                     icdi  , TRACEHEADER)
               call savew2(JHEAD,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     icli  , TRACEHEADER)
               call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     icdi  , TRACEHEADER)
               call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     icli  , TRACEHEADER)
               call savew2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     idis   , TRACEHEADER)
               call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                     ICDPX   , TRACEHEADER)
               call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                     ICDPY   , TRACEHEADER)

          call wrtape (luout , jhead, nbytes)

      END IF

      go to 1500
 5000 CONTINUE

      write(LER,*)' '
      write(LER,*)'Doing reverse NMO step'
      write(LER,*)' '

      reverse = .true.
      DO  J = minli, maxli
          DO  K = mindi, maxdi
          DO  I = 1, ngrp

              ipntr = (J - minli) * ndi * nfold +
     1                (K - mindi) * nfold + I
 
              call sisseek (luout , ipntr)
              call rtape (luout , jhead, nbytes)
              call vmov  (jhead(ITHWP1), 1, sum, 1, nsamps)
              call dotpr (sum, 1, sum, 1, sumx, nsamps)
              call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                    idist  , TRACEHEADER)
              dis = abs ( float(idist) )
              if (sumx .lt. 1.e-30) then
                 call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       J      , TRACEHEADER)
                 call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       K      , TRACEHEADER)
                 call savew2(JHEAD,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                       J      , TRACEHEADER)
                 call savew2(JHEAD,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                       K      , TRACEHEADER)
                 call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       30000  , TRACEHEADER)
              else
                 call nmo (sum, V, wrk1, dis, nsamps, dt, wrk2, reverse)
                 call dagcab (wrk2, tab, nsamps, iwin, amp)
                 call vmult  (nsamps, wrk2, tab)
                 call vmov (wrk2, 1, jhead(ITHWP1), 1, nsamps)
              endif
              call sisseek (luout , ipntr)
              call wrtape  (luout , jhead, nbytes)
          ENDDO
          ENDDO
      ENDDO



      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,minang,maxang,MAXFLD
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM ANGLE.... . . . . . . .',1X,F4.0,
     &        //, 23X, '  MAXIMUM ANGLE.... . . . . . . .',1X,F4.0,
     &        //, 23X, '  MAXIMUM STACK REDUNDANCY. . . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'Binned ',NRREC,' records'
      ICC = 0

      RETURN
      END
