C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include     <f77/iounit.h>

      integer   limin, limax, dimin, dimax
      integer   ix1, ix2, ix3, ix4, iy1, iy2, iy3, iy4
      integer   ixc (4), iyc (4)
      integer   ixo (4), iyo (4)
      integer   mask (4)
      integer   NWx, NEx, SEx, SWx
      integer   NWx_fringe, NEx_fringe, SEx_fringe, SWx_fringe
      integer   NWy, NEy, SEy, SWy
      integer   NWy_fringe, NEy_fringe, SEy_fringe, SWy_fringe
      integer   argis

      real      dx, dy

      REAL*8    XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL*8    DE, DF, E, F, XYYXXY

      logical   para, NSEW

      data      mask/4*0/
      data      NSEW/.false./


c initialize variables

      rad2deg = 180. / 3.14159265
      pi2     = 3.14159265 / 2.

c get command line help if requested
      
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif
 
c parse command line

      call cmdln ( ix1, iy1, ix2, iy2, ix3, iy3, ix4, iy4, dx, dy, 
     :     dimin, dimax, limin, limax, para )

      ixc (1) = ix1
      ixc (2) = ix2
      ixc (3) = ix3
      ixc (4) = ix4
      ixo (1) = ix1
      ixo (2) = ix2
      ixo (3) = ix3
      ixo (4) = ix4
      iyc (1) = iy1
      iyc (2) = iy2
      iyc (3) = iy3
      iyc (4) = iy4
      iyo (1) = iy1
      iyo (2) = iy2
      iyo (3) = iy3
      iyo (4) = iy4

c test for parallelogram

      CALL XFMI ( IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1     IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT, para )
 
      if (para) then
         write(ler,*)' '
         write(ler,*)' '
         write(ler,*)'corners: Normal Completion '
         stop
      endif

      DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
      DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
      XYYXXY =  XYT * YXT - XXT * YYT
      if (XYYXXY .eq. 0.) then
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in corners:'
         write(LER ,*)'Attempt to use survey coords to fill in bin'
         write(LER ,*)'centers failed due to coord transform'
         write(LER ,*)'singularity (bad coord choice most likely)'
         stop 666
      endif
      
      dely = iy2 - iy1
      delx = ix2 - ix1
      
      dx2 = .5 * dx
      dy2 = .5 * dy
      dr  = amin1 (dx2, dy2)

      if (abs(delx) .lt. dr) delx = 0.
      if (abs(dely) .lt. dr) dely = 0.
      if (delx .eq. 0.0 .OR. dely .eq. 0.0) NSEW = .true.

      theta = atan2 ( dely, delx)
      phi   = pi2 - atan  ( abs(dely / delx) )
      dxcos = dx2 * cos (phi)
      dxsin = dx2 * sin (phi)
      dycos = dy2 * cos (phi)
      dysin = dy2 * sin (phi)

      thetad = rad2deg * theta
      phid   = rad2deg * phi
      
      if (limax .eq. 0) limax = NX
      if (dimax .eq. 0) dimax = NY

      write(LER ,*)' '
      write(LER ,*)'Input box:'
      write(LER ,*) ' X1, Y1 =  ',ix1,'  ',iy1
      write(LER ,*) ' X2, Y2 =  ',ix2,'  ',iy2
      write(LER ,*) ' X3, Y3 =  ',ix3,'  ',iy3
      write(LER ,*) ' X4, Y4 =  ',ix4,'  ',iy4
      write(LER ,*) ' inline (side 1-2) dimension =  ',dy
      write(LER ,*) ' xline (side 2-3) dimension  =  ',dx
      write(LER ,*) ' number cells along 1-2      =  ',ny
      write(LER ,*) ' number cells along 2-3      =  ',nx
      write(LER ,*)' '
      write(LER ,*) ' minimum LI = ',limin
      write(LER ,*) ' minimum DI = ',dimin
      write(LER ,*) ' maximum LI = ',limax
      write(LER ,*) ' maximum DI = ',dimax
      write(LER ,*)' '
      write(LER ,*) ' angle of 1-2 direction to E-W axis = ',thetad
      write(LER ,*) ' angle of 1-2 direction to E-W axis = ',phid
      write(LER ,*) ' delta Y length caused by adding half bin to'
      write(LER ,*) ' to 1-2 direction = ',dycos,dysin
      write(LER ,*) ' delta X length caused by adding half bin to'
      write(LER ,*) ' to 1-4 direction = ',dxcos,dxsin
      write(LER ,*)' '
      
      
      E = (DBLE(FLOAT(limin)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimin)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX1 = CDPX
      ICDPY1 = CDPY
      
      E = (DBLE(FLOAT(limin)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimax)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX2 = CDPX
      ICDPY2 = CDPY
      
      E = (DBLE(FLOAT(limax)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimax)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX3 = CDPX
      ICDPY3 = CDPY
      
      E = (DBLE(FLOAT(limax)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimin)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX4 = CDPX
      ICDPY4 = CDPY

      minx = min (ix1, ix2, ix3, ix4)
      miny = min (iy1, iy2, iy3, iy4)
      maxx = max (ix1, ix2, ix3, ix4)
      maxy = max (iy1, iy2, iy3, iy4)

      IF ( NSEW ) THEN

         NWx = minx
         NWy = maxy
         NEx = maxx
         NEy = maxy
         SEx = maxx
         SEy = miny
         SWx = minx
         SWy = miny

      ELSE
   
         do  i = 1, 4
             if (minx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                 NWx = ixc(i)
                 NWy = iyc(i)
                 mask (i) = 1
                 go to 1
             endif
         enddo
1        continue
                           
         do  i = 1, 4
             if (maxy .eq. iyc(i) .AND. mask(i) .eq. 0) then
                 NEx = ixc(i)
                 NEy = iyc(i)
                 mask (i) = 1
                 go to 2
             endif
         enddo
2        continue

         do  i = 1, 4
             if (maxx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                 SEx = ixc(i)
                 SEy = iyc(i)
                 mask (i) = 1
                 go to 3
             endif
         enddo
3        continue

         do  i = 1, 4
             if (miny .eq. iyc(i) .AND. mask(i) .eq. 0) then
                 SWx = ixc(i)
                 SWy = iyc(i)
                 mask (i) = 1
                 go to 4
             endif
         enddo
4        continue

      ENDIF

      do  i = 1, 4

          if     (NWx .eq. ixc(i) .AND. NWy .eq. iyc(i)) then

              NWx_fringe = NWx - dxsin - dycos
              NWy_fringe = NWy - dxcos + dysin
              ixo (i) = NWx_fringe
              iyo (i) = NWy_fringe

          elseif (NEx .eq. ixc(i) .AND. NEy .eq. iyc(i)) then

              NEx_fringe = NEx + dxsin - dycos
              NEy_fringe = NEy + dxcos + dysin
              ixo (i) = NEx_fringe
              iyo (i) = NEy_fringe

          elseif (SEx .eq. ixc(i) .AND. SEy .eq. iyc(i)) then

              SEx_fringe = SEx + dxsin + dycos
              SEy_fringe = SEy + dxcos - dysin
              ixo (i) = SEx_fringe
              iyo (i) = SEy_fringe

          elseif (SWx .eq. ixc(i) .AND. SWy .eq. iyc(i)) then

              SWx_fringe = SWx - dxsin + dycos
              SWy_fringe = SWy - dxcos - dysin
              ixo (i) = SWx_fringe
              iyo (i) = SWy_fringe
      
          endif
      enddo
      
      write(LER,*)' '
      write(LER,*)'CORNER BIN CENTER XYs contained with input box:'
      write(LER,*)' '
      write(LER,*)' Corner 1 [limin:dimin] - X ',ICDPX1,'  Y ',ICDPY1
      write(LER,*)' Corner 2 [limin:dimax] - X ',ICDPX2,'  Y ',ICDPY2
      write(LER,*)' Corner 3 [limax:dimax] - X ',ICDPX3,'  Y ',ICDPY3
      write(LER,*)' Corner 4 [limax:dimin] - X ',ICDPX4,'  Y ',ICDPY4
      write(LER,*)' '

      write(LER,*)' '
      write(LER,*)'CORNER XYs for 1/2-bin fringe around input box:'
      write(LER,*)' '
      write(LER,*)' Corner 1 [+fringe]     - X ',ixo(1),'  Y ',iyo(1)
      write(LER,*)' Corner 2 [+fringe]     - X ',ixo(2),'  Y ',iyo(2)
      write(LER,*)' Corner 3 [+fringe]     - X ',ixo(3),'  Y ',iyo(3)
      write(LER,*)' Corner 4 [+fringe]     - X ',ixo(4),'  Y ',iyo(4)
      write(LER,*)' '

      write(ler,*)' '
      write(ler,*)' '
      write(ler,*)'corners: Normal Completion '
      
      stop
      end
