C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FKKFilter(Input, nxIN, nyIN, Filter, nxF, nyF,
     :                     work, work1, workc, nffy, nffx,
     :                     lenitabx,lenitaby,lenrtabx,lenrtaby,
     :                     itaby,itabx,rtaby,rtabx,ipwry,ipwrx,
     :                     inity,initx,maxft,lagx,lagy,
     :                     first, irec, ftaper, xcorr,SZSMPD,
     :                     debug,luout1,obytes1,ITHWP1,lhed2)

      real     Input (nxIN,nyIN), Filter (nxF,nyF)
      real     xcorr (lagx,lagy)
      complex  work  (nffx,nffy)
      complex  work1 (nffx,nffy)
      complex  workc (maxft)
      integer  nxIN, nyIN, nxF, nyF
      integer  lenitabx, lenitaby, lenrtabx, lenrtaby
      integer  itabx (lenitabx), itaby(lenitaby)
      real     rtabx(lenrtabx), rtaby(lenrtaby), ftaper
      integer  ipwrx (5), ipwry (5), irec
      logical  first, debug
      integer  luout1,obytes1,ITHWP1,lhed2(*),SZSMPD
      

c------------
c          Compute dot products of inputs for normaization
c------------
       if (ftaper .ne. 0.0) then
           call taper (Input, nxIN, nyIN, ftaper)
       endif

       xnorma = 0.0
       do  j = 1, nyIN
           do  i = 1, nxIN
               xnorma = xnorma + Input (i,j) * Input (i,j)
           enddo
       enddo
      
       IF (.not. first) THEN

          if (ftaper .ne. 0.0) then
              call taper (Filter, nxF, nyF, ftaper)
          endif

          xnormb = 0.0
          do  j = 1, nyF
              do  i = 1, nxF
                  xnormb = xnormb + Filter (i,j) * Filter (i,j)
              enddo
          enddo

       ENDIF
      
c------------
c          For nonzero input:

c       .. Fourier transform:  (y,x) --> (ky,kx)
c          2D X-correlation is product in kx,ky
c       .. Fourier transform: (ky,kx) --> (y,x)

c       .. Normalize
c------------
      do  j = 1, nffy
          do  i = 1, nffx
              work  (i,j) = 0.
              work1 (i,j) = 0.
          enddo
      enddo

      IF (xnorma .ne. 0.0 .AND. xnormb .ne. 0.0) THEN

         call corf2d   (Input, nxIN, nyIN, Filter, nxF, nyF,
     :                  work,work1,workc,nffx,nffy,initx,inity,
     :                  lenitabx,lenitaby,lenrtabx,lenrtaby,
     :                  itabx,itaby,rtabx,rtaby,ipwrx,ipwry,
     :                  maxft, lagx, lagy, xcorr, SZSMPD,
     :                  debug,luout1,obytes1,ITHWP1,lhed2)


      ELSE

         do  j = 1, lagy
             do  i = 1, lagx
                 xcorr (i,j) = 0.0
             enddo
         enddo

      ENDIF

      return
      end
