C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taper (array, nx, ny, ftaper)

      real     array (nx, ny)
      real     ftaper, pi

      pi = 3.14159265

      nxt = nx * ftaper
      nyt = ny * ftaper
      if (nxt .lt. 3) return

      argx = pi / float (nxt)

      DO  j = 1, ny

          do  i = 1, nxt

              wt = .5 * (1. + cos (argx * float (i)) )
              array (nxt-i+1, j) = wt * array (nxt-i+1, j)
              array (nx-nxt+i,j) = wt * array (nx-nxt+i,j)
          enddo
      ENDDO

      if (nyt .lt. 3) return

      argy = pi / float (nyt)
 
      DO  i = 1, nx
 
          do  j = 1, nyt
 
              wt = .5 * (1. + cos (argy * float (j)) )
              array (i, nyt-j+1) = wt * array (i, nyt-j+1)
              array (i,ny-nyt+j) = wt * array (i,ny-nyt+j)
          enddo
      ENDDO

      return
      end
