      SUBROUTINE DMTAPE (IPRT,   ITAPIN, luout , IBYTES, ngrp,
     &             IREC,   NREC,   IOREC,  ICC, spread,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, lusht, lurcv,
     &             DSTMIN, DSTMAX, NLI, NDI, luoff,
     &             NSAMPS, IFMT,   SI,      dt,     IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, nooff,
     &             restart, divexp, pr, ol, prew)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      DIMENSION     RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      INTEGER       MHEAD  (SZLNHD)
      INTEGER       NHEAD  (SZLNHD)
      integer       obytes
      integer       intbin, ordfft, irrec, nrrec
      REAL          spread (*), peo (SZLNHD)
      REAL          offnvec, offauto
      REAL          offnorm, auto, trace, work, autor, autos, autox
      REAL          work1
      pointer       (wkoffnvec,   offnvec(1))
      pointer       (wkoffauto,   offauto(1))
      pointer       (wkoffnorm,   offnorm(1))
      pointer       (wkauto   ,   auto   (1))
      pointer       (wkautor  ,   autor  (1))
      pointer       (wkautos  ,   autos  (1))
      pointer       (wkautox  ,   autox  (1))
      pointer       (wktrace  ,   trace  (1))
      pointer       (wkwork   ,   work   (1))
      pointer       (wkwork1  ,   work1  (1))

      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical       verbos, norm, shot, restart, nooff

      integer       ISLIMN,ISDIMN,IRLIMN,IRDIMN,ICLIMN,ICDIMN,ISLIMX
      integer       ISDIMX,IRLIMX,IRDIMX,ICLIMX,ICDIMX,MINDST,MAXDST
      integer       MAXFLDs
      integer       MAXFLDr
      integer       MAXFLDx
      integer       minJ, maxJ, minI, maxI

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      EQUIVALENCE  (MHEAD, NHEAD)
      DATA IDSK1 / 97 /

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLDs /-999999999 /
      DATA MAXFLDr /-999999999 /
      DATA MAXFLDx /-999999999 /
      DATA minJ / 999999999 /
      DATA maxJ /-999999999 /
      DATA minI / 999999999 /
      DATA maxI /-999999999 /
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/

      call move   (1, mhead, JHEAD, ibytes)
      call saver  (JHEAD, 'NumRec', nreci, LINHED)
      call saver  (JHEAD, 'NumTrc', ntrci, LINHED)
      call saver  (JHEAD, 'NumSmp', nsmpi, LINHED)

      pi  = 3.14159265
      deg = 180. / pi
      nu = ordfft( nsamps )
      nt = 2 ** nu
      prew = prew / 100.

      lpf  = ol / si
      lpr  = pr / si
      la   = lpf
      lf   = la + lpr
      lags = min0 (nsamps, lf)
      dxg  = TRCSPC

C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      call savelu('TVPT01',ifmt_TVPT01,l_TVPT01,ln_TVPT01,TRACEHEADER)
      call savelu('TVPT02',ifmt_TVPT02,l_TVPT02,ln_TVPT02,TRACEHEADER)

      IREC = 0

C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'DECON starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi
      write(LER,*)'Number of lags   =  ',lags
      write(LER,*)'Prediction samps =  ',lpr
      write(LER,*)'Operator samps   =  ',lpf
      write(LER,*)'Min offset used  =   ',DSTMIN
      write(LER,*)'Max offset used  =   ',DSTMAX
      write(LER,*)'*********************************'
      write(LER,*)' '

      NBYTR  = nsamps * SZSMPD
      NTRKS  = NX * NY
      obytes = NBYTR + SZTRHD

      NXNY  = NX * NY

      write(LERR,*)'nx,ny,nxny= ',nx,ny,nxny

      write(LER,*)'la,lpr,lpf,lf= ',la,lpr,lpf,lf
      items = NXNY
      itemx = ngrp * lags
      itemo = ngrp
      itema = lags
      itemt = nsamps + lf

      call galloc (wkoffnvec, SZSMPD * itemo , ierr1, iabort1)
      call galloc (wkoffauto, SZSMPD * itemx , ierr2, iabort2)
      call galloc (wkoffnorm, SZSMPD * itemo , ierr3, iabort3)
      call galloc (wkauto   , SZSMPD * itema , ierr4, iabort4)
      call galloc (wkautor  , SZSMPD * itema , ierr4, iabort4)
      call galloc (wkautos  , SZSMPD * itema , ierr4, iabort4)
      call galloc (wkautox  , SZSMPD * itema , ierr4, iabort4)
      call galloc (wktrace  , SZSMPD * itemt , ierr5, iabort5)
      call galloc (wkwork   , SZSMPD * itemt , ierr6, iabort6)
      call galloc (wkwork1  , SZSMPD * itemt , ierr6, iabort6)

      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     1    ierr4 .ne. 0 .or. ierr5 .ne. 0 .or. ierr6 .ne. 0) then
         write(LER ,*)'Unable to allocate arrays - too big'
         write(LER ,*)'2 array sized ',SZSMPD*itemo,' Mb, and'
         write(LER ,*)'1 array sized ',SZSMPD*itemx,' Mb, and'
         write(LER ,*)'4 array sized ',SZSMPD*itema,' Mb, and'
         write(LER ,*)'3 array sized ',SZSMPD*itemt,' Mb'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

      call vclr (offnvec, 1, ngrp)
      call vclr (offnorm, 1, ngrp)
    

      write(LERR,*)' '
      write(LERR,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LERR,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt
      write(LERR,*)'NX,NY,items= ',NX,NY,NDI,NLI,items
      write(LERR,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LERR,*)'ntrcs= ',ntrcs
      write(LERR,*)'TRCSPC= ',TRCSPC,' SI= ',si,' norm? ',norm,shot
      write(LERR,*)' '

c-----
C *** for shot & rcvr data sets read over LH
C *** for offset data set read into internal memory since it's small
c-----
      call vclr (trace, 1, nsamps)

      call rwd (lusht )
      call rwd (lurcv )
      call sislgbuf (lusht , 'off')
      call sislgbuf (lurcv , 'off')
      call rtape (lusht , mhead, IBYTES)
      call rtape (lurcv , mhead, IBYTES)
      call rtape (luoff , mhead, IBYTES)

c-----
C *** adjust line header & write output LH
c-----
      call savew  (MHEAD, 'NumRec', nreci, LINHED)
      call savew  (MHEAD, 'NumTrc', ntrci, LINHED)
      call savew  (MHEAD, 'NumSmp', nsmpi, LINHED)
      call savhlh (MHEAD, IBYTES, lbyout)
      CALL WRTAPE (luout , MHEAD, lbyout)

      do  j = 1, ngrp

          is = (j-1) * lags + 1
          call rtape (luoff , mhead, IBYTES)
          call vmov  (mhead(ITHWP1), 1, offauto(is), 1, lags)
          call getfp2(mhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                xlive  , TRACEHEADER)
          call getfp2(mhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                xnorm  , TRACEHEADER)
          offnvec (j) = xlive
          offnorm (j) = xnorm
          write(IPRT,*)'j= ',j,' live,norm= ',xlive,xnorm

      enddo

      write(LER,*)'Opened pre-built files successfully'


c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = 0
      call vclr (trace, 1, nsamps)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDIST  , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD  = IRREC
         NRREC = NRREC + 1
         write(LER,*)'Decon on Record ',NRREC
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) THEN
          call wrtape (luout, JHEAD, obytes)
          GO TO 1500
      ENDIF

      IDIST = IABS (IDIST)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, IRLI)
      IRDIMN = MIN (IRDIMN, IRDI)
      ICLIMN = MIN (ICLIMN, ICLI)
      ICDIMN = MIN (ICDIMN, ICDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, IRLI)
      IRDIMX = MAX (IRDIMX, IRDI)
      ICLIMX = MAX (ICLIMX, ICLI)
      ICDIMX = MAX (ICDIMX, ICDI)
      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)


C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )

      if (off .lt. DSTMIN .OR. off .gt. DSTMAX) then
         call wrtape (luout, JHEAD, obytes)
         go to 1500
      endif

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

c----
c   if the current midpoint, src, or rcvr locations of this trace are
c   out of bounds & if so
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (ISLI .LT. MINLI) IWRN = 1
      IF (ISLI .GT. MAXLI) IWRN = 1
      IF (ISDI .LT. MINDI) IWRN = 1
      IF (ISDI .GT. MAXDI) IWRN = 1

      IF (IRLI .LT. MINLI) IWRN = 1
      IF (IRLI .GT. MAXLI) IWRN = 1
      IF (IRDI .LT. MINDI) IWRN = 1
      IF (IRDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

          call dotpr  (trace, 1, trace, 1, xdot, nsamps)
          xdot = sqrt ( xdot / float(nsamps) )
          if (xdot .eq. 0.0) then
              call wrtape (luout, jhead, obytes)
              go to 1500
          endif
c-----
c  find the pointer into the spread array for the current offset
c-----
          joff = intbin (ngrp, dxg, spread, off)

c-----
c  extract the current auto's from this part of the output volume for
c  shot and receiver
c  do the same for the offset record (we hold this guy in memory because
c  it's small enough).
c  we update the normalization vectors: (1) the number of time something
c  got summed into a cell for shot, rcvr, & offset, and (2) the cummulating
c  trace norms
c            ipntc = (ICLI - minli) + (ICDI - mindi) * ndi + 1
c            ipnts = (ISLI - minli) + (ISDI - mindi) * ndi + 1
c            ipntr = (IRLI - minli) + (IRDI - mindi) * ndi + 1

c            ipnts = jsl + isd * ndi + 1
c            ipntr = jrl + ird * ndi + 1
c-----
             jsl = ISLI - minli
             isd = ISDI - mindi
             jrl = IRLI - minli
             ird = IRDI - mindi
             ipnts = isd + jsl * ndi + 1
             ipntr = ird + jrl * ndi + 1

             maxJ = max (maxJ, jsl, jrl)
             minJ = min (minJ, jsl, jrl)
             maxI = max (maxI, isd, ird)
             minI = min (minI, isd, ird)

             xnormt = 0.
             ic = 0

             call sisseek (lusht , ipnts)
             call rtape (lusht , mhead, nbytes)
             call getfp2(mhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                   xlives , TRACEHEADER)
             call getfp2(mhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                   xnorms , TRACEHEADER)
             if (xlives .gt. 0.0) then
   
                ic = ic + 1
                xnormt = xnormt + xnorms
                call vmov (mhead(ITHWP1), 1, autos, 1, lags)
                call prdapp (trace, nsamps, lpr, la, peo, prew, autos,
     1                       work)
             endif

             call sisseek (lurcv , ipntr)
             call rtape (lurcv , mhead, nbytes)
             call getfp2(mhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                   xliver , TRACEHEADER)
             call getfp2(mhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                   xnormr , TRACEHEADER)
             if (xliver .gt. 0.0) then

                ic = ic + 1
                xnormt = xnormt + xnormr
                call vmov (mhead(ITHWP1), 1, autor, 1, lags)
                call prdapp (work, nsamps, lpr, la, peo, prew, autor,
     1                       work1)
             endif

             if ( .not. nooff) then

                is = (joff-1) * lags + 1
                call vmov (offauto(is), 1, autox, 1, lags)
                xnormx = offnorm (joff)
                xlivex = offnvec (joff)
                if (xlivex .gt. 0.0) then
  
                   ic = ic + 1
                   xnormt = xnormt + xnormx
                   call prdapp (work1, nsamps, lpr, la, peo,prew,autox,
     1                          work)
                endif

                call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                      ICDPX   , TRACEHEADER)
                call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                      ICDPY   , TRACEHEADER)
             endif

             if (ic .eq. 0) then
                call wrtape (luout, jhead, obytes)
                go to 1500
             else
                call wrtape (luout, JHEAD, obytes)

             endif
 
      ELSE

             call wrtape (luout, JHEAD, obytes)
      ENDIF
c----
c  end of IWRN if block
c----

      go to 1500
 5000 CONTINUE

      write(IPRT,*)' '
      write(IPRT,*)'minI, maxI, minJ, maxJ= ',mini,maxi,minj,maxj
      write(IPRT,*)' '

      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,maxflds,maxfldr,maxfldx
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM SOURCE REDUNDANCY . . .',1X,I9,
     &        //, 23X, '  MAXIMUM RECEIVER REDUNDANCY. . ',1X,I9,
     &        //, 23X, '  MAXIMUM OFFSET REDUNDANCY.. . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'Deconvolved ',NRREC,' records'
      ICC = 0

      RETURN
      END
