      SUBROUTINE DMCARD (IPRT,   ICRD,   NTRCS, NFOLD,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, spread,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3,    IX4, IY4, NTPL,NLI, NDI,
     &             TRCSPC,   verbos, shot, dxg,
     &             aliasflag, ampflag, sprdflag)
C***********************************************************************00001970
C                                                                       00001980
C     PROGRAM NAME: DMCARD (READ USER CARDS FOR DM3D)                   00001990
C                                                                       00002000
C     LANGUAGE: FORTRAN                                                 00002010
C                                                                       00002020
C     AUTHOR: G.MURPHY                                                  00002030
C                                                                       00002040
C     DATE WRITTEN: 07/01/88                                            00002050
C                                                                       00002060
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00002080
C                                                                       00002100
C     ABSTRACT: READ DM3D CARDS                                         00002110
C                                                                       00002120
C                                                                       00002130
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00002140
C                                                                       00002150
C***********************************************************************00002160
C                                                                       00002170
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL          TC (*), VC (*)
      REAL          spread (SZLNHD)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER*2     IHEAD  (SZLNHD)
      CHARACTER*48  CHEAD
      integer       argis
      integer       aliasflag, ampflag, sprdflag
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (CHEAD, JHEAD, IHEAD, RHEAD)
      CHARACTER*80  CARD
      logical       alias, sprd, verbos, shot, split
      logical       csamp, coamp, bkamp
      DATA IEND, IFLAG /0,1/

c---
C *** read TDFN file if not a velocity tape input
c---

         NPAIRS = 0
         ICC = 0
         CONTINUE
         READ (ICRD, 140, END=2000) CARD
  140    FORMAT (A80)
         CALL WRCARD (CARD, IFLAG, IPRT)
         IFLAG = 3
         rewind ICRD

         call argr4 ('-dmin', DSTMIN, 0., 0.)
         call argr4 ('-dmax', DSTMAX, 0., 0.)
         call argr4 ('-ddel', DSTDEL, 0., 0.)
         call argr4 ('-dipm', ANGMAX, 90., 90.)
         call argr4 ('-dexp', DIVEXP, 0.7, 0.7)
         call argi4 ('-ntrc', NTRCST, 0 , 0 )
         call argi4 ('-dimin', MINDIT, 1 , 1 )
         call argi4 ('-dimax', MAXDIT, 0 , 0 )
         call argi4 ('-limin', MINLIT, 1 , 1 )
         call argi4 ('-limax', MAXLIT, 0 , 0 )
         call argi4 ('-iorec', IOREC , 0 , 0 )

         alias  = (argis('-AS') .gt. 0)
         if (alias) then
            aliasflag = 1
         else
            aliasflag = 0
         endif

         sprd   = (argis('-GS') .gt. 0)
         if (sprd) then
            sprdflag = 0
         else
            sprdflag = 1
         endif

         csamp    = (argis('-CSA') .gt. 0)
         coamp    = (argis('-COA') .gt. 0)
         bkamp    = (argis('-BKA') .gt. 0)
         ampflag = 0
         if (csamp) ampflag = 0
         if (coamp) ampflag = 1
         if (bkamp) ampflag = 2

         shot   = (argis('-shot') .gt. 0)
         split  = (argis('-split') .gt. 0)
         verbos = (argis('-V') .gt. 0)

C *** FILL IN THE DEFAULTS                                              00002460

         IF (MINLIT .NE. 0 ) MINLI = MINLIT
         IF (MAXLIT .NE. 0 ) MAXLI = MAXLIT
         IF (MINDIT .NE. 0 ) MINDI = MINDIT
         IF (MAXDIT .NE. 0 ) MAXDI = MAXDIT
c        NLI = MAXLI - MINLI + 1
c        NDI = MAXDI - MINDI + 1

         IF (NTRCST .NE. 0 ) NTRCS  = NTRCST
         IF (IOREC  .EQ. 0 ) IOREC  = 1

c        READ (CARD, 160) IX3, IY3, IX4, IY4, DYT, DXT                  00002680

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )

         call argr4 ('-cldm', dxt, 0., 0.)
         call argr4 ('-ildm', dyt, 0., 0.)

         if (dxt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmovel3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmovel3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif
 
         if (dyt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmovel3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmovel3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif

         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmovel3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmovel3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif


C *** COMPUTE NUMBER OF INPUT TRACES                                    00002700

         IF (DYT .NE. 0.) DY = DYT
         IF (DXT .NE. 0.) DX = DXT
         TRCSPC = MIN (DY, DX)
         if (DSTMAX .eq. 0.0 .AND. DSTMIN .eq. 0.0 .AND.
     1       DSTDEL .eq. 0.0) then
             write(IPRT,*)'FATAL ERROR in dmovel3d:'
             write(IPRT,*)'Must enter spread geometry using'
             write(IPRT,*)'-dmin[] -dmax[] -ddel[] cmd line args'
             stop
         endif
         NFOLD  = (DSTMAX - DSTMIN) / DSTDEL + 1
         TRCSPC = DSTDEL
         NTRCS = NFOLD
         NTPL  = NFOLD
         NREC  = (NDI * NLI)
         dxg   = DSTDEL
c-------
c compute spread model
c-------
         ngrp = NFOLD
         ngrp2 = ngrp / 2
         call vfill (0.0, spread, 1, ngrp)

         if (split) then
 
            x  = -DSTMAX - dxg
            do  j = 1, ngrp2
 
                x = x + dxg
                spread (j) = x
            enddo
            jj = 0
            do  j = 1, ngrp2
                jj = ngrp - j + 1
                spread (jj) = abs(spread (j))
            enddo
 
         else

            do  j = 1, ngrp
 
                if (DSTMAX .gt. 0.) then
 
                       spread (j) = DSTMAX - (ngrp-j) * dxg
 
                elseif (DSTMAX .lt. 0.) then
 
                       spread (j) = DSTMAX + (j-1) * dxg
                endif
            enddo
 
         endif

         call minmgv (spread, 1, rmin, lmin, ngrp)
         call maxmgv (spread, 1, rmax, lmax, ngrp)
 
         write(IPRT,*)' '
         write(IPRT,*)'Spread model:'
         write(IPRT,*)'Number of groups in spread   = ',ngrp
         write(IPRT,*)'Minimum distance located at grp= ',lmin
         write(IPRT,*)(spread(i),i=1,ngrp)
         write(IPRT,*)' '


         call RCTDFN (ICRD, IPRT, NSAMP,NSI,TC,VC,npairs,ltdri,
     1                CARD,ICDRDR,IERROR,IEOF)

 2000 CONTINUE

C *** WRITE PARAMETERS TO USER REPORT                                   00003220

      write(IPRT,*)' '
      do  i = 1, npairs
          write(IPRT,*)'Time(ms)= ',tc(i),'  Velocity= ',vc(i)
      enddo
      write(IPRT,*)' '

      WRITE (IPRT, 180) DSTMIN, DSTMAX, DSTDEL, ANGMAX, NTRCS,
     &                  MINLI, MAXLI, MINDI, MAXDI, TRCSPC
  180 FORMAT (//, 30X, 'COMMAND LINE PARAMETERS:'                 ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  DELTA DISTANCE... . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DIP . . . . . . . . . .',F15.5  ,
     &        //, 23X, '  NUMBER OF TRACES PER RECORD . .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  OUTPUT TRACE SPACING. . . . . .',F15.5  )
      WRITE (IPRT, 190) IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4,
     &                  IOREC, DY, DX
  190 FORMAT ( /, 23X, '  CORNER 1 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 1 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  STARTING OUTPUT RECORD NUMBER .',1X,I9  ,
     &        //, 23X, '  CROSSLINE CELL DIMENSION. . . .',F15.5  ,
     &        //, 23X, '  INLINE CELL DIMENSION . . . . .',F15.5,//)

      RETURN
      END
