C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	subroutine fzero(x, n)

*****************************************************************
*
* FZERO - vector fill with zeros
*
*          not optomized
*
* Parameters:
*    X - vector to be filled with zeros
*    N - number of elements in x
*
****************************************************************

*	implicit none

	integer n
	real x(n)

**
* Local variables:
*    I - loop counter
**

	integer i

	do 1 i = 1, n
 		x(i) = 0.0
 1      continue
	return
	end

*===========================================================


	subroutine init(dt, w, sincs, mt)

*****************************************************************
*
* INIT - initializations
*
* Parameters:
*	DMO(,)		- output data panel
*	NT		- samples per trace
*	DT		- time sample rate
*	NX		- number of traces in output
*	W()		- frequency vector
*	SINCS()		- vector containing sinc weights
*	MT		- global dimension: max time samples
*	MX		- global dimension: max output traces
*
****************************************************************


*	implicit none

	integer mt,	iw,	ntnyq
	real	dt,	dw,	sincs(41)
	real 	w(*)

**
* Local integer variables:
*    IW 	- frequency index
*    NTNYQ 	- nyquist frequency index
* Local real variables:
*    DW 	- frequency increment 
*    PI		- pi
*    TWOPI 	- 2 * pi
**

	real	pi,	twopi
 
        pi = 3.14159265
        twopi = 2. * pi

c 	.. zero outdata and vmap
c       call fzero(dmo, nt*mx)
 
c 	.. Initialize frequency vector
c
c					Positive frequencies
	ntnyq = mt/2 + 1
	dw = twopi / ( float(mt) * dt )

      	do 13 iw = 1, ntnyq
         	w(iw) = float( iw - 1 ) * dw
 13   	continue

c					Negative frequencies
c     	do 14 iw = ntnyq + 1, mt
c        	w(iw) = float( iw - 1 - mt ) * dw
c14   	continue

c 	.. Initialize sinc interpolation coefficients 
	call tablsinc(sincs)

	return
	end

*===========================================================


      	subroutine iwtrace(trace, mt, nt, dt, ctrace, w)

*****************************************************************
*
* IWTRACE - process a seismic trace through multiplication by 
*	    sqrt(i*frequency).
*
* Parameters:
*    TRACE(,)	- real input data
*    NT		- time samples on input data
*    DT		- time sample rate of data 
*    POW	- exponent of (i*w) 
*    ITRACE(,) 	- imaginary part of cdata
*    CTRACE(,) 	- complex data
*    W()	- frequency array (read 'omega')
*
****************************************************************

*	implicit none

      	integer nt

      	real trace(mt),	dt,	w(nt)

	complex ctrace(nt)

**
* Local integer variables:
*    IW		- frequency counter
*
* Local real variables:
*    POW	- exponent of (i*w) 
*    AMP	- real amp of sqrt(i*w) 
*    ONE	- 1.0
*    PI		- pi 
*    TWO	- 2.0
*    TWOPI	- 2.0*pi
*    ZERO	- 0.0
*
* Local complex variables:
*    CI		- sqrt(-1) 
*    PHASE	- complex phase of sqrt(i*w)
**

      	integer iw

      	real amp,	one,	pi,	two
	real twopi,	zero

	complex ci,	czero,	negphase,	phase,	plusphase

      	parameter (pi=3.14159265)

 
c 	.. Constants
      	zero = 0.0
      	czero = cmplx(zero,zero) 
      	one = 1.0
      	two = 2.0
      	twopi = 2*pi
        nt2 = nt / 2 + 1
	ci = cmplx(zero,one)
 
c 	.. Zero-out itrace and ctrace
        do  i = 1, nt
            ctrace (i) = cmplx (0.,0.)
        enddo
 
c  	.. copy trace and itrace (which is zero) into ctrace
 
c  	.. Fourier Transform: ctrace(t) --> ctrace(w)
c     	call fft(nt,ctrace,1.0,sqrt(1.0/float(nt)))
        call rfftf  (trace, ctrace, nt)
        call rfftsc (ctrace, nt, 3, 1)
 
c  	 .. set up the positive and negative phase terms 
	 plusphase = cexp(   ci*pi / 4.0 )
	 negphase  = cexp( - ci*pi / 4.0 )
 
c  	 .. do the iomega mult
	 do 124 iw = 1, nt2
	  	if ( w(iw) .eq. 0 ) then
			ctrace(iw) = cmplx(zero,zero)
		else
c			   phase = plusphase
			   phase = negphase
			amp = sqrt( abs(w(iw)) )
	 	   	ctrace(iw) = ctrace(iw) * amp * phase
		endif
 124	   continue
 
c  	   	.. Fourier Transform: ctrace(w) --> ctrace(t)
c     	   call fft(nt,ctrace,-1.0,sqrt(1.0/float(nt)))
           call rfftsc (ctrace, nt, -3, 0)
           call rffti  (ctrace, trace, nt)
 

	return
	end

*===========================================================

*===========================================================

	real function sinc(x)

*****************************************************************
*
* SINC   - sinc function
*
*****************************************************************

*	implicit none

	real x

**
* Local real variables:
*    PI     - pi
**

	real pi

	pi = 3.1415926

c
c	This sinc function is zero on integer values of x
c

	if ( x .eq. 0.0 ) then
		sinc = 1.0
	else
		sinc = sin( pi*x ) / ( pi*x )
	end if

	return
	end

*===========================================================


	subroutine sincit (vec, amp, t, ist, iend,
     1                     dt, mt, sincs, norm)

*****************************************************************
*
* SINCIT - add an amplitude value into a vector 
*	   by 8-point sinc interpolation
*
*          resolution is 1/10th of a sample
*
* Parameters:
*    VEC   - data vector 
*    AMP   - value to add into the vector
*    T     - time location of the value to be added
*    DT    - time sample rate
*    NT    - number of samples in vector
*    SINCS - sinc interpolation weights [from tablsinc()] 
*
****************************************************************

*	implicit none
	real amp, dt, sincs(41), t, vec(mt), norm(mt)

**
* Local variables:
*    IT     - time sample at, or above, 't'
*    ISINC  - temporary sinc weight index
*    ISINC1 - sinc weight index for 'it'
*    K      - temporary time sample index
**

	integer it,	k,	isnc1,	isnc
	
c	.. amp to be added into trace is in interval
c	.. it <= t/dt < it + 1
	it = int( t / dt )

        ist1  = ist + 3
        iend1 = iend - 4
        IF (it .lt. ist1 .OR. it .gt. iend1) RETURN

	isnc1 = ( t/dt - it ) * 10 + 1

c	.. eight point sinc interplotion
        iit = it - ist + 1
	k = iit


 	vec(k) = vec(k) + amp*sincs(isnc1)
        norm(k) = norm(k) + 1

	k = iit + 1
	isnc = 11 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 2
	isnc = 21 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 3
	isnc = 31 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 4
	isnc = 41 - isnc1 + 1
 	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 1
	isnc = 11 + isnc1 - 1
 	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 2
	isnc = 21 + isnc1 - 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 3
	isnc = 31 + isnc1 - 1
	vec(k) = vec(k) + amp*sincs(isnc)

	return
	end

*===========================================================


	subroutine tablsinc(sincs)

*****************************************************************
*
* TABLSINC - table sinc function values
*
* Parameters:
*    SINCS - sinc interpolation weights
*
****************************************************************

*	implicit none

	real sincs(41)

**
* Local integer variables:
*    I      - counter
* 
* Local real variables:
*    SINC   - sinc function 
*    X      - sinc function argument (fractional sample point)
**

	real sinc,	x
	integer i

c	.. table sinc values for interpolation.
c	.. Incremental sample step size is .1 sample.
c	.. 
c	.. numbering system -- *=sample loc ... :=sinc value
c	.. 
c	..  |<----------- dt ------------>|
c	.. 
c	.. 
c	..  +  + 
c	..        +  +
c	..              +  +
c	..                    +
c	..                       +
c	..                          +
c	..                             +
c	..  *--:--:--:--:--:--:--:--:--:--*--:--:--:--:--:--:--:--:--:--*
c	..  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21
c	..                                   +                       +
c	..                                      +  +           +  +
c	..                                            +  +  +

	do 1 i = 1, 41
		x = ( i - 1 ) * .1
		sincs(i) = sinc( x )
 1	continue

	return
	end

*===========================================================

