C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2ree (rdata,nsamp,ntrc,nt,nt2,nx,cdata)

c  routine to do 2-d fft

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      	integer	 nt, nx, nsamp, ntrc

      	real 	 rdata(nt2 ,nx)
        complex  cdata(nt  ,nx)
        complex  workc(2*SZLNHD)

       do  kx = 1, nx

           if (kx .gt. nx/2) then
               kxout = kx - nx/2
           else
               kxout = nx/2 + kx
           endif

           ix = kxout

           do  kt = 1, nt

               if (kt .gt. nt/2) then
                   ktout = kt - nt/2
               else
                   ktout = nt/2 + kt
               endif

               iamp   = nt  - ktout + 1
               iphase = nt2 - ktout + 1

               cdata(kt,kx) =  rdata(iamp  , ix)    *
     1                         cexp ( cmplx(0.,rdata(iphase, ix)) )

           enddo
       enddo

c------------
c  	.. Fourier transform:  (ky,kx) --> (y,x)

           do  i = 1, nt
               do  j = 1, nx
                   workc(j) = cdata(i,j)
               enddo
               call cfft   (workc, nx, -1)
               do  j = 1, nx
                   cdata (i, j) = workc (j)
               enddo
           enddo

            do     j = 1, ntrc
               do     i = 1, nt
                      workc(i) = cdata(i,j)
               enddo
                call  cfft  (workc, nt, -1)
               do  i = 1, nsamp
                   rdata (i,j) = real (workc(i))
               enddo
           enddo

      return
      end
