C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE fft3da
C**********************************************************************C
C
C fft3da reads the frequency sliced data [ as output by fftpack|ttds3d -NDtxy -ODxyt ] , 
c performs either a forward or inverse 2D fft transforms it, and outputs
c the data.
c
c P.G.A. Garossino
c
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c Standard USP variable

      integer lhed(SZLNHD)
      integer luin, luout, nbytes, obytes, argis
      integer nsampKK, nsi, nrec, ntrcKK, iform, lbytes
      integer nsampXY, ntrcXY, ntrcREAD, ntrcWRITE

      character   name * 8, ntap * 100, otap * 100
      character domain*2

      logical verbos, query

c variables used with dynamic memory allocation

      integer errcd1, errcd2, errcd3
      integer abort, itemHeader, itemSpace

      integer headers

      real work, Cwork

      pointer ( wkadr1, headers(200000) )
      pointer ( wkadr2, work(200000) )
      pointer ( Cwkadr, Cwork(200000) )

c non-standard keyword variables used on the command line

      real      dt, dz

      logical   reverse

c program dependant variables

      integer NextPowerOf2, size, JJ, KK, increment
      integer trndx, hdrndx
      integer ordfft


c initialize variables

      data  nbytes / 0 /
      data  lbytes / 0 /
      data  abort / 0 /
      data  name/'FFT3DA'/
      data reverse/.false./
C get help if requested

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0  )
      if ( query ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

C read command line parameters

      call cmdln ( ntap, otap, dt, dx, dy, dz, reverse, verbos )

c open input and output datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c read input lineheader 

      lbytes=0
      call rtape  ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'FFT3DA: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence/permissions of file & rerun'
         stop
      endif

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
  
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)

      if ( .not. reverse ) then

         call saver(lhed, 'NumSmp', nsampXY, LINHED)
         call saver(lhed, 'NumTrc', ntrcXY , LINHED)

c determine number of traces/record and samples/trace for the 
c forward transform data 

         NextPowerOf2 = ordfft(nsampXY)
         nsampKK = 2 ** NextPowerOf2
         increment = 2 * nsampKK

         NextPowerOf2 = ordfft(ntrcXY)
         ntrcKK = 2 ** NextPowerOf2

         ntrcREAD = ntrcXY
         ntrcWRITE = ntrcKK
         obytes = SZTRHD + SZSMPD * 2 * nsampKK
         domain = 'kk'

         if(nsampKK .gt. 8192) then
         write(LERR,*) ' '
         write(LERR,*) 'FFT3DA: Trace length too long to transform'
         write(LERR,*) '          Be sure next power of 2 is less than'
         write(LERR,*) '          8192 or contact the USP guys at APR'
         write(LERR,*) '          for a program change'
         write(LERR,*) 'Fatal'  
         write(LERR,*) ' '
         write(LER,*) ' '
         write(LER,*) 'FFT3DA: Trace length too long to transform'
         write(LER,*) '          Be sure next power of 2 is less than'
         write(LER,*) '          8192 or contact the USP guys at APR'
         write(LER,*) '          for a program change'
         write(LER,*) 'Fatal'        
         write(LER,*) ' '
         goto 999
         endif

      else

         call saver(lhed, 'NumSmp', nsampKK, LINHED)
         increment = nsampKK
         nsampKK = nsampKK / 2
         call saver(lhed, 'NumTrc', ntrcKK , LINHED)
         call saver ( lhed, 'OpGrFl', ntrcXY, LINHED )
         call saver ( lhed, 'IndAdj', nsampXY, LINHED )
         call saver( lhed, 'DgTrkS', domain, LINHED)
         ntrcREAD = ntrcKK
         ntrcWRITE = ntrcXY
         obytes = SZTRHD + SZSMPD * nsampXY

         if ( domain .ne. 'kk' ) then
            write(LERR,*)' '
            write(LERR,*)'FFT3DA: Input data not (Kx,Ky,Omega) Format'
            write(LERR,*)'FATAL '
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'FFT3DA: Input data not (Kx,Ky,Omega) Format'
            write(LER,*)'FATAL '
            write(LER,*)' '
            goto 999
         endif
         
         domain = 'xy'
      endif
      
c dynamic memory allocation

      itemHeader = ntrcKK * ITRWRD * SZSMPD
      size = (ntrcKK+2) * 2 * (nsampKK+2) 
      itemSpace = size  * SZSMPD
    
      call galloc (wkadr1, itemHeader, errcd1, abort)
      call galloc (wkadr2, itemSpace, errcd2, abort)
      call galloc (Cwkadr, itemSpace, errcd3, abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.  
     :     errcd3 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemSpace,' bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemSpace,' bytes'
         write(LERR,*)' '
      endif

c initialize header memory

      call vclr ( Headers, 1, ntrcKK * ITRWRD )

c update HLH

      call hlhprt ( lhed , lbytes, name, 8, LERR )
  
c modify header as needed

      if ( .not. reverse ) then
         
         call savew ( lhed, 'NumSmp', 2*nsampKK, LINHED )
         call savew ( lhed, 'NumTrc', ntrcKK, LINHED )
         call savew ( lhed, 'NumRec', nrec, LINHED )

c store the original number of traces and samples for retrieval 
c upon an inverse transform.  Use as many of the same header
c words as fftxy

         call savew ( lhed, 'OpGrFl', ntrcXY, LINHED )
         call savew ( lhed, 'IndAdj', nsampXY, LINHED )

c verbal printout

         call verbal( ntap, otap, nsampXY, ntrcXY, nrec, dt, dx, dy, dz, 
     :     reverse, verbos ) 

      else

         call savew ( lhed, 'NumSmp', nsampXY, LINHED )
         call savew ( lhed, 'NumTrc', ntrcXY, LINHED )
         call savew ( lhed, 'NumRec', nrec, LINHED )

c verbal printout

         call verbal( ntap, otap, nsampKK, ntrcKK, nrec, dt, dx, dy, dz, 
     :     reverse, verbos ) 

      endif

      call savew( lhed, 'DgTrkS', domain, LINHED)
      call savhlh ( lhed, lbytes, lbyout )

c write out modified line header

      call wrtape(luout, lhed, lbyout)

c start processing 

      DO JJ = 1, nrec

c clear workspace

         call vclr ( work, 1, size )

c load next record

         trndx = 1 - increment
         hdrndx = 1 - ITRWRD

         DO KK = 1, ntrcREAD

c set data and header index

            trndx = trndx + increment
            hdrndx = hdrndx + ITRWRD
            
            nbytes = 0
            call rtape ( luin, lhed, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            
            call vmov ( lhed, 1, headers(hdrndx), 1, ITRWRD )

            if ( .not. reverse ) then
               call vmov ( lhed(ITHWP1), 1, work(trndx), 1, nsampXY )
            else
               call vmov ( lhed(ITHWP1), 1, work(trndx), 1, 2*nsampKK )
            endif

         ENDDO
            
c debug --> take a look at what is loaded
c         call look2D ( work, 2*nsampKK, ntrcKK )

c do required transform

         call vclr ( Cwork, 1, size )

         if ( .not. reverse ) then

c Forward fft2d

            call fft2dee ( work, nsampXY, ntrcXY, nsampKK, 2*nsampKK,  
     :           ntrcKK, Cwork ) 

         else

c Inverse fft2d 

            call fft2ree ( work, nsampXY, ntrcXY, nsampKK, 2*nsampKK,
     :           ntrcKK, Cwork )
         endif

c debug --> take a look at the transform result
c         call look2D ( work, 2*nsampKK, ntrcKK )

c output the transformed data

         trndx = 1 - increment
         hdrndx = 1 - ITRWRD

         DO KK = 1, ntrcWRITE

c load up output trace headers and don't walk outside of memory.  Use
c the last trace header input for any extra traces on the way out.

            hdrndx = hdrndx + ITRWRD 
            call vmov ( headers(hdrndx), 1, lhed, 1, ITRWRD )

c load up output trace amplitude and phase data

            trndx = trndx + increment
            
            if ( .not. reverse ) then
               call vmov( work(trndx), 1, lhed(ITHWP1), 1, 2 * nsampKK )
            else
               call vmov( work(trndx), 1, lhed(ITHWP1), 1, nsampXY )
            endif

c write output trace 

            call wrtape( luout, lhed, obytes)

         ENDDO

      ENDDO

c finished processing, close all attached files and terminate

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' Normal Termination'
      write(LER,*)'FFT3DA: Normal Termination'
      stop

 999  continue

c something abnormal occured, usually premature eof

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)' Abormal Termination'
      write(LER,*)'FFT3DA: Abnormal Termination'
      stop
      END
