C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, nsamp, ntrc, nrec, dt, dx, dy, dz, 
     :     reverse, verbos ) 

#include <f77/iounit.h>

      integer     nsamp, ntrc, nrec

      real        dt, dx, dy, dz

      character   ntap*(*), otap*(*)

      logical     reverse, verbos
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' Cross-line spacing    =  ', dy
      write(LERR,*) ' In-line spacing       =  ', dx
      if ( abs(dz) .lt. 1.e-30 ) then
         write(LERR,*) ' Sample Interval       =  ', dt, 'Seconds'
      else
         write(LERR,*) ' Sample Interval       =  ', dz, 'M or FT'
      endif
      if ( reverse ) then
         write(LERR,*)' Inverse transform performed'
      else
         write(LERR,*)' Forward transform performed'
      endif
      write(LERR,*)' '
      if (verbos) write(LERR,*)' Verbos printout requested'
      write(LERR,*)' '
 
      return
      end
