C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine avemed (Input, Output, nxIN, nyIN, nf, nf2, 
     1                   Filter, med, avmed )

      real    Input(nxIN,nyIN), Output(nxIN,nyIN)
      real    Filter (nf*nf)   
      integer avmed
      real    work (9)
      logical med

c---
c  full median filter:
c  for each window position ix,iy extract all the amplitudes wiithin
c  and store in vector Filter
c  Then compute the median of all the amplitudes and output into 
c  point ix,iy of Output
c---
      IF (med) THEN

      nfc = nf2 + 1

      DO  IY = 1, nxIN

          DO  IX = 1, nyIN

              ic = 0
              do  j = 1, nf
              do  i = 1, nf

                  IYj = IY - nfc + j
                  IXi = IX - nfc + i
 
                  if (IYj .ge. 1 .AND. IYj .le. nxIN .AND.
     1                IXi .ge. 1 .AND. IXi .le. nyIN)     then
                      amp = Input (IYj, IXi)
                      if (amp .ne. 0.0) then
                         ic = ic + 1
                         Filter (ic) = amp
                      endif
                  endif

             enddo
             enddo

             if (ic .gt. 2) then
                call median (Filter, ic, xmed)
             elseif (ic .eq. 1) then
                xmed = Filter (1)
             else
                xmed = 0.
             endif

             Output (IY,IX) = xmed

          ENDDO
      ENDDO

c---
c  average median filter:  for example a 5x5 case...

c  data matrix D centered at point ix,iy in overall two dimensional
c  data array:

c      d11  d12  d13  d14  d15
c      d21  d22  d23  d24  d25
c      d31  d32  d33  d34  d35
c      d41  d42  d43  d44  d45
c      d51  d52  d53  d54  d55


c  case: avmed=1
c  partial sums are formed:

c      dr1 = d11 + d22
c      dr2 = d44 + d55
c      dl1 = d24 + d15
c      dl2 = d42 + d51
c      xf1 = d31 + d32
c      xf2 = d34 + d35
c      yf1 = d13 + d23
c      yf2 = d43 + d53

c  The output of the filter is then

c   output(ix,iy) = median (d33, dr1, dr2, dl1, dl2, xf1, xf2, yf1, yf2)
c
c
c
c
c   case: avmed=2
c
c   first, the averaging median filter using the 2 horizontal subfilters is run
c   second, the averaging median filter using the 2 vertical subfilters is run
c   finally, the median of the center pixel and of the two above averaging
c   median filters is computed
c
c
c
c
c   case: avmed=3
c
c   first the averaging median filter using only 2 horizontal and 2 vertical
c   subfilters is applied to the data;
c   second, the averaging median filter using only the 4 diagonal subfilters
c   is applied to the data
c   finally the median of the center window pixel and of the outpus of the
c   two previously mentioned averaging median filters is created
c---
      ELSE
 
c
c         avmed=1
c
      if (avmed .eq. 1) then

      DO  IY = nf2+1, nxIN-nf2

          DO  IX = nf2+1, nyIN-nf2

              dr1 = 0.
              dr2 = 0.
              dl1 = 0.
              dl2 = 0.
              xf1 = 0.
              xf2 = 0.
              yf1 = 0.
              yf2 = 0.

              do  i = 1, nf2

                  dr1 = dr1 + Input (IY-i, IX-i)
                  dr2 = dr2 + Input (IY+i, IX+i)
                  dl1 = dl1 + Input (IY-i, IX+i)
                  dl2 = dl2 + Input (IY+i, IX-i)
                  xf1 = xf1 + Input (IY  , IX-i)
                  xf2 = xf2 + Input (IY  , IX+i)
                  yf1 = yf1 + Input (IY-i, IX  )
                  yf2 = yf2 + Input (IY+i, IX  )
             enddo


             work (1) = dr1 / float(nf2)
             work (2) = dr2 / float(nf2)
             work (3) = dl1 / float(nf2)
             work (4) = dl2 / float(nf2)
             work (5) = xf1 / float(nf2)
             work (6) = xf2 / float(nf2)
             work (7) = yf1 / float(nf2)
             work (8) = yf2 / float(nf2)
             work (9) = Input (IY,IX)
             call median (work, 9, xmed)
             Output(IY,IX) = xmed
                END DO
                   END DO

          elseif (avmed .eq. 2) then

          DO  IY = nf2+1, nxIN-nf2
              DO  IX = nf2+1, nyIN-nf2
              xf1 = 0.
              xf2 = 0.
              yf1 = 0.
              yf2 = 0.

              do  i = 1, nf2
                  xf1 = xf1 + Input (IY  , IX-i)
                  xf2 = xf2 + Input (IY  , IX+i)
                  yf1 = yf1 + Input (IY-i, IX  )
                  yf2 = yf2 + Input (IY+i, IX  )
             end do
             work (1) = xf1 / float(nf2)
             work (2) = xf2 / float(nf2)
             work (3) = Input (IY,IX)
             call median (work, 3, fmed1)
             work (1) = yf1 / float(nf2)
             work (2) = yf2 / float(nf2)
             work (3) = Input (IY,IX)
             call median (work, 3, fmed2)
             work (1) = fmed1
             work (2) = fmed2
             work (3) = Input (IY,IX)
             call median (work, 3, xmed)
             Output (IY,IX) = xmed
                 END DO
                 END DO
  

             elseif (avmed .eq. 3) then

             DO IY = nf2+1 , nxIN-nf2
                DO IX = nf2+1 , nyIN-nf2
              dr1 = 0.
              dr2 = 0.
              dl1 = 0.
              dl2 = 0.
              xf1 = 0.
              xf2 = 0.
              yf1 = 0.
              yf2 = 0.

              do  i = 1, nf2
                  dr1 = dr1 + Input (IY-i, IX-i)
                  dr2 = dr2 + Input (IY+i, IX+i)
                  dl1 = dl1 + Input (IY-i, IX+i)
                  dl2 = dl2 + Input (IY+i, IX-i)
                  xf1 = xf1 + Input (IY  , IX-i)
                  xf2 = xf2 + Input (IY  , IX+i)
                  yf1 = yf1 + Input (IY-i, IX  )
                  yf2 = yf2 + Input (IY+i, IX  )
             end do
             work (1) = xf1 / float(nf2)
             work (2) = xf2 / float(nf2)
             work (3) = yf1 / float(nf2)
             work (4) = yf2 / float(nf2)
             work (5) = Input (IY,IX)
             call median (work, 5, fmed1)
             work (1) = dr1 / float(nf2)
             work (2) = dr2 / float(nf2)
             work (3) = dl1 / float(nf2)
             work (4) = dl2 / float(nf2)
             work (5) = Input (IY, IX)
             call median (work, 5, fmed2)
             work (1) = fmed1
             work (2) = fmed2
             work (3) = Input (IY, IX)
             call median (work, 3, xmed)
               Output (IY,IX) = xmed

          ENDDO
      ENDDO

      endif

      ENDIF

      return
      end
