C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c  Program FKKSTRIP : [Kx,Ky] filtering
c  Author: Paul G. A. Garossino [APR:1993]
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c -----
c basic usp variables
c -----

      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, nreco, irs, ire, iform
      integer     luin , lbytes, nbytes, luout, obytes
      integer     KK,JJ,argis

c -----
c program variables defined with dynamic memory allocation
c -----

      integer     RecordHeaders
      integer     errcd1,errcd2,errcd3,errcd4,errcd5,abort
      integer     itemHeader,itemRecord

      real        TimeSlice,Filter,WorkSpace,WorkSpace1,output(SZLNHD)

      pointer     (wkadr1, RecordHeaders(200000))
      pointer     (wkadr2, TimeSlice(200000))
      pointer     (wkadr3, Filter(200000))
      pointer     (wkadr4, WorkSpace(200000))
      pointer     (wkadr5, WorkSpace1(200000))

c -----
c program variables defined with static memory allocation
c -----

      integer StartRec,EndRec,FilterLength,Xtaper,Ytaper,Xpad,Ypad 
      integer start,end,nxWork,nyWork,nWork,lufilt,iopa, ioph

      real Intercept,CosTaper,chp

      character   name*10, ntap*256, otap*256, ftap*256

      logical verbos,pass,query,edge,edgev,edgeh,edgedr,edgedl
      logical avmed, med, har, gauss, dup

c -----
c j0 is a fcn to calculate the bessel j0(r)
c -----

      external j0

c -----
c Initialize Required Variables
c -----

      data name/'FKKSTRIP'/,abort/0/,luin/1/,lbytes/0/,nbytes/0/
      verbos = .false.
      pass = .true.

c -----
c get online help if necessary
c -----

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if( query ) then
          call help ()
          stop
      endif

c -----
c open printout
c -----

#include <f77/open.h>

c -----
c read program parameters from command line argument string
c -----

      call cmdln (ntap,otap,irs,ire,StartRec,EndRec,FilterLength,
     :    Intercept,CosTaper,Xtaper,Ytaper,Xpad,Ypad,pass,ftap,verbos,
     :    edge,edgev,edgeh,edgedr,edgedl,avmed,med,har,iopa,ioph,chp,
     :    gauss,sigma,dup)

  
c -----
c open input/output datasets
c -----

      call getln ( luin, ntap, 'r', 0)
      call getln ( luout, otap, 'w', 1)
      if(ftap.ne.' ')call getln ( lufilt, ftap, 'w', 1)

c -----
c read and update line header,
c write line header, save key parameters.
c -----

      lbytes=0

      call rtape  ( luin, lhed, lbytes )

      if(lbytes .eq. 0) then
         write(LERR,*)'FKKSTRIP: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)

      

      call hlhprt ( lhed , lbytes, name, 10, LERR )

c -----
c  Check Defaults and validity of command line entries
c -----

      if(StartRec.le.nsi)then
         start = 1
      else
         start = StartRec
      endif

       if(EndRec.eq.0)then
         end = nrec
      else
         end = EndRec 
      endif

c -----
c ascertain that FilterLength is odd
c -----

      FilterLength = FilterLength + ( mod(FilterLength,2) - 1 )

      nxWork = nsamp + 2*Xpad + FilterLength
      nyWork = ntrc + 2*Ypad + FilterLength

      nWork = nxWork*nyWork
      
      if(ire.eq.0)ire = nrec
      nreco = ire - irs + 1

c -----
c  update historical line header & output header
c -----

      obytes = SZTRHD + SZSMPD * nsamp

      call savew (lhed, 'NumRec' , nreco, LINHED)

      call savhlh ( lhed, lbytes, lbyout )
      call wrtape(luout,lhed,lbyout)

c -----
c write filter header if requested
c -----

      if(ftap.ne.' ')then
         call savew (lhed, 'NumRec' , 1, LINHED)
         call savew (lhed, 'NumTrc',FilterLength, LINHED)
         call savew (lhed, 'NumSmp',FilterLength, LINHED)
         call wrtape(lufilt,lhed,lbyout)
      endif

c -----
c  echo input parameters to printout
c -----

      call verbal(irs,ire,nsamp,ntrc,nsi,StartRec,EndRec,FilterLength,
     :     Intercept,Xtaper,Ytaper,Xpad,Ypad,pass,ntap,otap,iform,
     :     CosTaper,verbos,edge,edgev,edgeh,edgedr,edgedl,avmed,med,
     :     har,iopa,ioph,chp,gauss,sigma,dup)

c -----
c  Dynamic Memory Allocation
c  note : SZSMPD is the native
c  size of a float or int in bytes
c -----

      itemHeader = ntrc * ITRWRD * SZSMPD
      itemFilter = FilterLength**2 * SZSMPD
      itemRecord = nxWork*nyWork*SZSMPD

      call galloc (wkadr1, itemHeader, errcd1, abort)
      call galloc (wkadr2, itemRecord, errcd2, abort)
      call galloc (wkadr3, itemFilter, errcd3, abort)
      call galloc (wkadr4, itemRecord, errcd4, abort)
      call galloc (wkadr5, itemRecord, errcd5, abort)
 
      if (errcd1.ne.0 .or. errcd2.ne.0 .or. errcd3.ne.0
     :    .or. errcd4.ne.0 .or. errcd5.ne.0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 3*itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemHeader,' bytes'
         write(LER ,*) 3*itemRecord,'  bytes'
         write(LER ,*) itemFilter,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 3*itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*)' '
      endif

c -----
c Build Filter
c -----

      
      CosTaper = (100. - CosTaper)/100.
      call XYFilter(Intercept,CosTaper,FilterLength,nf2,j0,Filter,
     1              edge,edgev,edgeh,edgedr,edgedl,avmed,med,har,
     2              gauss,sigma)

c -----
c Skip Down to User Defined Start Time Slice
c -----

      call recskp(1,irs-1,luin,ntrc,lhed)

c -----
c Process Data 
c -----

      DO 1000 JJ = irs,ire

c -----
c initialize  arrays
c -----

         call clr2D(TimeSlice,nxWork,nyWork)
         call clr2D(WorkSpace,nxWork,nyWork)
         call clr2D(WorkSpace1,nxWork,nyWork)

c -----
c Load Record
c ----- 

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp

         DO 1001 KK = 1,ntrc

            nbytes = 0
            call rtape( luin, lhed, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',jj,'  trace= ',kk
               go to 999
            endif

c -----
c     advance array indices for this trace
c -----

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c -----
c load headers 
c -----

            call vmov (lhed,1,RecordHeaders(IndexHeader),1,ITRWRD)

c -----
c load time series 
c -----

            call vmov(lhed(ITHWP1),1,TimeSlice(IndexTrace),1,nsamp)

 1001    CONTINUE

c -----
c filter data within user defined range of records only
c -----

         IF(JJ.ge.start .and. JJ.le.end)then

c -----
c cut, pad and taper 
c -----
            
            call CutPadTaper(TimeSlice,nsamp,ntrc,Xpad,Ypad,
     :           FilterLength,Xtaper,Ytaper,WorkSpace,nxWork,nyWork,
     :           dup)

c -----
c Filter Time Slice
c -----

            call FKKFilter(WorkSpace,nxWork,nyWork,Filter,FilterLength,
     :           nf2,WorkSpace1,Xpad,Ypad,pass,avmed,med,har,iopa,ioph,
     :           chp,gauss)

c -----
c Remove Pad
c -----

            call clr2D(WorkSpace,nxWork,nyWork)

            call PadOff(WorkSpace1,nxWork,nyWork,WorkSpace,nsamp,ntrc,
     :           Xpad,Ypad,FilterLength)

         ENDIF

c -----
c Output Record
c -----

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp

         DO 1002 KK = 1,ntrc

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c -----
c restore header
c -----

            call vmov (RecordHeaders(IndexHeader),1,lhed(1),1,ITRWRD)

c -----
c if trace was processed then output filtered trace otherwise output the input
c -----


            IF(JJ.ge.start .and. JJ.le.end)then
            
c -----
c clear trace area
c -----

               call vclr(output,1,nsamp)

c -----
c extract trace from WorkSpace 
c -----

               call SliceOut(WorkSpace,nxWork,nyWork,nsamp,KK,output)

c ------
c load filtered trace to output time series array
c -----

               call vmov(output(1),1,lhed(ITHWP1),1,nsamp)

            ELSE

c -----
c load unfiltered trace to output time series array
c -----

               call vmov(TimeSlice(IndexTrace),1,lhed(ITHWP1),1,nsamp)

            ENDIF

            call wrtape(luout,lhed,obytes)

 1002    CONTINUE

 1000 CONTINUE

 999  continue

c -----
c write out filter if requested
c -----

      if(ftap.ne.' ')then

        obytes = SZTRHD + SZSMPD * FilterLength
        call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
        call savew2(lhed,ifmt_RecNum,l_RecNum,ln_RecNum,1,TRACEHEADER)
        call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

         do i = 1,FilterLength
            call savew2(lhed,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i,
     :           TRACEHEADER)
            call SliceOut(Filter,FilterLength,FilterLength,FilterLength,
     :           i,output)
            call vmov(output(1),1,lhed(ITHWP1),1,FilterLength)
            call wrtape(lufilt,lhed,obytes)
         enddo

         call lbclos ( lufilt )

      endif

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'processed ',nreco,' record(s) with ',ntrc,' traces'

      stop
      end
      



 
