C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine timrd (iunit, nli, ndi, nhor, limin, limax, 
     1                  dimin, dimax, dcolor, times, SZSMPD, si,
     2                  maxcol, debug,lu_debug,verbos,
     3                  smooth, fit, iord, irtype, ilim,
     4                  nf, notrp)

#include <f77/iounit.h>

      real       times (ndi, nli, nhor)
      integer    dcolor (*)

      integer    limin, limax, dimin, dimax, SZSMPD
      integer    li, di, icolor
      integer    iord, irtype, ilim, nf, lu_debug
      character  junk * 80, tmp * 10
      logical    EOP, debug, verbos, smooth, fit, notrp

      write(LERR,*)' '
      write(LERR,*)'Horizon pick read messages:'
      write(LERR,*)' '

      EOP = .false.

      do  k = 1, nhor
          do  j = 1, nli
              do  i = 1, ndi
                  times (i,j,k) = 0.
              enddo
          enddo
      enddo

      rewind iunit
 
      maxli = -999999
      minli =  999999
      maxdi = -999999
      mindi =  999999


         i = 0
         DO  while (1.eq.1)

             do while (1.eq.1)
                 read(iunit,'(a80)',end=35,err=666)junk
                 if (junk(1:5) .eq. 'Color') then
                     call fsscnf (junk,'%s %f',tmp,val)
                     icol = val
                     ic = icolor (dcolor, nhor, icol)
                     ip = 0
                     read(iunit,'(a80)',end=35,err=666)junk
                     if (junk(1:5) .eq. 'Picks') then
                         call fsscnf (junk,'%s %f',tmp,val)
                         npick = val
                     else
                         write(LERR,*)' '
                         write(LERR,*)'Error in xsd extended pick file'
                         write(LERR,*)'Sequence must be Color followed'
                         write(LERR,*)'by Picks. Check pick file'
                         write(LERR,*)' '
                         stop 666
                     endif
                     go to 30
                 endif
             enddo

30           continue


             do  while (1.eq.1)

                    read(iunit,'(a80)',end=32,err=666)junk
                    go to 33

32                  continue
                        times (di-dimin+1, li-limin+1, ic) = timi
                        go to 35
33                  continue

                    if     (junk(1:5) .eq. 'Pick ') then
                        ip = ip + 1
                        if (ip .gt. 1) then
                           times (di-dimin+1, li-limin+1, ic) = timi
                        endif
                    elseif (junk(1:6) .eq. 'DphInd') then
                        call fsscnf (junk,'%s %f',tmp,val)
                        di = val
                        if (di .le. mindi) mindi = di
                        if (di .ge. maxdi) maxdi = di
                    elseif (junk(1:6) .eq. 'LinInd') then
                        call fsscnf (junk,'%s %f',tmp,val)
                        li = val
                        if (li .le. minli) minli = li
                        if (li .ge. maxli) maxli = li
                    elseif (junk(1:6) .eq. 'Sample') then
                        call fsscnf (junk,'%s %f',tmp,val)
                        timi = (val - 1.0) * si
                    elseif (junk(1:7) .eq. 'Segment') then
                        times (di-dimin+1, li-limin+1, ic) = timi
                        go to 31
                    endif

             enddo
31           continue

         ENDDO

35       continue

      write(LERR,*)' '
      if (verbos) then
      write(LERR,*)'Functions As Read In'
      write(LERR,*)' '
      do  k = 1, nhor
          do  j = 1, nli
              do  i = 1, ndi
                  tt = times (i,j,k)
                  if (tt .gt. 0.)
     1            write(LERR,*)'Horizon= ',k,' LI= ',j,' DI= ',i,
     2                      ' time= ',tt
              enddo
          enddo
          write (LERR,777)
777       format ()
      enddo
      endif
      write(LERR,*)' '

      write(LERR,*)' '
      write(LERR,*)'From pick file:'
      write(LERR,*)'Min LI ',minli,'  Max LI ',maxli
      write(LERR,*)'Min DI ',mindi,'  Max DI ',maxdi
      write(LERR,*)' '
c-----
c  do 2Dx2D interpolation of the input times, matrices for each horizon
c-----
      if ( .not. notrp ) then
         do  k = 1, nhor

             call trp2d (limin, limax, dimin, dimax, nli, ndi,
     1                   times(1, 1, k), SZSMPD)
         enddo
      endif

c-----
c   optionally we can either fit a specific order surface to each horizon
c   time array (0=robust; 1=least squares), or do median smoothing of
c   each horz time array
c-----
      IF (fit .or. smooth) THEN
 
         do  k = 1, nhor
 
            call timmod (nli, ndi, nf, times(1, 1, k), smooth, fit,
     1                   iord, irtype, ilim, SZSMPD)
         enddo
 
      ENDIF


      write(LERR,*)' '
      if (debug) then
         do  k = 1, nhor
         do  j = 1, nli
         do  i = 1, ndi
             write(lu_debug,555)j,i,times(i,j,k)
         enddo
         enddo
         write(lu_debug,777)
555      format (2i5,5x,f10.3)
         enddo
      endif
      write(LERR,*)' '

      return

666   continue
      write(LERR,*)'FATAL ERROR in reading pick file'
      write(LER ,*)'FATAL ERROR in reading pick file'
      stop 666
999   continue
      write(LERR,*)'FATAL ERROR in pick file: premature end of file'
      write(LER ,*)'FATAL ERROR in pick file: premature end of file'
      stop 666

      end
