C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, navtap, skiptap, name,  
     :     water_velocity, ns, ne, irs, ire, ist, iend, 
     :     verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer    water_velocity, ist, iend, ns, ne, irs, ire

      character  ntap*(*), otap*(*), navtap*(*), skiptap*(*), name*(*)

      logical    verbos

c declare local variables

      integer argis

           call argi4 ( '-e', iend, 0, 0 )

           call argr4 ( '-ne', ne, 0., 0. )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )
           call argstr ( '-S', skiptap, ' ', ' ' ) 

           call argstr ( '-U', navtap, ' ', ' ' ) 

           call argi4 ( '-v', water_velocity, 1500, 1500 )
           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's (eat,die)

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

