C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c pad_lidi (1) takes input gathers and based on their 3D LI/DI numbering
c fills in missing LI's and/or DI's based on the LI/DI limits given, or
c (2) takes a post stack volume and fills out the volume to the LI
c DI limits given
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     itr  ( SZLNHD )
      integer     str  ( SZLNHD )

      integer     data
      pointer     (wkdata ,  data(1))
      integer     errcd1, errcd2, abort

      integer     nsamp, nsi, ntrci, nreci, iform, obytes
      integer     mfld
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     lilast, licur, dilast, dicur, didif
      integer     ic
      integer     limin, limax, dimin, dimax, lidel, didel
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 512, otap * 512, name*8, keywdl*6, keywdd*6
      logical     verbos, query, rev, inline, use, rnum
      logical     vverbos, tail, place, newli, EOF, first, post
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
c     equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'PAD_LIDI'/
      data inline/.true./, str/SZLNHD * 0/
      data abort/0/
      data EOF/.false./
      data first/.true./
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,verbos,rev,use,keywdl,keywdd,mfld,
     1            tail,place,limin,limax,dimin,dimax,vverbos,
     2            lidel,didel,post)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'pad: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)

      call savelu(keywdl,ifmt_keywdl,l_keywdl,ln_keywdl,TRACEHEADER)
      call savelu(keywdd,ifmt_keywdd,l_keywdd,ln_keywdd,TRACEHEADER)
      write(LERR,*)'keywdl,ifmt_keywdl,l_keywdl,ln_keywdl= ',
     1              keywdl,ifmt_keywdl,l_keywdl,ln_keywdl
      write(LERR,*)'keywdd,ifmt_keywdd,l_keywdd,ln_keywdd= ',
     1              keywdd,ifmt_keywdd,l_keywdd,ln_keywdd

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrci, LINHED)
      call saver(itr, 'NumRec', nreci, LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'CDPFld', ifold, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 8, LERR)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      if (mfld .eq. 0) then
          mfld = ntrci
          write(LERR,*)'NOTE:'
          write(LERR,*)'Output traces/gather defaults to input'
      endif
      nli = (limax - limin)/lidel + 1
      ndi = (dimax - dimin)/didel + 1

      if ( post ) then
         nreco = nli
         ntrco = ndi
         call savew(itr, 'NumRec', nreco, LINHED)
         call savew(itr, 'NumTrc', ntrco, LINHED)
      else
         nreco = nli * ndi
         ntrco = mfld
         call savew(itr, 'NumRec', nreco, LINHED)
         call savew(itr, 'NumTrc', ntrco, LINHED)
      endif

c
c ----- malloc only space we're going to use -----
c
      itemd = mfld * (nsamp+ITRWRD) * SZSMPD

      call galloc (wkdata , itemd, errcd2, abort)

      if (errcd2 .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)'itemd= ',itemd,wkdata
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*)'itemd= ',itemd,wkdata
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Able to allocate workspace:'
         write(LERR,*)'itemd= ',itemd,wkdata
      endif
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrco, nreco, iform,
     1                  limin, limax, dimin, dimax,lidel,didel,
     2                  use,tail,rev,rnum,ntap,otap,
     3                  post,nli,ndi)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
         dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
 
c-----
c     process desired trace records
c-----
      dilast  = dimin - didel
      lilast  = limin - lidel
      ic = 0
      live = 0
      livmax = -9999
      newli = .true.
      call savew2(str,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            30000 , TRACEHEADER)


1000  CONTINUE

c----
c   read full gather
c----
          it = 0
          live = 0
          DO  LL = 1, mfld
             nbytes = 0
             call rtape( luin, itr, nbytes)
             if(nbytes .eq. 0) then
                write(LERR,*)'End of file on input:'
                write(LERR,*)'  rec= ',jj,'  trace= ',kk
                if (LL .eq. 1) then
                    EOF = .true.
                    go to 500
                else
                    EOF = .true.
                    go to 200
                endif
             endif
             it = it + 1
             mbytes = nbytes
             iptr = (it-1) * itemt
             call vmov (itr, 1, data(iptr+1), 1, itemt)
             call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                   itrc , TRACEHEADER)
             call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   stacor , TRACEHEADER)
             if (stacor .ne. 30000) then
                live = live + 1
             endif
c------
c     use previously derived pointers to trace header values
c------
             if (LL .eq. 1) then

                call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      irec , TRACEHEADER)
                call saver2(itr,ifmt_keywdl,l_keywdl, ln_keywdl,
     1                      licur , TRACEHEADER)
                call saver2(itr,ifmt_keywdd,l_keywdd, ln_keywdd,
     1                      dicur , TRACEHEADER)
                if (vverbos) then
                write(LERR,*)'READ gather LI/DI ',LL,licur,dicur,stacor
                endif
             endif
          ENDDO

          if (live .ge. livmax) then
              if (vverbos) then
              write(LERR,*)' '
              write(LERR,*)'Found new max live trcs= ',live,
     1                     ' AT LI/DI ',licur,dicur,' Previous= ',livmax
              write(LERR,*)' '
              endif
              livmax = live
          endif

          go to 250
200       continue

c----
c   oops!  maybe we have a short gather...  Pad it out to mfld traces
c----
          k1 = it + 1
          k2 = mfld
          call complete(itr,data,itemt,mfld,k1,k2,mbytes,ITRWRD,
     1                   ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                   ifmt_RecNum,l_RecNum, ln_RecNum,
     3                   ifmt_DphInd,l_DphInd, ln_DphInd,
     4                   ifmt_LinInd,l_LinInd, ln_LinInd,
     5                   ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                   ifmt_StaCor,l_StaCor, ln_StaCor)
          go to 500
250       continue

c----
c   if this is the very first gather read, check to see we have missed
c   no full lines at the start
c----
          IF ( first ) THEN
             lidif = licur - limin
             if (lidif .ne. 0) then
                li1 = limin
                li2 = licur - lidel
                if (verbos) then
                write(LERR,*)'pad beginning lines ',li1,li2,' step ',
     1                        lidel
                write(LERR,*)' '
                endif
                do  j = li1, li2, lidel
                   j1 = dimin
                   j2 = dimax
                   jd = didel
                   call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                          ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                          ifmt_RecNum,l_RecNum, ln_RecNum,
     3                          ifmt_keywdd,l_keywdd, ln_keywdd,
     4                          ifmt_keywdl,l_keywdl, ln_keywdl,
     5                          ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                          ifmt_StaCor,l_StaCor, ln_StaCor,
     7                          j, ic)
                enddo
             endif
             first = .false.
             lilast = licur
          ENDIF

          IF (licur .ne. lilast) THEN
              newli = .true.
              if (verbos) then
                write(LERR,*)' '
                write(LERR,*)'Starting new LI ',licur
              endif
          ELSE
              newli = .false.
          ENDIF

c----
c   if current line is a new one be sure to pad out last line
c----
             IF ( newli ) THEN
                if (dilast .ne. dimax) then
                   j1 = dilast + didel
                   j2 = dimax
                   jd = didel
                   if (vverbos) then
                   write(LERR,*)' '
                   write(LERR,*)'pad out last LI ',lilast,' DIs ',
     1                        j1,j2,' step ',jd
                   write(LERR,*)' '
                   endif
                   call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                          ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                          ifmt_RecNum,l_RecNum, ln_RecNum,
     3                          ifmt_keywdd,l_keywdd, ln_keywdd,
     4                          ifmt_keywdl,l_keywdl, ln_keywdl,
     5                          ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                          ifmt_StaCor,l_StaCor, ln_StaCor,
     7                          lilast,ic)
                   ic = 0
                endif
c----
c   if there is a gap of complete lines between last and current, fill in
c----
                lidif = licur - lilast - lidel
                if (lidif .ne. 0) then
                   li1 = lilast + lidel
                   li2 = licur - lidel
                   if (verbos) then
                   write(LERR,*)' '
                   write(LERR,*)'pad missing lines ',li1,li2,' step ',
     1                           lidel
                   write(LERR,*)' '
                   endif
                   do  j = li1, li2, lidel
                      j1 = dimin
                      j2 = dimax
                      jd = didel
                      call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                             ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                             ifmt_RecNum,l_RecNum, ln_RecNum,
     3                             ifmt_keywdd,l_keywdd, ln_keywdd,
     4                             ifmt_keywdl,l_keywdl, ln_keywdl,
     5                             ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                             ifmt_StaCor,l_StaCor, ln_StaCor,
     7                             j, ic)
                   enddo
                endif
                lilast = licur

             ENDIF

c----
c   if current line is a new one be sure to pad in the start
c----
             IF ( newli ) THEN
                if (dicur .gt. dimin) then
                   j1 = dimin
                   j2 = dicur - didel
                   jd = didel
                   if (vverbos) then
                   write(LERR,*)' '
                   write(LERR,*)'pad out beg LI ',licur,' dicur,DIs ',
     1                        dicur,j1,j2,' step ',didel
                   write(LERR,*)' '
                   endif
                   call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                          ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                          ifmt_RecNum,l_RecNum, ln_RecNum,
     3                          ifmt_keywdd,l_keywdd, ln_keywdd,
     4                          ifmt_keywdl,l_keywdl, ln_keywdl,
     5                          ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                          ifmt_StaCor,l_StaCor, ln_StaCor,
     7                          licur,ic)
                endif
                newli = .false.
             ENDIF

c----
c   if we encounter a gap somewhere in the current line -- fill it
c----
             didif = dicur - dilast - didel
             IF (didif .gt. 0) THEN
                j1 = dilast + didel
                j2 = dicur  - didel
                jd = didel
                if (vverbos) then
                write(LERR,*)' '
                write(LERR,*)'pad gap LI ',licur,' DIs ',
     1                     j1,j2,' step ',jd
                write(LERR,*)' '
                endif
                call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                       ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                       ifmt_RecNum,l_RecNum, ln_RecNum,
     3                       ifmt_keywdd,l_keywdd, ln_keywdd,
     4                       ifmt_keywdl,l_keywdl, ln_keywdl,
     5                       ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                       ifmt_StaCor,l_StaCor, ln_StaCor,
     7                       licur,ic)
             ENDIF


c----
c   for current LI we are now up to the current cell -- so write it out
c   also update licur and dicur and see if we've transitioned to new
c   LI
c----
             DO  LL = 1, mfld
                iptr = (LL-1) * itemt
                call vmov (data(iptr+1), 1, itr, 1, itemt)
                call wrtape( luout, itr, nbytes)
             ENDDO
             ic = ic + 1
             dilast = dicur
             if (vverbos)
     1       write(LERR,*)'WROTE live gather LI/DI ',licur,dicur,
     2                    ' di count= ',ic

             IF (ic .eq. dimax) THEN
                 if (verbos) then
                 write(LERR,*)'detected EOL: licur= ',licur
                 endif
                 lilast = licur
                 licur  = licur + lidel
                 ic = 0
                 newli = .true.
             ELSE
                 newli = .false.
             ENDIF

             GO TO 1000


  500 CONTINUE

c----
c   here we are after the end of the input data:  do we need to fill
c   in more?
c----
      write(LERR,*)'last LI: lilast,limax= ',lilast,limax
      IF ( EOF ) THEN
         if (dilast .ne. dimax) then
            j1 = dilast + didel
            j2 = dimax
            jd = didel
            if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'pad out very last LI ',lilast,' DIs ',j1,j2,
     1                   ' step ',jd
            write(LERR,*)' '
            endif
            call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                   ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                   ifmt_RecNum,l_RecNum, ln_RecNum,
     3                   ifmt_keywdd,l_keywdd, ln_keywdd,
     4                   ifmt_keywdl,l_keywdl, ln_keywdl,
     5                   ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                   ifmt_StaCor,l_StaCor, ln_StaCor,
     7                   lilast,ic)
         endif

         lidif = limax - lilast
         if (lidif .gt. 0) then
            li1 = lilast + lidel
            li2 = limax
            if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'pad out last LIs ',li1,li2,' step ',lidel
            write(LERR,*)' '
            endif
            do  j = li1, li2, lidel
               j1 = dimin
               j2 = dimax
               jd = didel
               call padzero(str,j1,j2,jd,mfld,luout,mbytes,30000,
     1                      ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     2                      ifmt_RecNum,l_RecNum, ln_RecNum,
     3                      ifmt_keywdd,l_keywdd, ln_keywdd,
     4                      ifmt_keywdl,l_keywdl, ln_keywdl,
     5                      ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     6                      ifmt_StaCor,l_StaCor, ln_StaCor,
     7                      j, ic)
            enddo
         endif
      ENDIF


  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      write(LERR,*)'pad_lidi completed'
      write(LER ,*)'pad_lidi completed'

      call lbclos ( luin )
      call lbclos ( luout )
 

      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'pad_lidi fills out a pre- or post-stack volume based on indexing'
        write(LER,*)
     :'         limits given'
        write(LER,*)
     :'see manual pages for details'
        write(LER,*)' '
        write(LER,*)
     :'execute pad_lidi by typing pad and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)     : output data file name'
        write(LER,*)
     :' -p  input is post stack volume, else pre-stack gathers assumed'
        write(LER,*)
     :' -L [keywrdl]  (LinInd)        : LI trc header key word'
        write(LER,*)
     :' -D [keywrdd]  (DphInd)        : DI trc header key word'
        write(LER,*)
     :' -fold [fold] (line header)    : output traces/rec'
        write(LER,*)
     :'                                 ignore is post stack volume'
        write(LER,*)
     :' -limin [limin] (1)            : min LI'
        write(LER,*)
     :' -limax [limax] (no def)       : max LI'
        write(LER,*)
     :' -lidel [limax] (1)            : delta LI'
        write(LER,*)
     :' -dimin [dimin] (1)            : min DI'
        write(LER,*)
     :' -dimax [dimax] (no def)       : max DI'
        write(LER,*)
     :' -didel [dimax] (1)            : delta DI'
        write(LER,*) ' '
        write(LER,*)
        write(LER,*)
     :' -V  verbose printout is desired (padded DIs & LIs only)'
        write(LER,*)
     :' -VV  very verbose printout is desired (every DI read/written)'
        write(LER,*)
     :'usage:   pad_lidi -N[] -O[] [ -p ] -L[] -D[] -fold[] -limin[]'
        write(LER,*)
     :'                  -limax[] -lidel[] -dimin[] -dimax[] -didel[]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,verbos,rev,use,keywdl,keywdd,mfld,
     1                  tail,place,limin,limax,dimin,dimax,vverbos,
     2                  lidel,didel,post)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     rev     L        undo previous pad
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), keywdl*6, keywdd*6
      logical     verbos, vverbos, rev, use, rnum, tail, place
      logical     post
      integer     argis,limin,limax,dimin,dimax,lidel,didel
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program pad might be invoked in the following way:
 
c     pad  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into pad and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-L', keywdl, 'LinInd', 'LinInd' )
            call argstr( '-D', keywdd, 'DphInd', 'DphInd' )
            call argi4 ( '-fold', mfld, 0 , 0 )
            call argi4 ( '-limin', limin, 1 , 1 )
            call argi4 ( '-limax', limax, 0 , 0 )
            call argi4 ( '-lidel', lidel, 1 , 1 )
            call argi4 ( '-dimin', dimin, 1 , 1 )
            call argi4 ( '-dimax', dimax, 0 , 0 )
            call argi4 ( '-didel', didel, 1 , 1 )
            post    =   (argis('-p') .gt. 0)
            use     =   (argis('-U') .gt. 0)
            rev     =   (argis('-R') .gt. 0)
            place   =   (argis('-P') .gt. 0)
            rnum    =   (argis('-rnum') .gt. 0)
            tail    =   (argis('-tail') .gt. 0)
            vverbos =   (argis('-VV') .gt. 0)
            verbos  =   (argis('-V') .gt. 0)

      if (post) then
         mfold = 1
c     else
c        if (mfld .eq. 0) then
c           write(LERR,*)'pad_lidi FATAL ERROR: pre-stack mode'
c           write(LERR,*)'Must enter nonzero max fold, -fold[]'
c           write(LER ,*)'pad_lidi FATAL ERROR: pre-stack mode'
c           write(LER ,*)'Must enter nonzero max fold, -fold[]'
c        endif
      endif
      if (limax .eq. 0) then
         write(LERR,*)'FATAL ERROR:'
         write(LERR,*)'Must enter nonzero max LI, -limax[]'
         write(LER ,*)'FATAL ERROR:'
         write(LER ,*)'Must enter nonzero max LI, -limax[]'
      endif
      if (dimax .eq. 0) then
         write(LERR,*)'FATAL ERROR:'
         write(LERR,*)'Must enter nonzero max DI, -dimax[]'
         write(LER ,*)'FATAL ERROR:'
         write(LER ,*)'Must enter nonzero max LI, -limax[]'
      endif
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  limin, limax, dimin, dimax,lidel,didel,
     2                  use,tail,rev,rnum,ntap,otap,
     3                  post,nli,ndi)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, limin, limax, dimin, dimax
      integer     didel, lidel, nli, ndi
      character   ntap*(*), otap*(*)
      logical     rev, rnum, tail, use, post
 
       write(LERR,*)' '
       write(LERR,*)' line header values after default check '
       write(LERR,*) ' # of samples/trace =  ', nsamp
       write(LERR,*) ' sample interval    =  ', nsi
       write(LERR,*) ' format of data     =  ', iform
       write(LERR,*) ' output traces/rec  =  ', ntrc
       write(LERR,*) ' output records     =  ', nrec
       write(LERR,*) ' min LI             =  ',limin
       write(LERR,*) ' max LI             =  ',limax
       write(LERR,*) ' Delta LI           =  ',lidel
       write(LERR,*) ' Number of LIs      =  ',nli
       write(LERR,*) ' min DI             =  ',dimin
       write(LERR,*) ' max DI             =  ',dimax
       write(LERR,*) ' Delta DI           =  ',didel
       write(LERR,*) ' Number of DIs      =  ',ndi
       if (.not.post) then
            write(LERR,*) ' re pack data       =  ',rev
            write(LERR,*) ' renumber traces    =  ',rnum
            if ( tail )
     1      write(LERR,*) ' if EOF encountered pad last rec'
            if ( use )
     1      write(LERR,*) ' pad mode: use input line header info to dete
     2rmine total number records to pad'
       endif
       write(LERR,*) ' input data set name =  ', ntap
       write(LERR,*) ' output data set name=  ', otap
       write(LERR,*)' '
       write(LERR,*)' '

c-----
c    write out printout file in case program bombs later
c-----
c           call flush (LERR)
 
      return
      end
 
