C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  computes the time varying autocorrelation from the input
c  data - x and stores the result in output vector auto

      subroutine pretvp (nsamps, x, lslide, nwin, ovlp, lacorr,
     1                   acorr)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    x (*)
      real    acorr (*)
      real    winwork (SZLNHD), acorrn (SZLNHD), work (2*SZLNHD)
      integer lslide, nwin, ovlp, lacorr, nsamps, ilast, ifirst
      integer jmove, nmove, lwind, lxform, nu, imid1
      integer ordfft

      imid1 = 0
      DO  KK = 1, nwin
 
         if (kk .eq. 1) then
             nmove  = lslide + ovlp
             ilast  = lslide + ovlp
             ifirst = 1
             if (lslide .eq. nsamps) nmove = nsamps
             jmove = nmove
         else
             nmove  = lslide + ovlp
             jmove  = nmove
             ifirst = ifirst + ovlp
             imid1  = ifirst
             ilast  = ifirst + nmove - 1
             if (ilast .gt. nsamps) then
                 jmove = nsamps - ifirst + 1
             endif
         endif
         do   mm = 1, nmove
              winwork(mm) = 0.
         end do
         call vmov (x(ifirst), 1, winwork, 1, jmove)
         lwind = nmove
         xavg  = 0.
         xknt  = 0.
         jj = 1
         do   i = 1, lwind
              if (winwork(jj) .ne. 0.0) then
                  xavg = xavg + winwork(jj)
                  xknt = xknt + 1.
              endif
              jj = jj + 1
         end do
         if (xknt .ne. 0.0) then
               xavg = xavg/xknt
         else
               xavg = 0.
         end if
         do i=1,lwind
              work (i) = winwork(i) - xavg
         end do

         nu = ordfft (lwind)
         lxform = 2 ** nu

         call vclr  (acorrn, 1, lacorr)
         call vclr  (work(lwind+1), 1, lxform-lwind)
         call acorf (work, acorrn, lacorr, lxform)
 
         if (acorrn(1) .gt. 1.e-30) then
 
             xmax = acorrn (1)
             do  i = 1, lacorr
                 acorrn (i) = acorrn (i) / xmax
             enddo
 
             ip = (KK-1) * lacorr
             do  i = 1, lacorr
                 acorr (i+ip) = acorrn (i)
             enddo

         endif

      ENDDO

      return
      END
