C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PsdmMap(lhed,MapTrace,nsamp,remove,PassFlag,nsi,fmax,
     :     AliasFlag,tscl)

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c
c ----- arguments -----
c

      integer lhed(*)
      integer nsamp,nsi

      real    MapTrace(nsamp),fmax,tscl

      logical remove,PassFlag,AliasFlag
      
c
c ----- local variables -----
c

      integer pointer,counter,l_TVPT,l_TVPV,ifmt,length,ivalue

      real    DatumStorage(SZSMPM),HorizonStorage(SZSMPM),SI

c
c ----- initialize variables -----
c

      PassFlag = .false.
      counter = 0
      SI = float(nsi)

c
c ----- retrieve horizon and datum information from trace header -----
c       Horizon is stored in TVPT entry while associated datum is
c       stored in associated TVPV entry.  If both entries are zero
c       no further horizons will be accepted.
c

      
      counter = counter + 1
         
      call savelu('TVPT01',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV01',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl

      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 999

      counter = counter + 1
    
      call savelu('TVPT02',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl

      call savelu('TVPV02',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl

      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10

      counter = counter + 1

      call savelu('TVPT03',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl

      call savelu('TVPV03',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl

      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1

      call savelu('TVPT04',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl

      call savelu('TVPV04',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl

      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10

      counter = counter + 1
      
      call savelu('TVPT05',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV05',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT06',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV06',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT07',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV07',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT08',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV08',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT09',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV09',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT10',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV10',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT11',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV11',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT12',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV12',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT13',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV13',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT14',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV14',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT15',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV15',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT16',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV16',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT17',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV17',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT18',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV18',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT19',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV19',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT20',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV20',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      counter = counter + 1
      
      call savelu('TVPT21',ifmt,l_TVPT,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue) / tscl
      
      call savelu('TVPV21',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue) / tscl
      
      if(HorizonStorage(counter).lt.1.or.DatumStorage(counter).lt.1)
     :     goto 10
      
      
c
c ----- decrement counter unless 21 picks encountered -----
c       then decrement counter only if 21st picks are zero
c

 10   if ( counter .lt. 21) then
         counter = counter - 1
      elseif(HorizonStorage(counter).lt.1 .and.
     :        DatumStorage(counter).lt.1)then
         counter = counter - 1
      endif
      
c
c ----- sort HorizonStorage file based on increasing times, make -----
c       same changes to DatumStorage to keep horizons and associated
c       datums together
c

      if(counter .gt. 1) 
     1   call hsort2(counter,HorizonStorage,DatumStorage)

c
c ----- examine stretch/squeeze function for squeeze Nyquist violations
c

      call RedFlag(lhed,HorizonStorage,DatumStorage,counter,nsi,fmax,
     :     AliasFlag)

c
c ----- build the psdm function map for application/removal of -----
c       psdm stretch/squeeze.  The map will be contained in the
c       MapTrace array.
c

      pointer = 1

      DO i=1,nsamp
         
         tsamp = float(i)*SI

         IF(.not.remove)then

c
c ----- apply shift -----
c
 
            if( tsamp .lt. DatumStorage(pointer)
     :           .and.
     :           tsamp .lt. DatumStorage(counter)
     :           .and.
     :           pointer .eq. 1 ) then

               DatumLast = SI
               DatumNext = DatumStorage(pointer)
               HorizonLast = DatumLast
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            elseif( tsamp .lt. DatumStorage(pointer)
     :              .and.
     :              tsamp .lt. DatumStorage(counter) ) then
               
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            elseif( tsamp .ge. DatumStorage(pointer)
     :              .and.
     :              pointer .lt. counter ) then
               
               pointer = pointer + 1
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            elseif( tsamp .ge. DatumStorage(pointer)
     :              .and.
     :              pointer.eq.counter ) then

c handle samples below last horizon
               
               DatumLast = DatumStorage(pointer)
               DatumNext = float(nsamp) * SI
               HorizonLast = HorizonStorage(pointer)
               HorizonNext = DatumNext
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            endif
            
         ELSE

c
c ----- remove shift -----
c

            if( tsamp .lt. HorizonStorage(pointer)
     :           .and.
     :           tsamp .lt. HorizonStorage(counter)
     :           .and.
     :           pointer .eq. 1 ) then
               
               HorizonLast = SI
               HorizonNext = HorizonStorage(pointer)
               DatumLast = HorizonLast
               DatumNext = DatumStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
               
            elseif( tsamp .lt. HorizonStorage(pointer)
     :              .and.
     :              tsamp .lt. HorizonStorage(counter) ) then
               
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            elseif( tsamp .ge. HorizonStorage(pointer)
     :              .and.
     :              pointer .lt. counter ) then
               
               pointer = pointer + 1
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            elseif( tsamp .ge. HorizonStorage(pointer)
     :              .and.
     :              pointer.eq.counter ) then
               
               DatumLast = DatumStorage(pointer)
               DatumNext = float(nsamp) * SI
               HorizonLast = HorizonStorage(pointer)
               HorizonNext = DatumNext
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            endif

         ENDIF

         MapTrace(i) = MapTrace(i) / SI

      ENDDO

      if( MapTrace(nsamp) .gt. (float(nsamp)*SI) ) then
         write(LERR,*)' '
         write(LERR,*)'PSDM3D: You have asked to map data outside '
         write(LERR,*)'        the bounds of your input records.  This'
         write(LERR,*)'        usually means that your sample interval'
         write(LERR,*)'        is incorrect in your input dataset line'
         write(LERR,*)'        header.  Correct this using an in-situ'
         write(LERR,*)'        utop and re-run.'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         stop
      endif

      return
      
 999  continue

c      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
c      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
c      call saver2(lhed,ifmt,l_RecNum,length,irecord,TRACEHEADER)
c      call saver2(lhed,ifmt,l_TrcNum,length,itrace,TRACEHEADER)

c      write(LERR,*)' '
c       write(LERR,*)'PSDM3D:'
c       write(LERR,*)' TrcNum = ',itrace,' RecNum = ',irecord
c c       write(LERR,*)'No horizon/datum entries found in trace header.'
c       write(LERR,*)' '
c       write(LERR,*)'FATAL.....'
c       write(LERR,*)' '
c       write(LER,*)' '
c       write(LER,*)'PSDM3D:'
c       write(LER,*)' TrcNum = ',itrace,' RecNum = ',irecord
c       write(LER,*)'No horizon/datum entries found in trace header.'
c       write(LER,*)' '
c       write(LER,*)'FATAL.....'
c       write(LER,*)' '
c       stop

      PassFlag = .true.
      end
