C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                         psdm3D
c
c Implementation from 2D version by Paul G. A. Garossino
c
c psdm reads data in USP format one trace at a time, applies/removes
c a time variant stretch/squeeze and outputs data with updated line header.  
c
c
c ----- declare variables -----
c
c ----- get machine dependent parameters -----
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c
c ----- dimension standard USP variables -----
c

      integer     lhed( SZLNHD )
      integer     nsamp,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     luin,lbytes,nbytes,obytes
      integer     argis,irs,ire,ns,ne
      integer     JJ,KK

      real        tri(SZSMPM)

      character   name*6,ntap*100,otap*100

      logical     verbos,query


c ----- integer USP variables -----
c
c       lhed()     : input data 
c       nsamp      : number of samples of input trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       ntrco      : output traces/record
c       nrec       : input number of records
c       nreco      : output number of records
c       iform      : format of data
c       luin       : input device
c       lbytes     : number of bytes in lineheader
c       nbytes     : number of input bytes when trace is read
c       obytes     : number of bytes to output when processed trace is written
c       argis      : an int function returns 1 if element requested is there 0 if not
c       irs        : record start
c       ire        : record end
c       ns         : trace start
c       ne         : trace end
c       JJ,KK      : loop counters
c
c ----- real USP variables -----
c
c	tri()      : trace time series   
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input file name 
c       otap       : output file name
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c	query      : online help flag
c

c
c ----- dimension psdm specific variables -----
c

      integer     item,abort,errcd1,errcd2,errcd3

      real        work,MapTrace,fmax,samps,tscl

      pointer     (wkadr1, work(2000000))
      pointer     (wkadr2, MapTrace(2000000))
      pointer     (wkadr3, samps(2000000))

      logical     remove,linear,PassFlag,AliasFlag

c ----- integer program variables -----
c
c     item            : size of array in bytes (used in galloc of space)
c     errcd1-3        : error flag from galloc
c     abort           : abort flag from galloc
c
c ----- real program variables -----
c
c     work()      : working space for intermediate time series
c     MapTrace() : psdm mapping function time series
c     samps()     : array used as index for cubic spline interpolation
c     fmax        : max frequency of interest in input dataset
c
c ----- pointer program variables -----
c
c     wkadr1-3    : points to location of 1st element of galloc'd arrays
c
c ----- logical program variables -----
c
c     remove  : application/removal flag for psdm

c
c ----- initialize necessary variables -----
c

      data name/'PSDM3D'/,abort/1/
      data luin/1/,lbytes/0/
      remove = .false.
      linear = .false.
      AliasFlag = .false.

c
c ----- get online help if necessary -----
c

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c
c ----- open printout files -----
c

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln(ntap,otap,irs,ire,ns,ne,
     1           tscl,fmax,remove,linear,verbos)

c
c ----- get logical units -----
c

      call getln(luin,ntap,'r',0)
      call getln (luout,otap,'w',1)

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap
      write(LERR,*)'Output unit # is ',luout,' for DSN= ',otap

c
c ----- turn off large I/O buffer as we are doing tracewise operations -----
c

      call sislgbuf(luin,'off')

c
c ----- read line header, check to see if input empty -----
c

      call rtape(luin,lhed,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'FATAL.............................'
         write(LERR,*)'psdm3D: no header read on unit ',ntap
         write(LERR,*)'Check existence/permissions of file & rerun'
         write(LER,*)'FATAL.............................'
         write(LER,*)'psdm3D: no header read on unit ',ntap
         write(LER,*)'Check existence/permissions of file & rerun'
         stop
      endif

c
c ----- alter line header -----
c

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'Format', iform, LINHED)

      if(nsamp .gt. SZSMPM) nsamp=SZSMPM

c
c ----- ensure that command line values are compatible with data set -----
c       (i.e. start/end traces; start/end records)

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      call hlhprt (lhed, lbytes, name, 6, LERR)
 
c
c ----- check defaults -----
c

      if(ire .lt. 1) ire=nrec
      nreco=ire-irs+1

      if(ne.lt.1)ne = ntrc
      ntrco = ne - ns + 1


c
c ----- modify output lineheader -----
c

      call savew( lhed, 'NumSmp', nsamp, LINHED)
      call savew( lhed, 'NumRec', nreco , LINHED)
      call savew( lhed, 'NumTrc', ntrco   , LINHED)

c
c ----- change output bytes to reflect change -----
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsamp

c
c ----- adjust historical line header & write header -----
c

c---
c  for forward application grab time scale factor and stuff it into LH
c  for reverse if not on cmd line go look in LH and if at the end of the day
c  it is zero then yell for help
c---
      if (tscl .eq. 1.0) then
         call saver( lhed, 'T_Unit', itscl, LINHED)
         tscl = itscl
         if (itscl .ne. 0) then
           write(LERR,*)'WARNING from psdm3d:'
           write(LERR,*)'found time scale factor T_Unit= ',itscl
           write(LERR,*)'hope this is OK. If not run a utop:'
           write(LERR,*)'utop ... -h0T_Unit=xx | psdm3d ...'
           write(LERR,*)'where xx is the desired value, e.g. 0'
           write(LER ,*)'WARNING from psdm3d:'
           write(LER ,*)'found time scale factor T_Unit= ',itscl
           write(LER ,*)'hope this is OK. If not run a utop:'
           write(LER ,*)'utop ... -h0T_Unit=xx | psdm3d ...'
           write(LER ,*)'where xx is the desired value, e.g. 0'
         endif
      endif
      if (tscl .eq. 0.0) then
         write(LERR,*)'WARNING from psdm3d:'
         write(LERR,*)'Time scale factor is zero!!'
         write(LERR,*)'Check line header (T_Unit) or override'
         write(LERR,*)'on cmd line using -ts[]'
         write(LERR,*)'For now will set tscl = 1.0'
         write(LER ,*)'WARNING from psdm3d:'
         write(LER ,*)'Time scale factor is zero!!'
         write(LER ,*)'Check line header (T_Unit) or override'
         write(LER ,*)'on cmd line using -ts[]'
         write(LER ,*)'For now will set tscl = 1.0'
         tscl = 1.0
      endif

      call savhlh(lhed,lbytes,lbyout)
      call wrtape(luout,lhed,lbyout)

c
c ----- printout particulars for this run -----
c

      call verbal(nsamp,nsi,ntrc,ntrco,nrec,nreco,iform,
     :           ns,ne,irs,ire,tscl,fmax,remove,linear)

c
c ----- malloc only space we're going to use -----
c

      item = nsamp * SZSMPD

      call galloc(wkadr1,item,errcd1,abort)
      call galloc(wkadr2,item,errcd2,abort)
      call galloc(wkadr3,item,errcd5,abort)

      if (errcd1 .ne. 0 .or. errcd2 .ne. 0 .or. errcd3 .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
      endif


c
c ----- form sample index array for cubic spline interpolation -----
c       This is done here for performance.  If done in the subroutine
c       it would run nrec*ntrc number of times which is onerous on runtime
c

      do i=1,nsamp
         samps(i) = float(i)
      enddo

c 
c ----- skip to start record -----
c

      call recskp(1,irs-1,luin,ntrc,lhed)

      DO 100 JJ = irs, ire

c
c ----- skip to start trace -----
c

           call trcskp(jj,1,ns-1,luin,ntrc,lhed)

           DO 99 KK = ns,ne

c
c ----- read trace -----
c

                 nbytes = 0
                 call rtape(luin,lhed,nbytes)
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',KK
                    go to 999
                 endif
                 call vmov (lhed(ITHWP1), 1, tri(1), 1, nsamp)

c
c ----- clear working space for this trace -----
c

                 call vclr(work,1,nsamp)
                 call vclr(MapTrace,1,nsamp)

c
c ----- create MapTrace containing output positions of input samples -----
c

                 call PsdmMap(lhed,MapTrace,nsamp,remove,PassFlag,nsi,
     :                fmax,AliasFlag,tscl)

c  if no horizon data in header then output trace unchanged

                 if(PassFlag)goto 5002

c
c ----- apply/remove psdm stretch/squeeze to input trace -----
c

                 call PsdmApply(tri,work,MapTrace,nsamp,samps,linear)

c
c ----- move psdm'd trace from work space to output time series -----
c

                 call vclr(tri(1),1,nsamp)
                 call vmov(work(1),1,tri(1),1,nsamp)
                 call vmov (tri(1),1,lhed(ITHWP1),1,nsamp)

c
c ----- write out trace with trace header -----
c

 5002            call wrtape(luout,lhed,obytes)

99         CONTINUE

c
c ----- skip to end of record -----
c

            call trcskp(jj,ne+1,ntrc,luin,ntrc,lhed)


100   CONTINUE

999   continue

       call lbclos(luin)
       call lbclos(luout)

       if(AliasFlag)then
          write(LER,*)'PSDM3D: WARNING '
          write(LER,*)'Aliasing at frequencies below ',fmax,' hz has '
          write(LER,*)'occured.  Check printout file for particulars.'
          stop
       endif

       write(LERR,*)'PSDM3D: Normal Completion '
       write(LERR,*)'Processed ',nreco,' records of ',ntrco,' traces'
       write(LER,*)'PSDM3D: Normal Completion '

      stop
      end
