C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Description:

c      - read in 3D pre-stack shot records and re-sort the traces
c        using a primary sort parameter of Source/Receiver azimuth 
c        and a secondary sort parameter of Source/Receiver offset
c
c        The routine has a scoping mode that will allow the user to
c        determine the maximum number of traces per azimuthal bin for
c        a given -ai[].  The scoping output goes to the printout file
c        and stderr.
c
c        the -R parameter will restore the data to it's original endpoint
c        configuration based on c_PriSrt in the traceheader and  OrNTRC and 
c        OrNREC in the lineheader.  I may need to get Joe to create a
c        RaNREC and RaNTRC for this stuff if a lot of collisions occur.
c
c
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
      integer     itr_dead ( SZLNHD )
      integer     nsamp, nsampo, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*6

      logical     verbos, query

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, TraceSize, abort
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8
      integer Headers, OutputTrace, OutputX, TrcPerBin, SeqTrcNum

      real    Record, X, Azimuth  

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_X, X(200000))
      pointer (memadr_Azimuth, Azimuth(200000))
      pointer (memadr_SeqTrcNum, SeqTrcNum(200000))
      pointer (memadr_OutputTrace, OutputTrace(200000))
      pointer (memadr_OutputX, OutputX(200000))
      pointer (memadr_TrcPerBin, TrcPerBin(200000))

c Program Specific _ static memory variables

      integer ifmt_PriSrt,l_PriSrt,ln_PriSrt, PriSrt
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC, RcPtXC
      integer ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC, RcPtYC
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC, SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC, SrPtYC
      integer ifmt_TVPT01,l_TVPT01,ln_TVPT01, TVPT01
      integer ifmt_TVPT02,l_TVPT02,ln_TVPT02
      integer nbins, index, ntrco, JJ, KK, LL, MM
      integer Nlive, tr_index, hdr_index
      integer Nout, NoutMax, NoutMin, ntrc_bin, ntrc_output
      integer ntrc_live

      real Start_Azimuth, End_Azimuth, Delta_Azimuth
      real MaxAzimuth, MinAzimuth, MaxRadialDistance
      real Radian2Degree, DeltaX, DeltaY

      character c_PriSrt*6

      logical Scoping, Reverse

c Initialize variables

      data abort/1/
      data name/"RAZBIN"/
      data NoutMax/0/
      data NoutMin/99999/
      data itr_dead/SZLNHD*0/

c a good approximation to pi is 4.0 * atan ( 1.0 ) which is used below
c to determine the radian to degree conversion factor

      Radian2Degree = 180.0 / (4.0 * atan ( 1.0 ) )

c give command line help if requested

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0
     :     .or. argis ( '-help') .gt. 0 )
      if ( query )then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, name, 
     :     Start_Azimuth, End_Azimuth, Delta_Azimuth, Scoping, 
     :     ntrc_bin, Reverse, c_PriSrt, ntrc_live, verbos )

c POLICEMEN

      if ( .not. Scoping .and. .not. Reverse .and. ntrc_bin .eq. 0 )then
         write(LERR,*)' '
         write(LERR,*)'RAZBIN: To perform the sorting it is required'
         write(LERR,*)'        that you provide the maximum number of'
         write(LERR,*)'        traces per bin.  This will define the'
         write(LERR,*)'        number of traces/record on the output'
         write(LERR,*)'        dataset.  You may determine this value'
         write(LERR,*)'        by first running with -scope.  Once '
         write(LERR,*)'        determined enter the value using the '
         write(LERR,*)'        command line entry -ntrc.'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'RAZBIN: To perform the sorting it is required'
         write(LER,*)'        that you provide the maximum number of'
         write(LER,*)'        traces per bin.  This will define the'
         write(LER,*)'        number of traces/record on the output'
         write(LER,*)'        dataset.  You may determine this value'
         write(LER,*)'        by first running with -scope.  Once '
         write(LER,*)'        determined enter the value using the '
         write(LER,*)'        command line entry -ntrc.'
         write(LER,*)'FATAL'
         stop
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      if ( .not. Scoping ) call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'RAZBIN: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c build pointers to header values used

      call savelu ( c_PriSrt, ifmt_PriSrt, l_PriSrt, ln_PriSrt, 
     :     TRACEHEADER )
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
      call savelu ( 'DstSgn', ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER )
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'RcPtXC', ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, 
     :     TRACEHEADER )
      call savelu ( 'RcPtYC', ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, 
     :     TRACEHEADER )
      call savelu ( 'SrPtXC', ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, 
     :     TRACEHEADER )
      call savelu ( 'SrPtYC', ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, 
     :     TRACEHEADER )
      call savelu ( 'TVPT01', ifmt_TVPT01, l_TVPT01, ln_TVPT01, 
     :     TRACEHEADER )
      call savelu ( 'TVPT02', ifmt_TVPT02, l_TVPT02, ln_TVPT02, 
     :     TRACEHEADER )

c write dead trace flag into pad trace

      call savew2 ( itr_dead, ifmt_StaCor, l_StaCor, ln_StaCor, 30000, 
     :     TRACEHEADER )

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 6, LERR)

c handle millisecond sample interval if present

      dtmsec = float(nsi) * unitsc

c calculate number of output bins per record

      nbins = nint ( ( End_Azimuth - Start_Azimuth + 1.0 ) / 
     :     Delta_Azimuth )

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

c modify number of records in output line header

      nreco = ire - irs + 1

c store the original number of records to the header for use with the 
c reverse mode where the radial bins get put back where they belong.
c I want to get Joe to create an OrazNREC and OrazNTRC for use with
c these radial routines

      if ( .not. Reverse ) call savew(itr, 'OrNREC', nreco, LINHED)
      if ( ntrc_bin .gt. 0 ) nreco = nreco * nbins
      if ( .not. Reverse ) then
         call savew(itr, 'NumRec', nreco, LINHED)
      else

c in the case of reverse get the required output number of record from
c the OrNREC of the input dataset.  This was put there by a previous
c iteration of razbin

         call saver(itr, 'OrNREC', nreco, LINHED)
         call savew(itr, 'NumRec', nreco, LINHED)
      endif

c modify number of traces/record in output line header

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc
      ntrc_output = ne - ns + 1

      if ( .not. Reverse ) then
         call savew(itr, 'OrNTRC', ntrc_output, LINHED)
c if ntrc_bin is non-zero then user has stipulated the number of traces
c per bin on the input command line and wants output azimuth bin records
c of that size.  The RecNum entry will remain the same as the input for
c all sub bins to aide global parameterization, filtering etc later

         if ( ntrc_bin .gt. 0 ) ntrc_output = ntrc_bin
      else
         call saver(itr, 'OrNTRC', ntrc_output, LINHED)
      endif

      call savew(itr, 'NumTrc', ntrc_output, LINHED)

c modify number of samples / trace in output line header

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float ( nsi ) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      nsampo = iend - ist + 1
      call savew(itr, 'NumSmp', nsampo, LINHED)

      if ( .not. Scoping ) then

c number output bytes

         obytes = SZTRHD + SZSMPD * nsampo 

c save out hlh and line header

         call savhlh  ( itr, lbytes, lbyout )
         call wrtape ( luout, itr, lbyout )
      endif

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, dtmsec, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, Start_Azimuth, End_Azimuth, 
     :     Delta_Azimuth, Scoping, ntrc_bin, nreco, nsampo, 
     :     Reverse, c_PriSrt, ntrc_live, verbos)

c dynamic memory allocation:  

      if ( .not. Reverse ) then
         TraceSize =  (ne - ns + 1) 
      else
         TraceSize = ntrc_output
      endif
      RecordSize = TraceSize * nsampo 
      HeaderSize = TraceSize  * ITRWRD

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd2, abort)
      call galloc (memadr_X, TraceSize * SZSMPD, errcd3, abort)
      call galloc (memadr_Azimuth, TraceSize * SZSMPD, errcd4, abort)
      call galloc (memadr_SeqTrcNum, TraceSize * SZSMPD, errcd5, abort)
      call galloc (memadr_OutputTrace, TraceSize * SZSMPD, errcd6, 
     :     abort)
      call galloc (memadr_OutputX, TraceSize * SZSMPD, errcd7, abort)
      call galloc (memadr_TrcPerBin, nbins * SZSMPD, errcd8, abort)
  
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 5 * TraceSize * SZSMPD, '  bytes'
         write(LERR,*) nbins * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize * SZSMPD, '  bytes'
         write(LER,*) 5 * TraceSize * SZSMPD, '  bytes'
         write(LER,*) nbins * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 5 * TraceSize * SZSMPD, '  bytes'
         write(LERR,*) nbins * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( X, 1, TraceSize )
      call vclr ( Azimuth, 1, TraceSize )

      do i = 1, HeaderSize
         Headers(i) = 0
      enddo

      do i = 1, TraceSize
         SeqTrcnum(i) = 0
         OutputTrace(i) = 0
         OutputX(i) = 0
cprg     commented this guy out because it's only dimensioned nbins
c        TrcPerBin(i) = 0
      enddo

cprg     initialize through to nbins elements
      do i = 1, nbins
         TrcPerBin(i) = 0
      enddo


c BEGIN PROCESSING 

      write(LERR,*)' Number of Bins = ', nbins

      IF ( .not. Reverse ) then

c skip unwanted input records

         call recskp ( 1, irs-1, luin, ntrc, itr )

         DO JJ = irs, ire

C LOAD INPUT DATA 
c ---------------

            tr_index = 1 - nsampo
            hdr_index = 1 - ITRWRD
            Nlive = 0

c skip unwanted input traces

            call trcskp(JJ,1,ns-1,luin,ntrc,itr)

            DO KK = ns, ne

               nbytes = 0
               call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif

c set array load points for this trace 

               tr_index = tr_index + nsampo
               hdr_index = hdr_index + ITRWRD

c load trace to array Record[]

               if ( .not. Scoping ) 
     :              call vmov ( itr(ITHWP1+ist-1), 1, Record(tr_index),  
     :              1, nsampo )

c recover source and receiver co-ordinate data from trace header

               call saver2 ( itr, ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :              SrPtXC, TRACEHEADER )
               call saver2 ( itr, ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,  
     :              SrPtYC, TRACEHEADER )
               call saver2 ( itr, ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC,  
     :              RcPtXC, TRACEHEADER )
               call saver2 ( itr, ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, 
     :              RcPtYC, TRACEHEADER )
               call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )

c work on live traces only

               if ( StaCor .ne. 30000 ) then

                  Nlive = Nlive + 1

C BUILD RADIAL DISTANCE ARRAY

                  DeltaX = float ( RcPtXC - SrPtXC )
                  DeltaY = float ( RcPtYC - SrPtYC )

                  X(Nlive) = sqrt ( DeltaX**2 + DeltaY**2 )

c write radial distance to trace header 

                  DstSgn = nint ( X ( Nlive ) )
                  call savew2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                 DstSgn, TRACEHEADER )

C BUILD AZIMUTH ARRAY, 0 degrees points north in this scheme

                  if ( DeltaX .ge. 0.0 .and. DeltaY .ge. 0.0 ) then

c quadrant 1,  0 - 90 degrees

                     Azimuth(Nlive) = atan2 ( abs(DeltaX), abs(DeltaY) ) 
     :                    * Radian2Degree

                  elseif ( DeltaX .ge. 0.0 .and. DeltaY .lt. 0.0 ) then

c quadrant 2,  91 - 180 degrees 

                     Azimuth(Nlive) = atan2 ( abs(DeltaY), abs(DeltaX) ) 
     :                    * Radian2Degree + 90.0

                  elseif ( DeltaX .lt. 0.0 .and. DeltaY .le. 0.0 ) then

c quadrant 3, 181 - 270 degrees

                     Azimuth(Nlive) = atan2 ( abs(DeltaX), abs(DeltaY) )
     :                    * Radian2Degree + 180.0
                     
                  elseif ( DeltaX .lt. 0.0 .and. DeltaY .gt. 0.0 ) then
               
c quadrant 4, 271 to 359 degrees

                     Azimuth(Nlive) = atan2 ( abs(DeltaY), abs(DeltaX) )
     :                    * Radian2Degree + 270.0

                  endif

c write azimuth to trace header 

                  TVPT01 = nint(Azimuth(Nlive))
                  call savew2 ( itr, ifmt_TVPT01, l_TVPT01, ln_TVPT01, 
     :                 TVPT01, TRACEHEADER )

C BUILD SEQUENTIAL TRACE NUMBER ARRAY

                  SeqTrcNum(Nlive) = KK
            
               endif

c load trace header to array Headers[]

               if ( .not. Scoping ) 
     :              call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )
               
            ENDDO
c debug
c            call Int_Look2D ( Headers, ITRWRD, TraceSize )
c            call Look2D ( Record, nsampo, TraceSize )
c debug

c RECORD NOW IN MEMORY
c --------------------

c do first sort on Azimuth

            if ( Nlive .gt. 1 ) then
               call hsort3 ( Nlive, Azimuth, X, SeqTrcNum )
            endif

c output data in Azimuthal bins using radial distance as secondary sort

c report number of bins for this record

            if ( scoping ) then
               write(LERR,*)' '
               write(LERR,*)' Record = ',JJ
               write(LERR,*)' '
               write(LERR,*)' Bin    Max Angle   Number of Live Traces '
               write(LERR,*)' -----  ---------   ----------------------'
            endif

            index = 1
            ntrco = 0
            MaxRadialDistance = 0

            DO LL = 1, nbins
            
               MinAzimuth = Start_Azimuth + float(LL-1) * Delta_Azimuth 
               MaxAzimuth = Start_Azimuth + float(LL) * Delta_Azimuth 
               Nout = 0
            
               DO MM = index, Nlive

c build output arrays for traces in this bin

                  if ( Azimuth(MM) .ge. MinAzimuth .and.  
     :                 Azimuth(MM) .le. MaxAzimuth ) then
                  
                     Nout = Nout + 1
                     OutputTrace(Nout) = SeqTrcNum(MM)
                     OutputX(Nout) = X(MM)
                     if ( X(MM) .gt. MaxRadialDistance ) 
     :                    MaxRadialDistance = X(MM)
                  endif
                  if ( Azimuth(MM) .gt. MaxAzimuth ) goto 10
               ENDDO

c do secondary sort on output based on radial distance
c Nout is the number of live traces in this bin

 10            if ( Nout .gt. 0 ) then

                  if ( Scoping ) then

c report bin number and number of live traces in bin 

                     if ( Nout .gt. NoutMax ) NoutMax = Nout
                     if ( Nout .lt. NoutMin .and. Nout .gt. 0 ) 
     :                    NoutMin = Nout
                     write(LERR,*) LL, nint ( Start_Azimuth + LL * 
     :                    Delta_Azimuth), Nout
                     
                     TrcPerBin(LL) = TrcPerBin(LL) + Nout

                  else
               
                     if ( Nout .gt. 1 ) 
     :                    call isort2 ( Nout, OutputX, OutputTrace )
                     
                     DO MM = 1, Nout

c output appropriate traces

                        tr_index = (OutputTrace(MM) - 1 ) * nsampo + 1
                        hdr_index = (OutputTrace(MM) - 1 ) * ITRWRD + 1
                     
                        call vmov ( Headers(hdr_index), 1, itr, 1, 
     :                       ITRWRD )
                        call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, 
     :                       nsampo )

c write bin number into header

                        call savew2 ( itr, ifmt_TVPT02, l_TVPT02, 
     :                       ln_TVPT02, LL, TRACEHEADER )

                        call wrtape ( luout, itr, obytes )
                        ntrco = ntrco + 1
                        
                     ENDDO

                     if ( ntrc_bin .gt. 0 ) then

c if ntrc_bin is non-zero then the user has supplied a number of traces
c per bin for the output.  Here is where I would flush out dead traces up
c to the ntrc_bin limit if Nout < ntrc_bin.  In this case the new number
c of records in the output dataset would be the input nreco * nbins and
c the new number of traces per record would be ntrc_bin

                        call saver2 ( itr, ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, RecNum, TRACEHEADER )
                        call savew2 ( itr_dead, ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, RecNum, TRACEHEADER )

                        if ( Nout .lt. ntrc_bin ) then
                           do MM = Nout + 1, ntrc_bin
                              call wrtape ( luout, itr_dead, obytes )
                              ntrco = ntrco + 1
                           enddo
                        endif
                     endif
                  endif

               else
                  
c this is the empty bin to be padded if not scoping 

                  if ( .not. Scoping ) then
                     call saver2 ( itr, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, RecNum, TRACEHEADER )
                     call savew2 ( itr_dead, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, RecNum, TRACEHEADER )

                     do MM = 1, ntrc_output
                        call wrtape ( luout, itr_dead, obytes )
                        ntrco = ntrco + 1
                     enddo
                  endif
               endif

               index = index + Nout

            ENDDO

c flush out record with dead traces if necessary
         
            if ( ntrco .lt. ntrc .and. 
     :           .not. Scoping .and. ntrc_bin .eq. 0 )then

               call saver2 ( itr, ifmt_RecNum, l_RecNum,
     :              ln_RecNum, RecNum, TRACEHEADER )
               call savew2 ( itr_dead, ifmt_RecNum, l_RecNum,
     :              ln_RecNum, RecNum, TRACEHEADER )

               DO MM = ntrco + 1, ntrc
                  call wrtape ( luout, itr_dead, obytes )
               ENDDO

            elseif ( ntrco .lt. nbins*ntrc_output .and.
     :              .not. scoping .and. ntrc_bin .ne. 0 ) then
          
               call saver2 ( itr, ifmt_RecNum, l_RecNum, 
     :              ln_RecNum, RecNum, TRACEHEADER )
               call savew2 ( itr_dead, ifmt_RecNum, l_RecNum, 
     :              ln_RecNum, RecNum, TRACEHEADER )

               DO MM = ntrco + 1, ntrc_output*nbins
                  call wrtape ( luout, itr_dead, obytes )
               ENDDO

            endif

c----------------------
c  skip to end of record
c----------------------

            call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)

         ENDDO

      ELSE

c reverse sorting from radial azimuth back to original endpoint record.  Here
c I want to build the record in memory with secondary sort on original c_PriSrt

         DO JJ = 1, nreco

            tr_index = 1 - nsampo
            hdr_index = 1 - ITRWRD
            Nlive = 0

            DO KK = 1, nbins

               DO LL = 1, ntrc
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'Premature EOF on input at:'
                     write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                     go to 999
                  endif

c     pick up necessary header entries

                  call saver2 ( itr, ifmt_StaCor, l_StaCor, 
     :                 ln_StaCor, StaCor, TRACEHEADER )

c work on live trace only

                  if ( StaCor .ne. 30000 ) then

c set array load points for this trace 

                     tr_index = tr_index + nsampo
                     hdr_index = hdr_index + ITRWRD
                     Nlive = Nlive + 1

                     call saver2 ( itr, ifmt_PriSrt, l_PriSrt, 
     :                    ln_PriSrt,  PriSrt, TRACEHEADER )
                     Azimuth(Nlive) = float(PriSrt)
                     SeqTrcNum(Nlive) = tr_index
                     X(Nlive) = hdr_index

c load trace and header to record and header arrays 

                     call vmov ( itr(ITHWP1+ist-1), 1, Record(tr_index),  
     :                    1, nsampo )
                     call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )
                     
                  endif
               ENDDO
            ENDDO

c debug
c            call Int_Look2D ( Headers, ITRWRD, TraceSize )
c            call Look2D ( Record, nsampo, TraceSize )
c debug

c sort according to original trace indexing

            call hsort3 ( Nlive, Azimuth, X, SeqTrcNum )

c output live traces

            DO KK = 1, Nlive

c since SeqTrcNum holds the resorted trc_index and X() holds
c the resorted hdr_index() output is now trivial

               call vmov ( Record(SeqTrcNum(KK)), 1, itr(ITHWP1), 1, 
     :              nsampo )
               hdr_index = nint(X(KK))
               call vmov ( Headers(hdr_index), 1, itr, 1, ITRWRD )
               call wrtape ( luout, itr, obytes )

            ENDDO

c flush out with dead traces if required

            if ( Nlive .lt. ntrc_output ) then
               call saver2 ( itr, ifmt_RecNum, l_RecNum, 
     :              ln_RecNum, RecNum, TRACEHEADER )
               call savew2 ( itr_dead, ifmt_RecNum, l_RecNum, 
     :              ln_RecNum, RecNum, TRACEHEADER )

               DO LL = Nlive + 1, ntrc_output
                  call savew2 ( itr_dead, ifmt_TrcNum, l_TrcNum, 
     :                 ln_TrcNum, LL, TRACEHEADER )
                  call wrtape ( luout, itr_dead, obytes )
               ENDDO
            endif
         ENDDO
      ENDIF

c close data files 

      if ( Scoping ) then
         write(LERR,*)' '
         write(LERR,*)' Maximum number of traces per bin = ',NoutMax
         write(LERR,*)' Minimum number of traces per bin = ',NoutMin
         write(LERR,*)' Maximum radial offset in the dataset = ', 
     :        MaxRadialDistance
         write(LERR,*)' '
         write(LERR,*)' Histogram of live traces for a given bin '
         write(LERR,*)' Bin Number   Max Angle  Number Of Live Traces'
         do i = 1, nbins
            write(LERR,*)i, nint(Start_Azimuth + i * Delta_Azimuth), 
     :           TrcPerBin(i)
         enddo
         write(LER,*)' '
         write(LER,*)' Maximum number of traces per bin = ',NoutMax
         write(LER,*)' Minimum number of traces per bin = ',NoutMin
         write(LER,*)' Maximum radial offset in the dataset = ', 
     :        MaxRadialDistance
         write(LER,*)' '
         write(LER,*)' Bin Histogram [Whole Dataset Accumluated]'
         write(LER,*)' Bin Number   Max Angle  Number Of Live Traces'
         do i = 1, nbins
            write(LER,*)i, nint(Start_Azimuth + i * Delta_Azimuth), 
     :           TrcPerBin(i)
         enddo
         call lbclos ( luin )
      else
         call lbclos ( luin )
         call lbclos ( luout )
      endif

      write(LERR,*)'razbin: Normal Termination'
      write(LER,*)'razbin: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      if ( .not. Scoping ) call lbclos ( luout )
      write(LERR,*)'razbin: ABNORMAL Termination'
      write(LER,*)'razbin: ABNORMAL Termination'
      stop
      end
