C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do spatial 
c interpolation
c and sum

      subroutine binsum (ntrc, ngrp, ntrcm, nsamp, dist, xmax,
     1                   tabl1, tabl2, zz, iz, icinit, live, dx,
     2                   spread, data, out, itrh, itrho)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      
      real       data (nsamp,ntrcm)
      real       out  (nsamp,ntrcm)

      real       dist(*), spread(*)
      real       zz(*), tabl1(*), tabl2(*)

      integer    itrh  (ITRWRD,ntrcm)
      integer    itrho (ITRWRD,ntrcm)

      integer    iz(*)

      real       work1 (SZLNHD)
      real       work2 (SZLNHD)
      integer    jdist (SZLNHD)
      integer    nrept (SZLNHD)

      SAVE

c----
c vertically stack into distance bins
c----
c----
c   build input distance table,
c   find any bins that have multiple traces
c   in them
c----
      ic = 0
      nrept(1) = 1
      do  j = 1, live
          x  = dist (j)
          do  jj = 1, ngrp
              x1 = spread (jj) - .5 * dx
              x2 = spread (jj) + .5 * dx
              if (x .ge. x1 .and. x .lt. x2) then
                 jdist (j) = jj
                 if (j .ge. 2 .AND. (jdist(j) .eq. jdist(j-1))) then
                    nrept(ic) = nrept(ic) + 1
                 else
                    ic = ic + 1
                    nrept(ic) = 1
                 endif
              endif
          enddo
      enddo
      nrp = ic

c     write(0,*)'dist'
c     write(0,*)(dist(i),i=1,live)
c     write(0,*)'jdist'
c     write(0,*)(jdist(i),i=1,live)
c     write(0,*)'nrept'
c     write(0,*)(nrept(i),i=1,nrp)

c----
c for the ones that repeat (i.e. 2 or more occupy the same bin) we
c average them and output a single trace for that bin at a true
c distance that we get by averaging the original input trace distances
c----
      icum = 1

      do  j = 1, nrp

          ir1 = icum
          ir2 = icum + nrept(j) - 1
          rp  = nrept(j)
          x = 0.
          do  ii = 1, nsamp
              work1(ii) = 0.
          enddo
          do  ir = ir1, ir2
              icum = icum + 1
              x = x + dist(ir)
              do  ii = 1, nsamp
                  work1(ii) = work1(ii) + data(ii,ir)
              enddo
          enddo
          dist(j) = x / rp
          jdist(j) = jdist(ir1)
          do  ii = 1, nsamp
              data(ii,j) = work1(ii) / rp
          enddo
      enddo

      do  j = 1, nrp
          tabl1 (j) = dist (j)
      enddo

      do  j = 1, nrp
          tabl2(j) = spread (jdist(j))
      enddo

c     write(0,*)'tabl1'
c     write(0,*)(tabl1(i),i=1,nrp)
c     write(0,*)'tabl2'
c     write(0,*)(tabl2(i),i=1,nrp)
c     write(0,*)'dist'
c     write(0,*)(dist(i),i=1,nrp)
c     write(0,*)'jdist'
c     write(0,*)(jdist(i),i=1,nrp)

c----
c   interpolate record
c----

      call vclr (work1, 1, ntrcm)

      DO  100  i = 1, nsamp

          do  1  j = 1, nrp

              work1 (j) = data (i,j)
1         continue

          call vclr (work2, 1, ngrp)
          call fcuint (tabl1, work1, nrp, tabl2, work2, nrp,
     1                            iz, zz, icinit)
          icinit = 0

          do  2  j = 1, nrp

              data (i,j) = work2(j)
2         continue

100   CONTINUE

c---
c   vertically sum re-gridded record (bin option)
c----
      do  j = 1, nrp

          jm = jdist (j)
          do  i = 1, nsamp

              out (i,jm) = out (i,jm) + data (i,j)
          enddo
          do  i = 1, ITRWRD
              itrho (i,jm) = itrh (i,j)
          enddo
      enddo

      return
      end
