C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <f77/localsys.h>
c
c  This is intended to be a Unix system substitute for the 
c  functionality of the diskio routines on the old MVS system.
c  The original concept came from Cecil Jones' batch version of
c  vanl on the Sun. I modified his concept of using a scratch
c  fortran file to grab dynamic memory if possible. If that
c  allocation fails, I go ahead and get a scratch disk. I have
c  done some quick tests which reveal that the heap allocation
c  is much more cost-efficient that the temp disk. ( at least 
c  on the Cray). 
c 					- Joe M Wade 03/12/90
c
      subroutine daopen(ntrs,ntrks,nbytes,lud,nunits)
      real array(*)
      real work
      pointer(wkaddr, work(1))
      logical heap
      integer nsamps

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer errcod, abort
      data abort / 0 /
      save abort
      data heap / .true. /
      SAVE nsamps,heap
      save wkaddr
      nsamps = nbytes/SZSMPD
      call galloc(wkaddr, ntrs*ntrks*nbytes, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      if (.not. heap) then
        write(LERR,*)' DAOPEN: unable to allocate memory',
     *              ', use scratch disk'
        open(lud,form='UNFORMATTED',access='DIRECT', recl=nbytes,
     *     status = 'SCRATCH',iostat=ios)
        if (iostat .ne. 0)
     *    write(LERR,*)' DAOPEN: Unable to allocate scratch disk,',
     *              ' recl = ',nbytes,', iostat = ',ios
      endif
      return
*
      entry daread(irec,array,lud)
      if ( heap ) then
        iloca=(irec-1)*nsamps+1
        call vmov(work(iloca),1,array(1),1,nsamps)
      else
        read(lud,rec=irec)(array(i),i=1,nsamps)
      endif
      return
*
      entry dawrte(irec,array,lud)
      if ( heap ) then
        iloca=(irec-1)*nsamps+1
        call vmov(array(1),1,work(iloca),1,nsamps)
      else
        write(lud,rec=irec)(array(i),i=1,nsamps)
      endif
      return
*
      entry daclos(lud)
      if ( heap ) then
        call gfree(wkaddr)
      else
        close(lud, status = 'DELETE')
      endif
      return
*
      end
