C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                 PROGRAM ST3D COMPUTES AND APPLIES SURFACE-CONSISTENT
C                 STATIC CORRECTIONS FOR 3-D SEISMIC DATA.
C  KEYWORDS:  SURFACE-CONSISTENT, STATICS, CORRECTIONS
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHORS:      G. M. RUCKGABER
C  ORIGIN DATE:  84/08/02
C  MAJOR ROUTINES CALLED:
C      ERDS3B   -      CALCULATES ERRORS AND SWITCHES ALTERNATE PICKS.
C      GAUS3B   -      SOLVES STATIC EQUATIONS BY GAUSS-SEIDEL METHOD.
C      PLEM3B   -      VERSATEC PLOT OF ERROR DISTR. AND STATICS MAPS.
C  UTILITY ROUTINES CALLED:
C      ALLOTR   -      ALLOCATE DISK SPACE.
C      CCEXIT   -      EXIT ROUTINE.
C      DACLOS   -      CLOSE DISK FILE.
C      DAOPEN   -      OPEN DISK FILE.
C      DAWRTE   -      WRITE DATA BLOCK TO DISK.
C      DEALLO   -      DELETE TEMPORARY DISK FILES.
C      EBCASC   -      EBCDIC TO ASCII CHARACTER CONVERSION.
C      GAMOCO   -      BANNER PAGE ROUTINE.
C      GSPARM   -      GET PARM PARAMETERS.
C      HLH      -      LINE HEADER SUMMARY AND UPDATE.
C      ICLOCK   -      DETERMINE TIME.
C      LBCLOS   -      CLOSE TAPE.
C      LBOPEN   -      OPEN TAPE.
C      MOVE     -      MOVE ARRAYS.
C      NACCT    -      ACCOUNTING ROUTINE.
C      NACCT2   -      ACCOUNT CLOSING ROUTINE.
C      OPTION   -      TAPE I/O OPTION ROUTINE.
C      RTAPE    -      READ DATA BLOCK FROM TAPE.
C      RWD      -      REWIND TAPE TO LOAD POINT.
C      WRTAPE   -      WRITE DATA BLOCK TO TAPE.
C  FORTRAN SUPPLIED PROCEDURES:
C      COS
C      IABS
C      MOD
C      SIGN
C      SIN
C  COMMON:
C      ERRORS  (  * )  ERROR DISTRIBUTION AND OTHER ERROR STATISTICS
C                      SET BY SUBROUTINE ERDS3B.
C                        DIST   - ARRAY FOR ERROR DISTRIBUTION
C                        NODIS  - LENGTH OF ARRAY FOR ERROR DISTRIBUTION
C                        DID    - ERROR INCREMENT IN ERROR DIST. ARRAY
C                        ERMAX  - MAXIMUM ERROR
C                        POSER  - LARGEST POSITIVE ERROR
C                        ERNEG  - LARGEST NEGATIVE ERROR
C                        RMSER  - RMS ERROR
C                        NSUMO  - NO. OF EVENTS INCLUDED IN ERROR DIST.
C                        NOLEG  - NO. OF ALTERNATE PICKS SUBSTITUTED
C      FILCON  (  * )  PARAMETERS FOR TWO TEMPORARY DISK AREAS SET BY
C                      MAIN PROGRAM.
C                        NWPEA  - NO. OF WORDS PER EVENT IN DISK A
C                        NEPBA  - NO. OF EVENTS PER BLOCK IN DISK A
C                        NWPBA  - NO. OF WORDS PER BLOCK IN DISK A
C                        NBPBA  - NO. OF BYTES PER BLOCK IN DISK A
C                        NBLKSA - NO. OF BLOCKS IN DISK A
C                        NEVNTS - NO. OF ACCEPTABLE EVENTS IN DISK A
C                        NWPCB  - NO. OF WORDS PER COORDINATE IN DISK B
C                        NCPBB  - NO. OF COORDINATES PER BLOCK IN DISK B
C                        NWPBB  - NO. OF WORDS PER BLOCK IN DISK B
C                        NBPBB  - NO. OF BYTES PER BLOCK IN DISK B
C                        NBLKSB - NO. OF BLOCKS IN DISK B
C                        NCORDS - NO. OF COORDINATES IN DISK B
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET
C                      BY MAIN PROGRAM.
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS
C                        LUPRNT - LOGICAL UNIT FOR PRINTER
C                        LUPNCH - LOGICAL UNIT FOR OUTPUT STATICS CARDS
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B
C                        LUVRUP - LOGICAL UNIT FOR VERSATEC UNIV. PARAM.
C                        LUVRWA - LOGICAL UNIT FOR VERSATEC WORK AREA A
C                        LUVRWB - LOGICAL UNIT FOR VERSATEC WORK AREA B
C                        LUCLCM - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS
C      PLTMAP  (  * )  PARAMETERS FOR VERSATEC PLOT OF ERROR
C                      DISTRIBUTION AND STATICS MAPS SET BY MAIN
C                      PROGRAM.
C                        NHSCAL - HORIZONTAL SCALE OF ERROR DISTRIBUTION
C                        NHIGHT - HEIGHT OF ERROR DISTRIBUTION PLOT
C                        NMAPSC - SCALE OF STATICS MAPS
C                        JBNAME - ARRAY FOR JOB NAME
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE
C                      SET BY MAIN PROGRAM.
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM
C                        MINJR  - MINIMUM GROUP (GI) INDEX
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX
C                        NOJR   - NO. OF GROUP (GI) INDEXES
C                        JRPOIN - POINTER FOR FIRST GROUP TERM
C                        NOKK   - NO. OF BINS
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM
C                        MINLI  - MINIMUM LINE (LI) INDEX
C                        MAXLI  - MAXIMUM LINE (LI) INDEX
C                        NOLI   - NO. OF LINE (LI) INDEXES
C                        MINDI  - MINIMUM DEPTH (DI) INDEX
C                        MAXDI  - MAXIMUM DEPTH (DI) INDEX
C                        NODI   - NO. OF DEPTH (DI) INDEXES
C                        NOSRK  - TOTAL NO. OF UNKNOWNS
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS
C                        NUPWFG - USE PICK WEIGHTS FLAG
C                                     (0=YES, 1=NO)
C                        MODEFG - MODE OF SOLUTION FLAG
C                                     (1  --  I + R = T                )
C                                     (2  --  I + R + C + M = T        )
C                                     (3  --  I + R + C + M + E + F = T)
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG
C                                     (0=YES, 1=NO)
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING
C                                     ALL RNMO TERMS
C      STAFL3  (  * )  ARRAYS FOR DATA FROM EVENT TAPE.
C                        TIJ    - ARRAY FOR PRIMARY PICKS
C                        TIJM   - ARRAY FOR ALTERNATE PICK (LT PRIMARY)
C                        TIJX   - ARRAY FOR ALTERNATE PICK (GT PRIMARY)
C                        COR    - ARRAY FOR SQUARE OF WEIGHTS
C                        CORM   - ARRAY FOR SQ. OF ALT. WEIGHT (LT PRI.)
C                        CORX   - ARRAY FOR SQ. OF ALT. WEIGHT (GT PRI.)
C                        ISPOS  - ARRAY FOR SOURCEPOINT (PRI) POINTERS
C                        JRPOS  - ARRAY FOR GROUP (GI) POINTERS
C                        KKPOS  - ARRAY FOR BIN POINTERS
C                        XOF    - ARRAY FOR SQUARE OF OFFSETS
C                        XOFSIN - ARRAY FOR (XOF**2)*SIN(AZIMUTH)
C                        XOFCOS - ARRAY FOR (XOF**2)*COS(AZIMUTH)
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:
C      PROGRAM ST3D READS AN EVENT TAPE FROM PROGRAM PICK AND DETERMINES
C      SURFACE-CONSISTENT STATIC CORRECTIONS.  THE PROGRAM THEN
C      OPTIONALLY APPLIES THESE STATICS TO AN INPUT DATA TAPE AND/OR
C      PUNCHES THE STATICS TO 8STAT AND 9CORR CARDS.  AN ERROR
C      DISTRIBUTION AND MAPS OF THE STATICS SOLUTION ARE OPTIONALLY
C      PLOTTED ON THE VERSATEC PLOTTER.  BIN-ORIENTED SOLUTION ARRAYS
C      ARE OPTIONALLY WRITTEN TO AN SIS-FORMAT OUTPUT TAPE AS TIME
C      SLICES.  AN OUTPUT CARD FILE IS CREATED FOR CONTOURING OF THE
C      STATICS SOLUTION USING THE AMOCO I CONTOURING PROGRAMS.
C
C      THE STATICS CAN BE DETERMINED USING ONE OF THREE DIFFERENT MODES.
C      THESE MODES USE THE FOLLOWING RESPECTIVE MATRIX MODELS:
C
C                MODE 1  --  I + R = T,
C                MODE 2  --  I + R + C + M = T,
C                MODE 3  --  I + R + C + M + E + F = T,
C
C      WHERE I IS THE SOURCEPOINT STATIC VECTOR, R IS THE GROUP STATIC
C      VECTOR, C IS THE STRUCTURAL ERROR VECTOR, M IS THE 2-D RNMO ERROR
C      VECTOR, E IS THE 3-D SINE RNMO ERROR VECTOR, F IS THE 3-D COSINE
C      RNMO ERROR VECTOR, AND T REPRESENTS THE TIME DIFFERENTIALS PICKED
C      BY PROGRAM PICK.  MODE 3 IS THE FULL 3-D MODEL, MODE 2 IS THE 2-D
C      MODEL, AND MODE 1 IS A LESSOR (APPROXIMATE) MODEL THAT IS MORE
C      ECONOMICAL THAN MODES 2 AND 3.
C
C      THE INPUT EVENT TAPE MUST BE SIS FORMAT 5 FROM PROGRAM PICK AND
C      HAVE 256-BYTE TRACE HEADERS.
C
C      AFTER THE INPUT EVENT TAPE IS OPENED AND CHECKED FOR THE CORRECT
C      TAPE FORMAT, ETC, THE INPUT DATA CARDS ARE INTERPRETED AND
C      MISSING PARAMETERS ARE DEFAULTED.  AN INTERPRETED CARD PARAMETER
C      SUMMARY IS THEN PRINTED.
C
C      THE INPUT EVENT TAPE IS THEN SCANNED TO DETERMINE THE MINIMUM
C      AND MAXIMUM SOURCEPOINT, GROUP, LINE, AND DEPTH INDEXES FOR ALL
C      LIVE (PICKED) EVENTS ON THE TAPE.  THE USER CAN EDIT EVENTS BY
C      SPECIFYING MINIMUM AND MAXIMUM LINE INDEXES, DEPTH INDEXES,
C      RANGES, AND AZIMUTHS.  EVENTS PASSING THIS LIMITING AND EDITING
C      PROCESS ARE ALSO ANALYZED FOR THEIR MINIMUM AND MAXIMUM INDEXES.
C      DATA FOR THESE PASSED EVENTS ARE THEN WRITTEN TO A TEMPORARY DISK
C      AREA PACKED IN BLOCKS.  THE PARTICULAR DATA WORDS WRITTEN ARE
C      DEPENDENT UPON THE MODE.
C
C      IF THE VERSATEC PLOT OF THE STATICS MAPS IS REQUESTED, THE X,Y
C      COORDINATES OF THE SOURCEPOINT AND GROUP STATICS ARE WRITTEN TO A
C      SECOND TEMPORARY DISK AREA.
C
C      SURFACE-CONSISTENT STATICS ARE THEN DETERMINED USING A GAUSS-
C      SEIDEL ITERATIVE METHOD ON THE NORMAL EQUATIONS RESULTING FROM
C      THE LEAST-MEAN-SQUARE-ERROR FORMULATION OF THE PARTICULAR STATICS
C      MODEL SELECTED.  IN COMPUTING THE LMSE MATRIX, EACH STATIC
C      EQUATION IS OPTIONALLY WEIGHTED BY ITS PICK WEIGHT.  THE LMSE
C      MATRIX AND SOLUTION VECTOR ARE AUTOMATICALLY PARTITIONED INTO
C      SEGMENTS CORRESPONDING TO THE I, R, C, M, E, AND F TERMS
C      ACCORDING TO THE MODE OF SOLUTION AND PARAMETERS IN
C      COMMON/POINT3/.  FOR THE SOLUTION VECTOR XX,
C      XX(ISPOIN) CORRESPONDS TO THE FIRST SOURCEPOINT STATIC TERM AND
C      THERE ARE NOIS SOURCEPOINTS, SO LOCATIONS THROUGH
C      XX(ISPOIN + NOIS - 1) CONTAIN THE SOURCEPOINT TERMS.
C      XX(JRPOIN) CORRESPONDS TO THE FIRST GROUP TERM, AND THERE ARE
C      NOJR GROUP TERMS.
C      DEPENDING ON THE MODE OF SOLUTION, THE STRUCTURE, 2-D RNMO, 3-D
C      SINE RNMO, AND 3-D COSINE RNMO VECTORS MAY OR MAY NOT BE PRESENT:
C           XX(KCPOIN) IS THE FIRST OF THE NOKK STRUCTURE TERMS,
C           XX(KMPOIN) IS THE FIRST OF THE NOKK 2-D RNMO TERMS,
C           XX(KEPOIN) IS THE FIRST OF THE NOKK 3-D SINE RNMO TERMS, AND
C           XX(KFPOIN) IS THE FIRST OF THE NOKK 3-D COSINE RNMO TERMS.
C      THE MAIN DIAGONAL AND RHS OF THE LMSE MATRIX AND THE PRODUCT OF
C      THE LMSE MATRIX WITH THE CURRENT SOLUTION VECTOR ARE SIMILIARLY
C      PARTITIONED.  HOWEVER, FOR THESE THREE LATTER VECTORS ONLY THE
C      PARTITION CURRENTLY NEEDED BY THE ITERATIVE PROCESS ARE STORED IN
C      CORE.
C
C      SUBROUTINE GAUS3B IMPLEMENTS THE GAUSS-SEIDEL ITERATIVE METHOD.
C      FIRST, THE I SOLUTION IS UPDATED (STARTING FROM INITIAL VALUES OF
C      ZERO), THEN THE R SOLUTION, THEN C, THEN M, ETC.  AS EACH
C      PARTITION OF THE SOLUTION VECTOR IS BEING UPDATED, EVENT DATA IS
C      READ IN FROM DISK TO COMPUTE THE CURRENT PARTITION OF THE MAIN
C      DIAGONAL AND RHS OF THE LMSE MATRIX AND THE CURRENT PARTITION OF
C      THE PRODUCT OF THE LMSE MATRIX WITH THE LATEST SOLUTION VECTOR.
C      A SCALING FACTOR IS COMPUTED FOR DOWNWARD SCALING OF THE THREE
C      RNMO VECTORS RELATIVE TO THE I, R, AND C TERMS TO PREVENT
C      DOMINATION BY THE RNMO TERMS.  THE SOLUTION IS PREWHITENED BY
C      ADDING A USER-SPECIFIED PERCENTAGE OF THE SOLUTION VECTOR TO THE
C      MAIN DIAGONAL OF THE LMSE MATRIX.  ALSO, THRESHOLD LEVELS ARE
C      DETERMINED IN EACH PARTITION.  IF A MAIN-DIAGONAL ELEMENT OF THE
C      LSME MATRIX DROPS BELOW THE THRESHOLD LEVEL FOR ITS PARTITION,
C      THEN THE ELEMENT IS SET EQUAL TO THE THRESHOLD LEVEL.  THIS
C      ADDITIONAL PREWHITENING PREVENTS INSTABILITIES FOR ELEMENTS
C      HAVING LOW MULTIPLICITY.  THE THRESHOLD LEVEL IN EACH PARTITION
C      IS EQUAL TO ONE-FOURTH OF THE AVERAGE MULTIPLICITY IN THAT
C      PARTITION.
C
C      AFTER NPITER ITERATIONS (SPECIFIED BY THE USER), AN ERROR IS
C      COMPUTED FOR EACH PICK USING THE CURRENT SOLUTION.  THE TWO
C      ALTERNATE PICKS ARE SUCCESSIVELY CHECKED FOR LESS ERROR THAN THE
C      PRIMARY PICK.  IF ONE OF THE ALTERNATE PICKS RESULTS IN LESS
C      ERROR, THEN THIS ALTERNATE PICK AND ITS WEIGHT IS SWITCHED WITH
C      THE PRIMARY PICK AND ITS WEIGHT.  ANOTHER NPITER ITERATIONS ARE
C      THEN DONE AND ALL ALTERNATE PICKS ARE AGAIN CHECKED AND POSSIBLY
C      SWITCHED.  THE MAIN DIAGONAL AND RHS OF THE LMSE MATRIX ARE
C      REINITIALIZED AFTER EACH CYCLE OF PICK SWITCHING USING THE NEW
C      PRIMARY PICK SET.  THIS LOOP IS REPEATED UNTIL NO ALTERNATE PICKS
C      RESULT IN LESS ERROR OR UNTIL MXPITR CYCLES (SPECIFIED BY THE
C      USER) ARE COMPLETED.  FINALLY, NFITER ITERATIONS (SPECIFIED BY
C      THE USER) ARE DONE TO COMPLETE THE SOLUTION.
C
C      SUBROUTINE ERDS3B COMPUTES THE ERRORS AND PERFORMS THE PICK
C      SWITCHING.
C
C      ALL SOLUTION VECTORS ARE THEN OPTIONALLY PRINTED.  THE STATICS
C      SOLUTION IS PRINTED AS 8STAT AND 9CORR CARD IMAGES AND OPTIONALLY
C      WRITTEN TO A CARD IMAGE FILE IN THIS SAME FORMAT FOR APPLICATION
C      IN PROGRAM STAT.  THE FILENAME AND EXTENSION OF THIS LATTER FILE
C      IS XXXXXXXX.STA WHERE XXXXXXXX IS THE JOBNAME.
C
C      THE BIN-ORIENTED SOLUTION VECTORS (C, M, E, AND F) CAN BE
C      OPTIONALLY WRITTEN TO AN SIS FORMAT 3 OUTPUT TAPE AS TIME-SLICE
C      RECORDS WITH EACH ARRAY (VECTOR) EQUIVALENT TO ONE TIME SLICE.
C
C      A VERSATEC PLOT OF THE FINAL ERROR DISTRIBUTION AND POSTED MAPS
C      OF THE STATICS SOLUTION IS THEN OPTIONALLY CREATED ALONG WITH A
C      CARD IMAGE FILE CONTAINING THE STATICS SOLUTION AND THE STATICS
C      X,Y COORDINATES FORMATTED FOR INPUT TO THE AMOCO I CONTOURING
C      PROGRAMS.  THE FILENAME AND EXTENSION OF THIS LATTER FILE IS
C      XXXXXXXX.CLC WHERE XXXXXXXX IS THE JOBNAME.
C
C      FINALLY, THE STATICS SOLUTION CAN BE APPLIED TO AN OPTIONAL INPUT
C      DATA TAPE.  THIS DATA TAPE MUST BE SIS FORMAT 1 OR 3 HAVING NO
C      MORE THAN 6000 SAMPLES/TRACE.
C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
 
	integer argis
	logical nodsco
cmam		added to put out reject print optionally
	logical verbos
cmam......added amplitude option....10-26-95
	logical ampopt
cmam.....added option to make 2d data work in 3d code..2-20-96
	logical x2d
cmam  INTEGER*2 ILH(  3000), IX(12128), ITEMP(6000)

      INTEGER*4 NLH(  1500), NX(  6064), pipe

cmam......10-20-95.....dynamically allocate these arrays......
	real XX, BB, BNO, WA
        pointer (memadr_XX,XX(200000))
        pointer (memadr_BB,BB(200000))
        pointer (memadr_BNO,BNO(200000))
        pointer (memadr_WA,WA(200000))

cmam  REAL*4 XX(2200000), BB(550000), BNO(550000), WA(550000)
cmam  REAL*4 XX(2100000), BB(500000), BNO(500000), WA(500000)

cmam  REAL*4 RTEMP(6000)

	CHARACTER*100 EVNFIL, OUTFIL
cmam......option added by garossino to specify location of temp files
        character tempfile*255
cmam
	character*100 timesl
      CHARACTER IJBNAM*8, IDSNAM*22, IVOLSR*6, IDDCRD*92, IOTHLH*16,
     *          NAME*4,   NAMEPR*4,
cmam *          NAME*4,   TJOB1*8,   NAMEPR*4,
     *          DDNAME*8, NDVICE*4,  NSETUP*4, NTITLE*20,
     *          CTPRTY*2, CARDA*80,  CARDB*80, CARDC*80

      COMMON/ERRORS/DIST(201),NODIS,DID,ERMAX,POSER,ERNEG,RMSER,NSUMO,
     *              NOLEG
      COMMON/FILCON/NWPEA,NEPBA,NWPBA,NBPBA,NBLKSA,NEVNTS,
     *              NWPCB,NCPBB,NWPBB,NBPBB,NBLKSB,NCORDS
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,luprnt,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB

      COMMON/PLTMAP/NAMEPR,NTITLE,CARDA,CARDB,CARDC,NHSCAL,NHIGHT,
     *              NMAPSC,NCNTIN,NXSHFT,NYSHFT,NDVICE,NSETUP,CTPRTY,
     *              IJBNAM,IDSNAM,IVOLSR
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,
     *              MINLI,MAXLI,NOLI,MINDI,MAXDI,NODI,NOSRK,MXNSRK,
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF
      COMMON/STAFL3/TIJ(680),TIJM( 680),TIJX( 680),COR( 680),
     *              CORM( 680),CORX( 680),ISPOS( 680),JRPOS( 680),
     *              KKPOS( 680),XOF( 680),XOFSIN( 680),XOFCOS( 680)
	common/hedrs/j_RecNum,i_RecNum,l_RecNum,
     *		     j_TrcNum,i_TrcNum,l_TrcNum,
     *		     j_NumTrc,i_NumTrc,l_NumTrc,
     *		     j_NumRec,i_NumRec,l_NumRec,
     *		     j_SmpInt,i_SmpInt,l_SmpInt,
     *		     j_NumSmp,i_NumSmp,l_NumSmp,
     *		     j_Format,i_Format,l_Format
cmam  EQUIVALENCE (NLH(1),ILH(1)), (NX(1),IX(1))
c     EQUIVALENCE  (NX(1),IX(1))
cmam  EQUIVALENCE (ITEMP(1),BB(1),RTEMP(1))
      EQUIVALENCE (DDNAME, IDDCRD(1:8))
      DATA NAME/'SC3D'/, IOTHLH/'SC3D (MODE =  ) '/
      DATA IDDCRD/'FT07F001                                          '/
      DATA CHG / 1.0 /, IER / 0 /
#include <f77/pid.h>
	data pipe/0/
	if (ARGIS('-H') .GT. 0 .OR. ARGIS('-?') .GT. 0) CALL HELP
      itrpnt = 0
      jpnt   = 1
#include <f77/open.h>
C
C---- SET LOGICAL UNIT VALUES....
	luotap = 6
	IREADR = LUN
	IPRNTR = LERR
	LUPRNT = LERR
    	LUPRTN = LERR
      LUPNCH = 22
      LUDSKA = 51
      LUDSKB = 61
      LUVRUP = 66
      LUVRWA = 67
      LUVRWB = 68
      LUCLCM = 23
      MXNSPT = 6000
cmam  MXNSRK = 500000
cmam  MXNOKK = 2100000
      MXNSRK = 2200000
      MXNOKK = 550000
cmam...........10-20-95.................................................
cmam...........the XX,BB,BNO and WA arrays are now dynamically allocated
cmam...........the above 2 variables are no longer used because the
cmam...........dimensions are calculated from the data input.
C
C*             MXNOKK IS THE MAXIMUM ALLOWABLE NO. OF BINS.
C*
C*             MXNSRK IS THE MAXIMUM ALLOWABLE NO. OF UNKNOWNS.
C*
C*             DEFINING MXNOKK AND MXNSRK ALSO FIXES THE MAXIMUM
C*             ALLOWABLE NO. OF SOURCEPOINT PLUS GROUPS (MXNOSG)
C*             AS FOLLOWS.  FOR MODES 1 AND 2, MXNOSG=MXNOKK
C*             BECAUSE OF THE TEMPORARY UTILIZATION OF ARRAYS BNO
C*             AND BB FOR STORING SOURCEPOINT AND GROUP X,Y
C*             COORDINATES.  FOR MODE 3, MXNOSG VARIES FROM A
C*             MAXIMUM OF MXNOKK DOWN TO A MINIMUM OF
C*             (MXNSRK - (4*ACTUAL NO. OF BINS)), WHICH COULD BE
C*             AS SMALL AS (MXNSRK - (4*MXNOKK)), DEPENDING ON
C*             THE ACTUAL NO. OF BINS.
C*
C*
C*             THEREFORE, MXNSRK SHOULD BE DEFINED GREATER THAN
C*             4*MXNOKK TO ALLOW SPACE FOR THE SOURCEPOINT PLUS
C*             GROUP TERMS IN MODE 3, BUT SHOULD BE LESS THAN
C*             5*MXNOKK, OR ELSE STORAGE WOULD BE ALLOCATED FOR
C*             THE SOURCEPOINT PLUS GROUP TERMS THAT WOULD NEVER
C*             BE ALLOWED TO BE USED.
C*
C*   WARNING:  MXNOKK SHOULD NOT BE LESS THAN MXNSPT BECAUSE OF
C*             THE EQUIVALENCING OF ARRAY RTEMP TO BB.
C*
C*             THE DIMENSION OF ARRAY XX SHOULD EQUAL MXNSRK.
C*
C*             THE DIMENSION OF ARRAYS BNO, BB, AND WA SHOULD
C*             EACH EQUAL MXNOKK.
 
C*             THE DIMENSION OF ARRAYS ITEMP AND RTEMP SHOULD
C*             EACH EQUAL MXNSPT.
C***********************************************************************
C                                                                       
c     IF ( MXNSRK .LE. (4*MXNOKK) .OR.                                  
c    1     MXNSRK .GT. (5*MXNOKK) .OR.                                  
c    2     MXNOKK .LT. MXNSPT ) THEN                                    
c       WRITE (LUPRNT,1900)                                             
c1900   FORMAT ('0INTERNAL PROGRAM ARRAY LENGTHS ARE INCONSISTENTLY ',  
c    *          'DEFINED BY PROGRAMMER (NOT A USER ERROR)--',           
c    *          'EXECUTION TERMINATED' )                                
c       IER = 100                                                       
c       GOTO 9999                                                       
c     END IF                                                            
C                                                                       
      NEPBA = 680                                                       
      NCPBB = 680                                                       
C                                                                       
C***********************************************************************
C*  WARNING:  NEPBA AND NCPBB MUST BE IDENTICAL TO THE DIMENSION OF    *
C*            ARRAYS TIJ, TIJM, TIJX, COR, CORM, CORX, ISPOS, JRPOS,   *
 
C*            KKPOS, XOF, XOFSIN, AND XOFCOS.  THE VALUE 680 WILL      *
C*            OPTIMALLY FIT THE LIMIT FOR SUBROUTINE DAOPEN OF 32760   *
C*            BYTES IN THE CASE HAVING THE MOST DATA PER EVENT         *
C*            (MODEFG=3).                                              *
C***********************************************************************
C
C
C---- PRINT FUNKY STUFF...
C
 
      NWPCB = 2
      NODIS = 201
      IF ( MOD(NODIS,2) .EQ. 0 ) NODIS = NODIS - 1
      DID = 1.0
      NAMEPR = NAME
      CALL GAMOCO ('                 STATIC CORRECTIONS 3-DIMENSIONAL'//
     *             '                 ', 1, LUPRNT)                      
C***********************************************************************
C*   OPEN INPUT EVENT TAPE, READ EVENT TAPE LINE HEADER, CHECK THAT    *
C* INPUT EVENT TAPE MEETS REQUIREMENTS, CALL SUBROUTINE TO ACCESS JOB  *
C* NAME AND EVENT TAPE INFORMATION FOR THE PLOTTING SUBROUTINE, DEFINE *
C* PARAMETERS, CALL HLH AND ACCOUNTING ROUTINES.                       *
C***********************************************************************
C                                                                       
      IRETCD = 0
      ikp = in_ikp()
      write(LERR,*)'scorusp: ikp= ',ikp
 
      if (ikp .eq. 0) then
          call argstr ('-N', evnfil, ' ', ' ')
          call getln (lunevt, evnfil, 'r', 0)
      elseif (ikp .eq. 1) then
          call sisfdfit (lunevt, pipe)
      endif
cmam.....change made by garossino to tell where to put temp files
      call argstr ( '-S',tempfile, ' ', ' ' )
      if (lunevt .lt. 0) IRETCD = 1
 
      IF (IRETCD .NE. 0) THEN
          WRITE (LERR,'(A)') 'SC3D ERROR: CAN''T OPEN EVENT FILE'
          CALL CCEXIT(9999)
      ENDIF
      write(LERR,*)'Opened event file= ',evnfil,' on unit= ',lunevt
 
      IRETCD = 0
      call argstr ('-O', outfil, ' ', ' ')
	if(outfil .ne. ' ') then
	luotap =  73
	   write(LERR,*)'Output file=',outfil,' will go to unit=',
     *			luotap
	else
	   write(LERR,*)'Output file will be piped'
	   luotap = 6
	endif
 
c
      IRETCD = 0
      call argstr ('-T', timesl, ' ', ' ')
	if(timesl .eq. ' ') then
		nslafg = 0
	write(LERR,*)'no time slices requested'
	else
		nslafg = 1
	write(LERR,*)'time slices are requested'
      call getln (luosla, timesl, 'w', 1)
      if (luosla .lt. 0) IRETCD = 1
      IF (IRETCD .NE. 0) THEN
          WRITE (LERR,'(A)') 'SCOR3D ERROR: CAN''T OPEN Time Slices OUTPUT
     * FILE'
          CALL CCEXIT(9999)
      ENDIF
      write(LERR,*)'Opened output file= ',timesl,' on unit= ',luosla
	endif

cmam
	call savelu('NumSmp',j_NumSmp,i_NumSmp,l_NumSmp,0)
	call savelu('SmpInt',j_SmpInt,i_SmpInt,l_SmpInt,0)
	call savelu('NumTrc',j_NumTrc,i_NumTrc,l_NumTrc,0)
	call savelu('NumRec',j_NumRec,i_NumRec,l_NumRec,0)
	call savelu('Format',j_Format,i_Format,l_Format,0)
	call savelu('MnLnIn',j_MnLnIn,i_MnLnIn,l_MnLnIn,0)
	call savelu('MxLnIn',j_MxLnIn,i_MxLnIn,l_MxLnIn,0)
	call savelu('MnDpIn',j_MnDpIn,i_MnDpIn,l_MnDpIn,0)
	call savelu('MxDpIn',j_MxDpIn,i_MxDpIn,l_MxDpIn,0)
	call savelu('JobNum',j_JobNum,i_JobNum,l_JobNum,0)
	call savelu('ReSpFm',j_ReSpFm,i_ReSpFm,l_ReSpFm,0)
C
C---- READ EVENT TAPE LINE HEADER...
      LENGTH = 0
 
          CALL RTAPE ( LUNEVT, NLH, LENGTH )
      IF (Length.EQ.0) THEN
         WRITE ( LUPRNT, 1901 )
 1901    FORMAT ( '0** M1901 **  ERROR DETECTED IN PROGRAM ST3D.', /,
     1       15X, 'EOF ENCOUNTERED WHEN ATTEMPTING TO READ INPUT ', /,
     2       15X, 'EVENT TAPE LINE HEADER.  EXECUTION TERMINATED.' )
         IER = 100
         GOTO 9999
      END IF
cmam...this was overlooked in the original port....
cmam...TJOB1 is passed to SOLTp1 but not used there....get rid of this
cmam  CALL MOVE ( 1, TJOB1, NLH(11), 8 )
      WRITE ( LUPRNT, 999 )
  999 FORMAT ( /, 46X, '*** MESSAGE FROM PROGRAM ST3D ***', /,
     *            45X, 'THE FOLLOWING IS THE INPUT EVENT TAPE', /,
     *            45X, '(NEVT) LINE HEADER TO PROGRAM ST3D.' )

cmam      call saver(NLH, 'NumSmp', nsamp, LINHED)
cmam      call saver(NLH, 'SmpInt', nsi  , LINHED)
cmam      call saver(NLH, 'NumTrc', ntrc1, LINHED)
cmam      call saver(NLH, 'NumRec', nrec1, LINHED)
cmam      call saver(NLH, 'Format', iform, LINHED)
cmam      call saver(NLH, 'MnLnIn', mnli1, LINHED)
cmam      call saver(NLH, 'MxLnIn', mxli1, LINHED)
cmam      call saver(NLH, 'MnDpIn', mndi1, LINHED)
cmam      call saver(NLH, 'MxDpIn', mxdi1, LINHED)
	call saver2(NLH,j_NumSmp,i_NumSmp,l_NumSmp,nsamp,0)
	call saver2(NLH,j_SmpInt,i_SmpInt,l_SmpInt,nsi,0)
	call saver2(NLH,j_NumTrc,i_NumTrc,l_NumTrc,ntrc1,0)
	call saver2(NLH,j_NumRec,i_NumRec,l_NumRec,nrec1,0)
	call saver2(NLH,j_Format,i_Format,l_Format,iform,0)
	call saver2(NLH,j_MnLnIn,i_MnLnIn,l_MnLnIn,mnli1,0)
	call saver2(NLH,j_MxLnIn,i_MxLnIn,l_MxLnIn,mxli1,0)
	call saver2(NLH,j_MnDpIn,i_MnDpIn,l_MnDpIn,mndi1,0)
	call saver2(NLH,j_MxDpIn,i_MxDpIn,l_MxDpIn,mxdi1,0)
	call saver2(NLH,j_ReSpFm,i_ReSpFm,l_ReSpFm,iunit,0)
          write(LERR,*)'Event tape # samples   = ',nsamp
          write(LERR,*)'Event tape # traces/rec= ',ntrc1
          write(LERR,*)'Event tape # recs      = ',nrec1
          write(LERR,*)'Event tape iform       = ',iform
          write(LERR,*)'Event tape mnlnin      = ',mnli1
          write(LERR,*)'Event tape mxlnin      = ',mxli1
          write(LERR,*)'Event tape mndiin      = ',mndi1
          write(LERR,*)'Event tape mxdiin      = ',mxdi1
          write(LERR,*)'Event tape unit val    = ',iunit
	xunit = float(iunit)
	xunit = 1./xunit
 
 	kbytes = lbytes
      CALL HLHPRT(ILH, LENGTH, SC3D, 4, IPRNTR) ! Cray
c	go to 9999
C***********************************************************************00004730
C*   READ 1ST3D, 2ST3D, AND 3ST3D DATA CARDS, PRINT CARD IMAGES,       *00004740
C* INTERPRET CARD PARAMETERS, CHECK FOR WRONG CARD IDENTIFIERS, CHECK  *00004750
C* FOR UNREASONABLE CARD PARAMETERS, AND DEFAULT MISSING CARD          *00004760
C* PARAMETERS.  IF NUMERR RETURNS AS 9999 THEN AND END OF FILE WAS     *00004770
C* ENCOUNTERED ON FIRST CARD INPUT READ.                               *00004780
C***********************************************************************00004790
                 ! *** Command Line Input *****************
	nd = 3
         call argi4 ('-minli',nsmli,1,1)
         call argi4 ('-maxli',nlrli,9999,9999)
         call argi4 ('-mindi',nsmdi,1,1)
         call argi4 ('-maxdi',nlrdi,9999,9999)
         call argi4 ('-minoff',nnrrng,0,0)
         call argi4 ('-maxoff',nfrrng,99999,99999)
         call argi4 ('-minaz',nazsm ,0, 0 )
         call argi4 ('-maxaz',nazlr ,180, 180 )
         call argi4 ('-wt', nupwfg ,0, 0 )
         call argi4 ('-mod', modefg,3, 3 )
         call argi4 ('-alt', nalpfg,1, 1 )
         call argi4 ('-niprior', npiter,3, 3 )
         call argi4 ('-nithru', mxloop,1, 1 )
         call argi4 ('-niafter', nfiter,5, 5 )
         call argr4 ('-pre', sigin ,1.0, 1.0 )
         call argi4 ('-prnt', nprtfg,1,1)
      nodsco = (argis('-disco') .gt. 0)
cmam		added to put out reject prints optionally
	verbos = (argis('-V') .gt. 0)
      SIG = SIGIN
	nmapsc = 1000
cmam......added -amp option.....10-26-95
        ampopt = (argis('-amp') .gt. 0)
cmam.....added code to make 2d data run thru 3d program..2-20-96
	x2d = (argis('-2d') .gt. 0)
	
C                                                                       00004960
C***********************************************************************00004970
C*   CHECK TO MAKE SURE THAT THE EVENT TAPE DIMENSION IS NOT LESS THAN *00004980
C* THE SOLUTION MODEL REQUESTED BY USER.                               *00004990
 
C***********************************************************************00005000
C                                                                       00005010
      IF ( ND .LT. MODEFG ) THEN
        WRITE ( 6, 1904 ) ND, MODEFG
 1904   FORMAT ( '0** M1904 **  ERROR DETECTED BY PROGRAM ST3D.', /
     1,     15X, 'EVENT TAPE IS ', I1, 'D, BUT THE SOLUTION MODEL '
     2,     15X, 'CHOSEN IS ', I1, 'D.  THE EVENT TAPE MUST BE EQUAL'
     3,     15X, ' TO OR GREATER IN DIMENSION THAN THE SOLUTION ', /
     4,     15X, 'MODEL.  EXECUTION TERMINATED.' )
        IER = 100
        GOTO 9999
      END IF
      IF ( NAZSM .LT. 0 ) THEN
        NAZSMA = NAZSM
        NAZLRA = NAZLR
        NAZSMB = NAZSMA + 180
        NAZLRB = NAZLRA + 180
      ELSE
        NAZSMA = NAZSM - 180
        NAZLRA = NAZLR - 180
        NAZSMB = NAZSM
        NAZLRB = NAZLR
      END IF
C                                                                       00005380
C                                                                       00005400
 
         IHDWRD = 2

C***********************************************************************00005410
C*  DEFINE PARAMETERS.                                                 *00005420
C***********************************************************************00005430
C                                                                       00005440
      RATIO = 3.14159265 / 180.0
      AZSMA = RATIO * NAZSMA
      AZLRA = RATIO * NAZLRA
      AZSMB = RATIO * NAZSMB
      AZLRB = RATIO * NAZLRB
C                                                                       00005610
c	read event tape for min and max sp, group. and di indexes.
c	limit event picks to live traces within constrained search
c	areas and print summary of results
cmam  CALL EVNSUM ( IX, NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB, AZLRB,
      CALL EVNSUM ( NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB, AZLRB,
     *   NSMLI, NLRLI, NSMDI, NLRDI, NNRRNG, NFRRNG, IER,idsk2,verbos,
     *	tempfile, xunit, x2d)
cmam *	tempfile, xunit)
cmam *	xunit)
cmam *    NSMLI, NLRLI, NSMDI, NLRDI, NNRRNG, NFRRNG, IER,idsk2 )
      IF ( IER .EQ. 100 ) GOTO 9999
C                                                                       00005650
C***********************************************************************00005660
C*   EDIT EVENT INPUT TAPE AND PUT IT TO DISK.                         *00005670
C***********************************************************************00005680
C                                                                       00005690
 
 1111 continue
cmam......here we will dynamically allocate the arrays xx,bb,bno,wa
	inokk = noli * nodi
	inosrk = nois + nojr
	if(modefg.eq.2) inosrk = inosrk + 2*inokk
	if(modefg.eq.3) inosrk = inosrk + 4*inokk
cmam.......round up the values for the vector allocations
	inokk = inokk / 1000
	inokk = inokk + 1
	inokk = inokk * 1000
	inosrk = inosrk / 1000
	inosrk = inosrk + 1
	inosrk = inosrk * 1000
      call galloc (memadr_XX, inosrk * SZSMPD, errcd, abort)
        if(errcd .ne. 0) go to 1112
        write(LER,*)'allocated XX space: ',inosrk
        write(LERR,*)'allocated XX space: ',inosrk
        ierrcd = ierrcd + 1
      call galloc (memadr_BB, inokk * SZSMPD, errcd, abort)
        if(errcd .ne. 0) go to 1112
        write(LER,*)'allocated BB space: ',inokk
        write(LERR,*)'allocated BB space: ',inokk
        ierrcd = ierrcd + 1
      call galloc (memadr_BNO, inokk * SZSMPD, errcd, abort)
        if(errcd .ne. 0) go to 1112
        write(LER,*)'allocated BNO space: ',inokk
        write(LERR,*)'allocated BNO space: ',inokk
        ierrcd = ierrcd + 1
      call galloc (memadr_WA, inokk * SZSMPD, errcd, abort)
        if(errcd .ne. 0) go to 1112
        write(LER,*)'allocated WA space: ',inokk
        write(LERR,*)'allocated WA space: ',inokk
        go to 1113
 1112	continue
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR occurred.'
         write(LERR,*)'Unable to allocate workspace for vectors:'
         write(LERR,*)'  Error occurred allocating vector ',ierrcd
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'FATAL ERROR occurred.'
         write(LER,*)'Unable to allocate workspace for vectors:'
         write(LER,*)'  Error occurred allocating vector ',ierrcd
         write(LER,*)' '
         go to 9999

 1113  continue


cmam  CALL EVNTDS ( IX, NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB, AZLRB,
      CALL EVNTDS ( NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB, AZLRB,
     *              NSMLI, NLRLI, NSMDI, NLRDI, NNRRNG, NFRRNG,
     *              BB, BNO,idsk2,xunit)
C                                                                       00005730
      CALL ALPKSW ( XX, BB, BNO, WA, NFITER, NPITER, MXLOOP,x2d )
cmam  CALL ALPKSW ( XX, BB, BNO, WA, NFITER, NPITER, MXLOOP )
C                                                                       00005880
C***********************************************************************00005890
C*   PRINT SOLUTION VECTORS, IF REQUESTED.                             *00005900
C***********************************************************************00005910
C                                                                       00005920
      IF ( NPRTFG .EQ. 1 ) CALL PRNSOL ( XX )
C                                                                       00005940
C***********************************************************************00005950
C*   PRINT AND, IF REQUESTED, PUNCH 8STAT AND 9CORR CARDS.             *00005960
C***********************************************************************00005970
C                                                                       00005980
cmam....added amplitude option.....10-26-95
      CALL PUNCRD ( XX, nodsco, outfil, ampopt )
cmam  CALL PUNCRD ( XX, nodsco, outfil )
C                                                                       00006000
C***********************************************************************00006010
C*   WRITE BIN-ORIENTED SOLUTION ARRAYS TO OUTPUT DATA TAPE, IF        *00006020
C* REQUESTED.                                                          *00006030
C***********************************************************************00006040
C                                                                       00006050
      WRITE ( IOTHLH(13:14), 1000 ) MODEFG
 1000 FORMAT (I2)
cmam....TJOB1 is not used inside this subroutine...get rid of it
      IF ( NSLAFG .EQ. 1 ) CALL SOLTp1 ( NLH, XX, nX, IOTHLH)
cmam  IF ( NSLAFG .EQ. 1 ) CALL SOLTp1 ( ILH, NLH, TJOB1, XX, IX,
cmam *		IOTHLH)
 
C                                                                       00006100
 9999 CONTINUE
2750	continue
	write(LERR,*)'program sc3d finished'
      CALL CCEXIT ( IER )
	end
	SUBROUTINE HELP()
#include <f77/iounit.h>
 
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'sc3d - compute statics from picks on 3-D data'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'Usage: sc3d -N[events] -O[output] [  -T[time slices] '
      WRITE (LER,*)
     *'       -S[temporary filespace]'
      WRITE (LER,*)
C                                                                       00006100
     *'       -minli[nsmli] -maxli[nlrli] -mindi[nsmdi] -maxdi[nlrdi]'
      WRITE (LER,*)
     *'       -minoff[nnrrng] -maxoff[nfrrng] -minaz[nazsm]'
      WRITE (LER,*)
     *'       -maxaz[nazlr] -wt[mupwfg] -mod[modefg] -alt[nalpfg]'
      WRITE (LER,*)
     *'       -niprior[npiter] -nithru[mxloop] -niafter[nfiter]'
      WRITE (LER,*)
     *'       -pre[sigin] -prnt[nprtfg] -disco -amp -V ]'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'-N   : Input events file created by pick. Default is stdin.'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'-O   : Output flatfile of card images.  Default is stdout.'
cmam *'-O   : Output 8STAT/9CORR card file. Default is stdout.'
      WRITE (LER,*)
     *'       If -amp is specified, this file will contain logs of'
      WRITE (LER,*)
     *'      amplitude scalar values.  Default is to output statics'
      WRITE (LER,*)
     *'      as 8STAT/9CORR card images.'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'-T   : Output time slices (bin-oriented solution arrays)'
      WRITE (LER,*)
     *'       NOTE: this output is OPTIONAL'
cmam....option added by garossino to specify location of temp files
      WRITE (LER,*)
     *'-S   : Tempory filespace (default is /var/tmp/scratch??)'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *' '
cmam
      WRITE (LER,*)
     *'       Command Line Input                            (default)'
      WRITE (LER,*)
     *' '
      WRITE (LER,*)
     *'-minli    - minimum LI                                     (1)'
      WRITE (LER,*)
     *'-maxli    - maximum LI                                  (9999)'
      WRITE (LER,*)
     *'-mindi    - minimum DI                                     (1)'
      WRITE (LER,*)
     *'-maxdi    - maximum DI                                  (9999)'
      WRITE (LER,*)
     *'-minoff   - minimum offset                                 (0)'
      WRITE (LER,*)
     *'-maxoff   - maximum offset                             (99999)'
      WRITE (LER,*)
     *'-minaz    - minimum azimuth                                (0)'
      WRITE (LER,*)
     *'-maxaz    - maximum azimuth                              (180)'
      WRITE (LER,*)
     *'-wt       - weighted solution:  0 = yes;  1 = no           (0)'
      WRITE (LER,*)
     *'-mod      - mode of solution:                              (3)'
      WRITE (LER,*)
     *'                    (1 -- I + R = T)                          '
      WRITE (LER,*)
     *'                    (2 -- I + R + C + M = T)                  '
      WRITE (LER,*)
     *'                    (3 -- I + R + C + M + E + F = T)          '
      WRITE (LER,*)
     *'-alt     - alternate pick substitution flag:0=yes,1=no     (1)'
      WRITE (LER,*)
     *'-niprior - iterations prior to alternate picks             (3)'
      WRITE (LER,*)
     *'-nithru  - iterations through alternate picks              (1)'
      WRITE (LER,*)
     *'-niafter - iterations after alternate picks                (5)'
      WRITE (LER,*)
     *'-pre     - percent for prewhitening of main diagonal     (1.0)'
      WRITE (LER,*)
     *'-prnt    -  print solution vectors? 0=no,1=yes             (1)'
      WRITE (LER,*)
     *'-disco   -  flag to print and write a file containing disco   '
      WRITE (LER,*)
     *'            card images SHT-STAT/REC-STAT.  The output file   '
      WRITE (LER,*)
     *'            will be named <otap>.disco.  If this flag is      '
      WRITE (LER,*)
     *'            omitted, no disco-format statics will be output.  '
      WRITE (LER,*)
     *'-amp     -  flag to read event tape as amplitude scalar'
      WRITE (LER,*)
     *'            values, and the output files will contain the log'
      WRITE (LER,*)
     *'            values of amplitude scalars to be applied in rest'
      WRITE (LER,*)
     *'            using the -A option.  The event tape input must'
      WRITE (LER,*)
     *'            have been created by picker using the -amp option.'
cmam......added 3-26-96
      WRITE (LER,*)
     :'-2d      - flag to use with -amp option when data is 2d.  This'
      WRITE (LER,*)
     :'           causes the program to use di-gi for the pri index.'
      WRITE (LER,*)
     :'           If mode=2, it computes t=i+r+c only.  It also uses'
      WRITE (LER,*)
     :'           absolute value of DstSgn instead of DstUsg.'
cmam........
      WRITE (LER,*)
     *'-V       - flag for verbose output of rejected ri/tr info     '
      WRITE (LER,*)
     *'           default is not to output the reject information    '
      STOP
      END
C***********************************************************************00025420
C***********************************************************************00025430
C***********************************************************************00025440
C***********************************************************************00025450
C***********************************************************************00025460
cmam  SUBROUTINE EVNSUM ( IX, NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB,    00025470
      SUBROUTINE EVNSUM ( NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB,
     *                    AZLRB, NSMLI, NLRLI, NSMDI, NLRDI, NNRRNG,    00025480
cmam *                    NFRRNG, IER,idsk2, verbos, tempfile, xunit ) 
     *                    NFRRNG, IER,idsk2, verbos, tempfile, xunit,
     *			  x2d ) 
cmam *                    NFRRNG, IER,idsk2, verbos, xunit ) 
cmam *                    NFRRNG, IER,idsk2 ) 
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00025500
C***********************************************************************00025510
C                                                                      *00025520
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00025550
C***********************************************************************00025560
C  ROUTINE:       EVNSUM                                                00025570
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00025580
C  PURPOSE:                                                             00025590
C      READ ALL EVENTS ON THE EVENT TAPE AND SET VALUES IN THE COMMON   00025600
C      BLOCKS AND PRINT OUT A SUMMARY OF THE EVENT TAPE.                00025610
C  CALLING PARAMETERS: SUBROUTINE EVNSUM ( IX, NX, NREC1, NTRC1, AZSMA, 00025620
C                                          AZLRA, AZSMB, AZLRB, NSMLI,  00025630
C                                          NLRLI, NSMDI, NLRDI, NNRRNG, 00025640
C                                          NFRRNG, IER )                00025650
C  ARGUMENTS:                                                           00025660
C      NAME                        DESCRIPTION                          00025670
C      IX      I*2      PASSED     ARRAY USED TO READ EVENT TAPE TRACES.00025680
C      NX      I*4      PASSED     ARRAY EQUIVALENCE TO IX.             00025690
C      NREC1   I*4      PASSED     NUMBER OF RECORDS ON EVENT TAPE.     00025700
C      NTRC1   I*4      PASSED     NUMBER OF TRACES PER RECORD.         00025710
C      AZSMA   R*4      PASSED     SMALL ASZMITH A                      00025720
C      AZLRA   R*4      PASSED     LARGE ASZMITH A                      00025730
C      AZSMB   R*4      PASSED     SMALL ASZMITH B                      00025740
C      AZLRB   R*4      PASSED     LARGE ASZMITH B                      00025750
C      NSMLI   I*4      PASSED     LINE INDEX MINIMUM                   00025760
C      NLRLI   I*4      PASSED     LINE INDEX MAXIMUM                   00025770
C      NSMDI   I*4      PASSED     DEPTH INDEX MINIMUM                  00025780
C      NLRDI   I*4      PASSED     DEPTH INDEX MAXIMUM                  00025790
C      NNRRGN  I*4      PASSED     RANGE MINIMUM                        00025800
C      NFRRNG  I*4      PASSED     RANGE MAXIMUM                        00025810
C      IER     I*4      RETURNED   ERROR FLAG.                          00025820
C                                   = 0 - NO ERRORS                     00025830
C                                   > 0 - ERRORS                        00025840
C  CATEGORY:  SPECIFIC                                                  00025850
C       +------------------------------------------------------+        00025860
C       |               DEVELOPMENT INFORMATION                |        00025870
C       +------------------------------------------------------+        00025880
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 16, 1987              00025890
C  LANGUAGE:  FORTRAN 77                                                00025900
C       +------------------------------------------------------+        00025910
C       |                 EXTERNAL ENVIRONMENT                 |        00025920
C       +------------------------------------------------------+        00025930
C  EXTERNAL REFERENCES:                                                 00025940
C      READ EVENT TAPE FROM LOGICAL UNIT LUNEVT.                        00025950
C  ROUTINES CALLED:                                                     00025960
C      RTAPE    -    READ EVENTS FROM EVENT TAPE.                       00025970
C  COMMON:                                                              00025980
C      FILCON  (  * )  PARAMETERS FOR TWO TEMPORARY DISK AREAS SET BY   00025990
C                      MAIN PROGRAM.                                    00026000
C                        NWPEA  - NO. OF WORDS PER EVENT IN DISK A      00026010
C                        NEPBA  - NO. OF EVENTS PER BLOCK IN DISK A     00026020
C                        NWPBA  - NO. OF WORDS PER BLOCK IN DISK A      00026030
C                        NBPBA  - NO. OF BYTES PER BLOCK IN DISK A      00026040
C                        NBLKSA - NO. OF BLOCKS IN DISK A               00026050
C                        NEVNTS - NO. OF ACCEPTABLE EVENTS IN DISK A    00026060
C                        NWPCB  - NO. OF WORDS PER COORDINATE IN DISK B 00026070
C                        NCPBB  - NO. OF COORDINATES PER BLOCK IN DISK B00026080
C                        NWPBB  - NO. OF WORDS PER BLOCK IN DISK B      00026090
C                        NBPBB  - NO. OF BYTES PER BLOCK IN DISK B      00026100
C                        NBLKSB - NO. OF BLOCKS IN DISK B               00026110
C                        NCORDS - NO. OF COORDINATES IN DISK B          00026120
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00026130
C                      BY MAIN PROGRAM.                                 00026140
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00026150
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00026160
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00026170
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00026180
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00026190
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00026200
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00026210
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00026220
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00026230
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00026240
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00026250
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00026260
C      PLTMAP  (  * )  PARAMETERS FOR PLOT OF ERROR DISTRIBUTION AND    00026270
C                      STATICS MAPS SET BY MAIN PROGRAM.                00026280
C                        NAMEPR - PROGRAM NAME                          00026290
C                        NTITLE - 20-BYTE ARRAY FOR PLOT TITLE          00026300
C                        CARDA  - 80-CHAR ARRAY FOR 1ST3D CARD IMAGE    00026310
C                        CARDB  - 80-CHAR ARRAY FOR 2ST3D CARD IMAGE    00026320
C                        CARDC  - 80-CHAR ARRAY FOR 3ST3D CARD IMAGE    00026330
C                        NHSCAL - HORIZONTAL SCALE OF ERROR DISTR. PLOT 00026340
C                        NHIGHT - HEIGHT OF ERROR DISTRIBUTION PLOT     00026350
C                        NMAPSC - SCALE OF STATICS MAPS                 00026360
C                        NCNTIN - CONTOUR INTERVAL FOR AMOCO I          00026370
C                                     CONTOURING FILE                   00026380
C                        NXSHFT - X-COMPONENT OF ORIGIN SHIFT FOR       00026390
C                                     STATICS COORDINATES               00026400
C                        NYSHFT - Y-COMPONENT OF ORIGIN SHIFT FOR       00026410
C                                     STATICS COORDINATES               00026420
C                        NDVICE - HARDWARE DEVICE NAME FOR PLOT         00026430
C                        NSETUP - SETUP CODE FOR PLOT                   00026440
C                        CTPRTY - 2-CHARACTER PLOT TAPE TP PRIORITY     00026450
C                        IJBNAM - 8-CHARACTER FOR JOBNAME               00026460
C                        IDSNAM - 22-CHARACTER FOR EVENT TAPE DSNAME    00026470
C                        IVOLSR - 6-CHARACTER FOR EVENT TAPE VOLSER     00026480
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00026490
C                      SET BY MAIN PROGRAM.                             00026500
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00026510
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00026520
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00026530
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00026540
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00026550
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00026560
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00026570
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00026580
C                        NOKK   - NO. OF BINS                           00026590
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00026600
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00026610
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00026620
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00026630
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00026640
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00026650
C                        MNLI   - MINIMUM LINE (LI) INDEX               00026660
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00026670
C                        NOLI   - NO. OF LINE (LI) INDEXES              00026680
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00026690
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00026700
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00026710
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00026720
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00026730
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00026740
C                                     (0=YES, 1=NO)                     00026750
C                        MODEFG - MODE OF SOLUTION FLAG                 00026760
C                                     (1  --  I + R = T                )00026770
C                                     (2  --  I + R + C + M = T        )00026780
C                                     (3  --  I + R + C + M + E + F = T)00026790
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00026800
C                                     (0=YES, 1=NO)                     00026810
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00026820
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00026830
C                                     ALL RNMO TERMS                    00026840
C      STAFL3  (  * )  ARRAYS FOR DATA FROM EVENT TAPE.                 00026850
C                        TIJ    - ARRAY FOR PRIMARY PICKS               00026860
C                        TIJM   - ARRAY FOR ALTERNATE PICK (LT PRIMARY) 00026870
C                        TIJX   - ARRAY FOR ALTERNATE PICK (GT PRIMARY) 00026880
C                        COR    - ARRAY FOR SQUARE OF WEIGHTS           00026890
C                        CORM   - ARRAY FOR SQ. OF ALT. WEIGHT (LT PRI.)00026900
C                        CORX   - ARRAY FOR SQ. OF ALT. WEIGHT (GT PRI.)00026910
C                        ISPOS  - ARRAY FOR SOURCEPOINT (PRI) POINTERS  00026920
C                        JRPOS  - ARRAY FOR GROUP (GI) POINTERS         00026930
C                        KKPOS  - ARRAY FOR BIN POINTERS                00026940
C                        XOF    - ARRAY FOR SQUARE OF OFFSETS           00026950
C                        XOFSIN - ARRAY FOR (XOF**2)*SIN(AZIMUTH)       00026960
C                        XOFCOS - ARRAY FOR (XOF**2)*COS(AZIMUTH)       00026970
C                                                                       00026980
C  ERROR RETURNS:  SEE ARGUEMENT DESCRIPTION FOR IER.                   00026990
C                                                                       00027000
C*******************   END OF DOCUMENTATION PACKAGE   ******************00027010
C***********************************************************************00027020
C                                                                       00027030
C                                                                       00027040
C                                                                       00027050
cmam		verbos=T to optionally output reject information
	logical verbos
cmam....code to make 2d data work in 3d program...2-20-96
	logical x2d
cmam  INTEGER*2  IX(*)                                                  00027060
	real hold(6)
C                                                                       00027070
      INTEGER*4  NX(*)                                                  00027080
C                                                                       00027090
      CHARACTER   IJBNAM*8, IDSNAM*22, IVOLSR*6,  CTPRTY*2,  CARDA*80,  00027100
     *            CARDB*80, CARDC*80,  NTITLE*20, NAMEPR*4,
     *            NDVICE*4, NSETUP*4, tempfile*(*)
cmam *            NDVICE*4, NSETUP*4                                    00027120
C                                                                       00027130
      COMMON/FILCON/NWPEA,NEPBA,NWPBA,NBPBA,NBLKSA,NEVNTS,              00027140
     *              NWPCB,NCPBB,NWPBB,NBPBB,NBLKSB,NCORDS               00027150
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,luprnt,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00027170
      COMMON/PLTMAP/NAMEPR,NTITLE,CARDA,CARDB,CARDC,NHSCAL,NHIGHT,      00027180
     *              NMAPSC,NCNTIN,NXSHFT,NYSHFT,NDVICE,NSETUP,CTPRTY,   00027190
     *              IJBNAM,IDSNAM,IVOLSR                                00027200
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00027210
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00027220
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00027230
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00027240
      COMMON/STAFL3/TIJ(680),TIJM(680),TIJX(680),COR(680),CORM(680),    00027250
     *              CORX(680),ISPOS(680),JRPOS(680),KKPOS(680),XOF(680),00027260
     *              XOFSIN(680),XOFCOS(680)                             00027270
	common/hedrs/j_RecNum,i_RecNum,l_RecNum,
     *		     j_TrcNum,i_TrcNum,l_TrcNum,
     *		     j_NumTrc,i_NumTrc,l_NumTrc,
     *		     j_NumRec,i_NumRec,l_NumRec,
     *		     j_SmpInt,i_SmpInt,l_SmpInt,
     *		     j_NumSmp,i_NumSmp,l_NumSmp,
     *		     j_Format,i_Format,l_Format
C                                                                       00027280
      DATA IREAD / 0 /                                                  00027290
C                                                                       00027300
C***********************************************************************00027310
C*   INITIALIZE VALUES BEFORE LOOP TO READ EVENTS AND TO CALCULATE     *00027320
C* MINIMUM AND MAXIMUM VALUES ON TAPE AFTER EDITTING.                  *00027330
C***********************************************************************00027340
C                                                                       00027350
      IER = 0                                                           00027360
      MINIST = 1000000000                                               00027370
      MINJRT = MINIST                                                   00027380
      MINLIT = MINIST                                                   00027390
      MINDIT = MINIST                                                   00027400
      MAXIST = 0                                                        00027410
      MAXJRT = 0                                                        00027420
      MAXLIT = 0                                                        00027430
      MAXDIT = 0                                                        00027440
      MINIS = MINIST                                                    00027450
      MINJR = MINIST                                                    00027460
      MNLI = MINIST                                                     00027470
      MNDI = MINIST                                                     00027480
      MAXIS = 0                                                         00027490
      MAXJR = 0                                                         00027500
      MXLI = 0                                                          00027510
      MXDI = 0                                                          00027520
      NXMIN = 999999999                                                 00027530
      NYMIN = 999999999                                                 00027540
      NLIFLG = 0                                                        00027550
      NAZFLG = 0                                                        00027560
      NEVNTL = 0                                                        00027570
      NEVNTS = 0                                                        00027580
      NREADS = NREC1 * NTRC1                                            00027590
C                                                                       00027600
C***********************************************************************00027610
C*  FIND THE MINIMUM AND MAXIMUM VALUES FOR VARIABLES THAT ARE IN THE  *00027620
C* COMMON BLOCKS AND FOR PRINTING SUMMARY OF THE EVENT TAPE TO THE     *00027630
C* PRINTER.                                                            *00027640
C***********************************************************************00027650
C                                                                       00027660
	idsk2 = 77
cmam	open(unit = idsk2,form = 'formatted',

cmam......option to specify location of temp files
        if ( tempfile .ne. ' ' ) then
           length = lenth(tempfile)
           open(unit = idsk2,file=tempfile(1:length),
     :          form = 'unformatted',
     *          status = 'scratch', access = 'sequential',
     *          iostat = ierr2)
        else
	   open(unit = idsk2,form = 'unformatted',
     *		status = 'scratch', access = 'sequential',
     *		iostat = ierr2)
	endif

	if(ierr2.gt.0) then
	  write(LERR,*)'FATAL ERROR opening temporary disk2'
	  stop 999
	endif
      IBYTES = 0                                                        00027670
      CALL RTAPE ( LUNEVT, NX, IBYTES )
cmam  CALL RTAPE ( LUNEVT, IX, IBYTES )                                 00027680
C                                                                       00027690
cmam..new version of picker writes a format 3 dataset, so we do not
cmam........need to check for this crazy format 5 stuff anymore.......
cmam..  ival = sztrhd + 50*szsmpd
cmam  ival = sztrhd + 50*szhfwd
cmam..  if (ibytes .ne. ival) then
cmam..  IER = 100                                                       00027710
        IF ( IBYTES .EQ. 0 ) THEN                                       00027720
          WRITE ( LUPRNT, 1000 )                                        00027730
 1000     FORMAT ( '0** M1000 **  ERROR DETECTED BY SUBROUTINE ',       00027740
     1             'EVNSUM.', /,                                        00027750
     2        15X, 'END OF FILE WAS READ ON THE FIRST ATTEMPTED READ ', 00027760
     3             'ON THE EVENT TAPE.' )                               00027770
          GOTO 9999                                                     00027780
        END IF                                                          00027790
	call savelu('StaCor',j_StaCor,i_StaCor,l_StaCor,1)
	call savelu('RecNum',j_RecNum,i_RecNum,l_RecNum,1)
	call savelu('TrcNum',j_TrcNum,i_TrcNum,l_TrcNum,1)
	call savelu('PrRcNm',j_PrRcNm,i_PrRcNm,l_PrRcNm,1)
	call savelu('RecInd',j_RecInd,i_RecInd,l_RecInd,1)
	call savelu('DphInd',j_DphInd,i_DphInd,l_DphInd,1)
	call savelu('DstUsg',j_DstUsg,i_DstUsg,l_DstUsg,1)
	call savelu('DstSgn',j_DstSgn,i_DstSgn,l_DstSgn,1)
	call savelu('SrRcAz',j_SrRcAz,i_SrRcAz,l_SrRcAz,1)
	call savelu('SrPtXC',j_SrPtXC,i_SrPtXC,l_SrPtXC,1)
	call savelu('SrPtYC',j_SrPtYC,i_SrPtYC,l_SrPtYC,1)
	call savelu('RcPtXC',j_RcPtXC,i_RcPtXC,l_RcPtXC,1)
	call savelu('RcPtYC',j_RcPtYC,i_RcPtYC,l_RcPtYC,1)
c......................................
c   patch made by dew May 9, 1994
cmam..	if (ibytes .eq. ival) go to 100
cmam	if (ibytes .eq. 356) go to 100
c......................................
cmam..  WRITE ( LUPRNT, 1001 ) IBYTES                                   00027800
cmam    WRITE ( LUPRTN, 1001 ) IBYTES                                   00027800
 1001   FORMAT ( '0** M1001 **  ERROR DETECTED IN SUBROUTINE EVNSUM.',  00027810
     1   /, 15X, 'ALL EVENT TRACES MUST BE 356 BYTES LONG, BUT THE',    00027820
     2   /, 15X, 'FIRST TRACE WAS ONLY ', I5, ' BYTES LONG.  ',         00027830
     3           'EXECUTION TERMINATED.' )                              00027840
cmam..  GOTO 9999                                                       00027850
cmam..END IF                                                            00027860
C                                                                       00027870
  100 CONTINUE                                                          00027880
C                                                                       00027890
        IREAD = IREAD + 1                                               00027900
C                                                                       00027910
cmam	call saver(ix,'StaCor',istcor,1)
          NEVNTL = NEVNTL + 1                                           00027930
cmam	call saver(ix,'RecNum',ixri,1)
cmam	call saver(ix,'TrcNum',ixtr,1)
cmam............
cmam	call saver(ix,'PrRcNm',ntmpis,1)
cmam	call saver(ix,'RecInd',ntmpjr,1)
cmam	call saver(ix,'LinInd',ntmpli,1)
cmam	call saver(ix,'DphInd',ntmpdi,1)
cmam	call saver(ix,'DstUsg',ntmpx,1)
cmam	call saver(ix,'SrRcAz',iazmth,1)
cmam	call saver(nx,'SrPtXC',nx12,1)
cmam	call saver(nx,'SrPtYC',nx13,1)
cmam	call saver(nx,'RcPtXC',nx14,1)
cmam	call saver(nx,'RcPtYC',nx15,1)
	call saver2(nx,j_StaCor,i_StaCor,l_StaCor,istcor,1)
	call saver2(nx,j_RecNum,i_RecNum,l_RecNum,ixri,1)
	call saver2(nx,j_TrcNum,i_TrcNum,l_TrcNum,ixtr,1)
	call saver2(nx,j_PrRcNm,i_PrRcNm,l_PrRcNm,ntmpis,1)
	call saver2(nx,j_RecInd,i_RecInd,l_RecInd,ntmpjr,1)
	call saver2(nx,j_LinInd,i_LinInd,l_LinInd,ntmpli,1)
	call saver2(nx,j_DphInd,i_DphInd,l_DphInd,ntmpdi,1)
	call saver2(nx,j_DstUsg,i_DstUsg,l_DstUsg,ntmpx,1)
	call saver2(nx,j_SrRcAz,i_SrRcAz,l_SrRcAz,iazmth,1)
	call saver2(nx,j_SrPtXC,i_SrPtXC,l_SrPtXC,nx12,1)
	call saver2(nx,j_SrPtYC,i_SrPtYC,l_SrPtYC,nx13,1)
	call saver2(nx,j_RcPtXC,i_RcPtXC,l_RcPtXC,nx14,1)
	call saver2(nx,j_RcPtYC,i_RcPtYC,l_RcPtYC,nx15,1)

cmam.....code to make 2d data work in 3d program...2-20-96
	if(x2d) then
	  ntmpis = ntmpdi - ntmpjr
	  ntmpli = 1
        call saver2(nx,j_DstSgn,i_DstSgn,l_DstSgn,ntmpxx,1)
 	ntmpx = iabs(ntmpxx)
	endif

cmam	ix129 = ix(129)
cmam	ix130 = ix(130)
cmam	ix131 = ix(131)
cmam	ix132 = ix(132)
cmam	ix133 = ix(133)
cmam	ix134 = ix(134)
cmam......new version of picker output a format 3 event dataset...
cmam....vmov uses NUMBER of ELEMENTS, not NUMBER of BYTES!!
	call vmov (nx(ITHWP1),1,hold(1),1,6)
cmam....call vmov (nx(ITHWP1),1,hold(1),1,6*szsmpd)
cmam;;;;;;new picker multiplies by a unit -- see ReSpFm in lh
	x129 = hold(1) * xunit
	x130 = hold(2) * xunit
	x131 = hold(3) * xunit
	x132 = hold(4) * xunit
	x133 = hold(5) * xunit
	x134 = hold(6) * xunit
cmam	write(idsk2,1070)ntmpis,ntmpjr,ntmpli,ntmpdi,ntmpx,iazmth,
	write(idsk2)ntmpis,ntmpjr,ntmpli,ntmpdi,ntmpx,iazmth,
     *      istcor,nx12,nx13,nx14,nx15,
     *	     x129, x130, x131, x132, x133, x134
cmam *	    ix129,ix130,ix131,ix132,ix133,ix134
 1070	format(17i10)
cmam;;;;if(istcor.ne.30000. and. x129.ne. -10000) then
        if(istcor.ne.30000. and. x129.ne. (-10000.*xunit)) then
cmam....if(istcor.ne.30000. and. ix129.ne. -10000) then
          IF ( NTMPLI .NE. 0 ) NLIFLG = 1                               00027990
	  if (iazmth .ne. 0 ) nazflg = 1
          IF ( NTMPIS .LT. MINIST ) MINIST = NTMPIS                     00028010
          IF ( NTMPIS .GT. MAXIST ) MAXIST = NTMPIS                     00028020
          IF ( NTMPJR .LT. MINJRT ) MINJRT = NTMPJR                     00028030
          IF ( NTMPJR .GT. MAXJRT ) MAXJRT = NTMPJR                     00028040
          IF ( NTMPLI .LT. MINLIT ) MINLIT = NTMPLI                     00028050
          IF ( NTMPLI .GT. MAXLIT ) MAXLIT = NTMPLI                     00028060
          IF ( NTMPDI .LT. MINDIT ) MINDIT = NTMPDI                     00028070
          IF ( NTMPDI .GT. MAXDIT ) MAXDIT = NTMPDI                     00028080
C                                                                       00028090
          IF ( NTMPLI .GE. NSMLI  .AND.                                 00028100
     1         NTMPLI .LE. NLRLI  .AND.                                 00028110
     2         NTMPDI .GE. NSMDI  .AND.                                 00028120
     3         NTMPDI .LE. NLRDI  .AND.                                 00028130
     4         NTMPX  .GE. NNRRNG .AND.                                 00028140
     5         NTMPX  .LE. NFRRNG ) THEN                                00028150
            AZIM = iazmth * 0.0001                                      00028160
C                                                                       00028170
            IF ( ( AZIM .GE. AZSMA .AND. AZIM .LE. AZLRB ) .AND.        00028180
     1           ( AZIM .LE. AZLRA .OR.  AZIM .GE. AZSMB ) ) THEN       00028190
              NEVNTS = NEVNTS + 1                                       00028200
              IF ( NTMPIS .LT. MINIS ) MINIS = NTMPIS                   00028210
              IF ( NTMPIS .GT. MAXIS ) MAXIS = NTMPIS                   00028220
              IF ( NTMPJR .LT. MINJR ) MINJR = NTMPJR                   00028230
              IF ( NTMPJR .GT. MAXJR ) MAXJR = NTMPJR                   00028240
              IF ( NTMPLI .LT. MNLI ) MNLI = NTMPLI                     00028250
              IF ( NTMPLI .GT. MXLI ) MXLI = NTMPLI                     00028260
              IF ( NTMPDI .LT. MNDI ) MNDI = NTMPDI                     00028270
              IF ( NTMPDI .GT. MXDI ) MXDI = NTMPDI                     00028280
cmam....these slipped through on the original conversion
cmam          IF ( NX(12) .LT. NXMIN ) NXMIN = NX(12)                   00028290
cmam          IF ( NX(14) .LT. NXMIN ) NXMIN = NX(14)                   00028300
cmam          IF ( NX(13) .LT. NYMIN ) NYMIN = NX(13)                   00028310
cmam          IF ( NX(15) .LT. NYMIN ) NYMIN = NX(15)                   00028320
              IF ( NX12 .LT. NXMIN ) NXMIN = NX12
              IF ( NX14 .LT. NXMIN ) NXMIN = NX14
              IF ( NX13 .LT. NYMIN ) NYMIN = NX13
              IF ( NX15 .LT. NYMIN ) NYMIN = NX15
	    else
cmam		reject print out optional
		if(verbos)
     *		write(LERR,*)'2:reject ri,tr:',ixri,ixtr,ntmpis,ntmpjr,
     *		ntmpli,ntmpdi,iazmth
            END IF                                                      00028330
          else
cmam		reject print out optional
		if(verbos)
     *		write(LERR,*)'1:reject ri,tr:',ixri,ixtr,ntmpis,ntmpjr,
     *		ntmpli,ntmpdi,iazmth
          END IF                                                        00028340
        else
cmam		reject print out optional
		if(verbos)
     *		write(LERR,*)'reject ri,tr:',ixri,ixtr,istcor,x129
cmam *		write(LERR,*)'reject ri,tr:',ixri,ixtr,istcor,ix129
        END IF                                                          00028350
C                                                                       00028360
        IBYTES = 0                                                      00028370
        CALL RTAPE ( LUNEVT, nX, IBYTES )                               00028380
cmam    CALL RTAPE ( LUNEVT, IX, IBYTES )                               00028380
      IF ( IBYTES .GT. 0 ) GOTO 100                                     00028390
C                                                                       00028400
      IF ( IREAD .NE. NREADS ) THEN                                     00028410
        WRITE ( LUPRNT, 1002 ) NREADS, IREAD                            00028420
 1002   FORMAT ( '0** M1002 **  WARNING IN SUBROUTINE EVNSUM.', /,      00028430
     *      15X, 'ACCORDING TO LINE HEADER THERE SHOULD BE ', I9,       00028440
     *           ' EVENTS ON EVENT TAPE BUT,', /,                       00028450
     *      15X, 'THERE WERE ACTUALLY ', I9, ' EVENTS ON EVENT TAPE.' ) 00028460
      END IF                                                            00028470
C                                                                       00028480
C***********************************************************************00028490
C*  CHECK TO SEE IF THIS EVENT TAPE CAN BE RUN WITH THESE INPUT        *00028500
C* PARAMETERS.  IF THEY CAN THEN INITIALIZE THE REST OF THE COMMON     *00028510
C* BLOCKS AND PRINT SUMMARY OF EVENT TAPE.                             *00028520
C***********************************************************************00028530
C                                                                       00028540
      IF ( MODEFG .EQ. 3 ) THEN                                         00028550
        IF ( NLIFLG .EQ. 0 ) THEN                                       00028560
          WRITE ( LUPRNT, 1003 )                                        00028570
 1003     FORMAT ( '0** M1003 **  ERROR DETECTED BY SUBROUTINE EVNSUM.',00028580
     1     /, 15X, 'ALL LIVE EVENTS ON INPUT EVENT TAPE HAVE ZERO LINE',00028590
     *             ' INDEX--EXECUTION TERMINATED')                      00028600
          IER = 100                                                     00028610
          GOTO 9999                                                     00028620
        END IF                                                          00028630
C                                                                       00028640
        IF ( NAZFLG .EQ. 0 ) THEN                                       00028650
          WRITE ( LUPRNT, 1004 ) MODEFG                                 00028660
 1004     FORMAT ( '0** M1004 **  ERROR DETECTED BY SUBROUTINE EVNSUM.',00028670
     1     /, 15X, 'MODE OF SOLUTION FLAG = ',I1,' BUT ALL EVENTS HAVE',00028680
     *            ' ZERO AZIMUTH--EXECUTION TERMINATED')                00028690
          IER = 100                                                     00028700
          GOTO 9999                                                     00028710
        END IF                                                          00028720
      END IF                                                            00028730
C                                                                       00028740
      NOIST = MAXIST - MINIST + 1                                       00028750
      NOJRT = MAXJRT - MINJRT + 1                                       00028760
      NOLIT = MAXLIT - MINLIT + 1                                       00028770
      NODIT = MAXDIT - MINDIT + 1                                       00028780
      NOBINT = NOLIT * NODIT                                            00028790
      NOIS = MAXIS - MINIS + 1                                          00028800
      NOJR = MAXJR - MINJR + 1                                          00028810
      NOLI = MXLI - MNLI + 1                                            00028820
      NODI = MXDI - MNDI + 1                                            00028830
      NOBIN = NOLI * NODI                                               00028840
      NOKK = NOBIN                                                      00028850
C                                                                       00028860
      WRITE ( LUPRNT, 1005 ) MINIST, MINIS, MAXIST, MAXIS, NOIST, NOIS  00028870
 1005 FORMAT ( ///, '0',                                                00028880
     *    24X, '  SUMMARY OF EVENT (NEVT) TAPE     BEFORE      AFTER',  00028890
     * /, 25X, '        TRACE INFORMATION:         EDITING     EDITING',00028900
     * /, 25X, '---------------------------------- -------     -------',00028910
     * /, 25X, 'MINIMUM SOURCEPOINT (PRI) INDEX . ',  I8, '   ', I9, /, 00028920
     *    25X, 'MAXIMUM SOURCEPOINT (PRI) INDEX . ',  I8, '   ', I9, /, 00028930
     *    25X, 'NO. OF SOURCEPOINT (PRI) INDEXES. ',  I8, '   ', I9   ) 00028940
      WRITE ( LUPRNT, 1006 ) MINJRT, MINJR, MAXJRT, MAXJR, NOJRT, NOJR, 00028950
     *                       MINLIT, MNLI, MAXLIT, MXLI, NOLIT, NOLI,   00028960
     *                       MINDIT, MNDI, MAXDIT, MXDI, NODIT, NODI,   00028970
     *                       NEVNTL, NEVNTS, NOBINT, NOBIN              00028980
 1006 FORMAT ( '0',                                                     00028990
     *    24X, 'MINIMUM GROUP (GI) INDEX. . . . . ',  I8, '   ', I9, /, 00029000
     *    25X, 'MAXIMUM GROUP (GI) INDEX. . . . . ',  I8, '   ', I9, /, 00029010
     *    25X, 'NO. OF GROUP (GI) INDEXES . . . . ',  I8, '   ', I9, //,00029020
     *    25X, 'MINIMUM LINE (LI) INDEX . . . . . ',  I8, '   ', I9, /, 00029030
     *    25X, 'MAXIMUM LINE (LI) INDEX . . . . . ',  I8, '   ', I9, /, 00029040
     *    25X, 'NO. OF LINE (LI) INDEXES. . . . . ',  I8, '   ', I9, //,00029050
     *    25X, 'MINIMUM DEPTH (DI) INDEX. . . . . ',  I8, '   ', I9, /, 00029060
     *    25X, 'MAXIMUM DEPTH (DI) INDEX. . . . . ',  I8, '   ', I9, /, 00029070
     *    25X, 'NO. OF DEPTH (DI) INDEXES . . . . ',  I8, '   ', I9, //,00029080
     *    25X, 'LIVE TRACES (EVENTS). . . . . . . ',  I8, '   ', I9, /, 00029090
     *    25X, 'TOTAL NO. BINS. . . . . . . . . . ',  I8, '   ', I9   ) 00029100
C                                                                       00029110
      IF ( NEVNTS .EQ. 0 ) THEN                                         00029120
        WRITE ( LUPRNT , 1007 )                                         00029130
 1007   FORMAT ( '0** M1007 **  ERROR DETECTED BY SUBROUTINE EVNSUM.',/,00029140
     *      15X, 'NONE OF THE EVENT TRACES PASSED EDITING.  PLEASE',    00029150
     *           ' RECHECK EDITING PARAMETERS AND RESUBMIT.', /,        00029160
     *      15X, 'EXECUTION TERMINATED.' )                              00029170
        IER = 100                                                       00029180
        GOTO 9999                                                       00029190
      END IF                                                            00029200
C                                                                       00029210
C***********************************************************************00029220
C*   CALCULATE TOTAL NO. OF UNKNOWNS TO BE SOLVED AND POINTERS FOR     *00029230
C* PARTITIONS IN THE SOLUTION VECTOR.                                  *00029240
C***********************************************************************00029250
C                                                                       00029260
      NOSRK = NOIS + NOJR                                               00029270
      IF ( MODEFG .EQ. 2 ) NOSRK = NOSRK + 2*NOKK                       00029280
      IF ( MODEFG .EQ. 3 ) NOSRK = NOSRK + 4*NOKK                       00029290
C                                                                       00029300
      WRITE ( LUPRNT, 1010 ) NOSRK                                      00029310
 1010 FORMAT ( 25X, 'TOTAL NO. OF UNKNOWNS . . . . . .', 11X, I10 )     00029320
C                                                                       00029330
cmam  IF ( ( NOKK .GT. MXNOKK ) .AND. ( MODEFG .GT. 1 ) ) THEN          00029340
cmam    WRITE ( LUPRNT, 1011 ) NOKK, MXNOKK                             00029350
 1011   FORMAT ( '0** M1011 **  ERROR DETECTED BY SUBROUTINE EVNSUM.', /00029360
     1,     15X, 'TOTAL NUMBER OF BINS AFTER EVENT LIMITING IS ',I8, '.'00029370
     2,  /, 15X, 'THIS IS GREATER THAN THE MAXIMUM ALLOWABLE OF ', I8,  00029380
     3           '.', /, 15X, 'EXECUTION TERMINATED.' )                 00029390
cmam    IER = 100                                                       00029400
cmam    GOTO 9999                                                       00029410
cmam  END IF                                                            00029420
C                                                                       00029430
cmam  IF ( NOSRK .GT. MXNSRK ) THEN                                     00029440
cmam    WRITE ( LUPRNT, 1012 ) NOSRK, MXNSRK                            00029450
 1012   FORMAT ( '0** M1012 **  ERROR DETECTED BY SUBROUTINE EVNSUM.', /00029460
     1,     15X, 'TOTAL NUMBER OF UNKNOWNS IN SOLUTION VECTOR OF ',I8, /00029470
     2,     15X, 'IS GREATER THAN MAXIMUM ALLOWABLE OF ',I8, '.', /     00029480
     3,     15X, 'EXECUTION TERMINATED')                                00029490
cmam    IER = 100                                                       00029500
cmam    GOTO 9999                                                       00029510
cmam  END IF                                                            00029520
C                                                                       00029530
      NCORDS = NOIS + NOJR                                              00029540
cmam  IF ( NCORDS .GT. MXNOKK ) THEN                                    00029550
cmam    WRITE ( LUPRNT, 1013 ) NCORDS, MXNOKK                           00029560
 1013   FORMAT ( '0** M1013 **  ERROR DETECTED BY SUBROUTINE EVNSUM.', /00029570
     1,     15X, 'TOTAL NUMBER OF SOURCE AND GROUP STATICS TO BE', /    00029580
     2,     15X, 'DETERMINED OF ',I7,' IS GREATER THAN MAXIMUM', /      00029590
     3,     15X, 'ALLOWABLE OF ', I7, '.  EXECUTION TERMINATED.' )      00029600
cmam    IER = 100                                                       00029610
cmam    GOTO 9999                                                       00029620
cmam  END IF                                                            00029630
C                                                                       00029640
      ISPOIN = 1                                                        00029650
      JRPOIN = ISPOIN + NOIS                                            00029660
      KKPOIN = JRPOIN + NOJR                                            00029670
C                                                                       00029680
      IF ( MODEFG .GT. 1 ) THEN                                         00029690
        KCPOIN = KKPOIN                                                 00029700
        KMPOIN = KCPOIN + NOKK                                          00029710
        IF ( MODEFG .EQ. 3 ) THEN                                       00029720
          KEPOIN = KMPOIN + NOKK                                        00029730
          KFPOIN = KEPOIN + NOKK                                        00029740
        END IF                                                          00029750
      END IF                                                            00029760
C                                                                       00029770
C***********************************************************************00029780
C*   DETERMINE ORIGIN TRANSLATION FOR STATICS X,Y COORDINATES TO AVOID *00029790
C* POSSIBLE REAL*4 ROUNDOFF ERRORS THAT WOULD CAUSE LOSS OF COORDINATE *00029800
C* PRECISION FOR STATE-PLANE COORDINATES.  THE SHIFTED COORDINATES ARE *00029810
C* ONLY NEEDED FOR PLOTTING OF THE STATICS SOLUTION.                   *00029820
C***********************************************************************00029830
C                                                                       00029840
      NXFACT = NXMIN / NMAPSC                                           00029850
      IF ( MOD(NXMIN,NMAPSC) .LT. 0 ) NXFACT = NXFACT - 1               00029860
      NXSHFT = NXFACT * NMAPSC                                          00029870
      NYFACT = NYMIN / NMAPSC                                           00029880
      IF ( MOD(NYMIN,NMAPSC) .LT. 0 ) NYFACT = NYFACT - 1               00029890
      NYSHFT = NYFACT * NMAPSC                                          00029900
C                                                                       00029910
 9999 CONTINUE                                                          00029920
      RETURN                                                            00029930
      END                                                               00029940
C***********************************************************************00029950
C***********************************************************************00029960
C***********************************************************************00029970
C***********************************************************************00029980
C***********************************************************************00029990
cmam  SUBROUTINE EVNTDS ( IX, NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB,    00030000
      SUBROUTINE EVNTDS ( NX, NREC1, NTRC1, AZSMA, AZLRA, AZSMB,
     *                    AZLRB, NSMLI, NLRLI, NSMDI, NLRDI, NNRRNG,    00030010
     *                    NFRRNG, BB, BNO,idsk2, xunit )
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00030030
C***********************************************************************00030040
C                                                                      *00030050
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00030080
C***********************************************************************00030090
C  ROUTINE:       EVNTDS                                                00030100
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00030110
C  PURPOSE:                                                             00030120
C      READ ALL EVENTS ON THE EVENT TAPE AND EDIT THE EVENTS BY THE     00030130
C      A MINIMUM AND MAXIMUM LIMITS AND STORE THEM ONTO DISK.           00030140
C  CALLING PARAMETERS: SUBROUTINE EVNTDS ( IX, NX, NREC1, NTRC1, AZSMA, 00030150
C                                          AZLRA, AZSMB, AZLRB, BB,     00030160
C                                          BNO )                        00030170
C  ARGUMENTS:                                                           00030180
C      NAME                        DESCRIPTION                          00030190
C      IX      I*2      PASSED     ARRAY USED TO READ EVENT TAPE TRACES.00030200
C      NX      I*4      PASSED     ARRAY EQUIVALENCED ON IX.            00030210
C      NREC1   I*4      PASSED     NUMBER OF RECORDS ON EVENT TAPE.     00030220
C      NTRC1   I*4      PASSED     NUMBER OF TRACES PER RECORD.         00030230
C      AZSMA   R*4      PASSED     SMALL ASZMITH A                      00030240
C      AZLRA   R*4      PASSED     LARGE ASZMITH A                      00030250
C      AZSMB   R*4      PASSED     SMALL ASZMITH B                      00030260
C      AZLRB   R*4      PASSED     LARGE ASZMITH B                      00030270
C      NSMLI   I*4      PASSED     LINE INDEX MINIMUM                   00030280
C      NLRLI   I*4      PASSED     LINE INDEX MAXIMUM                   00030290
C      NSMDI   I*4      PASSED     DEPTH INDEX MINIMUM                  00030300
C      NLRDI   I*4      PASSED     DEPTH INDEX MAXIMUM                  00030310
C      NNRRGN  I*4      PASSED     RANGE MINIMUM                        00030320
C      NFRRNG  I*4      PASSED     RANGE MAXIMUM                        00030330
C      BB      R*4      RETURNED   PARTITION OF RIGHT-HAND-SIDE         00030340
C                                  OF LMSE MATRIX.  ITS LENGTH NOKK     00030350
C                                  IS IN COMMON/POINT3/.                00030360
C      BNO     R*4      RETURNED   PARTITION OF MAIN DIAGONAL OF        00030370
C                                  LMSE MATRIX.                         00030380
C  CATEGORY:  SPECIFIC                                                  00030390
C       +------------------------------------------------------+        00030400
C       |               DEVELOPMENT INFORMATION                |        00030410
C       +------------------------------------------------------+        00030420
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 21, 1987              00030430
C  LANGUAGE:  FORTRAN 77                                                00030440
C       +------------------------------------------------------+        00030450
C       |                 EXTERNAL ENVIRONMENT                 |        00030460
C       +------------------------------------------------------+        00030470
C  EXTERNAL REFERENCES:                                                 00030480
C      READ EVENT TAPE FROM LOGICAL UNIT LUNEVT.                        00030490
C      OUTPUT EVENT TO DISK FROM LOGICAL UNIT LUDSKA.                   00030500
C  ROUTINES CALLED:                                                     00030510
C      RTAPE    -    READ EVENTS FROM EVENT TAPE.                       00030520
C      DAWRTE   -    WRITE EVENTS TO DISK.                              00030530
C  COMMON:                                                              00030540
C      FILCON  (  * )  PARAMETERS FOR TWO TEMPORARY DISK AREAS SET BY   00030550
C                      MAIN PROGRAM.                                    00030560
C                        NWPEA  - NO. OF WORDS PER EVENT IN DISK A      00030570
C                        NEPBA  - NO. OF EVENTS PER BLOCK IN DISK A     00030580
C                        NWPBA  - NO. OF WORDS PER BLOCK IN DISK A      00030590
C                        NBPBA  - NO. OF BYTES PER BLOCK IN DISK A      00030600
C                        NBLKSA - NO. OF BLOCKS IN DISK A               00030610
C                        NEVNTS - NO. OF ACCEPTABLE EVENTS IN DISK A    00030620
C                        NWPCB  - NO. OF WORDS PER COORDINATE IN DISK B 00030630
C                        NCPBB  - NO. OF COORDINATES PER BLOCK IN DISK B00030640
C                        NWPBB  - NO. OF WORDS PER BLOCK IN DISK B      00030650
C                        NBPBB  - NO. OF BYTES PER BLOCK IN DISK B      00030660
C                        NBLKSB - NO. OF BLOCKS IN DISK B               00030670
C                        NCORDS - NO. OF COORDINATES IN DISK B          00030680
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00030690
C                      BY MAIN PROGRAM.                                 00030700
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00030710
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00030720
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00030730
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00030740
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00030750
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00030760
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00030770
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00030780
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00030790
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00030800
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00030810
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00030820
C      PLTMAP  (  * )  PARAMETERS FOR PLOT OF ERROR DISTRIBUTION AND    00030830
C                      STATICS MAPS SET BY MAIN PROGRAM.                00030840
C                        NAMEPR - PROGRAM NAME                          00030850
C                        NTITLE - 20-BYTE ARRAY FOR PLOT TITLE          00030860
C                        CARDA  - 80-CHAR ARRAY FOR 1ST3D CARD IMAGE    00030870
C                        CARDB  - 80-CHAR ARRAY FOR 2ST3D CARD IMAGE    00030880
C                        CARDC  - 80-CHAR ARRAY FOR 3ST3D CARD IMAGE    00030890
C                        NHSCAL - HORIZONTAL SCALE OF ERROR DISTR. PLOT 00030900
C                        NHIGHT - HEIGHT OF ERROR DISTRIBUTION PLOT     00030910
C                        NMAPSC - SCALE OF STATICS MAPS                 00030920
C                        NCNTIN - CONTOUR INTERVAL FOR AMOCO I          00030930
C                                     CONTOURING FILE                   00030940
C                        NXSHFT - X-COMPONENT OF ORIGIN SHIFT FOR       00030950
C                                     STATICS COORDINATES               00030960
C                        NYSHFT - Y-COMPONENT OF ORIGIN SHIFT FOR       00030970
C                                     STATICS COORDINATES               00030980
C                        NDVICE - HARDWARE DEVICE NAME FOR PLOT         00030990
C                        NSETUP - SETUP CODE FOR PLOT                   00031000
C                        CTPRTY - 2-CHARACTER PLOT TAPE TP PRIORITY     00031010
C                        IJBNAM - 8-CHARACTER FOR JOBNAME               00031020
C                        IDSNAM - 22-CHARACTER FOR EVENT TAPE DSNAME    00031030
C                        IVOLSR - 6-CHARACTER FOR EVENT TAPE VOLSER     00031040
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00031050
C                      SET BY MAIN PROGRAM.                             00031060
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00031070
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00031080
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00031090
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00031100
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00031110
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00031120
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00031130
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00031140
C                        NOKK   - NO. OF BINS                           00031150
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00031160
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00031170
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00031180
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00031190
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00031200
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00031210
C                        MNLI   - MINIMUM LINE (LI) INDEX               00031220
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00031230
C                        NOLI   - NO. OF LINE (LI) INDEXES              00031240
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00031250
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00031260
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00031270
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00031280
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00031290
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00031300
C                                     (0=YES, 1=NO)                     00031310
C                        MODEFG - MODE OF SOLUTION FLAG                 00031320
C                                     (1  --  I + R = T                )00031330
C                                     (2  --  I + R + C + M = T        )00031340
C                                     (3  --  I + R + C + M + E + F = T)00031350
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00031360
C                                     (0=YES, 1=NO)                     00031370
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00031380
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00031390
C                                     ALL RNMO TERMS                    00031400
C      STAFL3  (  * )  ARRAYS FOR DATA FROM EVENT TAPE.                 00031410
C                        TIJ    - ARRAY FOR PRIMARY PICKS               00031420
C                        TIJM   - ARRAY FOR ALTERNATE PICK (LT PRIMARY) 00031430
C                        TIJX   - ARRAY FOR ALTERNATE PICK (GT PRIMARY) 00031440
C                        COR    - ARRAY FOR SQUARE OF WEIGHTS           00031450
C                        CORM   - ARRAY FOR SQ. OF ALT. WEIGHT (LT PRI.)00031460
C                        CORX   - ARRAY FOR SQ. OF ALT. WEIGHT (GT PRI.)00031470
C                        ISPOS  - ARRAY FOR SOURCEPOINT (PRI) POINTERS  00031480
C                        JRPOS  - ARRAY FOR GROUP (GI) POINTERS         00031490
C                        KKPOS  - ARRAY FOR BIN POINTERS                00031500
C                        XOF    - ARRAY FOR SQUARE OF OFFSETS           00031510
C                        XOFSIN - ARRAY FOR (XOF**2)*SIN(AZIMUTH)       00031520
C                        XOFCOS - ARRAY FOR (XOF**2)*COS(AZIMUTH)       00031530
C                                                                       00031540
C  ERROR RETURNS:  SEE ARGUEMENT DESCRIPTION FOR IER.                   00031550
C                                                                       00031560
C*******************   END OF DOCUMENTATION PACKAGE   ******************00031570
C***********************************************************************00031580
C                                                                       00031590
C                                                                       00031600
C                                                                       00031610
      REAL*4     BB(*), BNO(*)                                          00031620
C                                                                       00031630
cmam  INTEGER*2  IX(*)                                                  00031640
C                                                                       00031650
      INTEGER*4  NX(*)                                                  00031660
C                                                                       00031670
      CHARACTER   IJBNAM*8, IDSNAM*22, IVOLSR*6,  CTPRTY*2,  CARDA*80,  00031680
     *            CARDB*80, CARDC*80,  NTITLE*20, NAMEPR*4,
     *            NDVICE*4, NSETUP*4                                    00031700
C                                                                       00031710
      COMMON/FILCON/NWPEA,NEPBA,NWPBA,NBPBA,NBLKSA,NEVNTS,              00031720
     *              NWPCB,NCPBB,NWPBB,NBPBB,NBLKSB,NCORDS               00031730
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,LUPRNT,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00031750
      COMMON/PLTMAP/NAMEPR,NTITLE,CARDA,CARDB,CARDC,NHSCAL,NHIGHT,      00031760
     *              NMAPSC,NCNTIN,NXSHFT,NYSHFT,NDVICE,NSETUP,CTPRTY,   00031770
     *              IJBNAM,IDSNAM,IVOLSR                                00031780
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00031790
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00031800
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00031810
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00031820
      COMMON/STAFL3/TIJ(680),TIJM(680),TIJX(680),COR(680),CORM(680),    00031830
     *              CORX(680),ISPOS(680),JRPOS(680),KKPOS(680),XOF(680),00031840
     *              XOFSIN(680),XOFCOS(680)                             00031850
C                                                                       00031860
      DATA NRPT / 1 /, NBLCKK / 0 /, NWORDK / 0 /, LBYTES / 0 /,        00031870
     *     NEVNDS / 0 /                                                 00031880
C                                                                       00031890
C***********************************************************************00031900
C*   INITIALIZE SOME VARIABLES BEFORE GETTING STARTED.                 *00031910
C***********************************************************************00031920
C                                                                       00031930
      NWPEA = 8 + ( MODEFG - 1 ) * 2
cmam..NWPEA = 8 + ( MODEFG - 1 ) * 2                                    00031940
      NBLKSA  = ( ( NEVNTS - 1 ) / NEPBA ) + 1                          00031950
      NWPBA = NWPEA * NEPBA                                             00031960
cmam.......this was killing us on the cray!!!!!
      NBPBA = NWPBA * szsmpd
cmam  NBPBA = NWPBA * 4                                                 00031970
      ISSHFT = MINIS - 1                                                00031980
      JRSHFT = MINJR - 1                                                00031990
      KKSHFT = MNDI - 1                                                 00032000
C                                                                       00032010
C***********************************************************************00032020
C*   REWIND INPUT EVENT TAPE TO LOAD POINT.  OPEN DISK FILE LUDSKA FOR *00032030
C* TEMPORARY STORAGE OF EVENT WORDS.  THIS DATA WILL BE WRITTEN TO DISK*00032040
C* IN BLOCKS THAT ARE EACH NWPBA WORDS LONG (NBPBA BYTES LONG).  THERE *00032050
C* ARE NBLKSA BLOCKS.                                                  *00032060
C***********************************************************************00032070
C                                                                       00032080
	endfile idsk2
	rewind idsk2
      CALL DAOPen( NRPT, NBLKSA, NBPBA, LUDSKA, NLUDSA )                00032100
      WRITE ( LUPRNT, 1000 ) NBLKSA, NBPBA                              00032110
 1000 FORMAT ( ////, 25X, 'DISK FILE (A) REQUIREMENTS: ', I5,           00032120
     1                    ' BLOCKS, ', I7, ' BYTES/BLOCK.' )            00032130
C                                                                       00032140
C***********************************************************************00032150
C*   READ INPUT EVENT TAPE AGAIN, THIS TIME TO WRITE DATA FOR ALL      *00032160
C* EVENTS THAT PASS LIMITING AND EDITING TO DISK FILE LUDSKA.  PLACE   *00032170
C* THE APPROPRIATE WORDS FOR THE ACCEPTED EVENTS INTO TIJ, TIJM, TIJX, *00032180
C* COR, CORM, CORX, ISPOS, JRPOS, KKPOS, XOF, XOFSIN, XOFCOS ARRAYS    *00032190
C* (DEPENDING UPON THE MODE), AND WRITE THESE ARRAYS TO DISK APPENDED  *00032200
C* AS ONE BLOCK.  EACH BLOCK IS NWPBA WORDS LONG (NBPBA BYTES LONG).   *00032210
C* THERE ARE NBLKSA BLOCKS.                                            *00032220
C***********************************************************************00032230
C                                                                       00032240
C                                                                       00032260
   50 CONTINUE                                                          00032270
cmam	read(idsk2,1010,end=2020)ntmpis,ntmpjr,ntmpli,ntmpdi,
	read(idsk2,end=2020)ntmpis,ntmpjr,ntmpli,ntmpdi,
     *		ntmpx,iazmth,
     *      istcor,nx12,nx13,nx14,nx15,
     *	     x129, x130, x131, x132, x133, x134
cmam *	    ix129,ix130,ix131,ix132,ix133,ix134
c1010	format(17i10)
C                                                                       00032310
	if(istcor .ne. 30000 .and. x129 .ne.(-10000.*xunit)) then
cmam;;;;if(istcor .ne. 30000 .and. x129 .ne. -10000) then
cmam....if(istcor .ne. 30000 .and. ix129 .ne. -10000) then
C                                                                       00032330
C                                                                       00032370
            IF ( NTMPLI .GE. NSMLI .AND. NTMPLI .LE. NLRLI   .AND.      00032380
     1           NTMPDI .GE. NSMDI .AND. NTMPDI .LE. NLRDI   .AND.      00032390
     2           NTMPX .GE. NNRRNG .AND. NTMPX .LE. NFRRNG ) THEN       00032400
		azim = iazmth * 0.0001
C                                                                       00032420
              IF ( AZIM .GE. AZSMA .AND. AZIM .LE. AZLRB   .AND.        00032430
     1           ( AZIM .LE. AZLRA .OR.  AZIM .GE. AZSMB ) ) THEN       00032440
                NEVNDS = NEVNDS + 1                                     00032450
                NWORDK = NWORDK + 1                                     00032460
	if(NWORDK.gt.680) then
	  write(LUPRNT,*)'nwordk=',nwordk
	  stop 680
	endif
cmam            TIJ(NWORDK) = IX129
cmam            TIJM(NWORDK) = IX133
cmam            TIJX(NWORDK) = IX131
                TIJ(NWORDK) =  X129
                TIJM(NWORDK) =  X133
                TIJX(NWORDK) =  X131
cmam            PKCOR = IX130 * 0.0001
cmam            PKCORM = IX134 * 0.0001
cmam            PKCORX = IX132 * 0.0001
                PKCOR =  X130 * 0.0001
                PKCORM =  X134 * 0.0001
                PKCORX =  X132 * 0.0001
                COR(NWORDK) = PKCOR * PKCOR                             00032530
                CORM(NWORDK) = PKCORM * PKCORM                          00032540
                CORX(NWORDK) = PKCORX * PKCORX                          00032550
                ISTEMP = ntmpis - ISSHFT 
                JRTEMP = ntmpjr - JRSHFT
                ISPOS(NWORDK) = ISTEMP                                  00032580
                JRPOS(NWORDK) = JRTEMP                                  00032590
                BNO(ISTEMP) = NX12 - NXSHFT
                BB(ISTEMP) = NX13 - NYSHFT
                BNO(JRTEMP + NOIS) = NX14 - NXSHFT
                BB(JRTEMP + NOIS) = NX15 - NYSHFT
C                                                                       00032640
                IF ( MODEFG .GE. 2 ) THEN                               00032650
                   KKPOS(NWORDK) = ( NODI * ( ntmpli - MNLI ) )
     1                             + ntmpdi - KKSHFT
                  TEMP = ntmpx
                  TEMP = TEMP * TEMP                                    00032690
                  XOF(NWORDK) = TEMP                                    00032700
C                                                                       00032710
                  IF ( MODEFG .EQ. 3 ) THEN                             00032720
                    AZIM2 = 2.0 * AZIM                                  00032730
                    XOFSIN(NWORDK) = TEMP * SIN(AZIM2)                  00032740
                    XOFCOS(NWORDK) = TEMP * COS(AZIM2)                  00032750
                  END IF                                                00032760
                END IF                                                  00032770
C                                                                       00032780
                IF ( NWORDK .GE. NEPBA ) THEN                           00032790
                  NBLCKK = NBLCKK + 1                                   00032800
                  CALL DAWRTE ( NBLCKK, TIJ, LUDSKA )                   00032810
                  NWORDK = 0                                            00032820
                END IF                                                  00032830
C                                                                       00032840
                IF ( NEVNDS .EQ. NEVNTS ) GOTO 101                      00032850
C                                                                       00032860
              END IF                                                    00032870
            END IF                                                      00032880
          END IF                                                        00032890
 2020 continue
        GOTO 50                                                         00032910
C                                                                       00032920
 101  CONTINUE                                                          00032930
C                                                                       00032940
      IF ( NWORDK .NE. 0 ) THEN                                         00032950
        NSTART = NWORDK + 1                                             00032960
        JBYTES = szsmpd * ( NEPBA - NWORDK )
        CALL MOVE ( 0, TIJ(NSTART), 0, JBYTES )                         00032980
        CALL MOVE ( 0, TIJM(NSTART), 0, JBYTES )                        00032990
        CALL MOVE ( 0, TIJX(NSTART), 0, JBYTES )                        00033000
        CALL MOVE ( 0, COR(NSTART), 0, JBYTES )                         00033010
        CALL MOVE ( 0, CORM(NSTART), 0, JBYTES )                        00033020
        CALL MOVE ( 0, CORX(NSTART), 0, JBYTES )                        00033030
        CALL MOVE ( 0, ISPOS(NSTART), 0, JBYTES )                       00033040
        CALL MOVE ( 0, JRPOS(NSTART), 0, JBYTES )                       00033050
C                                                                       00033060
        IF ( MODEFG .GE. 2 ) THEN                                       00033070
          CALL MOVE ( 0, KKPOS(NSTART), 0, JBYTES)                      00033080
          CALL MOVE ( 0, XOF(NSTART), 0, JBYTES)                        00033090
          IF ( MODEFG .EQ. 3 ) THEN                                     00033100
            CALL MOVE ( 0, XOFSIN(NSTART), 0, JBYTES )                  00033110
            CALL MOVE ( 0, XOFCOS(NSTART), 0, JBYTES )                  00033120
          END IF                                                        00033130
        END IF                                                          00033140
        NBLCKK = NBLCKK + 1                                             00033150
        CALL DAWRTE ( NBLCKK, TIJ, LUDSKA )                             00033160
      END IF                                                            00033170
C                                                                       00033180
C                                                                       00033200
      WRITE ( LUPRNT, 1001 )                                            00033210
 1001 FORMAT ( 25X, 'DISK FILE (A) COMPLETE.' )                         00033220
C                                                                       00033230
 9999 CONTINUE                                                          00033240
      RETURN                                                            00033250
      END                                                               00033260
C***********************************************************************00054950
C***********************************************************************00054960
C***********************************************************************00054970
C***********************************************************************00054980
C***********************************************************************00054990
      SUBROUTINE ALPKSW ( XX, BB, BNO, WA, NFITER, NPITER, MXLOOP,x2d )
cmam  SUBROUTINE ALPKSW ( XX, BB, BNO, WA, NFITER, NPITER, MXLOOP )     00055000
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00055010
C***********************************************************************00055020
C                                                                      *00055030
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00055060
C***********************************************************************00055070
C  ROUTINE:       ALPKSW                                                00055080
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00055090
C  PURPOSE:                                                             00055100
C      CALCULATE SOLUTION VECTORS.                                      00055110
C  CALLING PARAMETERS: SUBROUTINE ALPKSW ( XX, BB, BNO, WA, NFITER,     00055120
C                                          NPITER, MXLOOP )             00055130
C  ARGUMENTS:                                                           00055140
C      NAME                           DESCRIPTION                       00055150
C      XX      R*4     PASSED         SOLUTION VECTOR WITH LENGTH OF    00055160
C                                     NORSK IN COMMON /POINT3/.         00055170
C      BB      R*4     RETURNED       PARTITION OF RIGHT-HAND-SIDE      00055180
C                                     OF LMSE MATRIX.  ITS LENGTH NOKK  00055190
C                                     IS IN COMMON/POINT3/.             00055200
C      BNO     R*4     RETURNED       PARTITION OF MAIN DIAGONAL OF     00055210
C                                     LMSE MATRIX.                      00055220
C      WA      R*4     RETURNED       AUXILIARY ARRAY FOR PARTITION OF  00055230
C                                     PRODUCT OF LMSE MATRIX WITH       00055240
C                                     SOLUTION VECTOR.                  00055250
C      NFITER  I*4     PASSED         ITERATIONS AFTER ALTERNATE PICKS  00055260
C      NPITER  I*4     PASSED         ITERATIONS PRIOR TO ALTERNATE PICK00055270
C      MXLOOP  I*4     PASSED         ITERATIONS THROUGH ALTERNATE PICKS00055280
C  CATEGORY:  SPECIFIC                                                  00055290
C       +------------------------------------------------------+        00055300
C       |               DEVELOPMENT INFORMATION                |        00055310
C       +------------------------------------------------------+        00055320
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 28, 1987              00055330
C  LANGUAGE:  FORTRAN 77                                                00055340
C       +------------------------------------------------------+        00055350
C       |                 EXTERNAL ENVIRONMENT                 |        00055360
C       +------------------------------------------------------+        00055370
C  EXTERNAL REFERENCES:                                                 00055380
C      TAPE READS FROM LOGICAL UNIT LUNTAP AND TAPE WRITES TO LOGICAL   00055390
C      UNIT LUOTAP.                                                     00055400
C  ROUTINES CALLED:                                                     00055410
C      MOVE    -    MOVE VALUES INTO ARRAYS.                            00055420
C      ERDS3C  -    CALCULATES ERRORS AND SWITCHES ALTERNATE PICKS.     00055430
C      GAUS3C  -    SOLVES STATIC EQUATIONS BY GAUSS-SEIDEL METHOD.     00055440
C      DACLOS  -    CLOSE DISK FILE LOGICAL UNIT LUDSKA.                00055450
C  COMMON:                                                              00055460
C      ERRORS  (  * )  ERROR DISTRIBUTION AND OTHER ERROR STATISTICS    00055470
C                      SET BY SUBROUTINE ERDS3C.                        00055480
C                        DIST   - ARRAY FOR ERROR DISTRIBUTION          00055490
C                        NODIS  - LENGTH OF ARRAY FOR ERROR DISTRIBUTION00055500
C                        DID    - ERROR INCREMENT IN ERROR DIST. ARRAY  00055510
C                        ERMAX  - MAXIMUM ABOLUTE ERROR                 00055520
C                        POSER  - LARGEST POSITIVE ERROR                00055530
C                        ERNEG  - LARGEST NEGATIVE ERROR                00055540
C                        RMSER  - RMS ERROR                             00055550
C                        NSUMO  - NO. OF EVENTS INCLUDED IN ERROR DIST. 00055560
C                        NOLEG  - NO. OF ALTERNATE PICKS SUBSTITUTED    00055570
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00055580
C                      BY MAIN PROGRAM.                                 00055590
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00055600
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00055610
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00055620
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00055630
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00055640
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00055650
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00055660
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00055670
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00055680
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00055690
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00055700
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00055710
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00055720
C                      SET BY MAIN PROGRAM.                             00055730
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00055740
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00055750
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00055760
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00055770
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00055780
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00055790
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00055800
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00055810
C                        NOKK   - NO. OF BINS                           00055820
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00055830
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00055840
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00055850
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00055860
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00055870
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00055880
C                        MNLI   - MINIMUM LINE (LI) INDEX               00055890
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00055900
C                        NOLI   - NO. OF LINE (LI) INDEXES              00055910
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00055920
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00055930
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00055940
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00055950
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00055960
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00055970
C                                     (0=YES, 1=NO)                     00055980
C                        MODEFG - MODE OF SOLUTION FLAG                 00055990
C                                     (1  --  I + R = T                )00056000
C                                     (2  --  I + R + C + M = T        )00056010
C                                     (3  --  I + R + C + M + E + F = T)00056020
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00056030
C                                     (0=YES, 1=NO)                     00056040
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00056050
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00056060
C                                     ALL RNMO TERMS                    00056070
C                                                                       00056080
C  ERROR RETURNS:  NONE.                                                00056090
C                                                                       00056100
C*******************   END OF DOCUMENTATION PACKAGE   ******************00056110
C***********************************************************************00056120
C                                                                       00056130
C                                                                       00056140
	logical x2d
C                                                                       00056150
      REAL*4      XX(*), BB(*), BNO(*), WA(*)                           00056160
C                                                                       00056170
      INTEGER*4   NDIST(201)
C                                                                       00056190
      COMMON/ERRORS/DIST(201),NODIS,DID,ERMAX,POSER,ERNEG,RMSER,NSUMO,  00056200
     *              NOLEG                                               00056210
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,luprnt,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00056230
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00056240
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00056250
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00056260
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00056270
C                                                                       00056280
      DATA NOLEGT / 0 /                                                 00056290
C                                                                       00056300
C***********************************************************************00056310
C*   START STATIC COMPUTATIONS.                                        *00056320
C***********************************************************************00056330
C                                                                       00056340
      WRITE ( LUPRNT, 999 )                                             00056350
  999 FORMAT ( ////, 19X, '***** START STATICS COMPUTATIONS:', / '0' )  00056360
C                                                                       00056370
C***********************************************************************00056380
C*   ALTERNATE PICK SWITCHING LOOP.  WHEN NOLEG BECOMES ZERO THEN      *00056390
C* EXIT LOOP.  IF NOLEG NEVER BECOMES ZERO FOR MXLOOPS THEN OUTPUT A   *00056400
C* MESSAGE WARNING THAT NOLEG NEVER WENT TO ZERO.                      *00056410
C***********************************************************************00056420
C                                                                       00056430
      IBYTES = szsmpd * NOSRK
      IF ( NALPFG .EQ. 0 ) THEN                                         00056450
C                                                                       00056460
        DO 100 NLOOP = 1, MXLOOP                                        00056470
          CALL MOVE ( 0, XX, 0, IBYTES )                                00056480
          CALL GAUS3C ( BB, BNO, XX, WA, NPITER,x2d )
cmam      CALL GAUS3C ( BB, BNO, XX, WA, NPITER )                       00056490
          CALL ERDS3C ( XX )                                            00056500
C                                                                       00056510
          WRITE ( LUPRNT, 1000 ) NLOOP, NOLEG, ERMAX, RMSER             00056520
 1000     FORMAT ( /, 25X, 'LOOP NO. ', I2, /,                          00056530
     *             25X, 'NO. OF ALTERNATE PICKS SUBSTITUTED = ', I8, /, 00056540
     *             25X, 'ERRORS (MS): MAXIMUM ABSOLUTE = ', F7.1,       00056550
     *             ', RMS = ', F10.4 )                                  00056560
C                                                                       00056570
          IF ( NOLEG .EQ. 0 ) GOTO 110                                  00056580
C                                                                       00056590
          NOLEGT = NOLEGT + NOLEG                                       00056600
          WRITE ( LUPRNT, 2000 )                                        00056610
 2000     FORMAT ( //, 19X, '***** SOLUTION BEING RECOMPUTED USING ',   00056620
     *             'NEW PICK SET:', /, ' ' )                            00056630
  100   CONTINUE                                                        00056640
C                                                                       00056650
        WRITE ( LUPRNT, 3000 )                                          00056660
 3000   FORMAT ( ////, '0** M3000 **  WARNING FROM SUBROUTINE ALPKSW.', 00056670
     *         /, 15X, 'WARNING:  MAXIMUM ALLOWABLE NO. OF LOOPS ',     00056680
     *         /, 15X, 'THROUGH TESTING OF ALTERNATE PICKS ATTAINED ',  00056690
     *         /, 15X, 'WITHOUT REACHING ZERO PICK SUBSITUTION.' )      00056700
C                                                                       00056710
  110   CONTINUE                                                        00056720
      END IF                                                            00056730
C                                                                       00056740
      WRITE ( LUPRNT, 4000 ) NOLEGT                                     00056750
 4000 FORMAT ( ///, 25X, '***** ', I8, ' TOTAL ALTERNATE PICKS ',       00056760
     *                   'SUBSTITUTED. *****' )                         00056770
C                                                                       00056780
C***********************************************************************00056790
C*   FINAL ITERATIONS.                                                 *00056800
C***********************************************************************00056810
C                                                                       00056820
      WRITE ( LUPRNT, 5000 )                                            00056830
 5000 FORMAT ( ///, 19X, '***** SOLUTION BEING RECOMPUTED USING ',      00056840
     *                   'FINAL PICK SET:', /, ' ' )                    00056850
      CALL MOVE ( 0, XX, 0, IBYTES )                                    00056860
      CALL GAUS3C ( BB, BNO, XX, WA, NFITER,x2d )
cmam  CALL GAUS3C ( BB, BNO, XX, WA, NFITER )                           00056870
C                                                                       00056880
C***********************************************************************00056890
C*   SOLUTION IS COMPLETE.  CALCULATE AND PRINT FINAL ERROR PARAMETERS.*00056900
C* CLOSE DISK FILE A.                                                  *00056910
C***********************************************************************00056920
C                                                                       00056930
      WRITE ( LUPRNT, 5500 )                                            00056940
 5500 FORMAT ( ///, 19X, '***** STATICS COMPUTATION COMPLETE' )         00056950
C                                                                       00056960
      NALPFG = 1                                                        00056970
      CALL ERDS3C ( XX )                                                00056980
      WRITE ( LUPRNT, 6000 ) ERMAX, RMSER                               00056990
 6000 FORMAT ( //, 25X, '***** FINAL ERRORS (MS):  MAXIMUM ABSOLUTE = ',00057000
     *         F7.1, ',  RMS = ', F10.4, ' *****' )                     00057010
C                                                                       00057020
      DO 200 I = 1, NODIS                                               00057030
        NDIST(I) = DIST(I)                                              00057040
  200 CONTINUE                                                          00057050
C                                                                       00057060
      NCENTR = ( NODIS / 2 ) + 1                                        00057070
      WRITE ( LUPRNT, 7000 ) DID, NCENTR                                00057080
 7000 FORMAT ( ///, 8X, 'FINAL ERROR DISTRIBUTION SORTED INTO ', F4.2,  00057090
     *              ' MS INCREMENTS.  NUMBER PRINTED IS NO. OF ',       00057100
     *              'EVENTS PER INCREMENT.', /,                         00057110
     *              8X, 'INCREMENT CENTERED ON ZERO ERROR IS ELEMENT ', 00057120
     *              'NO. ', I3, '.', /, 8X, 104('-')  )                 00057130
C                                                                       00057140
      WRITE ( LUPRNT, 8000 ) NDIST                                      00057150
 8000 FORMAT ( 5X, 10I10 )                                              00057160
C                                                                       00057170
C                                                                       00057180
 9999 CONTINUE                                                          00057190
      CALL DACLOS ( LUDSKA )                                            00057200
      RETURN                                                            00057210
      END                                                               00057220
C***********************************************************************00062590
C***********************************************************************00062600
C***********************************************************************00062610
C***********************************************************************00062620
C***********************************************************************00062630
cmam....TJOB1 is not used in this subroutine....get rid of it
cmam  SUBROUTINE SOLTp1 ( ILH, NLH, TJOB1, XX, IX, IOTHLH )             00060870
      SUBROUTINE SOLTp1 ( NLH, XX, IX, IOTHLH )
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00060880
C***********************************************************************00060890
C                                                                      *00060900
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00060930
C***********************************************************************00060940
C  ROUTINE:       SOLTAP                                                00060950
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00060960
C  PURPOSE:                                                             00060970
C      WRITE BIN-ORIENTED SOLUTION ARRAYS TO OUPUT DATA TAPE.           00060980
C  CALLING PARAMETERS: SUBROUTINE SOLTAP ( ILH, NLH, TJOB1, XX, IX,     00060990
C                                          IOTHLH )                     00061000
C  ARGUMENTS:                                                           00061010
C      NAME                           DESCRIPTION                       00061020
C      ILH     I*2     PASSED         ARRAY USED FOR LINE HEADER.       00061030
C      NLH     I*4     PASSED         ARRAY EQUIVALENCED ON ILH.        00061040
C      TJOB1   C*8     PASSED         JOB NUMBER FROM INPUT EVENT TAPE  00061050
C      XX      R*4     PASSED         SOLUTION VECTOR WITH LENGTH OF    00061060
C      IX      I*2     PASSED         ARRAY USED TO OUTPUT TRACES TO    00061070
C                                     TAPE.                             00061080
C      IOTHLH  C*16    PASSED         HISTORY LINE HEADER.              00061090
C  CATEGORY:  SPECIFIC                                                  00061100
C       +------------------------------------------------------+        00061110
C       |               DEVELOPMENT INFORMATION                |        00061120
C       +------------------------------------------------------+        00061130
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 28, 1987              00061140
C  LANGUAGE:  FORTRAN 77                                                00061150
C       +------------------------------------------------------+        00061160
C       |                 EXTERNAL ENVIRONMENT                 |        00061170
C       +------------------------------------------------------+        00061180
C  EXTERNAL REFERENCES:                                                 00061190
C      WRITE SOLUTION ARRAYS TO TAPE.                                   00061200
C  ROUTINES CALLED:                                                     00061210
C      WRTAPE - USED TO OUTPUT TO TAPES.                                00061220
C  COMMON:                                                              00061230
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00061240
C                      BY MAIN PROGRAM.                                 00061250
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00061260
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00061270
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00061280
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00061290
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00061300
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00061310
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00061320
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00061330
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00061340
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00061350
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00061360
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00061370
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00061380
C                      SET BY MAIN PROGRAM.                             00061390
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00061400
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00061410
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00061420
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00061430
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00061440
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00061450
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00061460
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00061470
C                        NOKK   - NO. OF BINS                           00061480
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00061490
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00061500
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00061510
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00061520
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00061530
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00061540
C                        MNLI   - MINIMUM LINE (LI) INDEX               00061550
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00061560
C                        NOLI   - NO. OF LINE (LI) INDEXES              00061570
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00061580
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00061590
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00061600
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00061610
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00061620
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00061630
C                                     (0=YES, 1=NO)                     00061640
C                        MODEFG - MODE OF SOLUTION FLAG                 00061650
C                                     (1  --  I + R = T                )00061660
C                                     (2  --  I + R + C + M = T        )00061670
C                                     (3  --  I + R + C + M + E + F = T)00061680
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00061690
C                                     (0=YES, 1=NO)                     00061700
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00061710
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00061720
C                                     ALL RNMO TERMS                    00061730
C                                                                       00061740
C  ERROR RETURNS:  NONE.                                                00061750
C                                                                       00061760
C*******************   END OF DOCUMENTATION PACKAGE   ******************00061770
C***********************************************************************00061780
C                                                                       00061790
C                                                                       00061800
C                                                                       00061810
      REAL*4       XX(*)                                                00061820
C                                                                       00061830
cmam  INTEGER*2    IX(*), ILH(*)                                        00061840
	integer    ix(*)
C                                                                       00061850
      INTEGER*4    NLH(*)
C                                                                       00061870
cmam....TJOB1 is not used in this subroutine....get rid of it
cmam  CHARACTER*8  TJOB1                                                00061880
C                                                                       00061890
      CHARACTER*16 IOTHLH                                               00061900
C                                                                       00061910
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,LUPRNT,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00061930
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00061940
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00061950
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00061960
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00061970
	common/hedrs/j_RecNum,i_RecNum,l_RecNum,
     *		     j_TrcNum,i_TrcNum,l_TrcNum,
     *		     j_NumTrc,i_NumTrc,l_NumTrc,
     *		     j_NumRec,i_NumRec,l_NumRec,
     *		     j_SmpInt,i_SmpInt,l_SmpInt,
     *		     j_NumSmp,i_NumSmp,l_NumSmp,
     *		     j_Format,i_Format,l_Format
C                                                                       00061980
C***********************************************************************00061990
C*   WRITE TAPE HEADERS TO TAPE.                                        00062000
C***********************************************************************00062010
C                                                                       00062020
      IF ( MODEFG .EQ. 2 ) NSRECS = 2                                   00062030
      IF ( MODEFG .EQ. 3 ) NSRECS = 4                                   00062040
      CALL MOVE ( 0, nLH, 0, szsmpd*1500 )
cmam  CALL MOVE ( 0, ILH, 0, szsmpd*1500 )
cmam	call savew(nlh,'NumTrc',noli,0)
cmam	call savew(nlh,'NumRec',nsrecs,0)
cmam	call savew(nlh,'SmpInt',4,0)
cmam	call savew(nlh,'NumSmp',nodi,0)
cmam	call savew(nlh,'Format',3,0)
	call savew2(nlh,j_NumTrc,i_NumTrc,l_NumTrc,noli,0)
	call savew2(nlh,j_NumRec,i_NumRec,l_NumRec,nsrecs,0)
	call savew2(nlh,j_SmpInt,i_SmpInt,l_SmpInt,4,0)
	call savew2(nlh,j_NumSmp,i_NumSmp,l_NumSmp,nodi,0)
	call savew2(nlh,j_Format,i_Format,l_Format,3,0)
C                                                                       00062120
      WRITE ( LUPRNT, 1001 )                                            00062130
 1001 FORMAT ( /, 49X, '*** MESSAGE FROM PROGRAM ST3D ***', /,          00062140
     *            45X, 'THE FOLLOWING IS THE OUTPUT SOLUTION ARRAY', /, 00062150
     *            45X, 'TAPE (OSLA) LINE HEADER FROM PROGRAM ST3D.' )   00062160
C                                                                       00062170
      LBYTES = 128                                                      00062180
cmam...5-5-95...looks like this slipped by in the original changes...
      CALL HLHprt ( nLH, LBYTES, IOTHLH, 16 , luprnt)
cmam  CALL HLH ( ILH, LBYTES, IOTHLH, 16 )                              00062190
C                                                                       00062200
C***********************************************************************00062210
C*   OPEN OUTPUT TAPE AND OUTPUT THE BIN-ORIENTED SOLUTION ARRAYS.     *00062220
C***********************************************************************00062230
C                                                                       00062240
      CALL RICLR ( LUPRNT )                                             00062250
      CALL WRTAPE ( LUOSLA, nLH, LBYTES )                               00062270
cmam  CALL WRTAPE ( LUOSLA, ILH, LBYTES )                               00062270
      CALL MOVE ( 0, IX, 0, sztrhd )
      N4NODI = szsmpd * NODI
      NBYTES = N4NODI + sztrhd
C                                                                       00062310
      DO 100 I = 1, NSRECS                                              00062320
        II = KKPOIN + ( (I - 1) * NOKK )
cmam    II = KKPOIN + ( (I - 1) * NOBIN )                               00062330
cmam	call savew(ix,'RecNum',i,1)
	call savew2(nlh,j_RecNum,i_RecNum,l_RecNum,i,1)
C                                                                       00062350
        DO 50 J = 1, NOLI                                               00062360
          NSTART = II + ( (J - 1) * NODI )                              00062370
cmam      CALL MOVE ( 1, IX(129), XX(NSTART), N4NODI )                  00062380
          CALL MOVE ( 1, IX(ITHWP1), XX(NSTART), N4NODI )
cmam	call savew(ix,'TrcNum',j,1)
	call savew2(nlh,j_TrcNum,i_TrcNum,l_TrcNum,j,1)
          CALL WRTAPE ( LUOSLA, IX, NBYTES )                            00062400
   50   CONTINUE                                                        00062410
        CALL RIPRNT ( I, LUPRNT )                                       00062420
C                                                                       00062430
  100 CONTINUE                                                          00062440
C                                                                       00062450
      CALL RICLR ( LUPRNT )                                             00062460
      CALL LBCLOS ( LUOSLA )                                            00062470
      WRITE ( LUPRNT, 1002 ) NSRECS, NOLI, NODI                         00062480
 1002 FORMAT ( ////, '0THIS TAPE CONTAINS ', I1, ' RECORDS (ONE FOR ',  00062490
     *               'EACH SOLUTION ARRAY), ', I4, ' TRACES/RECORD', /, 00062500
     *               1X, I4, ' SAMPLES/TRACE.  THE PSEUDO SAMPLE ',     00062510
     *               'INTERVAL IS 4 MSEC.', /, ' THESE ARRAYS ',        00062520
     *               '(RECORDS) CAN BE PLOTTED ANALAGOUSLY TO TIME ',   00062530
     *               'SLICES TO ANALYZE THE QUALITY OF THE STATICS ',   00062540
     *               'SOLUTION' )                                       00062550
C                                                                       00062560
      RETURN                                                            00062570
      END                                                               00062580
C***********************************************************************00057230
C***********************************************************************00057240
C***********************************************************************00057250
C***********************************************************************00057260
C***********************************************************************00057270
      SUBROUTINE PRNSOL ( XX )                                          00057280
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00057290
C***********************************************************************00057300
C                                                                      *00057310
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00057340
C***********************************************************************00057350
C  ROUTINE:       PRNSOL                                                00057360
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00057370
C  PURPOSE:                                                             00057380
C      PRINT OUT SOLUTION VECTORS.                                      00057390
C  CALLING PARAMETERS: SUBROUTINE PRNSOL ( XX )                         00057400
C  ARGUMENTS:                                                           00057410
C      NAME                           DESCRIPTION                       00057420
C      XX      R*4     PASSED         SOLUTION VECTOR WITH LENGTH OF    00057430
C  CATEGORY:  SPECIFIC                                                  00057440
C       +------------------------------------------------------+        00057450
C       |               DEVELOPMENT INFORMATION                |        00057460
C       +------------------------------------------------------+        00057470
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 28, 1987              00057480
C  LANGUAGE:  FORTRAN 77                                                00057490
C       +------------------------------------------------------+        00057500
C       |                 EXTERNAL ENVIRONMENT                 |        00057510
C       +------------------------------------------------------+        00057520
C  EXTERNAL REFERENCES:                                                 00057530
C      NONE                                                             00057540
C  ROUTINES CALLED:                                                     00057550
C      NONE                                                             00057560
C  COMMON:                                                              00057570
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00057580
C                      BY MAIN PROGRAM.                                 00057590
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00057600
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00057610
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00057620
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00057630
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00057640
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00057650
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00057660
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00057670
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00057680
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00057690
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00057700
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00057710
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00057720
C                      SET BY MAIN PROGRAM.                             00057730
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00057740
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00057750
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00057760
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00057770
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00057780
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00057790
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00057800
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00057810
C                        NOKK   - NO. OF BINS                           00057820
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00057830
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00057840
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00057850
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00057860
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00057870
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00057880
C                        MNLI   - MINIMUM LINE (LI) INDEX               00057890
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00057900
C                        NOLI   - NO. OF LINE (LI) INDEXES              00057910
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00057920
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00057930
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00057940
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00057950
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00057960
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00057970
C                                     (0=YES, 1=NO)                     00057980
C                        MODEFG - MODE OF SOLUTION FLAG                 00057990
C                                     (1  --  I + R = T                )00058000
C                                     (2  --  I + R + C + M = T        )00058010
C                                     (3  --  I + R + C + M + E + F = T)00058020
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00058030
C                                     (0=YES, 1=NO)                     00058040
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00058050
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00058060
C                                     ALL RNMO TERMS                    00058070
C                                                                       00058080
C  ERROR RETURNS:  NONE.                                                00058090
C                                                                       00058100
C*******************   END OF DOCUMENTATION PACKAGE   ******************00058110
C***********************************************************************00058120
C                                                                       00058130
C                                                                       00058140
C                                                                       00058150
      REAL*4      XX(*)                                                 00058160
C                                                                       00058170
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,LUPRNT,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00058190
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00058200
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00058210
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00058220
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00058230
C                                                                       00058240
C***********************************************************************00058250
C*   PRINT OUT SOLUTION VECTORS.                                       *00058260
C***********************************************************************00058270
C                                                                       00058280
      WRITE ( LUPRNT, 1000 ) MINIS                                      00058290
 1000 FORMAT ( ///, 15X, 'SOURCE STATICS SOLUTION VECTOR (MSEC) ',      00058300
     *               'STARTING AT SOURCEPOINT (PRI) INDEX = ', I7,      00058310
     *         /, 15X, 83('-') )                                        00058320
C                                                                       00058330
      NSTOP = ISPOIN + NOIS - 1                                         00058340
      WRITE ( LUPRNT, 1001 ) ( XX(N), N = ISPOIN, NSTOP )               00058350
 1001 FORMAT ( 5X, 10F10.1 )                                            00058360
      WRITE ( LUPRNT, 1002 ) MINJR                                      00058370
 1002 FORMAT ( ///, 19X, 'GROUP STATICS SOLUTION VECTOR (MSEC) STARTI', 00058380
     *               'NG AT GROUP (GI) INDEX = ', I7, /, 19X, 75('-') ) 00058390
C                                                                       00058400
      NSTOP = JRPOIN + NOJR - 1                                         00058410
      WRITE ( LUPRNT, 1001 ) ( XX(N), N = JRPOIN, NSTOP )               00058420
C                                                                       00058430
      IF ( MODEFG .GT. 1 ) THEN                                         00058440
        WRITE ( LUPRNT, 1003 ) MNLI, MNDI, NODI                         00058450
 1003   FORMAT ( ///, 12X, 'STRUCTURE SOLUTION VECTOR (MSEC) STARTING ',00058460
     *                 'AT LINE (LI) INDEX = ', I4, ', DEPTH (DI) ',    00058470
     *                 'INDEX = ', I4, ',', /, 12X, 'AND PROGRESSING ', 00058480
     *                 'WITH ', I4, ' BINS/LINE:', /, 12X, 93('-') )    00058490
C                                                                       00058500
        NSTOP = KCPOIN + NOKK - 1                                       00058510
        WRITE ( LUPRNT, 1001 ) ( XX(N), N = KCPOIN, NSTOP )             00058520
        WRITE ( LUPRNT, 1004 ) MNLI, MNDI, NODI                         00058530
 1004   FORMAT ( ///, 12X, '2-D RNMO SOLUTION VECTOR (MSEC) STARTING ', 00058540
     *                 'AT LINE (LI) INDEX = ', I4, ', DEPTH (DI) ',    00058550
     *                 'INDEX = ', I4, ',', /, 12X, 'AND PROGRESSING ', 00058560
     *                 'WITH ', I4, ' BINS/LINE:', /, 12X, 92('-') )    00058570
C                                                                       00058580
        NSTOP = KMPOIN + NOKK - 1                                       00058590
        WRITE ( LUPRNT, 1001 ) (XX(N), N = KMPOIN, NSTOP )              00058600
C                                                                       00058610
        IF ( MODEFG .EQ. 3 ) THEN                                       00058620
          WRITE ( LUPRNT, 1005 ) MNLI, MNDI, NODI                       00058630
 1005     FORMAT ( ///, 12X, '3-D SINE RNMO SOLUTION VECTOR (MSEC) ',   00058640
     *                  'STARTING AT LINE (LI) INDEX = ', I4,           00058650
     *                   ', DEPTH (DI) INDEX = ', I4, ',', /, 12X,      00058660
     *                   'AND PROGRESSING WITH ', I4, ' BINS/LINE:', /, 00058670
     *                   12X, 92('-') )                                 00058680
C                                                                       00058690
          NSTOP = KEPOIN + NOKK - 1                                     00058700
          WRITE ( LUPRNT, 1001 ) ( XX(N), N = KEPOIN, NSTOP )           00058710
          WRITE ( LUPRNT, 1006 ) MNLI, MNDI, NODI                       00058720
 1006     FORMAT ( ///, 12X, '3-D COSINE RNMO SOLUTION VECTOR (MSEC) ', 00058730
     *                   'STARTING AT LINE (LI) INDEX = ', I4,          00058740
     *                   ', DEPTH (DI) INDEX = ', I4, /, 12X,           00058750
     *                   'AND PROGRESSING WITH ', I4, ' BINS/LINE:', /, 00058760
     *                   12X, 92('-') )                                 00058770
C                                                                       00058780
          NSTOP = KFPOIN + NOKK - 1                                     00058790
          WRITE ( LUPRNT, 1001 ) ( XX(N), N = KFPOIN, NSTOP )           00058800
        END IF                                                          00058810
      END IF                                                            00058820
C                                                                       00058830
      RETURN                                                            00058840
      END                                                               00058850
C***********************************************************************00058860
C***********************************************************************00058870
C***********************************************************************00058880
C***********************************************************************00058890
C***********************************************************************00058900
cmam....added amplitude option.....10-26-95
      SUBROUTINE PUNCRD ( XX, nodsco, otap, ampopt )
cmam  SUBROUTINE PUNCRD ( XX, nodsco, otap )
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00058920
C***********************************************************************00058930
C                                                                      *00058940
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00058970
C***********************************************************************00058980
C  ROUTINE:       PUNCRD                                                00058990
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00059000
C  PURPOSE:                                                             00059010
C      PRINT AND, IF REQUESTED, PUNCH 8STAT AND 9CORR CARDS.            00059020
C  CALLING PARAMETERS: SUBROUTINE PUNCRD ( XX, NPNSFG )                 00059030
C  ARGUMENTS:                                                           00059040
C      NAME                           DESCRIPTION                       00059050
C      XX      R*4     PASSED         SOLUTION VECTOR WITH LENGTH OF    00059060
C      NPNSFG  I*4     PASSED         PUNCH STATICS FLAG.               00059070
C                                      0 = YES                          00059080
C                                      1 = NO                           00059090
cmam    nodsco  logical    input          output Disco SHT-STAT/REC-STAT cards
cmam                                    F=no
cmam                                    T=yes
cmam    otap  ch*100   input          output dataset filename to contain
cmam                                    8STAT/9CORR images.  If disco
cmam                                    format is requested, an output
cmam                                    file <otap>.disco will be also
cmam                                    be written.
C  CATEGORY:  SPECIFIC                                                  00059100
C       +------------------------------------------------------+        00059110
C       |               DEVELOPMENT INFORMATION                |        00059120
C       +------------------------------------------------------+        00059130
C  AUTHOR:    STEVEN AUTRY        DATE:   JANUARY 28, 1987              00059140
C  LANGUAGE:  FORTRAN 77                                                00059150
C       +------------------------------------------------------+        00059160
C       |                 EXTERNAL ENVIRONMENT                 |        00059170
C       +------------------------------------------------------+        00059180
C  EXTERNAL REFERENCES:                                                 00059190
C      NONE                                                             00059200
C  ROUTINES CALLED:                                                     00059210
C      NONE                                                             00059220
C  COMMON:                                                              00059230
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00059240
C                      BY MAIN PROGRAM.                                 00059250
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00059260
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00059270
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00059280
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00059290
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00059300
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00059310
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00059320
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00059330
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00059340
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00059350
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00059360
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00059370
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00059380
C                      SET BY MAIN PROGRAM.                             00059390
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00059400
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00059410
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00059420
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00059430
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00059440
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00059450
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00059460
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00059470
C                        NOKK   - NO. OF BINS                           00059480
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00059490
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00059500
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00059510
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00059520
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00059530
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00059540
C                        MNLI   - MINIMUM LINE (LI) INDEX               00059550
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00059560
C                        NOLI   - NO. OF LINE (LI) INDEXES              00059570
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00059580
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00059590
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00059600
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00059610
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00059620
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00059630
C                                     (0=YES, 1=NO)                     00059640
C                        MODEFG - MODE OF SOLUTION FLAG                 00059650
C                                     (1  --  I + R = T                )00059660
C                                     (2  --  I + R + C + M = T        )00059670
C                                     (3  --  I + R + C + M + E + F = T)00059680
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00059690
C                                     (0=YES, 1=NO)                     00059700
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00059710
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00059720
C                                     ALL RNMO TERMS                    00059730
C                                                                       00059740
C  ERROR RETURNS:  NONE.                                                00059750
C                                                                       00059760
C*******************   END OF DOCUMENTATION PACKAGE   ******************00059770
C***********************************************************************00059780
C                                                                       00059790
C                                                                       00059800
C                                                                       00059810
cmam....added amplitude option.....10-26-95
	logical ampopt
cmam...............
	character*100 dscofl, otap
	logical nodsco, iosis, iodsco
	integer ltap,ldtap,ludsco
cmam	integer ltap,lotap,ludsco
cmam...............
      REAL*4       XX(*)                                                00059820
C                                                                       00059830
      CHARACTER*1  CARDC(80)                                            00059840
C                                                                       00059850
      CHARACTER*7  NPSTAT(8)                                            00059860
	character*8 dscost(2)
	character*8 ampl1
	character*16 ampl2
C                                                                       00059870
      CHARACTER*80 CARD                                                 00059880
C                                                                       00059890
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,LUPRNT,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00059910
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00059920
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00059930
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00059940
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00059950
C                                                                       00059960
      EQUIVALENCE ( CARD(7:62), NPSTAT(1) ), ( CARDC(1), CARD )         00059970
	equivalence (card(9:24), dscost(1) )
	equivalence (card(9:16),ampl1),(card(17:32),ampl2)
C                                                                       00059980
      DATA CARDC / 80*' ' /                                             00059990
C                                                                       00060000
C***********************************************************************00060010
C*   INITIALIZE SOME VARIABLES.                                        *00060020
C***********************************************************************00060030
C                                                                       00060040
      NGI = MINJR                                                       00060050
      NPRI = MINIS                                                      00060060
C                                                                       00060070
C***********************************************************************00060080
C*   PRINT OUT 8STAT CARD IMAGES TO LUPRNT AND IF THE PUNCH FLAG IS SET*00060090
C* TO ON THEN OUTPUT 8STAT CARDS TO LUSTAT.                            *00060100
C***********************************************************************00060110
C                                                                       00060120
	if(nodsco) write(luprnt,*)'...NOTE:disco output requested'
	iosis = .false.
	iodsco = .false.
      CARD(1:5) = '8STAT'                                               00060130
cmam...............
c open output otap.sis file if SIS output is requested
cmam...10-26-95....open the output file regardless of output option
 
        if ( otap .ne. ' ' ) then
            ltap = lenth(otap)
           open ( unit = luotap, file = otap(1:ltap),
     :        status = 'unknown', iostat = ierr )
           if(ierr .ne. 0) then
              write(LERR,*)'SC3D: Could not open output output file ',
     :           otap(1:ltap)
              write(LERR,*)'       Check write permissions in output '
              write(LERR,*)'        directory'
            write(LERR,*)'FATAL'
            stop
           endif
	endif
 
	write(luprnt,*)'...NOTE:otap,luotap=',otap,luotap

C                                                                       00060140
	if(ampopt) then
cmam....amplitude option specified
	write(LUPRNT,2000)
 2000	format (////,20x,'Amplitude Scalar for shots',
     *          //,20x,'card id ','sta.no. ','scalar(log)',/,
     *             20x,'xxxxxxxx','nnnnnnnn','ssssssssssssssss',/,20x,
     *          '         1         2         3  ',/,20x,
     *          '----+----0----+----0----+----0--',//)
        nstop = ispoin + nois - 1
        write(luprnt,2010)(minis+nsp-ispoin,xx(nsp),nsp=ispoin,nstop)
 2010   format(20x,'SHT-AMPL',i8,e16.8,48x)
        write(luprnt,2020)
 2020   format (////,20x,'Amplitude Scalar for receivers',
     *          //,20x,'card id ','rec.no. ','scalar(log)',/,
     *             20x,'xxxxxxxx','nnnnnnnn','ssssssssssssssss',/,20x,
     *          '         1         2         3  ',/,20x,
     *          '----+----0----+----0----+----0--',//)
        nstop = jrpoin + nojr - 1
        write(luprnt,2030)(minjr+ngp-jrpoin,xx(ngp),ngp=jrpoin,nstop)
 2030   format(20x,'REC-AMPL',i8,e16.8,48x)
cmam............here we write the amplitude scalar card images........
          card(1:8) = 'SHT-AMPL'
          call move (2, cardc(9),0,72)
          nstop = ispoin + nois - 1
          ival = minis
          do 2050 i = ispoin,nstop
cmam...put the incrementing of ival here
          write(ampl1,2040) ival
 2040     format (i8)
          write(ampl2,2045) xx(i)
 2045     format (e16.8)
          write(luotap,1002) card
          ival = ival + 1
 2050     continue
cmam
          card(1:8) = 'REC-AMPL'
          nstop = jrpoin + nojr - 1
          ival = minjr
          do 2060 i = jrpoin,nstop
          write(ampl1,2040) ival
          write(ampl2,2045) xx(i)
          write(luotap,1002) card
          ival = ival + 1
 2060     continue
          endfile luotap
	write(LUPRNT,*)' finished writing amplitude scalar cards'
cmam.....................................................10-26-95
	else
      WRITE ( LUPRNT, 1000 )                                            00060150
 1000 FORMAT ( ///, 26X, '8STAT AND 9CORR STATICS CARD IMAGES:', /,     00060160
     *              12X, '(NOTE:  IMPLIED DECIMAL BETWEEN CC 11-12, ',  00060170
     *                   'CC 18-19, ..., CC 60-61)', //,  5X,           00060180
     *         '         1         2         3         4         5',    00060190
     *         '         6         7         8', /,  5X,                00060200
     *         8('----+----0') )                                        00060210
C                                                                       00060220
      DO 100 NSTART = JRPOIN, KKPOIN, 8                                 00060230
        CALL MOVE ( 2, NPSTAT(2), 0, 52 )                               00060240
        WRITE ( CARD(76:80), 20 ) NGI                                   00060250
  20    FORMAT ( I5 )                                                   00060260
C                                                                       00060270
        DO 50 N = 1, 8                                                  00060280
          NN = NSTART + N - 1                                           00060290
          IF ( NN .EQ. KKPOIN ) THEN                                    00060300
            NPSTAT(N) = '9999900'                                       00060310
            GOTO 60                                                     00060320
          END IF                                                        00060330
          IPSTAT = 100.0 * XX(NN) + SIGN( 0.5, XX(NN) )                 00060340
          WRITE ( NPSTAT(N), 30 ) IPSTAT                                00060350
  30      FORMAT ( I7 )                                                 00060360
  50    CONTINUE                                                        00060370
C                                                                       00060380
  60    CONTINUE                                                        00060390
C                                                                       00060400
        WRITE ( LUPRNT, 1001 ) CARD                                     00060410
 1001   FORMAT (  5X, A )                                               00060420
c1001   FORMAT ( 25X, A )                                               00060420
	write(luotap,1002) card
 1002   FORMAT ( A )                                                    00060440
C                                                                       00060450
        NGI = NGI + 8                                                   00060460
  100 CONTINUE                                                          00060470
C                                                                       00060480
C***********************************************************************00060490
C*   PRINT OUT 9CORR CARD IMAGES TO LUPRNT AND IF THE PUNCH FLAG IS SET*00060500
C* TO ON THEN OUTPUT 9CORR CARDS TO LUSTAT.                            *00060510
C***********************************************************************00060520
C                                                                       00060530
      CARD(1:5) = '9CORR'                                               00060540
C                                                                       00060550
      DO 200 NSTART = ISPOIN, JRPOIN, 8                                 00060560
        CALL MOVE ( 2, NPSTAT(2), 0, 52 )                               00060570
        WRITE ( CARD(76:80), 20 ) NPRI                                  00060580
C                                                                       00060590
        DO 150 N = 1, 8                                                 00060600
          NN = NSTART + N - 1                                           00060610
          IF ( NN .EQ. JRPOIN ) THEN                                    00060620
            NPSTAT(N) = '9999900'                                       00060630
            GOTO 160                                                    00060640
          END IF                                                        00060650
          IPSTAT = 100.0 * XX(NN) + SIGN( 0.5, XX(NN) )                 00060660
          WRITE ( NPSTAT(N), 30 ) IPSTAT                                00060670
 150    CONTINUE                                                        00060680
C                                                                       00060690
 160    CONTINUE                                                        00060700
C                                                                       00060710
        WRITE ( LUPRNT, 1001 ) CARD                                     00060720
	write(luotap,1002) card
C                                                                       00060740
        NPRI = NPRI + 8                                                 00060750
  200 CONTINUE                                                          00060760
      WRITE ( LUPRNT, 1003 )                                            00060770
 1003 FORMAT ( //, '0     ' )                                           00060780
	endfile luotap
	write(luprnt,*)'finished writing sis format cards'
	endif
cmam.....10-26-95
cmam     open output otap.disco file if Disco output is requested
 
	write(luprnt,*)'nodsco=',nodsco
        if(nodsco) then
	write(luprnt,*)'....WRITING DISCO FORMAT'
          iodsco = .true.
          ludsco = 83
 
          if ( otap .ne. ' ' ) then
            dscofl = otap
	    ldtap = lenth(otap) + 1
	    ldtap2 = ldtap + 5
	    dscofl(ldtap:ldtap2) = '.disco'
cmam        dscofl = 'sc3d.disco'
  	else
	    dscofl = 'sc3d.disco.cards'
	 endif
           ldtap = lenth(dscofl)
           call alloclun ( ludsco )
cmam       open ( unit = ludsco, file = dscofl(1:lotap),
           open ( unit = ludsco, file = dscofl(1:ldtap),
     :        status = 'unknown', iostat = ierr )
           if(ierr .ne. 0) then
              write(LERR,*)'SC3D: Could not open output .disco file ',
     :           dscofl(1:ldtap)
              write(LERR,*)'       Check write permissions in output '
              write(LERR,*)'        directory'
            iodsco = .false.
           endif
 
        endif
	write(luprnt,*)'dscofl,ludsco=',dscofl,ludsco
cmam		print out disco formatted statics for shot and receivers
cmam
	write(luprnt,4000)
 4000	format (///////,20x,'Disco-format statics for shots',
     *		//,20x,'card id ','sta.no. ','stat(ms)',/,
     *	 	   20x,'xxxxxxxx','nnnnnnnn','ssssssss',/,20x,
     *		'         1         2    ',/,20x,
     *		'----+----0----+----0----',//)
	nstop = ispoin + nois - 1
	write(luprnt,4010)(minis+nsp-ispoin,xx(nsp),nsp=ispoin,nstop)
cmam......changed format to match the file output  format
 4010	format(20x,'SHT-STAT',i8,f8.2,56x)
cmam....... 4010	format(20x,'SHT-STAT',i8,f8.1,56x)
        write(luprnt,4000)
 4020   format (////,20x,'Disco-format statics for receivers',
     *		//,20x,'card id ,''sta.no. ','stat(ms)',/,
     *	 	   20x,'xxxxxxxx','nnnnnnnn','ssssssss',/,20x,
     *		'         1         2    ',/,20x,
     *		'----+----0----+----0----',//)
	nstop = jrpoin + nojr - 1
        write(luprnt,4030)(minjr+ngp-jrpoin,xx(ngp),ngp=jrpoin,nstop)
 4030	format(20x,'REC-STAT',i8,f8.1,56x)
cmam......changed format to match the file output  format
cmam.....4030	format(20x,'REC-STAT',i8,f8.2,56x)
	if (iodsco) then
cmam............here we write the disco card images........
	  card(1:8) = 'SHT-STAT'
	  call move (2, cardc(9),0,72)
	  nstop = ispoin + nois - 1
cmam......ival = minis+i-ispoin
cmam,,,,  ival = minis-ispoin
	  ival = minis
	  do 4050 i = ispoin,nstop
cmam...put the incrementing of ival here
cmam,,,,  ival = ival + 1
	  write(dscost(1),4040) ival
 4040	  format (i8)
	  write(dscost(2),4045) xx(i)
 4045	  format (f8.2)
 	  write(ludsco,1002) card
	  ival = ival + 1
 4050	  continue
cmam
	  card(1:8) = 'REC-STAT'
	  nstop = jrpoin + nojr - 1
cmam,,,,  ival = minjr+i-jrpoin
	  ival = minjr
cmam//////ival = minjr-jrpoin
          do 4060 i = jrpoin,nstop
cmam...put the incrementing of ival here
cmam.......ival = ival + 1
          write(dscost(1),4040) ival
          write(dscost(2),4045) xx(i)
          write(ludsco,1002) card
	  ival = ival + 1
 4060     continue
	  endfile ludsco
	endif
cmam
      RETURN                                                            00060800
      END                                                               00060810
C***********************************************************************00034770
C***********************************************************************00034780
C***********************************************************************00034790
C***********************************************************************00034800
C***********************************************************************00034810
      SUBROUTINE GAUS3C (BB, BNO, XX, WA, NITER,x2d)
cmam  SUBROUTINE GAUS3C (BB, BNO, XX, WA, NITER)                        00034820
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00034830
C***********************************************************************00034840
C                                                                      *00034850
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00034880
C***********************************************************************00034890
C  ROUTINE:       GAUS3C                                                00034900
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00034910
C  PURPOSE:                                                             00034920
C      GIVEN EVENT PARAMETERS AND TIME PICKS AS DATA BLOCKS ON DISK AND 00034930
C      CONTROL POINTERS IN COMMON/POINT3/, THIS SUBROUTINE SOLVES THE   00034940
C      3-D SURFACE-CONSISTENT STATICS EQUATIONS BY A GAUSS-SEIDEL       00034950
C      ITERATIVE METHOD.                                                00034960
C  CALLING PARAMETERS: SUBROUTINE GAUS3C (BB, BNO, XX, WA, NITER)       00034970
C  ARGUMENTS:                                                           00034980
C      NAME                    LENGTH   DESCRIPTION                     00034990
C      BB      R*4  *  ( 1 )   NOKK     PARTITION OF RIGHT-HAND-SIDE    00035000
C                                       OF LMSE MATRIX.  ITS LENGTH NOKK00035010
C                                       IS IN COMMON/POINT3/.           00035020
C      BNO     R*4  *  ( 1 )   NOKK     PARTITION OF MAIN DIAGONAL OF   00035030
C                                       LMSE MATRIX.                    00035040
C      XX      R*4  O  ( 1 )   NOSRK    SOLUTION VECTOR RETURNED BY THIS00035050
C                                       SUBROUTINE.  IT SHOULD BE SET TO00035060
C                                       ZERO BEFORE THE FIRST CALL OF   00035070
C                                       THIS SUBROUTINE.  IF NOT SET TO 00035080
C                                       ZERO, VALUES IN THE XX ARRAY    00035090
C                                       WILL BE USED TO COMPUTE THE     00035100
C                                       RESIDUAL.  ITS LENGTH NOSRK IS  00035110
C                                       IN COMMON/POINT3/.              00035120
C      WA      R*4  *  ( 1 )   NOKK     AUXILIARY ARRAY FOR PARTITION OF00035130
C                                       PRODUCT OF LMSE MATRIX WITH     00035140
C                                       SOLUTION VECTOR.                00035150
C      NITER   I*4  I          1        NUMBER OF ITERATIONS.           00035160
C  CATEGORY:  SPECIFIC                                                  00035170
C  KEYWORDS:  GAUSS-SEIDEL, STATICS                                     00035180
C       +------------------------------------------------------+        00035190
C       |               DEVELOPMENT INFORMATION                |        00035200
C       +------------------------------------------------------+        00035210
C  AUTHOR:    GARY RUCKGABER                  ORIGIN DATE:  84/08/09    00035220
C  LANGUAGE:  FORTRAN IV                                                00035230
C       +------------------------------------------------------+        00035240
C       |                 EXTERNAL ENVIRONMENT                 |        00035250
C       +------------------------------------------------------+        00035260
C  EXTERNAL REFERENCES:                                                 00035270
C      READ DATA BLOCKS FROM DISK.                                      00035280
C  ROUTINES CALLED:                                                     00035290
C      DAREAD   -      READ DATA BLOCK FROM DISK.                       00035300
C      MOVE     -      MOVE ARRAYS.                                     00035310
C  COMMON:                                                              00035320
C      FILCON  (  * )  PARAMETERS FOR TWO TEMPORARY DISK AREAS SET BY   00035330
C                      MAIN PROGRAM.                                    00035340
C                        NWPEA  - NO. OF WORDS PER EVENT IN DISK A      00035350
C                        NEPBA  - NO. OF EVENTS PER BLOCK IN DISK A     00035360
C                        NWPBA  - NO. OF WORDS PER BLOCK IN DISK A      00035370
C                        NBPBA  - NO. OF BYTES PER BLOCK IN DISK A      00035380
C                        NBLKSA - NO. OF BLOCKS IN DISK A               00035390
C                        NEVNTS - NO. OF ACCEPTABLE EVENTS IN DISK A    00035400
C                        NWPCB  - NO. OF WORDS PER COORDINATE IN DISK B 00035410
C                        NCPBB  - NO. OF COORDINATES PER BLOCK IN DISK B00035420
C                        NWPBB  - NO. OF WORDS PER BLOCK IN DISK B      00035430
C                        NBPBB  - NO. OF BYTES PER BLOCK IN DISK B      00035440
C                        NBLKSB - NO. OF BLOCKS IN DISK B               00035450
C                        NCORDS - NO. OF COORDINATES IN DISK B          00035460
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00035470
C                      BY MAIN PROGRAM.                                 00035480
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00035490
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00035500
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00035510
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00035520
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00035530
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00035540
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00035550
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00035560
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00035570
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00035580
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00035590
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00035600
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00035610
C                      SET BY MAIN PROGRAM.                             00035620
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00035630
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00035640
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00035650
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00035660
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00035670
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00035680
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00035690
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00035700
C                        NOKK   - NO. OF BINS                           00035710
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00035720
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00035730
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00035740
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00035750
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00035760
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00035770
C                        MNLI   - MINIMUM LINE (LI) INDEX               00035780
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00035790
C                        NOLI   - NO. OF LINE (LI) INDEXES              00035800
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00035810
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00035820
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00035830
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00035840
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00035850
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00035860
C                                     (0=YES, 1=NO)                     00035870
C                        MODEFG - MODE OF SOLUTION FLAG                 00035880
C                                     (1  --  I + R = T                )00035890
C                                     (2  --  I + R + C + M = T        )00035900
C                                     (3  --  I + R + C + M + E + F = T)00035910
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00035920
C                                     (0=YES, 1=NO)                     00035930
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00035940
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00035950
C                                     ALL RNMO TERMS                    00035960
C      STAFL3  (  * )  ARRAYS FOR DATA FROM EVENT TAPE.                 00035970
C                        TIJ    - ARRAY FOR PRIMARY PICKS               00035980
C                        TIJM   - ARRAY FOR ALTERNATE PICK (LT PRIMARY) 00035990
C                        TIJX   - ARRAY FOR ALTERNATE PICK (GT PRIMARY) 00036000
C                        COR    - ARRAY FOR SQUARE OF WEIGHTS           00036010
C                        CORM   - ARRAY FOR SQ. OF ALT. WEIGHT (LT PRI.)00036020
C                        CORX   - ARRAY FOR SQ. OF ALT. WEIGHT (GT PRI.)00036030
C                        ISPOS  - ARRAY FOR SOURCEPOINT (PRI) POINTERS  00036040
C                        JRPOS  - ARRAY FOR GROUP (GI) POINTERS         00036050
C                        KKPOS  - ARRAY FOR BIN POINTERS                00036060
C                        XOF    - ARRAY FOR SQUARE OF OFFSETS           00036070
C                        XOFSIN - ARRAY FOR (XOF**2)*SIN(AZIMUTH)       00036080
C                        XOFCOS - ARRAY FOR (XOF**2)*COS(AZIMUTH)       00036090
C       +------------------------------------------------------+        00036100
C       |             OTHER DOCUMENTATION DETAILS              |        00036110
C       +------------------------------------------------------+        00036120
C  GENERAL DESCRIPTION:                                                 00036130
C      THIS SUBROUTINE DETERMINES SURFACE-CONSISTENT STATICS USING A    00036140
C      GAUSS-SEIDEL ITERATIVE METHOD ON THE NORMAL EQUATIONS RESULTING  00036150
C      FROM A LEAST-MEAN-SQUARE-ERROR FORMULATION OF THE PARTICULAR     00036160
C      STATICS MODEL SELECTED.  THE STATICS MODELS ARE:                 00036170
C                                                                       00036180
C                MODE 1  --  I + R = T,                                 00036190
C                MODE 2  --  I + R + C + M = T,                         00036200
C                MODE 3  --  I + R + C + M + E + F = T,                 00036210
C                                                                       00036220
C      WHERE I IS THE SOURCEPOINT STATIC VECTOR, R IS THE GROUP STATIC  00036230
C      VECTOR, C IS THE STRUCTURAL ERROR VECTOR, M IS THE 2-D RNMO ERROR00036240
C      VECTOR, E IS THE 3-D SINE RNMO ERROR VECTOR, F IS THE 3-D COSINE 00036250
C      RNMO ERROR VECTOR, AND T REPRESENTS THE TIME DIFFERENTIALS PICKED00036260
C      BY PROGRAM PICK.  MODE 3 IS THE FULL 3-D MODEL, MODE 2 IS THE 2-D00036270
C      MODEL, AND MODE 1 IS A LESSOR (APPROXIMATE) MODEL THAT IS MORE   00036280
C      ECONOMICAL THAN MODES 2 AND 3.                                   00036290
C                                                                       00036300
C      IN COMPUTING THE LMSE MATRIX, EACH STATIC EQUATION IS OPTIONALLY 00036310
C      WEIGHTED BY ITS PICK WEIGHT.  THE LMSE MATRIX AND SOLUTION VECTOR00036320
C      ARE AUTOMATICALLY PARTITIONED IN SEGMENTS CORRESPONDING TO THE I,00036330
C      R, C, M, E, AND F TERMS ACCORDING TO THE MODE OF SOLUTION AND    00036340
C      PARAMETERS IN COMMON/POINT3/.  FOR THE SOLUTION VECTOR XX,       00036350
C      XX(ISPOIN) CORRESPONDS TO THE FIRST SOURCEPOINT STATIC TERM AND  00036360
C      THERE ARE NOIS SOURCEPOINTS, SO LOCATIONS THROUGH                00036370
C      XX(ISPOIN + NOIS - 1) CONTAIN THE SOURCEPOINT TERMS.             00036380
C      XX(JRPOIN) CORRESPONDS TO THE FIRST GROUP TERM, AND THERE ARE    00036390
C      NOJR GROUP TERMS.                                                00036400
C      DEPENDING ON THE MODE OF SOLUTION, THE STRUCTURE, 2-D RNMO, 3-D  00036410
C      SINE RNMO, AND 3-D COSINE RNMO VECTORS MAY OR MAY NOT BE PRESENT:00036420
C           XX(KCPOIN) IS THE FIRST OF THE NOKK STRUCTURE TERMS,        00036430
C           XX(KMPOIN) IS THE FIRST OF THE NOKK 2-D RNMO TERMS,         00036440
C           XX(KEPOIN) IS THE FIRST OF THE NOKK 3-D SINE RNMO TERMS, AND00036450
C           XX(KFPOIN) IS THE FIRST OF THE NOKK 3-D COSINE RNMO TERMS.  00036460
C      THE MAIN DIAGONAL AND RHS OF THE LMSE MATRIX AND THE PRODUCT OF  00036470
C      THE LMSE MATRIX WITH THE CURRENT SOLUTION VECTOR ARE SIMILIARLY  00036480
C      PARTITIONED.  HOWEVER, FOR THESE THREE LATTER VECTORS ONLY THE   00036490
C      PARTITION CURRENTLY NEEDED ARE STORED IN CORE.                   00036500
C                                                                       00036510
C      FIRST, THE I SOLUTION IS UPDATED (STARTING FROM INITIAL VALUES OF00036520
C      ZERO), THEN THE R SOLUTION, THEN C, THEN M, ETC.  AS EACH        00036530
C      PARTITION OF THE SOLUTION VECTOR IS BEING UPDATED, EVENT DATA IS 00036540
C      READ IN FROM DISK TO COMPUTE THE CURRENT PARTITION OF THE MAIN   00036550
C      DIAGONAL AND RHS OF THE LMSE MATRIX AND THE CURRENT PARTITION OF 00036560
C      THE PRODUCT OF THE LMSE MATRIX WITH THE LATEST SOLUTION VECTOR.  00036570
C      A SCALING FACTOR IS COMPUTED FOR DOWNWARD SCALING OF THE THREE   00036580
C      RNMO VECTORS RELATIVE TO THE I, R, AND C TERMS TO PREVENT        00036590
C      DOMINATION BY THE RNMO TERMS.  THE SOLUTION IS PREWHITENED BY    00036600
C      ADDING A SPECIFIED PERCENTAGE OF THE SOLUTION VECTOR TO THE MAIN 00036610
C      DIAGONAL OF THE LMSE MATRIX.  ALSO, THRESHHOLD LEVELS ARE        00036620
C      DETERMINED FOR EACH PARTITION.  IF A MAIN-DIAGONAL ELEMENT OF THE00036630
C      LMSE MATRIX DROPS BELOW THE THRESHOLD LEVEL FOR ITS PARTITION,   00036640
C      THEN THE ELEMENT IS SET EQUAL TO THE THRESHOLD LEVEL.  THIS      00036650
C      ADDITIONAL PREWHITENING PREVENTS INSTABILITIES FOR ELEMENTS      00036660
C      HAVING LOW MULTIPLICITY.  THE THRESHOLD LEVEL IN EACH PARTITION  00036670
C      IS EQUAL TO ONE-FOURTH OF THE AVERAGE MULTIPLICITY IN THAT       00036680
C      PARTITION.                                                       00036690
C                                                                       00036700
C      AFTER EACH OF THE SOLUTION VECTORS (2 TO 6 DEPENDING ON THE MODE)00036710
C      IS UPDATED, THE CYCLE IS REPEATED UNTIL NITER ITERATIONS ARE     00036720
C      COMPLETED.  UPON EXIT OF THE SUBROUTINE, THE SOLUTION RESIDES IN 00036730
C      VECTOR XX.  NORMALLY, XX IS INITIALIZED TO ZERO PRIOR TO CALLING 00036740
C      THIS SUBROUTINE.  IF NOT, THE SUBROUTINE WILL FURTHER REFINE THE 00036750
C      PREVIOUS SOLUTION CONTAINED IN VECTOR XX ON INPUT.               00036760
C                                                                       00036770
C      THIS SUBROUTINE IS CALLED BY THE MAIN PROGRAM ST3DE.  SEE ITS    00036780
C      INTERNAL DOCUMENTATION FOR FURTHER EXPLANATION.                  00036790
C                                                                       00036800
C  LIMITATIONS OF THE SUBROUTINE:                                       00036810
C      EACH ARRAY IN COMMON/STAFL3/ IS DIMENSIONED NEPBA.               00036820
C                                                                       00036830
C  ERROR RETURNS:  NONE                                                 00036840
C                                                                       00036850
C*******************   END OF DOCUMENTATION PACKAGE   ******************00036860
C***********************************************************************00036870
C                                                                       00036880
	logical x2d
C                                                                       00036890
      REAL*4 BB(*), BNO(*), XX(*), WA(*)                                00036900
C                                                                       00036910
      COMMON/FILCON/NWPEA,NEPBA,NWPBA,NBPBA,NBLKSA,NEVNTS,              00036920
     *              NWPCB,NCPBB,NWPBB,NBPBB,NBLKSB,NCORDS               00036930
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,luprnt,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00036960
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00036970
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00036980
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00036990
      COMMON/STAFL3/TIJ(680),TIJM(680),TIJX(680),COR(680),CORM(680),    00037000
     *              CORX(680),ISPOS(680),JRPOS(680),KKPOS(680),XOF(680),00037010
     *              XOFSIN(680),XOFCOS(680)                             00037020
C                                                                       00037030
      DATA ONE / 1.0 /                                                  00037040
C                                                                       00037050
C***********************************************************************00037060
C*   DEFINE PARAMETERS.                                                *00037070
C***********************************************************************00037080
C                                                                       00037090
      JRSHFT = NOIS                                                     00037100
      KCSHFT = JRSHFT + NOJR                                            00037110
      KMSHFT = KCSHFT + NOKK                                            00037120
      KESHFT = KMSHFT + NOKK                                            00037130
      KFSHFT = KESHFT + NOKK                                            00037140
C                                                                       00037150
C***********************************************************************00037160
C*   SCAN EVENT DATA TO SUM ELEMENTS OF MAIN DIAGONAL IN EACH PARTITION*00037170
C* FOR DETERMINATION OF THRESHOLD AND SCALING PARAMETERS.              *00037180
C***********************************************************************00037190
C                                                                       00037200
      SUMEV  = 0.0                                                      00037210
      SUMX4  = 0.0                                                      00037220
      SUMX4S = 0.0                                                      00037230
      SUMX4C = 0.0                                                      00037240
      NEVNTK = 0                                                        00037250
C                                                                       00037260
      DO 50 NB = 1, NBLKSA                                              00037270
        CALL DAREAD ( NB, TIJ, LUDSKA )                                 00037280
C                                                                       00037290
        DO 25 NN = 1, NEPBA                                             00037300
          IF ( NUPWFG .EQ. 0 ) ONE = COR(NN)                            00037310
          SUMEV = SUMEV + ONE                                           00037320
C                                                                       00037330
          IF ( MODEFG .GT. 1 ) THEN                                     00037340
            SUMX4 = SUMX4 + XOF(NN) * XOF(NN) * ONE                     00037350
            IF ( MODEFG .EQ. 3 ) THEN                                   00037360
              SUMX4S = SUMX4S + XOFSIN(NN) * XOFSIN(NN) * ONE           00037370
              SUMX4C = SUMX4C + XOFCOS(NN) * XOFCOS(NN) * ONE           00037380
            END IF                                                      00037390
          END IF                                                        00037400
C                                                                       00037410
          NEVNTK = NEVNTK + 1                                           00037420
          IF ( NEVNTK .EQ. NEVNTS ) GO TO 75                            00037430
C                                                                       00037440
   25   CONTINUE                                                        00037450
   50 CONTINUE                                                          00037460
C                                                                       00037470
C***********************************************************************00037480
C*   SCALE SIG TO PERCENT OF AVERAGE BIN FOLD.  DETERMINE THRESHOLD    *00037490
C* AND SCALING PARAMETERS FOR ALIMIS AND ALIMJR.                       *00037500
C***********************************************************************00037510
C                                                                       00037520
   75 CONTINUE                                                          00037530
      SIG = SIG * SUMEV * 0.01 / NOKK                                   00037540
      ALIMIS = 0.25 * SUMEV / NOIS                                      00037550
      ALIMJR = 0.25 * SUMEV / NOJR                                      00037560
	ibytes = szsmpd * nois
	jbytes = szsmpd * nojr
C                                                                       00037590
C***********************************************************************00037600
C*   START ITERATIVE SOLUTION USING RESIDUALS.                         *00037610
C***********************************************************************00037620
C                                                                       00037630
      GO TO ( 101, 201, 301 ), MODEFG                                   00037640
C                                                                       00037650
C***********************************************************************00037660
C*   ITERATIVE SOLUTION USING RESIDUALS FOR I+R=T SYSTEM.              *00037670
C*                                                                     *00037680
C*   COMPUTE SOURCE STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE *00037690
C* MATRIX.  COMPUTE SOURCE STATICS PARTITION OF PRODUCT OF LMSE MATRIX *00037700
C* WITH CURRENT SOLUTION VECTOR.                                       *00037710
C***********************************************************************00037720
C                                                                       00037730
  101 CONTINUE                                                          00037740
C                                                                       00037750
      DO 132 NI = 1, NITER                                              00037760
        CALL MOVE ( 0, BNO, 0, IBYTES )                                 00037770
        CALL MOVE ( 0, BB, 0, IBYTES )                                  00037780
        CALL MOVE ( 0, WA, 0, IBYTES )                                  00037790
        NEVNTK = 0                                                      00037800
        DO 114 NB = 1,NBLKSA                                            00037810
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00037820
          DO 113 NN = 1, NEPBA                                          00037830
            II = ISPOS(NN)                                              00037840
            JJ = JRPOS(NN)                                              00037850
            IF ( NUPWFG .EQ. 0 ) THEN                                   00037860
              BB(II) = BB(II) + TIJ(NN) * COR(NN)                       00037870
              BNO(II) = BNO(II) + COR(NN)                               00037880
              WA(II) = ( XX(II) + XX(JJ+JRSHFT) ) * COR(NN) + WA(II)    00037890
            ELSE                                                        00037900
              BB(II) = BB(II) + TIJ(NN)                                 00037910
              BNO(II) = BNO(II) + 1.0                                   00037920
              WA(II) = XX(II) + XX(JJ+JRSHFT) + WA(II)                  00037930
            END IF                                                      00037940
            NEVNTK = NEVNTK + 1                                         00037950
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 115                         00037960
  113     CONTINUE                                                      00037970
  114   CONTINUE                                                        00037980
C                                                                       00037990
C***********************************************************************00038000
C*   BOOST SOURCE STATICS TERMS IN MAIN DIAGONAL HAVING LOW            *00038010
C* MULTIPLICITY.  COMPUTE NEW SOURCE STATICS VECTOR.                   *00038020
C***********************************************************************00038030
C                                                                       00038040
  115   DO 116 I = 1, NOIS                                              00038050
          IF ( BNO(I) .GT. 0.0 ) THEN                                   00038060
            IF ( BNO(I) .LT. ALIMIS ) BNO(I) = ALIMIS                   00038070
            XX(I) = (BB(I) - (WA(I) + SIG * XX(I))) / (BNO(I) + SIG)    00038080
     *              + XX(I)                                             00038090
          END IF                                                        00038100
  116   CONTINUE                                                        00038110
C                                                                       00038120
C***********************************************************************00038130
C*   COMPUTE GROUP STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE  *00038140
C* MATRIX.  COMPUTE GROUP STATICS PARTITION OF PRODUCT OF LMSE MATRIX  *00038150
C* WITH CURRENT SOLUTION VECTOR.                                       *00038160
C***********************************************************************00038170
C                                                                       00038180
        CALL MOVE (0, BNO, 0, JBYTES)                                   00038190
        CALL MOVE (0, BB, 0, JBYTES)                                    00038200
        CALL MOVE (0, WA, 0, JBYTES)                                    00038210
        NEVNTK = 0                                                      00038220
        DO 124 NB = 1,NBLKSA                                            00038230
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00038240
          DO 123 NN = 1, NEPBA                                          00038250
            II = ISPOS(NN)                                              00038260
            JJ = JRPOS(NN)                                              00038270
            IF ( NUPWFG .EQ. 0 ) THEN                                   00038280
              BB(JJ) = BB(JJ) + TIJ(NN) * COR(NN)                       00038290
              BNO(JJ) = BNO(JJ) + COR(NN)                               00038300
              WA(JJ) = ( XX(II) + XX(JJ+JRSHFT) ) * COR(NN) + WA(JJ)    00038310
            ELSE                                                        00038320
              BB(JJ) = BB(JJ) + TIJ(NN)                                 00038330
              BNO(JJ) = BNO(JJ) + 1.0                                   00038340
              WA(JJ) = XX(II) + XX(JJ+JRSHFT) + WA(JJ)                  00038350
            END IF                                                      00038360
            NEVNTK = NEVNTK + 1                                         00038370
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 125                         00038380
  123     CONTINUE                                                      00038390
  124   CONTINUE                                                        00038400
C                                                                       00038410
C***********************************************************************00038420
C*   BOOST GROUP STATICS TERMS IN MAIN DIAGONAL HAVING LOW             *00038430
C* MULTIPLICITY.  COMPUTE NEW GROUP STATICS VECTOR.                    *00038440
C***********************************************************************00038450
C                                                                       00038460
  125   DO 126 J = 1, NOJR                                              00038470
          IF ( BNO(J) .GT. 0.0 ) THEN                                   00038480
            JJ = J + JRSHFT                                             00038490
            IF ( BNO(J) .LT. ALIMJR ) BNO(J) = ALIMJR                   00038500
            XX(JJ) = (BB(J) - (WA(J) + SIG * XX(JJ))) / (BNO(J) + SIG)  00038510
     *               + XX(JJ)                                           00038520
          END IF                                                        00038530
  126   CONTINUE                                                        00038540
C                                                                       00038550
C***********************************************************************00038560
C*   THIS ITERATION IS COMPLETE.                                       *00038570
C***********************************************************************00038580
C                                                                       00038590
        WRITE ( LUPRNT, 131 ) NI                                        00038600
  131   FORMAT ( 25X, 'ITERATION ', I2 )                                00038610
  132 CONTINUE                                                          00038620
      GO TO 401                                                         00038630
C                                                                       00038640
C***********************************************************************00038650
C*   ITERATIVE SOLUTION USING RESIDUALS FOR I+R+C+M=T SYSTEM.          *00038660
C***********************************************************************00038670
C                                                                       00038680
  201 CONTINUE                                                          00038690
      ALIMKC = 0.25 * SUMEV / NOKK                                      00038700
      ALIMKM = ALIMKC                                                   00038710
      OFFREF = SQRT(SUMX4/SUMEV)                                        00038720
	kbytes = szsmpd * nokk
C                                                                       00038740
C***********************************************************************00038750
C*   COMPUTE SOURCE STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE *00038760
C* MATRIX.  COMPUTE SOURCE STATICS PARTITION OF PRODUCT OF LMSE MATRIX *00038770
C* WITH CURRENT SOLUTION VECTOR.                                       *00038780
C***********************************************************************00038790
C                                                                       00038800
      DO 252 NI = 1, NITER                                              00038810
        CALL MOVE (0, BNO, 0, IBYTES)                                   00038820
        CALL MOVE (0, BB, 0, IBYTES)                                    00038830
        CALL MOVE (0, WA, 0, IBYTES)                                    00038840
        NEVNTK = 0                                                      00038850
        DO 214 NB = 1, NBLKSA                                           00038860
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00038870
          DO 213 NN = 1, NEPBA                                          00038880
            II = ISPOS(NN)                                              00038890
            JJ = JRPOS(NN)                                              00038900
            KK = KKPOS(NN)                                              00038910
            IF ( NUPWFG .EQ. 0 ) THEN                                   00038920
              BB(II) = BB(II) + TIJ(NN) * COR(NN)                       00038930
              BNO(II) = BNO(II) + COR(NN)                               00038940
              WA(II) = (XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT) + XOF(NN)00038950
     *                 / OFFREF * XX(KK+KMSHFT)) * COR(NN) + WA(II)     00038960
            ELSE                                                        00038970
              BB(II) = BB(II) + TIJ(NN)                                 00038980
              BNO(II) = BNO(II) + 1.0                                   00038990
              WA(II) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00039000
     *                 + XOF(NN) / OFFREF * XX(KK+KMSHFT) + WA(II)      00039010
            END IF                                                      00039020
            NEVNTK = NEVNTK + 1                                         00039030
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 215                         00039040
  213     CONTINUE                                                      00039050
  214   CONTINUE                                                        00039060
C                                                                       00039070
C***********************************************************************00039080
C*   BOOST SOURCE STATICS TERMS IN MAIN DIAGONAL HAVING LOW            *00039090
C* MULTIPLICITY.  COMPUTE NEW SOURCE STATICS VECTOR.                   *00039100
C***********************************************************************00039110
C                                                                       00039120
  215   DO 216 I = 1, NOIS                                              00039130
          IF ( BNO(I) .GT. 0.0 ) THEN                                   00039140
            IF ( BNO(I) .LT. ALIMIS ) BNO(I) = ALIMIS                   00039150
            XX(I) = (BB(I) - (WA(I) + SIG * XX(I))) / (BNO(I) + SIG)    00039160
     *              + XX(I)                                             00039170
          END IF                                                        00039180
  216   CONTINUE                                                        00039190
C                                                                       00039200
C***********************************************************************00039210
C*   COMPUTE GROUP STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE  *00039220
C* MATRIX.  COMPUTE GROUP STATICS PARTITION OF PRODUCT OF LMSE MATRIX  *00039230
C* WITH CURRENT SOLUTION VECTOR.                                       *00039240
C***********************************************************************00039250
C                                                                       00039260
        CALL MOVE (0, BNO, 0, JBYTES)                                   00039270
        CALL MOVE (0, BB, 0, JBYTES)                                    00039280
        CALL MOVE (0, WA, 0, JBYTES)                                    00039290
        NEVNTK = 0                                                      00039300
        DO 224 NB = 1, NBLKSA                                           00039310
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00039320
          DO 223 NN = 1, NEPBA                                          00039330
            II = ISPOS(NN)                                              00039340
            JJ = JRPOS(NN)                                              00039350
            KK = KKPOS(NN)                                              00039360
            IF ( NUPWFG .EQ. 0 ) THEN                                   00039370
              BB(JJ) = BB(JJ) + TIJ(NN) * COR(NN)                       00039380
              BNO(JJ) = BNO(JJ) + COR(NN)                               00039390
              WA(JJ) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00039400
     *                  + XOF(NN) / OFFREF * XX(KK+KMSHFT) ) * COR(NN)  00039410
     *                 + WA(JJ)                                         00039420
            ELSE                                                        00039430
              BB(JJ) = BB(JJ) + TIJ(NN)                                 00039440
              BNO(JJ) = BNO(JJ) + 1.0                                   00039450
              WA(JJ) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00039460
     *                 + XOF(NN) / OFFREF * XX(KK+KMSHFT) + WA(JJ)      00039470
            END IF                                                      00039480
            NEVNTK = NEVNTK + 1                                         00039490
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 225                         00039500
  223     CONTINUE                                                      00039510
  224   CONTINUE                                                        00039520
C                                                                       00039530
C***********************************************************************00039540
C*   BOOST GROUP STATICS TERMS IN MAIN DIAGONAL HAVING LOW             *00039550
C* MULTIPLICITY.  COMPUTE NEW GROUP STATICS VECTOR.                    *00039560
C***********************************************************************00039570
C                                                                       00039580
  225   DO 226 J = 1, NOJR                                              00039590
          IF ( BNO(J) .GT. 0.0 ) THEN                                   00039600
            JJ = J + JRSHFT                                             00039610
            IF ( BNO(J) .LT. ALIMJR ) BNO(J) = ALIMJR                   00039620
            XX(JJ) = (BB(J) - (WA(J) + SIG * XX(JJ))) / (BNO(J) + SIG)  00039630
     *               + XX(JJ)                                           00039640
          END IF                                                        00039650
  226   CONTINUE                                                        00039660
C                                                                       00039670
C***********************************************************************00039680
C*   COMPUTE STRUCTURE PARTITION OF MAIN DIAGONAL AND RHS OF LMSE      *00039690
C* MATRIX.  COMPUTE STRUCTURE PARTITION OF PRODUCT OF LMSE MATRIX WITH *00039700
C* CURRENT SOLUTION VECTOR.                                            *00039710
C***********************************************************************00039720
C                                                                       00039730
        CALL MOVE (0, BNO, 0, KBYTES)                                   00039740
        CALL MOVE (0, BB, 0, KBYTES)                                    00039750
        CALL MOVE (0, WA, 0, KBYTES)                                    00039760
        NEVNTK = 0                                                      00039770
        DO 234 NB = 1, NBLKSA                                           00039780
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00039790
          DO 233 NN = 1, NEPBA                                          00039800
            II = ISPOS(NN)                                              00039810
            JJ = JRPOS(NN)                                              00039820
            KK = KKPOS(NN)                                              00039830
            IF ( NUPWFG .EQ. 0 ) THEN                                   00039840
              BB(KK) = BB(KK) + TIJ(NN) * COR(NN)                       00039850
              BNO(KK) = BNO(KK) + COR(NN)                               00039860
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00039870
     *                 + XOF(NN) / OFFREF * XX(KK+KMSHFT) ) * COR(NN)   00039880
     *                 + WA(KK)                                         00039890
            ELSE                                                        00039900
              BB(KK) = BB(KK) + TIJ(NN)                                 00039910
              BNO(KK) = BNO(KK) + 1.0                                   00039920
              WA(KK) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00039930
     *                 + XOF(NN) / OFFREF * XX(KK+KMSHFT) + WA(KK)      00039940
            END IF                                                      00039950
            NEVNTK = NEVNTK + 1                                         00039960
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 235                         00039970
  233     CONTINUE                                                      00039980
  234   CONTINUE                                                        00039990
C                                                                       00040000
C***********************************************************************00040010
C*   BOOST STRUCTURE TERMS IN MAIN DIAGONAL HAVING LOW                 *00040020
C* MULTIPLICITY.  COMPUTE NEW STRUCTURE VECTOR.                        *00040030
C***********************************************************************00040040
C                                                                       00040050
  235	if(x2d) go to 247
        DO 236 K = 1, NOKK                                              00040060
cmam  235   DO 236 K = 1, NOKK                                              00040060
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00040070
            KK = K + KCSHFT                                             00040080
            IF ( BNO(K) .LT. ALIMKC ) BNO(K) = ALIMKC                   00040090
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00040100
     *               + XX(KK)                                           00040110
          END IF                                                        00040120
  236   CONTINUE                                                        00040130
cmam	if(x2d) go to 247
C                                                                       00040140
C***********************************************************************00040150
C*   COMPUTE 2-D RNMO PARTITION OF MAIN DIAGONAL AND RHS OF LMSE       *00040160
C* MATRIX.  COMPUTE 2-D RNMO PARTITION OF PRODUCT OF LMSE MATRIX WITH  *00040170
C* CURRENT SOLUTION VECTOR.                                            *00040180
C***********************************************************************00040190
C                                                                       00040200
        CALL MOVE (0, BNO, 0, KBYTES)                                   00040210
        CALL MOVE (0, BB, 0, KBYTES)                                    00040220
        CALL MOVE (0, WA, 0, KBYTES)                                    00040230
        NEVNTK = 0                                                      00040240
        DO 244 NB = 1, NBLKSA                                           00040250
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00040260
          DO 243 NN = 1, NEPBA                                          00040270
            II = ISPOS(NN)                                              00040280
            JJ = JRPOS(NN)                                              00040290
            KK = KKPOS(NN)                                              00040300
            X2 = XOF(NN) / OFFREF                                       00040310
            IF ( NUPWFG .EQ. 0 ) THEN                                   00040320
              BB(KK) = BB(KK) + X2 * TIJ(NN) * COR(NN)                  00040330
              BNO(KK) = BNO(KK) + X2 * X2 * COR(NN)                     00040340
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00040350
     *                 + X2 * XX(KK+KMSHFT) ) * COR(NN) * X2 + WA(KK)   00040360
            ELSE                                                        00040370
              BB(KK) = BB(KK) + X2 * TIJ(NN)                            00040380
              BNO(KK) = BNO(KK) + X2 * X2                               00040390
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00040400
     *                 + X2 * XX(KK+KMSHFT) ) * X2 + WA(KK)             00040410
            END IF                                                      00040420
            NEVNTK = NEVNTK + 1                                         00040430
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 245                         00040440
  243     CONTINUE                                                      00040450
  244   CONTINUE                                                        00040460
C                                                                       00040470
C***********************************************************************00040480
C*   BOOST 2-D RNMO TERMS IN MAIN DIAGONAL HAVING LOW                  *00040490
C* MULTIPLICITY.  COMPUTE NEW 2-D RNMO VECTOR.                         *00040500
C***********************************************************************00040510
C                                                                       00040520
  245   DO 246 K = 1, NOKK                                              00040530
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00040540
            KK = K + KMSHFT                                             00040550
            IF ( BNO(K) .LT. ALIMKM ) BNO(K) = ALIMKM                   00040560
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00040570
     *               + XX(KK)                                           00040580
          END IF                                                        00040590
  246   CONTINUE                                                        00040600
C                                                                       00040610
C***********************************************************************00040620
C*   THIS ITERATION IS COMPLETE.                                       *00040630
C***********************************************************************00040640
  247	continue
C                                                                       00040650
        WRITE ( LUPRNT, 251 ) NI                                        00040660
  251   FORMAT ( 25X, 'ITERATION ', I2 )                                00040670
  252 CONTINUE                                                          00040680
      GO TO 401                                                         00040690
C                                                                       00040700
C***********************************************************************00040710
C*   ITERATIVE SOLUTION USING RESIDUALS FOR I+R+C+M+E+F=T SYSTEM.      *00040720
C***********************************************************************00040730
C                                                                       00040740
  301 CONTINUE                                                          00040750
      ALIMKC = 0.25 * SUMEV / NOKK                                      00040760
      ALIMKM = ALIMKC                                                   00040770
      OFFREF = SQRT(SUMX4/SUMEV)                                        00040780
      ALIMKE = SUMX4S / SUMX4 * ALIMKM                                  00040790
      ALIMKF = SUMX4C / SUMX4 * ALIMKM                                  00040800
	kbytes = szsmpd * nokk
C                                                                       00040820
C***********************************************************************00040830
C*   COMPUTE SOURCE STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE *00040840
C* MATRIX.  COMPUTE SOURCE STATICS PARTITION OF PRODUCT OF LMSE MATRIX *00040850
C* WITH CURRENT SOLUTION VECTOR.                                       *00040860
C***********************************************************************00040870
C                                                                       00040880
      DO 372 NI = 1, NITER                                              00040890
        CALL MOVE (0, BNO, 0, IBYTES)                                   00040900
        CALL MOVE (0, BB, 0, IBYTES)                                    00040910
        CALL MOVE (0, WA, 0, IBYTES)                                    00040920
        NEVNTK = 0                                                      00040930
        DO 314 NB = 1,NBLKSA                                            00040940
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00040950
          DO 313 NN = 1, NEPBA                                          00040960
            II = ISPOS(NN)                                              00040970
            JJ = JRPOS(NN)                                              00040980
            KK = KKPOS(NN)                                              00040990
            IF ( NUPWFG .EQ. 0 ) THEN                                   00041000
              BB(II) = BB(II) + TIJ(NN) * COR(NN)                       00041010
              BNO(II) = BNO(II) + COR(NN)                               00041020
              WA(II) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00041030
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00041040
     *                       + XOFSIN(NN) * XX(KK+KESHFT)               00041050
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF )  00041060
     *                 * COR(NN) + WA(II)                               00041070
            ELSE                                                        00041080
              BB(II) = BB(II) + TIJ(NN)                                 00041090
              BNO(II) = BNO(II) + 1.0                                   00041100
              WA(II) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00041110
     *                 + ( XOF(NN) * XX(KK+KMSHFT)                      00041120
     *                    + XOFSIN(NN) * XX(KK+KESHFT)                  00041130
     *                    + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF       00041140
     *                 + WA(II)                                         00041150
            END IF                                                      00041160
            NEVNTK = NEVNTK + 1                                         00041170
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 315                         00041180
  313     CONTINUE                                                      00041190
  314   CONTINUE                                                        00041200
C                                                                       00041210
C***********************************************************************00041220
C*   BOOST SOURCE STATICS TERMS IN MAIN DIAGONAL HAVING LOW            *00041230
C* MULTIPLICITY.  COMPUTE NEW SOURCE STATICS VECTOR.                   *00041240
C***********************************************************************00041250
C                                                                       00041260
  315   DO 316 I = 1, NOIS                                              00041270
          IF ( BNO(I) .GT. 0.0 ) THEN                                   00041280
            IF ( BNO(I) .LT. ALIMIS ) BNO(I) = ALIMIS                   00041290
            XX(I) = (BB(I) - (WA(I) + SIG * XX(I))) / (BNO(I) + SIG)    00041300
     *              + XX(I)                                             00041310
          END IF                                                        00041320
  316   CONTINUE                                                        00041330
C                                                                       00041340
C***********************************************************************00041350
C*   COMPUTE GROUP STATICS PARTITION OF MAIN DIAGONAL AND RHS OF LMSE  *00041360
C* MATRIX.  COMPUTE GROUP STATICS PARTITION OF PRODUCT OF LMSE MATRIX  *00041370
C* WITH CURRENT SOLUTION VECTOR.                                       800041380
C***********************************************************************00041390
C                                                                       00041400
        CALL MOVE (0, BNO, 0, JBYTES)                                   00041410
        CALL MOVE (0, BB, 0, JBYTES)                                    00041420
        CALL MOVE (0, WA, 0, JBYTES)                                    00041430
        NEVNTK = 0                                                      00041440
        DO 324 NB = 1, NBLKSA                                           00041450
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00041460
          DO 323 NN = 1, NEPBA                                          00041470
            II = ISPOS(NN)                                              00041480
            JJ = JRPOS(NN)                                              00041490
            KK = KKPOS(NN)                                              00041500
            IF ( NUPWFG .EQ. 0 ) THEN                                   00041510
              BB(JJ) = BB(JJ) + TIJ(NN) * COR(NN)                       00041520
              BNO(JJ) = BNO(JJ) + COR(NN)                               00041530
              WA(JJ) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00041540
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00041550
     *                       + XOFSIN(NN) * XX(KK+KESHFT)               00041560
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF )  00041570
     *                 * COR(NN) + WA(JJ)                               00041580
            ELSE                                                        00041590
              BB(JJ) = BB(JJ) + TIJ(NN)                                 00041600
              BNO(JJ) = BNO(JJ) + 1.0                                   00041610
              WA(JJ) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00041620
     *                 + ( XOF(NN) * XX(KK+KMSHFT)                      00041630
     *                     + XOFSIN(NN) * XX(KK+KESHFT)                 00041640
     *                     + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF      00041650
     *                 + WA(JJ)                                         00041660
            END IF                                                      00041670
            NEVNTK = NEVNTK + 1                                         00041680
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 325                         00041690
  323     CONTINUE                                                      00041700
  324   CONTINUE                                                        00041710
C                                                                       00041720
C***********************************************************************00041730
C*    BOOST GROUP STATICS TERMS IN MAIN DIAGONAL HAVING LOW            *00041740
C* MULTIPLICITY.  COMPUTE NEW GROUP STATICS VECTOR.                    *00041750
C***********************************************************************00041760
C                                                                       00041770
  325   DO 326 J = 1, NOJR                                              00041780
          IF ( BNO(J) .GT. 0.0 ) THEN                                   00041790
            JJ = J + JRSHFT                                             00041800
            IF ( BNO(J) .LT. ALIMJR ) BNO(J) = ALIMJR                   00041810
            XX(JJ) = (BB(J) - (WA(J) + SIG * XX(JJ))) / (BNO(J) + SIG)  00041820
     *               + XX(JJ)                                           00041830
          END IF                                                        00041840
  326   CONTINUE                                                        00041850
C                                                                       00041860
C***********************************************************************00041870
C*   COMPUTE STRUCTURE PARTITION OF MAIN DIAGONAL AND RHS OF LMSE      *00041880
C* MATRIX.  COMPUTE STRUCTURE PARTITION OF PRODUCT OF LMSE MATRIX      *00041890
C* WITH CURRENT SOLUTION VECTOR.                                       *00041900
C***********************************************************************00041910
C                                                                       00041920
        CALL MOVE (0, BNO, 0, KBYTES)                                   00041930
        CALL MOVE (0, BB, 0, KBYTES)                                    00041940
        CALL MOVE (0, WA, 0, KBYTES)                                    00041950
        NEVNTK = 0                                                      00041960
        DO 334 NB = 1, NBLKSA                                           00041970
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00041980
          DO 333 NN = 1, NEPBA                                          00041990
            II = ISPOS(NN)                                              00042000
            JJ = JRPOS(NN)                                              00042010
            KK = KKPOS(NN)                                              00042020
            IF ( NUPWFG .EQ. 0 ) THEN                                   00042030
              BB(KK) = BB(KK) + TIJ(NN) * COR(NN)                       00042040
              BNO(KK) = BNO(KK) + COR(NN)                               00042050
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00042060
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00042070
     *                       + XOFSIN(NN) * XX(KK+KESHFT)               00042080
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF )  00042090
     *                 * COR(NN) + WA(KK)                               00042100
            ELSE                                                        00042110
              BB(KK) = BB(KK) + TIJ(NN)                                 00042120
              BNO(KK) = BNO(KK) + 1.0                                   00042130
              WA(KK) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00042140
     *                 + ( XOF(NN) * XX(KK+KMSHFT)                      00042150
     *                     + XOFSIN(NN) * XX(KK+KESHFT)                 00042160
     *                     + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF      00042170
     *                 + WA(KK)                                         00042180
            END IF                                                      00042190
            NEVNTK = NEVNTK + 1                                         00042200
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 335                         00042210
  333     CONTINUE                                                      00042220
  334   CONTINUE                                                        00042230
C                                                                       00042240
C***********************************************************************00042250
C*   BOOST STRUCTURE TERMS IN MAIN DIAGONAL HAVING LOW                 *00042260
C* MULTIPLICITY.  COMPUTE NEW STRUCTURE VECTOR.                        *00042270
C***********************************************************************00042280
C                                                                       00042290
  335   DO 336 K = 1, NOKK                                              00042300
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00042310
            KK = K + KCSHFT                                             00042320
            IF ( BNO(K) .LT. ALIMKC ) BNO(K) = ALIMKC                   00042330
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00042340
     *               + XX(KK)                                           00042350
          END IF                                                        00042360
  336   CONTINUE                                                        00042370
C                                                                       00042380
C***********************************************************************00042390
C*   COMPUTE 2-D RNMO PARTITION OF MAIN DIAGONAL AND RHS OF LMSE       *00042400
C* MATRIX.  COMPUTE 2-D RNMO PARTITION OF PRODUCT OF LMSE MATRIX WITH  *00042410
C* CURRENT SOLUTION VECTOR.                                            *00042420
C***********************************************************************00042430
C                                                                       00042440
        CALL MOVE (0, BNO, 0, KBYTES)                                   00042450
        CALL MOVE (0, BB, 0, KBYTES)                                    00042460
        CALL MOVE (0, WA, 0, KBYTES)                                    00042470
        NEVNTK = 0                                                      00042480
        DO 344 NB = 1, NBLKSA                                           00042490
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00042500
          DO 343 NN = 1, NEPBA                                          00042510
            II = ISPOS(NN)                                              00042520
            JJ = JRPOS(NN)                                              00042530
            KK = KKPOS(NN)                                              00042540
            X2 = XOF(NN) / OFFREF                                       00042550
            IF ( NUPWFG .EQ. 0 ) THEN                                   00042560
              BB(KK) = BB(KK) + X2 * TIJ(NN) * COR(NN)                  00042570
              BNO(KK) = BNO(KK) + X2 * X2 * COR(NN)                     00042580
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00042590
     *                   + X2 * XX(KK+KMSHFT)                           00042600
     *                   + ( XOFSIN(NN) * XX(KK+KESHFT)                 00042610
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF )  00042620
     *                 * COR(NN) * X2 + WA(KK)                          00042630
            ELSE                                                        00042640
              BB(KK) = BB(KK) + X2 * TIJ(NN)                            00042650
              BNO(KK) = BNO(KK) + X2 * X2                               00042660
              WA(KK) = XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)           00042670
     *                 + X2 * XX(KK+KMSHFT)                             00042680
     *                 + ( XOFSIN(NN) * XX(KK+KESHFT)                   00042690
     *                     + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF      00042700
     *                 * X2 + WA(KK)                                    00042710
            END IF                                                      00042720
            NEVNTK = NEVNTK + 1                                         00042730
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 345                         00042740
  343     CONTINUE                                                      00042750
  344   CONTINUE                                                        00042760
C                                                                       00042770
C***********************************************************************00042780
C*   BOOST 2-D RNMO TERMS IN MAIN DIAGONAL HAVING LOW                  *00042790
C* MULTIPLICITY.  COMPUTE NEW 2-D RNMO VECTOR.                         *00042800
C***********************************************************************00042810
C                                                                       00042820
  345   DO 346 K = 1, NOKK                                              00042830
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00042840
            KK = K + KMSHFT                                             00042850
            IF ( BNO(K) .LT. ALIMKM ) BNO(K) = ALIMKM                   00042860
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00042870
     *               + XX(KK)                                           00042880
          END IF                                                        00042890
  346   CONTINUE                                                        00042900
C                                                                       00042910
C***********************************************************************00042920
C*   COMPUTE 3-D SINE RNMO PARTITION OF MAIN DIAGONAL AND RHS OF LMSE  *00042930
C* MATRIX.  COMPUTE 3-D SINE RNMO PARTITION OF PRODUCT OF LMSE MATRIX  *00042940
C* WITH CURRENT SOLUTION VECTOR.                                       *00042950
C***********************************************************************00042960
C                                                                       00042970
        CALL MOVE (0, BNO, 0, KBYTES)                                   00042980
        CALL MOVE (0, BB, 0, KBYTES)                                    00042990
        CALL MOVE (0, WA, 0, KBYTES)                                    00043000
        NEVNTK = 0                                                      00043010
        DO 354 NB = 1, NBLKSA                                           00043020
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00043030
          DO 353 NN = 1, NEPBA                                          00043040
            II = ISPOS(NN)                                              00043050
            JJ = JRPOS(NN)                                              00043060
            KK = KKPOS(NN)                                              00043070
            X2S = XOFSIN(NN) / OFFREF                                   00043080
            IF ( NUPWFG .EQ. 0 ) THEN                                   00043090
              BB(KK) = BB(KK) + X2S * TIJ(NN) * COR(NN)                 00043100
              BNO(KK) = BNO(KK) + X2S * X2S * COR(NN)                   00043110
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00043120
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00043130
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF    00043140
     *                   + X2S * XX(KK+KESHFT) ) * COR(NN) * X2S        00043150
     *                 + WA(KK)                                         00043160
            ELSE                                                        00043170
              BB(KK) = BB(KK) + X2S * TIJ(NN)                           00043180
              BNO(KK) = BNO(KK) + X2S * X2S                             00043190
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00043200
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00043210
     *                       + XOFCOS(NN) * XX(KK+KFSHFT) ) / OFFREF    00043220
     *                   + X2S * XX(KK+KESHFT) ) * X2S + WA(KK)         00043230
            END IF                                                      00043240
            NEVNTK = NEVNTK + 1                                         00043250
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 355                         00043260
  353     CONTINUE                                                      00043270
  354   CONTINUE                                                        00043280
C                                                                       00043290
C***********************************************************************00043300
C*   BOOST 3-D SINE RNMO TERMS IN MAIN DIAGONAL HAVING LOW             *00043310
C* MULTIPLICITY.  COMPUTE NEW 3-D SINE RNMO VECTOR.                    *00043320
C***********************************************************************00043330
C                                                                       00043340
  355   DO 356 K = 1, NOKK                                              00043350
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00043360
            KK = K + KESHFT                                             00043370
            IF ( BNO(K) .LT. ALIMKE ) BNO(K) = ALIMKE                   00043380
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00043390
     *               + XX(KK)                                           00043400
          END IF                                                        00043410
  356   CONTINUE                                                        00043420
C                                                                       00043430
C***********************************************************************00043440
C*   COMPUTE 3-D COSINE RNMO PARTITION OF MAIN DIAGONAL AND RHS OF LMSE*00043450
C* MATRIX.  COMPUTE 3-D COSINE RNMO PARTITION OF PRODUCT OF LMSE MATRIX*00043460
C* WITH CURRENT SOLUTION VECTOR.                                       *00043470
C***********************************************************************00043480
C                                                                       00043490
        CALL MOVE (0, BNO, 0, KBYTES)                                   00043500
        CALL MOVE (0, BB, 0, KBYTES)                                    00043510
        CALL MOVE (0, WA, 0, KBYTES)                                    00043520
        NEVNTK = 0                                                      00043530
        DO 364 NB = 1, NBLKSA                                           00043540
          CALL DAREAD (NB, TIJ, LUDSKA)                                 00043550
          DO 363 NN = 1, NEPBA                                          00043560
            II = ISPOS(NN)                                              00043570
            JJ = JRPOS(NN)                                              00043580
            KK = KKPOS(NN)                                              00043590
            X2C = XOFCOS(NN) / OFFREF                                   00043600
            IF ( NUPWFG .EQ. 0 ) THEN                                   00043610
              BB(KK) = BB(KK) + X2C * TIJ(NN) * COR(NN)                 00043620
              BNO(KK) = BNO(KK) + X2C * X2C * COR(NN)                   00043630
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00043640
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00043650
     *                       + XOFSIN(NN) * XX(KK+KESHFT) ) / OFFREF    00043660
     *                   + X2C * XX(KK+KFSHFT) ) * COR(NN) * X2C        00043670
     *                 + WA(KK)                                         00043680
            ELSE                                                        00043690
              BB(KK) = BB(KK) + X2C * TIJ(NN)                           00043700
              BNO(KK) = BNO(KK) + X2C * X2C                             00043710
              WA(KK) = ( XX(II) + XX(JJ+JRSHFT) + XX(KK+KCSHFT)         00043720
     *                   + ( XOF(NN) * XX(KK+KMSHFT)                    00043730
     *                       + XOFSIN(NN) * XX(KK+KESHFT) ) / OFFREF    00043740
     *                   + X2C * XX(KK+KFSHFT) ) * X2C + WA(KK)         00043750
            END IF                                                      00043760
            NEVNTK = NEVNTK + 1                                         00043770
            IF ( NEVNTK .EQ. NEVNTS ) GO TO 365                         00043780
  363     CONTINUE                                                      00043790
  364   CONTINUE                                                        00043800
C                                                                       00043810
C***********************************************************************00043820
C*   BOOST 3-D COSINE RNMO TERMS IN MAIN DIAGONAL HAVING LOW           *00043830
C* MULTIPLICITY.  COMPUTE NEW 3-D COSINE RNMO VECTOR.                  *00043840
C***********************************************************************00043850
C                                                                       00043860
  365   DO 366 K = 1, NOKK                                              00043870
          IF ( BNO(K) .GT. 0.0 ) THEN                                   00043880
            KK = K + KFSHFT                                             00043890
            IF ( BNO(K) .LT. ALIMKF ) BNO(K) = ALIMKF                   00043900
            XX(KK) = (BB(K) - (WA(K) + SIG * XX(KK))) / (BNO(K) + SIG)  00043910
     *               + XX(KK)                                           00043920
          END IF                                                        00043930
  366   CONTINUE                                                        00043940
C                                                                       00043950
C***********************************************************************00043960
C*   THIS ITERATION IS COMPLETE.                                       *00043970
C***********************************************************************00043980
C                                                                       00043990
        WRITE ( LUPRNT, 371 ) NI                                        00044000
  371   FORMAT ( 25X, 'ITERATION ', I2 )                                00044010
  372 CONTINUE                                                          00044020
C                                                                       00044030
  401 RETURN                                                            00044040
      END                                                               00044050
C***********************************************************************00044060
C***********************************************************************00044070
C***********************************************************************00044080
C***********************************************************************00044090
C***********************************************************************00044100
      SUBROUTINE ERDS3C (XX)                                            00044110
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C*********          SOURCE CODE FOR IBM-MVS VERSION            *********00044120
C***********************************************************************00044130
C                                                                      *00044140
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *00044170
C***********************************************************************00044180
C  ROUTINE:       ERDS3C                                                00044190
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)                            00044200
C  PURPOSE:                                                             00044210
C      GIVEN EVENT PARAMETERS AND TIME PICKS AS DATA BLOCKS ON DISK,    00044220
C      CONTROL POINTERS IN COMMON/POINT3/, AND A COMPUTED SOLUTION FOR  00044230
C      3-D SURFACE-CONSISTENT STATICS, THIS SUBROUTINE COMPUTES THE     00044240
C      ERROR DISTRIBUTION AND RMS, MINIMUM, AND MAXIMUM ERRORS.  IF     00044250
C      ALTERNATE PICKS ARE AVAILABLE, LEG JUMPS ARE CHECKED AND         00044260
C      CORRECTED BY CHOOSING THE PICKS PRODUCING THE LEAST ERROR.       00044270
C      OUTPUT IS IN COMMON/ERRORS/.                                     00044280
C  CALLING PARAMETERS:  SUBROUTINE ERDS3C (XX)                          00044290
C  ARGUMENTS:                                                           00044300
C      NAME                    LENGTH   DESCRIPTION                     00044310
C      XX    R*4  I  ( 1 )     NOSRK    SOLUTION VECTOR.  ITS LENGTH    00044320
C                                       NOSRK IS IN COMMON/POINT3/.     00044330
C  CATEGORY:  SPECIFIC                                                  00044340
C  KEYWORDS:  ERRORS, STATICS                                           00044350
C       +------------------------------------------------------+        00044360
C       |               DEVELOPMENT INFORMATION                |        00044370
C       +------------------------------------------------------+        00044380
C  AUTHOR:    M. TURHAN TANER                 ORIGIN DATE:  82/08/10    00044390
C             MODIFIED BY G. RUCKGABER (82/09/02)                       00044400
C             MODIFIED BY G. RUCKGABER (84/05/23)                       00044410
C             MODIFIED BY G. RUCKGABER (84/08/02)                       00044420
C             MODIFIED BY G. RUCKGABER (84/08/09)                       00044430
C  LANGUAGE:  FORTRAN IV                                                00044440
C       +------------------------------------------------------+        00044450
C       |                 EXTERNAL ENVIRONMENT                 |        00044460
C       +------------------------------------------------------+        00044470
C  EXTERNAL REFERENCES:                                                 00044480
C      READ AND WRITE DATA BLOCKS TO DISK.                              00044490
C  ROUTINES CALLED:                                                     00044500
C      DAREAD   -      READ DATA BLOCK FROM DISK.                       00044510
C      DAWRTE   -      WRITE DATA BLOCK TO DISK.                        00044520
C      MOVE     -      MOVE ARRAYS.                                     00044530
C  FORTRAN SUPPLIED PROCEDURES:                                         00044540
C      ABS                                                              00044550
C      SQRT                                                             00044560
C  COMMON:                                                              00044570
C      ERRORS  (  * )  ERROR DISTRIBUTION AND OTHER ERROR STATISTICS    00044580
C                      SET BY THIS SUBROUTINE.                          00044590
C                        DIST   - ARRAY FOR ERROR DISTRIBUTION          00044600
C                        NODIS  - LENGTH OF ARRAY FOR ERROR DISTRIBUTION00044610
C                        DID    - ERROR INCREMENT IN ERROR DIST. ARRAY  00044620
C                        ERMAX  - MAXIMUM ABOLUTE ERROR                 00044630
C                        POSER  - LARGEST POSITIVE ERROR                00044640
C                        ERNEG  - LARGEST NEGATIVE ERROR                00044650
C                        RMSER  - RMS ERROR                             00044660
C                        NSUMO  - NO. OF EVENTS INCLUDED IN ERROR DIST. 00044670
C                        NOLEG  - NO. OF ALTERNATE PICKS SUBSTITUTED    00044680
C      FILCON  (  * )  PARAMETERS FOR TWO TEMPORARY DISK AREAS SET BY   00044690
C                      MAIN PROGRAM.                                    00044700
C                        NWPEA  - NO. OF WORDS PER EVENT IN DISK A      00044710
C                        NEPBA  - NO. OF EVENTS PER BLOCK IN DISK A     00044720
C                        NWPBA  - NO. OF WORDS PER BLOCK IN DISK A      00044730
C                        NBPBA  - NO. OF BYTES PER BLOCK IN DISK A      00044740
C                        NBLKSA - NO. OF BLOCKS IN DISK A               00044750
C                        NEVNTS - NO. OF ACCEPTABLE EVENTS IN DISK A    00044760
C                        NWPCB  - NO. OF WORDS PER COORDINATE IN DISK B 00044770
C                        NCPBB  - NO. OF COORDINATES PER BLOCK IN DISK B00044780
C                        NWPBB  - NO. OF WORDS PER BLOCK IN DISK B      00044790
C                        NBPBB  - NO. OF BYTES PER BLOCK IN DISK B      00044800
C                        NBLKSB - NO. OF BLOCKS IN DISK B               00044810
C                        NCORDS - NO. OF COORDINATES IN DISK B          00044820
C      LUNITS  (  * )  LOGICAL UNIT SPECIFICATIONS FOR I/O DEVICES SET  00044830
C                      BY MAIN PROGRAM.                                 00044840
C                        LUNEVT - LOGICAL UNIT FOR INPUT EVENT TAPE     00044850
C                        LUOSLA - LOGICAL UNIT FOR OUTPUT SOLUTION TAPE 00044860
C                        LUNTAP - LOGICAL UNIT FOR INPUT DATA TAPE      00044870
C                        LUOTAP - LOGICAL UNIT FOR OUTPUT DATA TAPE     00044880
C                        LUCARD - LOGICAL UNIT FOR INPUT DATA CARDS     00044890
C                        LUPRNT - LOGICAL UNIT FOR PRINTER              00044900
C                        LUSTAT - LOGICAL UNIT FOR OUTPUT STATICS CARDS 00044910
C                        LUCNTR - LOGICAL UNIT FOR OUTPUT CONTOUR. CARDS00044920
C                        LUDSKA - LOGICAL UNIT FOR TEMPORARY DISK FILE A00044930
C                        LUDSKB - LOGICAL UNIT FOR TEMPORARY DISK FILE B00044940
C                        NLUDSA - NO. OF LOGICAL UNITS FOR TEMP. DISK A 00044950
C                        NLUDSB - NO. OF LOGICAL UNITS FOR TEMP. DISK B 00044960
C      POINT3  (  * )  INDEX INFORMATION FOR DATA ARRAYS FROM EVENT TAPE00044970
C                      SET BY MAIN PROGRAM.                             00044980
C                        MINIS  - MINIMUM SOURCEPOINT (PRI) INDEX       00044990
C                        MAXIS  - MAXIMUM SOURCEPOINT (PRI) INDEX       00045000
C                        NOIS   - NO. OF SOURCEPOINT (PRI) INDEXES      00045010
C                        ISPOIN - POINTER FOR FIRST SOURCEPOINT TERM    00045020
C                        MINJR  - MINIMUM GROUP (GI) INDEX              00045030
C                        MAXJR  - MAXIMUM GROUP (GI) INDEX              00045040
C                        NOJR   - NO. OF GROUP (GI) INDEXES             00045050
C                        JRPOIN - POINTER FOR FIRST GROUP TERM          00045060
C                        NOKK   - NO. OF BINS                           00045070
C                        MXNOKK - MAXIMUM ALLOWABLE NO. OF BINS         00045080
C                        KKPOIN - POINTER FOR FIRST BIN-ORIENTED TERM   00045090
C                        KCPOIN - POINTER FOR FIRST STRUCTURE TERM      00045100
C                        KMPOIN - POINTER FOR FIRST 2-D RNMO TERM       00045110
C                        KEPOIN - POINTER FOR FIRST 3-D SINE RNMO TERM  00045120
C                        KFPOIN - POINTER FOR FIRST 3-D COSINE RNMO TERM00045130
C                        MNLI   - MINIMUM LINE (LI) INDEX               00045140
C                        MXLI   - MAXIMUM LINE (LI) INDEX               00045150
C                        NOLI   - NO. OF LINE (LI) INDEXES              00045160
C                        MNDI   - MINIMUM DEPTH (DI) INDEX              00045170
C                        MXDI   - MAXIMUM DEPTH (DI) INDEX              00045180
C                        NODI   - NO. OF DEPTH (DI) INDEXES             00045190
C                        NOSRK  - TOTAL NO. OF UNKNOWNS                 00045200
C                        MXNSRK - MAXIMUM ALLOWABLE NO. OF UNKNOWNS     00045210
C                        NUPWFG - USE PICK WEIGHTS FLAG                 00045220
C                                     (0=YES, 1=NO)                     00045230
C                        MODEFG - MODE OF SOLUTION FLAG                 00045240
C                                     (1  --  I + R = T                )00045250
C                                     (2  --  I + R + C + M = T        )00045260
C                                     (3  --  I + R + C + M + E + F = T)00045270
C                        NALPFG - ALTERNATE PICK SUBSTITUTION FLAG      00045280
C                                     (0=YES, 1=NO)                     00045290
C                        SIG    - PERCENT FOR PREWHITENING OF MAIN DIAG.00045300
C                        OFFREF - REFERENCE OFFSET (SQUARED) FOR SCALING00045310
C                                     ALL RNMO TERMS                    00045320
C      STAFL3  (  * )  ARRAYS FOR DATA FROM EVENT TAPE.                 00045330
C                        TIJ    - ARRAY FOR PRIMARY PICKS               00045340
C                        TIJM   - ARRAY FOR ALTERNATE PICK (LT PRIMARY) 00045350
C                        TIJX   - ARRAY FOR ALTERNATE PICK (GT PRIMARY) 00045360
C                        COR    - ARRAY FOR SQUARE OF WEIGHTS           00045370
C                        CORM   - ARRAY FOR SQ. OF ALT. WEIGHT (LT PRI.)00045380
C                        CORX   - ARRAY FOR SQ. OF ALT. WEIGHT (GT PRI.)00045390
C                        ISPOS  - ARRAY FOR SOURCEPOINT (PRI) POINTERS  00045400
C                        JRPOS  - ARRAY FOR GROUP (GI) POINTERS         00045410
C                        KKPOS  - ARRAY FOR BIN POINTERS                00045420
C                        XOF    - ARRAY FOR SQUARE OF OFFSETS           00045430
C                        XOFSIN - ARRAY FOR (XOF**2)*SIN(AZIMUTH)       00045440
C                        XOFCOS - ARRAY FOR (XOF**2)*COS(AZIMUTH)       00045450
C       +------------------------------------------------------+        00045460
C       |             OTHER DOCUMENTATION DETAILS              |        00045470
C       +------------------------------------------------------+        00045480
C  GENERAL DESCRIPTION:                                                 00045490
C      IT IS ASSUMED THAT EVENT PARAMETERS AND TIME PICKS ARE STORED    00045500
C      ON DISK IN BLOCKS AS DESCRIBED IN THE MAIN PROGRAM.  THESE       00045510
C      PARAMETERS ARE READ FROM THE DISK ONCE IN THIS SUBROUTINE AND    00045520
C      USED TO CALCULATE AN ERROR FOR EACH STATIC EQUATION (PICK) USING 00045530
C      THE CURRENT SOLUTION.                                            00045540
C                                                                       00045550
C      IF NALPFG=0, THE ERROR IS ALSO CALCULATED FOR EACH ALTERNATE     00045560
C      PICK, AND IF ONE OF THE ALTERNATE PICKS YIELDS LESS ERROR THAN   00045570
C      THAT FOR THE PRIMARY PICK, THIS ALTERNATE PICK AND ITS WEIGHT ARE00045580
C      SWITCHED WITH THE PRIMARY PICK AND ITS WEIGHT.  THE MODIFIED DATA00045590
C      BLOCK IS THEN OVERWRITTEN BACK TO DISK.                          00045600
C                                                                       00045610
C      AN ERROR DISTRIBUTION IS ACCUMULATED ALONG WITH THE RMS, MINIMUM,00045620
C      AND MAXIMUM ERRORS.                                              00045630
C                                                                       00045640
C      THIS SUBROUTINE IS CALLED BY THE MAIN PROGRAM ST3DE.  SEE ITS    00045650
C      INTERNAL DOCUMENTATION FOR FURTHER EXPLANATION.                  00045660
C                                                                       00045670
C  LIMITATIONS OF THE SUBROUTINE:                                       00045680
C      EACH ARRAY IN COMMON/STAFL3/ IS DIMENSIONED NEPBA.               00045690
C                                                                       00045700
C  ERROR RETURNS:  NONE                                                 00045710
C                                                                       00045720
C*******************   END OF DOCUMENTATION PACKAGE   ******************00045730
C***********************************************************************00045740
C                                                                       00045750
C                                                                       00045760
      REAL*4 XX(*)                                                      00045770
      COMMON/ERRORS/DIST(201),NODIS,DID,ERMAX,POSER,ERNEG,RMSER,NSUMO,  00045780
     *              NOLEG                                               00045790
      COMMON/FILCON/NWPEA,NEPBA,NWPBA,NBPBA,NBLKSA,NEVNTS,              00045800
     *              NWPCB,NCPBB,NWPBB,NBPBB,NBLKSB,NCORDS               00045810
      COMMON/LUNITS/LUNEVT,LUOSLA,LUNTAP,LUOTAP,LUprnt,LUSTAT,
     *              LUCNTR,LUDSKA,LUDSKB,NLUDSA,NLUDSB                  00045830
      COMMON/POINT3/MINIS,MAXIS,NOIS,ISPOIN,MINJR,MAXJR,NOJR,JRPOIN,    00045840
     *              NOKK,MXNOKK,KKPOIN,KCPOIN,KMPOIN,KEPOIN,KFPOIN,     00045850
     *              MNLI,MXLI,NOLI,MNDI,MXDI,NODI,NOSRK,MXNSRK,         00045860
     *              NUPWFG,MODEFG,NALPFG,SIG,OFFREF                     00045870
      COMMON/STAFL3/TIJ(680),TIJM(680),TIJX(680),COR(680),CORM(680),    00045880
     *              CORX(680),ISPOS(680),JRPOS(680),KKPOS(680),XOF(680),00045890
     *              XOFSIN(680),XOFCOS(680)                             00045900
C                                                                       00045910
C***********************************************************************00045920
C*   CLEAR ERROR DISTRIBUTION ARRAY.                                   *00045930
C***********************************************************************00045940
C                                                                       00045950
      CALL MOVE (0, DIST, 0, szsmpd*NODIS)
C                                                                       00045970
C***********************************************************************00045980
C*   DEFINE AND INITIALIZE VARIABLES.                                  *00045990
C***********************************************************************00046000
C                                                                       00046010
      JRSHFT = NOIS                                                     00046020
      KCSHFT = JRSHFT + NOJR                                            00046030
      NCENTR = NODIS/2                                                  00046040
      CENTR = NCENTR + 1.5                                              00046050
      POSER = 0.0                                                       00046060
      ERNEG = 0.0                                                       00046070
      RMSER = 0.0                                                       00046080
C                                                                       00046090
C***********************************************************************00046100
C*   READ EVENT DATA AND COMPUTE ERROR FOR EACH EVENT USING CURRENT    *00046110
C* SOLUTION.                                                           *00046120
C***********************************************************************00046130
C                                                                       00046140
      NSUMO = 0                                                         00046150
      NOLEG = 0                                                         00046160
      NEVNTK = 0                                                        00046170
C                                                                       00046180
      DO 50 NB = 1, NBLKSA                                              00046190
        NOCOR = 0                                                       00046200
        CALL DAREAD (NB, TIJ, LUDSKA)                                   00046210
        DO 40 NN = 1, NEPBA                                             00046220
          GO TO (1,2,3), MODEFG                                         00046230
C                                                                       00046240
C***********************************************************************00046250
C*   COMPUTE ESTIMATED TIME DIFFERENTIAL FOR MODE 1.                   *00046260
C***********************************************************************00046270
C                                                                       00046280
    1     II = ISPOS(NN)                                                00046290
          JJ = JRPOS(NN) + JRSHFT                                       00046300
          TIJES = XX(II) + XX(JJ)                                       00046310
          GO TO 4                                                       00046320
C                                                                       00046330
C***********************************************************************00046340
C*   COMPUTE ESTIMATED TIME DIFFERENTIAL FOR MODE 2.                   *00046350
C***********************************************************************00046360
C                                                                       00046370
    2     II = ISPOS(NN)                                                00046380
          JJ = JRPOS(NN) + JRSHFT                                       00046390
          KC = KKPOS(NN) + KCSHFT                                       00046400
          KM = KC + NOKK                                                00046410
          TIJES = XX(II) + XX(JJ) + XX(KC) + XOF(NN) * XX(KM) / OFFREF  00046420
          GO TO 4                                                       00046430
C                                                                       00046440
C***********************************************************************00046450
C*   COMPUTE ESTIMATED TIME DIFFERENTIAL FOR MODE 3.                   *00046460
C***********************************************************************00046470
C                                                                       00046480
    3     II = ISPOS(NN)                                                00046490
          JJ = JRPOS(NN) + JRSHFT                                       00046500
          KC = KKPOS(NN) + KCSHFT                                       00046510
          KM = KC + NOKK                                                00046520
          KE = KM + NOKK                                                00046530
          KF = KE + NOKK                                                00046540
          TIJES = XX(II) + XX(JJ) + XX(KC)                              00046550
     *            + ( XOF(NN) * XX(KM) + XOFSIN(NN) * XX(KE)            00046560
     *                + XOFCOS(NN) * XX(KF) ) / OFFREF                  00046570
C                                                                       00046580
C***********************************************************************00046590
C*   COMPUTE ERROR FOR PRIMARY PICK.                                   *00046600
C***********************************************************************00046610
C                                                                       00046620
    4     ERR = TIJ(NN) - TIJES                                         00046630
C                                                                       00046640
C***********************************************************************00046650
C*   COMPUTE ERRORS FOR ALTERNATE PICKS, IF REQUESTED.                 *00046660
C***********************************************************************00046670
C                                                                       00046680
          IF ( NALPFG .EQ. 0 ) THEN                                     00046690
            ERMN = TIJM(NN) - TIJES                                     00046700
            ERMX = TIJX(NN) - TIJES                                     00046710
C                                                                       00046720
            IF ( ABS(ERR) .GE. ABS(ERMN) ) THEN                         00046730
              ERR = ERMN                                                00046740
              TEMP = TIJ(NN)                                            00046750
              TIJ(NN) = TIJM(NN)                                        00046760
              TIJM(NN) = TEMP                                           00046770
              TEMPC = COR(NN)                                           00046780
              COR(NN) = CORM(NN)                                        00046790
              CORM(NN) = TEMPC                                          00046800
              NOCOR = NOCOR + 1                                         00046810
            END IF                                                      00046820
C                                                                       00046830
            IF ( ABS(ERR) .GE. ABS(ERMX) ) THEN                         00046840
              ERR = ERMX                                                00046850
              TEMP = TIJ(NN)                                            00046860
              TIJ(NN) = TIJX(NN)                                        00046870
              TIJX(NN) = TEMP                                           00046880
              TEMPC = COR(NN)                                           00046890
              COR(NN) = CORX(NN)                                        00046900
              CORX(NN) = TEMPC                                          00046910
              NOCOR = NOCOR + 1                                         00046920
            END IF                                                      00046930
          END IF                                                        00046940
C                                                                       00046950
C***********************************************************************00046960
C*   COMPUTE ERROR STATISTICS.                                         *00046970
C***********************************************************************00046980
C                                                                       00046990
          IF ( ERR .GT. POSER ) POSER = ERR                             00047000
          IF ( ERR .LT. ERNEG ) ERNEG = ERR                             00047010
          RMSER = RMSER + ERR * ERR                                     00047020
          NSUMO = NSUMO + 1                                             00047030
C                                                                       00047040
C***********************************************************************00047050
C*   UPDATE ERROR DISTRIBUTION.                                        *00047060
C***********************************************************************00047070
C                                                                       00047080
          IPO = ( ERR / DID ) + CENTR                                   00047090
          IF ( IPO .LT. 1 ) IPO = 1                                     00047100
          IF ( IPO .GT. NODIS ) IPO = NODIS                             00047110
          DIST(IPO) = DIST(IPO) + 1.0                                   00047120
          NEVNTK = NEVNTK + 1                                           00047130
          IF ( NEVNTK .EQ. NEVNTS ) GO TO 45                            00047140
   40   CONTINUE                                                        00047150
C                                                                       00047160
C***********************************************************************00047170
C*   THIS BLOCK IS DONE.  CHECK IF LEG-JUMPS WERE CORRECTED AND, IF SO,*00047180
C* WRITE THE CORRECTED DATA BLOCK BACK TO DISK.                        *00047190
C***********************************************************************00047200
C                                                                       00047210
   45   IF ( NOCOR .GT. 0 ) THEN                                        00047220
          NOLEG = NOLEG + NOCOR                                         00047230
          CALL DAWRTE (NB, TIJ, LUDSKA)                                 00047240
        END IF                                                          00047250
   50 CONTINUE                                                          00047260
C                                                                       00047270
C***********************************************************************00047280
C*   COMPUTE RMS AND ABSOLUTE ERRORS.                                  *00047290
C***********************************************************************00047300
C                                                                       00047310
      RMSER = SQRT(RMSER/NSUMO)                                         00047320
      ERMAX = POSER                                                     00047330
      AERNEG = ABS(ERNEG)                                               00047340
      IF ( AERNEG .GT. ERMAX ) ERMAX = AERNEG                           00047350
C                                                                       00047360
      RETURN                                                            00047370
      END                                                               00047380
C***********************************************************************00047390
C***********************************************************************00047400
C***********************************************************************00047410
C***********************************************************************00047420
C***********************************************************************00047430
      SUBROUTINE RIPRNT (RI,PRINTR)
************************************************************************
*                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
*                                                                      *
************************************************************************
*  ROUTINE:       RIPRNT
*  ROUTINE TYPE:  SUBROUTINE  MULITPLE_ENTRY
*  ENTRY POINTS:
*
*      RIPRNT (RI,PRINTR)   RI_PRINT ACCUMULATES UP TO 20 RECORD INDEXES
*                           IN THE RI_LIST ARRAY BEFORE PRINTING. IF ANY
*                           OF THE RI VALUES ARE OUT OF SEQUENCY, THREE
*                           ASTERICS ARE PRINTED TO THE LEFT.
*
*      RICLR  (PRINTR)      RI_CLEAR PRINTS OUT ANY RI VALUES THAT ARE
*                           CURRENTLY IN THE RI LIST AND THREE ASTERCIS
*                           IF ANY OF THE RI VALUES ARE OUT OF SEQUENCE.
*
*      RIPROC (RI,PRINTR)   RI_PROCCESED PRINTS OUT ONE RECORD INDEX
*                           NUMBER PER LINE ALONG WITH THREE ASTERICS
*                           IF THE RI VALUES ARE OUT OF SEQUENCE.
*
*  PURPOSE:       THIS ROUTINE IS USED TO PRINT OUT THE RECORD INDEX
*                 NUMBERS OF THE SIESMIC RECORDS AS THEY ARE
*                 PROCESSED.
*  ARGUMENTS:
*       PRINTR I*4  INPUT       LOGICAL UNIT OF THE PRINTER.
*       RI     I*4  INPUT       CURRENT SIESMIC RECORD INDEX VALUE.
*       +------------------------------------------------------+
*       |               DEVELOPMENT INFORMATION                |
*       +------------------------------------------------------+
*  AUTHOR:    PHILLIP MANNING                 ORIGIN DATE:  82/05/05
*  LANGUAGE:  FORTRAN Q
*       +------------------------------------------------------+
*       |                 EXTERNAL ENVIRONMENT                 |
*       +------------------------------------------------------+
*  ROUTINES CALLED: NONE
*  FORTRAN SUPPLIED PROCEDURES: NONE
*  FILES:
*      PRINTR     ( OUTPUT  SEQUENTIAL )
*  COMMON: NONE
*       +------------------------------------------------------+
*       |             SPECIAL DOCUMENTATION ITEMS              |
*       +------------------------------------------------------+
*  CCEXIT CODES: NONE
*       +------------------------------------------------------+
*       |             OTHER DOCUMENTATION DETAILS              |
*       +------------------------------------------------------+
*  ERROR HANDLING: NONE
*  GENERAL DESCRIPTION: NONE
*  ASSUMPTIONS: NONE
*  INTERNAL VARIABLES:
*       RILIST I*4  (20)  RECORD INDEX LIST - CONTAINS THE RI VALUES
*                         TO BE PRINTED.
*       RICNT  I*4        RECORD INDEX COUNT - HOLDS A COUNT OF RECORD
*                         NUMBERS CURRENTLY IN THE RI LIST ARRAY.
*       LASTRI I*4        LAST RECORD INDEX - HOLDS THE VALUE OF THE
*                         LAST RECORD INDEX PASSED TO THIS ROUTINE.
*                         USED TO DETERMINE WHEN THERE IS A BREAK IN
*                         THE RI SEQUENCE.
*       SEQCHK I*4        SEQUENCE CHECK CHARACTER STRING - WRITTEN OUT
*                         WHEN EVER THERE IS A BREAK IN RI SEQUENCE.
********************   END OF DOCUMENTATION PACKAGE   ******************
************************************************************************
*
*              +-------------------------------+
*              |     VARIABLE DECLARATIONS     |
*              +-------------------------------+
*
*IBM  INTEGER*4 RI,LASTRI/0/,PRINTR,RILIST(20),RICNT/0/

      INTEGER   RI, LASTRI, PRINTR, RILIST ( 20 ), RICNT

*IBM  CHARACTER*4 SEQCHK/'    '/,BLANK/'    '/,ASTRIC/'*** '/

      CHARACTER * 4 SEQCHK, BLANK, ASTRIC

      DATA
     *       LASTRI / 0    /
     *     , RICNT  / 0    /
     *     , SEQCHK /'    '/
     *     , BLANK  /'    '/
     *     , ASTRIC /'*** '/

c - added this so these wouldn't get lost between entry pts - j.m.wade 2/20/91
      SAVE LASTRI,RILIST,RICNT,SEQCHK,BLANK,ASTRIC
*
*     +----------------------------------------------------+
*     |  STORE THE CURRENT RI VALUE IN THE RI LIST ARRAY   |
*     |  AND REMEMBER THE LAST RI FOR SEQUENCE CHECKING.   |
*     |  IF WE CURRENTLY HAVE 20 RI'S THEN PRINT THE LIST. |
*     +----------------------------------------------------+
*
      RICNT = RICNT + 1
      RILIST(RICNT) = RI
*
      IF (LASTRI + 1 .NE. RI) SEQCHK = ASTRIC
*
      LASTRI = RI
*
      IF (RICNT .LT. 20) RETURN
*
      ENTRY RICLR (PRINTR)
*
*     +--------------------------------------------------------+
*     |  IF THERE ARE ANY RECORD INDEXES, WRITE THE CURRENT    |
*     |  CONTENTS OF THE RI_LIST ARRAY, RESET THE RI_LIST      |
*     |  COUNTER AND SEQUENCE CHECK FIELD.                     |
*     +--------------------------------------------------------+
*
      IF (RICNT .GT. 0)  WRITE (PRINTR,10) SEQCHK,(RILIST(I),I=1,RICNT)
   10 FORMAT (' ',T6,A4,'RI PROCESSED ',20I6)
*
      RICNT = 0
      SEQCHK = BLANK
*
      RETURN
*
      ENTRY RIPROC (RI,PRINTR)
*
*     +--------------------------------------------------------+
*     |    WRITE OUT THE STANDARD 'RI PROCESSED' MESSAGE.      |
*     +--------------------------------------------------------+
*
      IF (LASTRI + 1 .NE. RI) SEQCHK = ASTRIC
*
      WRITE (PRINTR,20) SEQCHK,RI
   20 FORMAT (' ',T6,A4,'RI ',I6,' PROCESSED ')
*
      LASTRI = RI
      SEQCHK = BLANK
*
      RETURN
*
      ENTRY RIPT
*
*     +---------------------------------------+
*     |    DUMMY ENTRY POINT FOR LATER USE    |
*     +---------------------------------------+
*
      RETURN
*
      END
