      SUBROUTINE DMCARD (IPRT, ICRD, NTRCS, NFOLD, thresh, fcut,
     &             NREC,   ICC,DSTMIN, DSTMAX, global,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, xm,     tm,    NPAIRS, ANGMIN,
     &             IX1, IY1, IX2, IY2, IX3, spread, stk,
     &             IY3,    IX4, IY4, NLI, NDI, ngrp, dxg, pkthr,
     &             verbos, mute, ist, ied, nsi, ifmin, ifmax,
     &             ifdel,hdrwrd,TmMsFS)
C***********************************************************************00001970
C                                                                       00001980
C     PROGRAM NAME: DMCARD (READ USER CARDS FOR DM3D)                   00001990
C                                                                       00002000
C     LANGUAGE: FORTRAN                                                 00002010
C                                                                       00002020
C     AUTHOR: G.MURPHY                                                  00002030
C                                                                       00002040
C     DATE WRITTEN: 07/01/88                                            00002050
C                                                                       00002060
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00002080
C                                                                       00002100
C     ABSTRACT: READ DM3D CARDS                                         00002110
C                                                                       00002120
C                                                                       00002130
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00002140
C                                                                       00002150
C***********************************************************************00002160
C                                                                       00002170
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL          xm (*), tm (*)
      character     mtap * 256
      character     hdrwrd * 6
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       argis, ist, ied
      real          spread (*)
      integer       key (SZLNHD)
      real          tmp (SZLNHD)

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      logical       verbos, mute, stk, global
      DATA IEND, IFLAG /0,1/

      si = nsi

         if ( global ) then
            write(IPRT,*)'*****************'
            write(IPRT,*)'Using global mode'
            write(IPRT,*)'Trace header word = ',hdrwrd
            write(IPRT,*)'Time of 1st sample= ',TmMsFS
            write(IPRT,*)'*****************'
            mute = .false.
         else
            call argstr ('-M',  mtap, ' ', ' ')
            if (mtap(1:1) .ne. ' ') mute = .true.
         endif

         call argr4 ('-dmin',  DSTMIN, 0., 0.)
         call argr4 ('-dmax',  DSTMAX, 0., 0.)
         call argr4 ('-ddel',  DSTDEL, 0., 0.)
         call argr4 ('-angmn', ANGMAX, 0., 0.)
         call argr4 ('-angmx', ANGMIN, 0., 0.)
         call argr4 ('-pkthr', pkthr, .15, .15)
         call argi4 ('-s', ist, 0, 0)
         call argi4 ('-e', ied, 0, 0)
         call argi4 ('-fl', ifmin, 5, 5)
         call argi4 ('-fh', ifmax, 0, 0)
         call argi4 ('-df', ifdel, 5, 5)
         fnyq = 500. / si
         if (ifmax .eq. 0) ifmax = .5 * fnyq
         if (fcut .eq. 0.0) then
             fcut = .9 * ifmax
         else
             fcut = fcut * fnyq
         endif


         if (ist .eq. 0 .AND. ied .eq. 0) then
           write(IPRT,*)'FATAL ERROR in scope3d:'
           write(IPRT,*)'Must enter start window using -s[]'
           write(IPRT,*)'or end window using -e[]'
           write(LER ,*)'FATAL ERROR in scope3d:'
           write(LER ,*)'Must enter start window using -s[]'
           write(LER ,*)'or end window using -e[]'
           stop
         endif
     
         IF ( .not. stk ) THEN
   
            if (DSTMAX .eq. 0.0) THEN
                write(IPRT,*)'WARNING from scope3d:'
                write(IPRT,*)'Did not enter spread geometry using'
                write(IPRT,*)'-dmax[] cmd line arg'
                write(IPRT,*)'Spread will consist of one infinite'
                write(IPRT,*)'group'
                DSTMIN = 0.
                DSTMAX = 9999999.
                DSTDEL = 9999999.
            endif
   
            dxg = DSTDEL
            NFOLD  = nint ((DSTMAX - DSTMIN) / DSTDEL)
            ngrp = NFOLD

      write(0,*)'ngrp= ',ngrp

c-------
c compute spread model
c-------
            if (ngrp .gt. 1) then
   
               call vfill (0.0, spread, 1, ngrp)
   
               do  j = 1, ngrp
       
                   spread (j) = DSTMIN + (j-1) * dxg
               enddo
               ngrp = ngrp + 1
               spread (ngrp) = DSTMAX
               NFOLD = ngrp
            else
               spread (ngrp) = DSTMAX
            endif

         ELSE

            ngrp = 0
            DSTMAX = 999999999.
            DSTMIN = 0.

         ENDIF

      IF (mute) THEN
 
         call alloclun ( lumute )
         open (unit=lumute, file = mtap, status = 'old', iostat = ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'Could not open scope3d mute card file ',
     1                    mtap
            write(LERR,*)'Check existence'
            stop
         endif
 
         nm = 0
         do while (1.eq.1)
            read(lumute,'(a80)',end=999,err=998) card
            nm = nm + 1
            call fsscnf (card,'%f %f %d',TM(nm),XM(nm),idum)
            if (TM(nm) .lt. 0.) go to 999
         enddo
         go to 999
 
998      continue
            write(LERR,*)'Fatal error in scope3d:'
            write(LERR,*)'Error reading X-T mute file'
            stop
 
999      continue
         nm = nm - 1
         if (nm .lt. 2) then
            write(LERR,*)'Fatal error in scope3d:'
            write(LERR,*)'Mute file contains < 2 entries. Must have'
            write(LERR,*)'at least 2'
            stop
         endif
         call sortr (xm, key, nm)
         do  i = 1, nm
             tmp (i) = tm ( key(i) )
         enddo
         do  i = 1, nm
             tm (i) = tmp (i)
         enddo
         write(LERR,*)' '
         write(LERR,*)'Mute Function'
         write(LERR,*)'Distance    Time'
         do  i = 1, nm
            write(LERR,777) XM(i),Tm(i)
         enddo
         write(LERR,*)' '
777      format (2f10.0)
 
      ENDIF



      WRITE (IPRT, 190) IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4,
     &                  DY, DX
  190 FORMAT ( /, 23X, '  CORNER 1 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 1 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  STARTING OUTPUT RECORD NUMBER .',1X,I9  ,
     &        //, 23X, '  CROSSLINE CELL DIMENSION. . . .',F15.5,//)

      RETURN
      END
