C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hint3d (lupik, nhor, limin, limax, dimin, dimax,
     1                   nli, ndi, name, IX1, IY1,
     2                   NX, NY, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3                   DX, DY)

#include <f77/iounit.h>

      integer    lupik, nhor, limin, limax, dimin, dimax, nli, ndi
      integer    nl, nd, numli, numdi, nlmin, ndmin, nlmax, ndmax
      integer    li, di, lilst, dilst, NX, NY, IX1, IY1
      real       DX, DY
      real * 8   XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character  name*(*)
      character  card * 80
      logical    limit

      write(LERR,*)' '
      write(LERR,*)'cmdln: limin, limax, dimin, dimax, nli, ndi= ',
     1limin, limax, dimin, dimax, nli, ndi
      write(LERR,*)' '

      rewind lupik

      ll    = 0
      nl    = 0
      nd    = 0
      nhor  = 0
      numli = 0
      numdi = 0
      lilst = -99999999
      dilst = -99999999
      nlmin =  99999999
      ndmin =  99999999
      nlmax = -99999999
      ndmax = -99999999

      limit = .true.

      DO while (1.eq.1)

         nhor = nhor + 1

         DO while (1.eq.1)

            ll = ll + 1
            read (lupik, '(a80)', end=111, err=666) card
            go to 112
111         continue
            if (ll .ge. 1) then
                write(LERR,*)' '
                write(LERR,*)'Message from horizon file reader:'
                write(LERR,*)'Hit EOF at line ',ll,' after reading'
                write(LERR,*)nhor,' horizons.'
                go to 777
            else
                go to 999
            endif
112         continue

            nch = lenth (card)
            if (nch .eq. 0) then

               go to 1

            else

               call fsscnf (card,'%f %f %f %f %f', xli, xdi, CX, CY, t)

               IWRN = 0
               call xfmfwd (CX, CY, LI, DI, CXT, CYT, BXT, BYT,
     1                      IWRN, IX1, IY1, XX, XY, YX, YY, XXT, XYT,
     2                      YXT, YYT, DX, DY, NDI, NLI)

               if (LI .LT. limin .AND. limit) then
                 write(LERR,*)'WARNING for horizon ',nhor
                 write(LERR,*)'Found LI ',li,' < specified min ',limin
                 write(LERR,*)'Card entry:'
                 write(LERR,*) card
               endif
               if (LI .GT. limax .AND. limit) then
                 write(LERR,*)'WARNING for horizon ',nhor
                 write(LERR,*)'Found LI ',li,' > specified max ',limax
                 write(LERR,*)'Card entry:'
                 write(LERR,*) card
               endif
               if (DI .LT. dimin .AND. limit) then
                 write(LERR,*)'WARNING for horizon ',nhor
                 write(LERR,*)'Found DI ',di,' < specified min ',dimin
                 write(LERR,*)'Card entry:'
                 write(LERR,*) card
               endif
               if (DI .GT. dimax .AND. limit) then
                 write(LERR,*)'WARNING for horizon ',nhor
                 write(LERR,*)'Found DI ',di,' > specified max ',dimax
                 write(LERR,*)'Card entry:'
                 write(LERR,*) card
               endif
 
               if (di .ne. dilst) then
                   dilst = di
                   nd = nd + 1
               endif
               if (li .ne. lilst) then
                   nl = nl + 1
                   if (nd .ge. numdi) numdi = nd
                   nd = 1
                   lilst = li
               endif

               if (li .le. nlmin) nlmin = li
               if (li .ge. nlmax) nlmax = li
               if (di .le. ndmin) ndmin = di
               if (di .ge. ndmax) ndmax = di


            endif

         ENDDO

1        continue

         if (nl .ge. numli) numli = nl

      ENDDO

777   continue

      write(LERR,*)' '
      write(LERR,*)'Horizon file stats:'
      write(LERR,*)'Number horizons found        =  ',nhor
      write(LERR,*)'Max number of DIs per line   =  ',nd
      write(LERR,*)'Max number of LIs per horizon=  ',nl
      write(LERR,*)' '


      write(LERR,*)' '
      write(LERR,*)'Min DI found in horizon file=  ', ndmin
      write(LERR,*)'Max DI found in horizon file=  ', ndmax
      write(LERR,*)'Min LI found in horizon file=  ', nlmin
      write(LERR,*)'Max LI found in horizon file=  ', nlmax
      write(LERR,*)' '
      write(LERR,*)'LI/DI limits from XY corners and -limin[]'
      write(LERR,*)'-limax[] -dimin -dimax[] from command line:'
      write(LERR,*)'Min LI limit =  ',limin
      write(LERR,*)'Max LI limit =  ',limax
      write(LERR,*)'Min DI limit =  ',dimin
      write(LERR,*)'Max DI limit =  ',dimax
      write(LERR,*)'(these are the ones used to limit survey)'
      write(LERR,*)' '

      return

999   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Horizon file appears to be empty!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Horizon file appears to be empty!'
      call ccexit (999)

666   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Unable to read horizon file!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Unable to read horizon file!'
      call ccexit (666)


      end
