C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c locates interior "holes" in each time slice and attempts to fill in using
c the star interpolator in zombie
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer     itr  ( SZLNHD )
      real        head ( SZLNHD )

      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL*8      DE, DF, E, F, XYYXXY
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1
      integer     index, index0
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, index (1))
      pointer     (wkadr3, index0(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum, linind, dphind, stacor
      integer     lilast, dilast, rilast, trlast
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 256, otap * 256, name*8, code*3
      logical     verbos, heap1, heap2, heap3, post
      logical     first, centers, nopost
      integer     argis, errcd1, errcd2, errcd3
 
c-----
c    we access the header values which can be short or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'SLICETRP'/
      data code /'   '/
 
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0)then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,iter,verbos,post,centers,nopost,
     1            IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX)

c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, lhed, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'slicetrp: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

C**********************************************************************C
C     build LI/DI coordinates if available. This is to reconstruct
C     CDP bin center coords of missing cells given their reconstructed
C     LI & DIs
C**********************************************************************C

      if (centers) then

          CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1                IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

          DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
          DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
          XYYXXY =  XYT * YXT - XXT * YYT
          if (XYYXXY .eq. 0.) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR from slicetrp post processing:'
          write(LERR,*)'Attempt to use survey coords to fill in bin'
          write(LERR,*)'centers failed due to coord transform'
          write(LERR,*)'singularity (bad coord choice most likely)'
          stop 666
          endif

      endif
c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif

      IF ( .not. nopost) THEN
      if (post) then
         call saver(lhed, 'OACUsr', code , LINHED)
         if (code .ne. 'slc') then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR in slicetrp:'
            write(LERR,*)'A previous slicetrp wasnt run on time slices'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR in slicetrp:'
            write(LER ,*)'A previous slicetrp wasnt run on time slices'
            stop
         endif
      else
         call savew(lhed, 'OACUsr', 'slc', LINHED)
      endif
      ENDIF
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (lhed, lbytes, name, 8, LERR)
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
      heap3 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      if (post) then
         item1 = SZSMPD
         item2 = SZSMPD
         item3 = SZSMPD
      else
         item1 = ntrc * nsamp * SZSMPD
         item2 = ntrc * nsamp * SZSMPD
         item3 = ntrc * nsamp * SZSMPD
      endif
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadr1, item1, errcd1, abort1)
      call galloc (wkadr2, item2, errcd2, abort2)
      call galloc (wkadr3, item3, errcd3, abort3)
 
      if (errcd1 .ne. 0) heap1 = .false.
      if (errcd2 .ne. 0) heap2 = .false.
      if (errcd3 .ne. 0) heap3 = .false.
 
      if (.not. heap1 .or. .not. heap2 .or. .not. heap3) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(lhed,lbytes,lbyout)
c----------------------
 
      call wrtape ( luout, lhed, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                 iter,ntap,otap,centers,dx,dy,nx,ny,
     2                 ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,nopost)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read X-Y data, interpolate, write X-Y data
c-----

      IF (.not. post) THEN

      call vclr (index0, 1, nsamp*ntrc)

      DO  JJ = 1, nrec
 
          ic = 0
          do  kk = 1, ntrc
 
              nbytes = 0
              call rtape( luin, lhed, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'  rec= ',jj,'  trace= ',kk
                 go to 999
              endif
              call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

c------
c     use previously derived pointers to trace header values
              call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    recnum , TRACEHEADER)
              call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    trcnum , TRACEHEADER)
              call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    stacor , TRACEHEADER)
c------
 
c----------------------
c  pack data into array
c----------------------
              ic = ic + 1
              istrc = (ic-1) * nsamp
              call vmov (tri,1, bigar1(istrc+1),1, nsamp)
 
          enddo
 
c-----------------------
c  here's the meat...
c  2D X-Y interpolation
 
          call vclr  (index, 1, nsamp*ntrc)
          call trpsub (bigar1, ntrc, nsamp, index, index0, iter)
 
c-----------------------
 
c---------------------
c  extract traces from
c  output array and
c  write output data
c  up to last time slice
c---------------------

          IF ( (JJ .lt. nrec .OR. nrec .eq. 1) .OR. nopost) THEN

             do  kk = 1, ntrc
 
                 istrc = (kk-1) * nsamp
                 call vmov (bigar1(istrc+1), 1, lhed(ITHWP1), 1, nsamp)

                 call wrtape (luout, lhed, nbytes)
 
             enddo
 
c---------------------
c last slice is checked
c for zero cells (ones
c that are zero for all
c slices) and coded as
c dead cell
c---------------------
          ELSE

             call vclr (lhed(ITHWP1), 1, nsamp)
             call indint (index0, nsamp, ntrc)

             do  kk = 1, ntrc
 
                 istrc = (kk-1) * nsamp
                 do  i = 2, nsamp-1
                     if ( ( index0(istrc+i).eq.-1 ) .AND.
     1                    ( kk.gt.1 .and. kk.lt.ntrc )   ) then
                         lhed (ITRWRD+i) = 30000
                     else
                         lhed (ITRWRD+i) = 0
                     endif
                 enddo

                 call wrtape (luout, lhed, nbytes)

             enddo
 
          ENDIF
 
      ENDDO

c-----
c     BEGIN POST - PROCESSING
c     read LI/DI data, detect if original trace (prior to first
c     slicetrp) was dead, fix up headers using the last live input
c     trace hdr, then write to output
c-----
      ELSE

      DO  JJ = 1, nrec
 
          first = .false.
          id    = 0

          do  kk = 1, ntrc
 
              nbytes = 0
              call rtape( luin, lhed, nbytes)
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'  rec= ',jj,'  trace= ',kk
                 go to 999
              endif
c------
c     use previously derived pointers to trace header values
              call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    recnum , TRACEHEADER)
              call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    trcnum , TRACEHEADER)
              call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    linind , TRACEHEADER)
              call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    dphind , TRACEHEADER)
              call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    stacor , TRACEHEADER)
c------
              if (stacor .ne. 30000 .AND. .not. first) then
                 first = .true.
                 lilast = linind
                 dilast = dphind
                 rilast = recnum
                 trlast = trcnum
              endif

c-----
c    found a previously dead cell (trace)
c-----
              if (lhed(ITRWRD+nsamp) .eq. 30000) then
                  lhed(ITRWRD+nsamp) = 0
                  call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        0 , TRACEHEADER)
                  id = id + 1
                  dphind = dilast + id
                  trcnum = trlast + id
c-----
c    if survey coords were provided:
c    given legit LI & DI numbers reconstruct
c    bin center XYs of dead cell
c-----
                  if (centers) then

                      E = (DBLE(FLOAT(linind)) - 0.5) * DX + DE
                      F = (DBLE(FLOAT(dphind)) - 0.5) * DY + DF
                      CDPX  = (F * XYT - E * YYT) / XYYXXY
                      if (YYT .ne. 0.) then
                         CDPY  = (F - CDPX * YXT) / YYT
                      elseif (XYT .ne. 0.) then
                         CDPY  = (E - CDPX * XXT) / XYT
                      endif
                      ICDPX = CDPX
                      ICDPY = CDPY
                  endif

                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        linind , TRACEHEADER)
                  call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call savew2(lhed,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                        ICDPX  , TRACEHEADER)
                  call savew2(lhed,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                        ICDPY  , TRACEHEADER)

c-----
c    this was a live cell on input
c-----
              else

                  id = 0
                  lilast = linind
                  dilast = dphind
                  rilast = recnum
                  trlast = trcnum

                  if (stacor .eq. 30000)
     1            call vclr (lhed(ITHWP1), 1, nsamp)

              endif
 
              call wrtape (luout, lhed, nbytes)

 
          enddo
      ENDDO

      ENDIF
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of slicetrp, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of slicetrp, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'slicetrp takes X-Y time slice data & interpolates interior dead'
        write(LER,*)
     :'         cells using an iterative star interpolator'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute slicetrp by typing xytrp and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
      write(LER,*)' '
      write(LER,*)'Pre-process Parameters'
      write(LER,*)' '
        write(LER,*)
     :' -iter[iter] (default = 3)     : number iterations'
        write(LER,*)
     :' -nP no post-processing (can be used on any record not just TI)'
      write(LER,*)' '
      write(LER,*)'Post-process Parameters'
      write(LER,*)' '
        write(LER,*)
     :' -P  post process interpolated LI/DI data'
      write(LER,*)' '
      write(LER,*)'Optional Post-process Parameters to fill in missing'
      write(LER,*)'bin center XYs (otherwise only LI/DIs will be compute
     :d)'
      write(LER,*)' '
      write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (N-E)'
      write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (N-E)'
      write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
      write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
      write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
      write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
      write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
      write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
      write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
      write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   slicetrp -N[] -O[] -iter[] -V'
        write(LER,*)
     :'                  [-nP -P -x1[] -y1[] -x2[] -y2[] -x3[] -y3[]'
        write(LER,*)
     :'                      -x4[] -y4[] -ildm[] -cldm[]        ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,iter,verbos,post,centers,nopost,
     1                  IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      logical     verbos, post, centers, nopost
      integer     argis, iter
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program slicetrp might be invoked in the following way:
 
c     slicetrp  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into slicetrp and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
      post = .false.

      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argi4 ( '-iter', iter ,   3  ,  3    )

      post   =   (argis('-P') .gt. 0)
      nopost =   (argis('-nP') .gt. 0)
      if (nopost) post = .false.

      if (post) then

          call argi4 ('-x1', ix1, 0 , 0 )
          call argi4 ('-y1', iy1, 0 , 0 )
          call argi4 ('-x2', ix2, 0 , 0 )
          call argi4 ('-y2', iy2, 0 , 0 )
          call argi4 ('-x3', ix3, 0 , 0 )
          call argi4 ('-y3', iy3, 0 , 0 )
          call argi4 ('-x4', ix4, 0 , 0 )
          call argi4 ('-y4', iy4, 0 , 0 )
          call argr4 ('-cldm', dx, 0., 0.)
          call argr4 ('-ildm', dy, 0., 0.)

          if (ix1.ne.0 .or. iy1.ne.0 .or. ix2.ne.0 .or. iy2.ne.0 .or.
     1        ix3.ne.0 .or. iy3.ne.0 .or. ix4.ne.0 .or. iy4.ne.0) then

              if (dx .eq. 0.) then
                write(LERR,*)' '
                write(LERR,*)'FATAL ERROR in slicetrp post process:'
                write(LERR,*)'Attempt to use survey coords without'
                write(LERR,*)'specifying -cldm[]'
                write(LER ,*)' '
                write(LER ,*)'FATAL ERROR in slicetrp post process:'
                write(LER ,*)'Attempt to use survey coords without'
                write(LER ,*)'specifying -cldm[]'
                stop
              endif
              if (dy .eq. 0.) then
                write(LERR,*)' '
                write(LERR,*)'FATAL ERROR in slicetrp post process:'
                write(LERR,*)'Attempt to use survey coords without'
                write(LERR,*)'specifying -ildm[]'
                write(LER ,*)' '
                write(LER ,*)'FATAL ERROR in slicetrp post process:'
                write(LER ,*)'Attempt to use survey coords without'
                write(LER ,*)'specifying -ildm[]'
                stop
              endif
              centers = .true.

          else

              centers = .false.

          endif

          centers = .false.

       endif

       verbos =   (argis('-V') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  iter,ntap,otap,centers,dx,dy,nx,ny,
     2                  ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,nopost)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, iter
      character   ntap*(*), otap*(*)
      logical     centers, nopost
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' number iterations  =  ',iter
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            if (nopost) then
            write(LERR,*) ' No time slice data assumed - just records'
            else
            if (centers) then
            write(LERR,*) ' Using survey coords to fill in CDP bin cente
     1rs'
            write(LERR,*) ' X1, Y1 =  ',ix1,'  ',iy1
            write(LERR,*) ' X2, Y2 =  ',ix2,'  ',iy2
            write(LERR,*) ' X3, Y3 =  ',ix3,'  ',iy3
            write(LERR,*) ' X4, Y4 =  ',ix4,'  ',iy4
            write(LERR,*) ' inline (side 1-2) dimension =  ',dy
            write(LERR,*) ' xline (side 2-3) dimension  =  ',dx
            write(LERR,*) ' number cells along 1-2      =  ',ny
            write(LERR,*) ' number cells along 2-3      =  ',nx
            else
            write(LERR,*) ' No bin centers restored (just LIs & DIs)'
            endif
            endif
            write(LERR,*)' '

      return
      end
 
