C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine edger (WorkSpace,nxWork,nyWork,nf,nf2,first,last,
     1                  TimeSlice,Output,Filter,TI,Xpad,Ypad,edge,
     2                  med,avmed,pass,nts,its,wate,jrec,EOF)

      real     TimeSlice  (nxWork, nyWork)
      real     WorkSpace  (nxWork, nyWork)
      real     Output     (nxWork, nyWork)
      real     TI         (nxWork, nyWork,nts)
      real     Filter     (nf    , nf,    nts)
      real     wate (nts)
      integer  nxWork,nyWork,nf,nf2,Xpad,Ypad,nts
      logical  first, last, edge, med, avmed, pass, EOF


c----
c  roll the current buffer dropping the first slice
c----

      do  k = 1, nts-1
         do  j = 1, nyWork
             do  i = 1, nxWork
                 TI(i,j,k) = TI(i,j,k+1)
             enddo
         enddo
      enddo

c----
c  bring the next slice into buffer
c----
         do  j = 1, nyWork
             do  i = 1, nxWork
                 TI(i,j,nts) = WorkSpace (i,j)
             enddo
         enddo

c----
c  now operate spatially on each slice in the buffer using the appropriate
c  Filter and accumulate the results
c----
      IF ( edge ) THEN

         DO  k = 1, nts

             call FKKFilter (nxWork,nyWork,nf,nf2,
     1                      TI(1,1,k),WorkSpace,Filter(1,1,k),
     2                      Xpad,Ypad,med,avmed,pass)

             do  j = 1, nyWork
                 do  i = 1, nxWork
                     Output (i,j) = Output (i,j) + WorkSpace (i,j)
                 enddo
             enddo

          ENDDO

      ELSE

          IF (.not. EOF) THEN
             ic = nts / 2 + 1
             call FKKFilter (nxWork,nyWork,nf,nf2,
     1                      TI(1,1,nts),WorkSpace,Filter(1,1,ic),
     2                      Xpad,Ypad,med,avmed,pass)

             do  j = 1, nyWork
                 do  i = 1, nxWork
                     TI (i,j,nts) = WorkSpace (i,j)
                 enddo
             enddo
          ENDIF


             DO  k = 1, its
                if (EOF) then
                   kk = k
                else
                   kk = nts - k + 1
                endif
                if ( its .lt. nts) then
                   wt = 1 / float(its)
                else
                   wt = wate (kk)
                endif
                do  j = 1, nyWork
                    do  i = 1, nxWork
                        Output (i,j) = Output (i,j) +
     1                                 wt * TI (i,j,kk)
                    enddo
                enddo
             ENDDO


      ENDIF

      return
      end
