C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      REAL FUNCTION   J0   (X)
C
C   THIS SUBROUTINE COMPUTES THE BESSEL FUNCTION J0(X)
C   FOR ABS(X) .LE. 3 & X .GT. 3 USING THE APPROXIMATIONS
C   FOUND IN ABRAMOWITZ & STEGUN, P.369 - 370
C
C   INPUT:  X - ARGUMENT (MUST LIE BETWEEN -3 AND INFINITY)
C
C   OUTPUT: J0 - VALUE OF THE BESSEL FUNCTION FOR THIS ARGUMENT
C
C
C   CHECK ARGUMENT FOR TWO CASES: ABS(X) .LE. 3 & X .GT. 3
C
      J0=1.0
      y = abs (x)
      IF(y .GT. 3.0) GO TO 10
C
C   SECTION FOR ABS(X) .LE. 3.0
C
      if (y .lt. 1.e-06) return
      y = y*y/9.
      J0= 1.0+y*(-2.2499997+y*(1.2656208+y*(-.3163866+y*(.0444479+
     +y*(-.0039444+y*.00021)))))
      RETURN
C
C   SECTION FOR X .GT. 3
C
   10 CONTINUE
      XROOT=1./SQRT(y)
      ARG=y
      y=3./y
      F0=.79788456+y*(-.00000077+y*(-.00552740+y*(-.00009512+y*(
     *.00137237+y*(-.00072805+y*.00014476)))))
      O0=ARG  -.78539816+y*(-.04166397+y*(-.00003954+y*(.00262573+y
     **(-.00054125+y*(-.00029333+y*.00013558)))))
      J0=XROOT*F0*COS(O0)
      RETURN
      END
